------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  A D D        T A B L E S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------





IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_ZAGLAVLJE')
CREATE TABLE [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE](
	[pdz_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pdz_broj] [int] NULL,
	[pdz_broj_full] [nvarchar](50) NULL,
	[pdz_vrijeme] [datetime] NULL,
	[pdz_dan] [datetime] NULL,
	[pdz_kasa_id_fk] [int] NULL,
	[pdz_djelatnik_id_fk] [int] NULL,
	[pdz_tvrtka_id_fk] [int] NULL,
	[pdz_narucitelj_id_fk] [int] NULL,
	[pdz_popust] [decimal](12, 2) NULL,
	[pdz_iznos_bez_popusta] [decimal](12, 2) NULL,
	[pdz_iznos] [decimal](12, 2) NULL,
	[pdz_pdv] [decimal](12, 2) NULL,
	[pdz_pov_nak] [decimal](12, 2) NULL,
	[pdz_napomena] [nvarchar](200) NULL,
	[pdz_fis_vrijeme_slanja] [datetime] NULL,
	[pdz_fis_vrijeme_obrade] [datetime] NULL,
	[pdz_fis_uuid] [nvarchar](50) NULL,
	[pdz_fis_zastitni_kod] [nvarchar](40) NULL,
	[pdz_fis_jir] [nvarchar](50) NULL,
	[pdz_fis_ozn_pos_pros] [nvarchar](50) NULL,
	[pdz_fis_ozn_nap_uredaja] [nvarchar](50) NULL,
	[pdz_fis_naknadna_dostava] [bit] NULL,
	[pdz_fis_storno_sign] [nvarchar](1) NULL,
	[pdz_fis_source_id] [int] NULL,
  CONSTRAINT [PK_PRATECI_DOKUMENTI_ZAGLAVLJE] PRIMARY KEY CLUSTERED ([pdz_id_pk]),
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_KASE] FOREIGN KEY ([pdz_kasa_id_fk]) 
			REFERENCES [dbo].[KASE] ([ks_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_DJELATNICI] FOREIGN KEY ([pdz_djelatnik_id_fk]) 
			REFERENCES [dbo].[DJELATNICI] ([dj_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY ([pdz_narucitelj_id_fk]) 
			REFERENCES [dbo].[NARUCITELJI] ([na_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_TVRTKE] FOREIGN KEY ([pdz_tvrtka_id_fk]) 
			REFERENCES [dbo].[TVRTKE] ([tv_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_ZAGLAVLJE_PRATECI_DOKUMENTI_ZAGLAVLJE1] FOREIGN KEY ([pdz_fis_source_id]) 
			REFERENCES [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE] ([pdz_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION
)
ON [PRIMARY]
GO


GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRATECI_DOKUMENTI_STAVKE')
CREATE TABLE [dbo].[PRATECI_DOKUMENTI_STAVKE](
	[pds_id_pk] [int] IDENTITY(1,1) NOT NULL,
	[pds_pdz_id_fk] [int] NULL,
	[pds_artikal_id_fk] [int] NULL,
	[pds_gpdv_id_fk] [int] NULL,
	[pds_popust] [decimal](12, 3) NULL,
	[pds_cijena_bez_popusta] [decimal](12, 2) NULL,
	[pds_cijena] [decimal](12, 2) NULL,
	[pds_kolicina] [decimal](12, 2) NULL,
	[pds_iznos_bez_popusta] [decimal](12, 2) NULL,
	[pds_iznos] [decimal](12, 2) NULL,
	[pds_pdv] [decimal](12, 2) NULL,
	[pds_pov_naknada] [decimal](12, 2) NULL,
	[pds_tot_pov_naknada] [decimal](12, 2) NULL,
	[pds_napomena] [nvarchar](30) NULL,
  CONSTRAINT [PK_PRATECI_DOKUMENTI_STAVKE] PRIMARY KEY CLUSTERED ([pds_id_pk]),
  CONSTRAINT [FK_PRATECI_DOKUMENTI_STAVKE_ARTIKLI] FOREIGN KEY ([pds_artikal_id_fk]) 
			REFERENCES [dbo].[ARTIKLI] ([ar_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_STAVKE_GRUPE_PDV] FOREIGN KEY ([pds_gpdv_id_fk]) 
			REFERENCES [dbo].[GRUPE_PDV] ([gpdv_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION,
  CONSTRAINT [FK_PRATECI_DOKUMENTI_STAVKE_PRATECI_DOKUMENTI_ZAGLAVLJE] FOREIGN KEY ([pds_pdz_id_fk]) 
			REFERENCES [dbo].[PRATECI_DOKUMENTI_ZAGLAVLJE] ([pdz_id_pk]) ON UPDATE NO ACTION ON DELETE NO ACTION
)
ON [PRIMARY]
GO




--
-- Definition for table NARUDZBENICA_ZAGLAVLJE : 
--
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBENICA_ZAGLAVLJE')
BEGIN
	CREATE TABLE [dbo].[NARUDZBENICA_ZAGLAVLJE](
		[nz_id_pk] [int] IDENTITY(1,1) NOT NULL,
		[nz_broj] [int] NULL,
		[nz_nadnevak] [datetime] NULL,
		[nz_dj_id_fk] [int] NULL,
		[nz_napomena] [nvarchar](50) NULL,
		[nz_flag] [bit] NULL,
		[nz_proknjizeno] [bit] NULL,
	 CONSTRAINT [PK_NARUDZBENICA_ZAGLAVLJE] PRIMARY KEY CLUSTERED 
	(
		[nz_id_pk] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[NARUDZBENICA_ZAGLAVLJE]  WITH CHECK ADD  CONSTRAINT [FK_NARUDZBENICA_ZAGLAVLJE_DJELATNICI] FOREIGN KEY([nz_dj_id_fk])
	REFERENCES [dbo].[DJELATNICI] ([dj_id_pk])

	ALTER TABLE [dbo].[NARUDZBENICA_ZAGLAVLJE] CHECK CONSTRAINT [FK_NARUDZBENICA_ZAGLAVLJE_DJELATNICI]
END
GO



--
-- Definition for table NARUDZBENICA_STAVKE : 
--

GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'NARUDZBENICA_STAVKE')
BEGIN
	CREATE TABLE [dbo].[NARUDZBENICA_STAVKE](
		[ns_id_pk] [int] IDENTITY(1,1) NOT NULL,
		[ns_nz_id_fk] [int] NULL,
		[ns_artikal_id_fk] [int] NULL,
		[ns_kolicina] [decimal](16, 3) NULL,
	 CONSTRAINT [PK_NARUDZBENICA_STAVKE] PRIMARY KEY CLUSTERED 
	(
		[ns_id_pk] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[NARUDZBENICA_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_NARUDZBENICA_STAVKE_ARTIKLI] FOREIGN KEY([ns_artikal_id_fk])
	REFERENCES [dbo].[ARTIKLI] ([ar_id_pk])

	ALTER TABLE [dbo].[NARUDZBENICA_STAVKE] CHECK CONSTRAINT [FK_NARUDZBENICA_STAVKE_ARTIKLI]

	ALTER TABLE [dbo].[NARUDZBENICA_STAVKE]  WITH CHECK ADD  CONSTRAINT [FK_NARUDZBENICA_STAVKE_NARUDZBENICA_ZAGLAVLJE] FOREIGN KEY([ns_nz_id_fk])
	REFERENCES [dbo].[NARUDZBENICA_ZAGLAVLJE] ([nz_id_pk])

	ALTER TABLE [dbo].[NARUDZBENICA_STAVKE] CHECK CONSTRAINT [FK_NARUDZBENICA_STAVKE_NARUDZBENICA_ZAGLAVLJE]

END
GO


------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  A D D        C O L U M N S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  GRUPE_TOUCH_SCREEN.gt_order_index
--------  GRUPE_TOUCH_SCREEN.gt_color_index
--------  INVENTURA_ZAGLAVLJE.iz_zat_tot_pros_nab_vpc
--------  INVENTURA_ZAGLAVLJE.iz_zat_vpc
--------  INVENTURA_ZAGLAVLJE.iz_zat_pdv
--------  INVENTURA_ZAGLAVLJE.iz_zat_mpc
--------  INVENTURA_ZAGLAVLJE.iz_zat_pov_naknada
--------  INVENTURA_STAVKE.is_zat_tot_pros_nab_vpc
--------  INVENTURA_STAVKE.is_zat_osnovica
--------  INVENTURA_STAVKE.is_zat_pdv
--------  INVENTURA_STAVKE.is_zat_ukupno
--------  INVENTURA_STAVKE.is_zat_pov_naknada
--------  GRUPE_TOUCH_SCREEN_ARTIKLI.gt_ar_order
--------  RACUNI_ZAGLAVLJE.rz_nadnevak_isporuke
--------  PONUDA_ZAGLAVLJE.pnz_na_id_fk
--------  PONUDA_ZAGLAVLJE.pnz_status
--------  PRIMKE_ZAGLAVLJE.pr_status
--------  TVRTKE.tv_porezni_broj
--------  TVRTKE.tv_email
--------  TVRTKE.tv_adresa_broj
--------  TVRTKE.tv_mjesto_postanski_broj
--------  TVRTKE.tv_tel
--------  TVRTKE.tv_iban
--------  TVRTKE.tv_state
--------  TVRTKE.tv_sifra
--------  PROMJENA_CIJENE_ZAGLAVLJE.pcz_proknjizeno
--------  RACUNI_ZAGLAVLJE.rz_prat_dok_id_fk
--------  POCETNO_STANJE.ps_nabava_ukupno_pdv
--------  POCETNO_STANJE.ps_nabava_ukupno_vpc



GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_TOUCH_SCREEN' AND COLUMN_NAME = 'gt_order_index')
ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN] ADD gt_order_index int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_TOUCH_SCREEN' AND COLUMN_NAME = 'gt_color_index')
ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN] ADD gt_color_index int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_ZAGLAVLJE' AND COLUMN_NAME = 'iz_zat_tot_pros_nab_vpc')
ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE] ADD iz_zat_tot_pros_nab_vpc decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_ZAGLAVLJE' AND COLUMN_NAME = 'iz_zat_vpc')
ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE] ADD iz_zat_vpc decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_ZAGLAVLJE' AND COLUMN_NAME = 'iz_zat_pdv')
ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE] ADD iz_zat_pdv decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_ZAGLAVLJE' AND COLUMN_NAME = 'iz_zat_mpc')
ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE] ADD iz_zat_mpc decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_ZAGLAVLJE' AND COLUMN_NAME = 'iz_zat_pov_naknada')
ALTER TABLE [dbo].[INVENTURA_ZAGLAVLJE] ADD iz_zat_pov_naknada decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'is_zat_tot_pros_nab_vpc')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD is_zat_tot_pros_nab_vpc decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'is_zat_osnovica')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD is_zat_osnovica decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'is_zat_pdv')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD is_zat_pdv decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'is_zat_ukupno')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD is_zat_ukupno decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'INVENTURA_STAVKE' AND COLUMN_NAME = 'is_zat_pov_naknada')
ALTER TABLE [dbo].[INVENTURA_STAVKE] ADD is_zat_pov_naknada decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GRUPE_TOUCH_SCREEN_ARTIKLI' AND COLUMN_NAME = 'gt_ar_order')
ALTER TABLE [dbo].[GRUPE_TOUCH_SCREEN_ARTIKLI] ADD gt_ar_order int NULL 
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_nadnevak_isporuke')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_nadnevak_isporuke datetime NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PONUDA_ZAGLAVLJE' AND COLUMN_NAME = 'pnz_na_id_fk')
ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE] ADD pnz_na_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PONUDA_ZAGLAVLJE' AND COLUMN_NAME = 'pnz_status')
ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE] ADD pnz_status bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_status')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] ADD pr_status bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_porezni_broj')
ALTER TABLE [dbo].[TVRTKE] ADD tv_porezni_broj nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_email')
ALTER TABLE [dbo].[TVRTKE] ADD tv_email nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_adresa_broj')
ALTER TABLE [dbo].[TVRTKE] ADD tv_adresa_broj nvarchar(10)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_mjesto_postanski_broj')
ALTER TABLE [dbo].[TVRTKE] ADD tv_mjesto_postanski_broj int
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_tel')
ALTER TABLE [dbo].[TVRTKE] ADD tv_tel nvarchar(20)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_iban')
ALTER TABLE [dbo].[TVRTKE] ADD tv_iban nvarchar(30)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_state')
ALTER TABLE [dbo].[TVRTKE] ADD tv_state nvarchar(50)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_sifra')
ALTER TABLE [dbo].[TVRTKE] ADD tv_sifra nvarchar(30)
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PROMJENA_CIJENE_ZAGLAVLJE' AND COLUMN_NAME = 'pcz_proknjizeno')
ALTER TABLE [dbo].[PROMJENA_CIJENE_ZAGLAVLJE] ADD pcz_proknjizeno bit NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_prat_dok_id_fk')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] ADD rz_prat_dok_id_fk int NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'POCETNO_STANJE' AND COLUMN_NAME = 'ps_nabava_ukupno_pdv')
ALTER TABLE [dbo].[POCETNO_STANJE] ADD ps_nabava_ukupno_pdv decimal(12,2) NULL
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'POCETNO_STANJE' AND COLUMN_NAME = 'ps_nabava_ukupno_vpc')
ALTER TABLE [dbo].[POCETNO_STANJE] ADD ps_nabava_ukupno_vpc decimal(12,2) NULL
GO
 
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  D R O P        C O L U M N S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  RACUNI_ZAGLAVLJE.rz_datum_opomene
--------  RACUNI_ZAGLAVLJE.rz_datum_uplate
--------  PRIMKE_ZAGLAVLJE.rz_iznos_uplate
--------  PRIMKE_ZAGLAVLJE.pr_datum_placanja
--------  PRIMKE_ZAGLAVLJE.pr_iznos_placanja
--------  PRIMKE_ZAGLAVLJE.pr_povratna_naknada
--------  TISKACI.ts_chnr2_normal_left
--------  TISKACI.ts_chnr2_normal_right
--------  TISKACI.ts_chnr3_normal_col1
--------  TISKACI.ts_chnr3_normal_col2
--------  TISKACI.ts_chnr3_normal_col3
--------  TISKACI.ts_chnr4_normal_col1
--------  TISKACI.ts_chnr4_normal_col2
--------  TISKACI.ts_chnr4_normal_col3
--------  TISKACI.ts_chnr4_normal_col4
--------  TISKACI.ts_chnr2_bold_1_left
--------  TISKACI.ts_chnr2_bold_1_right
--------  TISKACI.ts_chnr2_bold_2_left
--------  TISKACI.ts_chnr2_bold_2_right
--------  TVRTKE.tv_tel_2
--------  TVRTKE.tv_fax
--------  TVRTKE.tv_kontakt_osoba_mob
--------  TVRTKE.tv_ziro_racun
--------  TVRTKE.tv_tel_1
--------  RACUNI_ZAGLAVLJE.rz_korisnik_kartice
--------  RACUNI_ZAGLAVLJE.rz_broj_kartice
--------  ARTIKLI.ar_barcode_to_check


GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_datum_opomene')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_datum_opomene
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_datum_uplate')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_datum_uplate
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'rz_iznos_uplate')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] DROP COLUMN rz_iznos_uplate
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_datum_placanja')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] DROP COLUMN pr_datum_placanja
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_iznos_placanja')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] DROP COLUMN pr_iznos_placanja
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PRIMKE_ZAGLAVLJE' AND COLUMN_NAME = 'pr_povratna_naknada')
ALTER TABLE [dbo].[PRIMKE_ZAGLAVLJE] DROP COLUMN pr_povratna_naknada
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_normal_left')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_normal_left
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_normal_right')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_normal_right
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr3_normal_col1')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr3_normal_col1
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr3_normal_col2')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr3_normal_col2
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr3_normal_col3')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr3_normal_col3
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col1')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col1
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col2')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col2
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col3')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col3
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr4_normal_col4')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr4_normal_col4
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_1_left')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_1_left
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_1_right')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_1_right
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_2_left')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_2_left
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TISKACI' AND COLUMN_NAME = 'ts_chnr2_bold_2_right')
ALTER TABLE [dbo].[TISKACI] DROP COLUMN ts_chnr2_bold_2_right
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_tel_2')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_tel_2
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_fax')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_fax
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_kontakt_osoba_mob')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_kontakt_osoba_mob
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_ziro_racun')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_ziro_racun
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'TVRTKE' AND COLUMN_NAME = 'tv_tel_1')
ALTER TABLE [dbo].[TVRTKE] DROP COLUMN tv_tel_1
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_korisnik_kartice')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_korisnik_kartice
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RACUNI_ZAGLAVLJE' AND COLUMN_NAME = 'rz_broj_kartice')
ALTER TABLE [dbo].[RACUNI_ZAGLAVLJE] DROP COLUMN rz_broj_kartice
GO
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ARTIKLI' AND COLUMN_NAME = 'ar_barcode_to_check')
ALTER TABLE [dbo].[ARTIKLI] DROP COLUMN ar_barcode_to_check
GO


------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  ACTIVITY LOG
------------------------------------------------
------------------------------------------------
------------------------------------------------
---- DROP CONSTRAITS
GO
	IF (OBJECT_ID('dbo.FK_ACTIVITY_LOG_DJELATNICI', 'F') IS NOT NULL)
	BEGIN
	    ALTER TABLE dbo.ACTIVITY_LOG DROP CONSTRAINT FK_ACTIVITY_LOG_DJELATNICI
	END
GO
---- DROP COLUMNS
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ACTIVITY_LOG' AND COLUMN_NAME = 'ac_djelatnik_id_fk')
ALTER TABLE [dbo].[ACTIVITY_LOG] DROP COLUMN ac_djelatnik_id_fk
GO
---- ADD COLUMNS
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ACTIVITY_LOG' AND COLUMN_NAME = 'ac_korisnik')
ALTER TABLE [dbo].[ACTIVITY_LOG] ADD ac_korisnik nvarchar(50) NULL
GO


------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  A L T E R        C O L U M N S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
ALTER TABLE [dbo].ARTIKLI ALTER column ar_pdv_fk int NOT NULL 
GO
ALTER TABLE [dbo].PRIMKE_STAVKE ALTER column ps_ar_cijena_vpc_osn decimal(16,4) NULL 
GO
ALTER TABLE [dbo].PRIMKE_STAVKE ALTER column ps_ar_kolicina decimal(16,4) NULL 
GO
ALTER TABLE [dbo].PRIMKE_STAVKE ALTER column ps_ar_cijena_vpc decimal(16,4) NULL 
GO
ALTER TABLE [dbo].PRIMKE_STAVKE ALTER column ps_ar_cijena_mpc decimal(16,4) NULL 
GO
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  C O N S T R A I N T S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARTIKLI]') AND name = N'UQ_ARTIKLI_ar_naziv')
	ALTER TABLE [dbo].[ARTIKLI] DROP CONSTRAINT [UQ_ARTIKLI_ar_naziv]
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TVRTKE]') AND name = N'UQ_TVRTKE_tv_ime')
	ALTER TABLE [dbo].[TVRTKE] DROP CONSTRAINT [UQ_TVRTKE_tv_ime]
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DOBAVLJACI]') AND name = N'UQ_DOBAVLJACI_do_name')
	ALTER TABLE [dbo].[DOBAVLJACI] DROP CONSTRAINT [UQ_DOBAVLJACI_do_name]
GO
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARTIKLI]') AND name = N'UQ_ARTIKLI_ar_barcode')
	ALTER TABLE [dbo].[ARTIKLI] DROP CONSTRAINT [UQ_ARTIKLI_ar_barcode]
GO
	ALTER TABLE [dbo].[ARTIKLI] ADD  CONSTRAINT [UQ_ARTIKLI_ar_naziv] UNIQUE NONCLUSTERED 
	([ar_naziv] ASC)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO
	ALTER TABLE [dbo].[TVRTKE] ADD  CONSTRAINT [UQ_TVRTKE_tv_ime] UNIQUE NONCLUSTERED 
	([tv_ime] ASC) WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO
	ALTER TABLE [dbo].[DOBAVLJACI] ADD  CONSTRAINT [UQ_DOBAVLJACI_do_name] UNIQUE NONCLUSTERED 
	([do_name] ASC)WITH (PAD_INDEX  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF) ON [PRIMARY]
GO
	IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PONUDA_ZAGLAVLJE_NARUCITELJI]') AND parent_object_id = OBJECT_ID(N'[dbo].[PONUDA_ZAGLAVLJE]'))
	BEGIN
		ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE]  WITH CHECK ADD  CONSTRAINT [FK_PONUDA_ZAGLAVLJE_NARUCITELJI] FOREIGN KEY([pnz_na_id_fk])
		REFERENCES [dbo].[NARUCITELJI] ([na_id_pk])
		ALTER TABLE [dbo].[PONUDA_ZAGLAVLJE] CHECK CONSTRAINT [FK_PONUDA_ZAGLAVLJE_NARUCITELJI]
	END
GO




------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  U P D A T E    F I E L D S
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
update GRUPE_TOUCH_SCREEN_ARTIKLI set gt_ar_order = ar_id_fk where gt_ar_order is null
GO
if not exists(select * from [SYS_PRINTERI] where sypr_name = 'EPSON TM U950')
BEGIN
	INSERT INTO [SYS_PRINTERI] ([sypr_id_pk], [sypr_name], [sypr_N], [sypr_B1], [sypr_B2], [sypr_cntr_text_normal], [sypr_cntr_text_bold_1], [sypr_cntr_text_bold_2], [sypr_cntr_ladica], [sypr_cntr_rezac])
	VALUES (11, N'EPSON TM U950', 40, 20, 20, N'CHR(27) + CHR(33) + CHR(1)', N'CHR(27) + CHR(33) + CHR(41)', N'CHR(27) + CHR(33) + CHR(61)', N'CHR(27) + p + CHR(0)+CHR(60) + CHR(240)', N'CHR(27) + i')
END
GO
if not exists(select * from [SYS_PRINTERI] where [sypr_id_pk] = 12)
BEGIN
	insert into SYS_PRINTERI (sypr_id_pk, sypr_name, sypr_N, sypr_B1, sypr_B2, sypr_cntr_text_normal, sypr_cntr_text_bold_1, sypr_cntr_text_bold_2, sypr_cntr_ladica, sypr_cntr_rezac) 
	values (12, 'BLUETOOTH 58mm', 42, 32, 16, 'CHR(27) + CHR(33) + CHR(1)', 'CHR(27) + CHR(33) + CHR(10)', 'CHR(27) + CHR(33) + CHR(40)', null, null)
END
GO
if not exists(select * from [SYS_PRINTERI] where [sypr_id_pk] = 13)
BEGIN
	INSERT INTO [dbo].[SYS_PRINTERI] ([sypr_id_pk], [sypr_name], [sypr_N], [sypr_B1], [sypr_B2], [sypr_cntr_text_normal], [sypr_cntr_text_bold_1], [sypr_cntr_text_bold_2], [sypr_cntr_ladica], [sypr_cntr_rezac])
	VALUES (13, N'SAMSUNG SRP 275', 40, 16, 16, N'CHR(27) + CHR(64)', N'CHR(27) + CHR(33) + CHR(40)', N'CHR(27) + CHR(33) + CHR(60)', N'CHR(27) + CHR(112) + CHR(00) + CHR(50) + CHR(250)', N'CHR(29) + CHR(86) + CHR(01) + CHR(49)')
END
GO

------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  ADDITIONAL SCRIPTS
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
update artikli set [ar_cijena_mpc_2] = NULL where ar_cijena_mpc_2 = -1
GO
update artikli set [ar_cijena_mpc_3] = NULL where ar_cijena_mpc_3 = -1
GO
update artikli set [ar_do_pdv_id_fk] = NULL where ar_do_pdv_id_fk = -1
GO
update artikli set [ar_do_cijena_vpc] = NULL where ar_do_cijena_vpc = -1
GO
update artikli set [ar_do_rabat] = NULL where ar_do_rabat = -1
GO
update artikli set [ar_zavisni_trosak] = NULL where ar_zavisni_trosak = -1
GO
update PROMJENA_CIJENE_ZAGLAVLJE set [pcz_proknjizeno] = 'true' where pcz_proknjizeno IS NULL
GO
------------------------------------------------
------------------------------------------------
------------------------------------------------
--------  UPDATE VERSION
------------------------------------------------
------------------------------------------------
------------------------------------------------
GO
UPDATE SYS_VERSION set syvs_nr_1 = 0
GO
UPDATE SYS_VERSION set syvs_nr_2 = 0
GO
UPDATE SYS_VERSION set syvs_nr_3 = 0
GO
 

