--
-- Definition for stored procedure System_TEST_DATABASE : 
--
GO
CREATE PROCEDURE [dbo].[System_TEST_DATABASE]
(
	@RetIznos int output
)
AS
	set @RetIznos = 1
GO

--
-- Definition for stored procedure System_Update_SYS_VERSION : 
--
GO
CREATE procedure [dbo].[System_Update_SYS_VERSION]
(
	@syvs_nr_1 int,
	@syvs_nr_2 int,
	@syvs_nr_3 int
)
as
update
	SYS_VERSION
set
	syvs_nr_1 = @syvs_nr_1,
	syvs_nr_2 = @syvs_nr_2,
	syvs_nr_3 = @syvs_nr_3
GO

--
-- Definition for stored procedure System_Get_SYS_VERSION : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_VERSION]
AS
Select * from SYS_VERSION
GO

--
-- Definition for stored procedure System_Get_SYS_JMJ : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_JMJ]
AS
Select * from SYS_JMJ
GO

--
-- Definition for stored procedure System_Get_PRINTERI : 
--
GO
CREATE procedure [dbo].[System_Get_PRINTERI]
AS
Select * from SYS_PRINTERI
GO

--
-- Definition for stored procedure System_Get_SYS_PLACANJA : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_PLACANJA]
AS
Select * from SYS_PLACANJA
GO

--
-- Definition for stored procedure System_DATABASE_REINDEX : 
--
GO
CREATE PROCEDURE [dbo].[System_DATABASE_REINDEX]
		AS
		DECLARE @TableName varchar(255)
		DECLARE TableCursor CURSOR FOR
		SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_TYPE = 'base table'
		OPEN TableCursor
		FETCH NEXT FROM TableCursor INTO @TableName
		WHILE @@FETCH_STATUS = 0
		BEGIN
		PRINT 'Reindexing ' + @TableName
		DBCC DBREINDEX(@TableName,' ',90)
		FETCH NEXT FROM TableCursor INTO @TableName
		END
		CLOSE TableCursor
		DEALLOCATE TableCursor
GO




--
-- Definition for stored procedure Skladiste_Get_STANJE_SKLADISTA_KOLICINE : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_STANJE_SKLADISTA_KOLICINE]
(
	@dateStart datetime,
	@dateEnd datetime
)
AS
BEGIN
	SELECT     ARTIKLI.*,  CASE WHEN ar_is_active =0 THEN 'NE' ELSE 'DA' END AS ar_is_active_str, 
			   GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_ARTIKALA.ga_name,  
			   SYS_ARTIKAL_KATEGORIJA.syak_name
	FROM       ARTIKLI LEFT OUTER JOIN
			   SYS_ARTIKAL_KATEGORIJA ON ARTIKLI.ar_kat_id_fk = SYS_ARTIKAL_KATEGORIJA.syak_id_pk LEFT OUTER JOIN
			   GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			   GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	WHERE	   ARTIKLI.ar_is_active = 1 and ARTIKLI.ar_kat_id_fk = 1
	
	SELECT SUM(PRIMKE_STAVKE.ps_ar_kolicina) AS PrimkeKolicina, PRIMKE_STAVKE.ps_ar_id_fk
	FROM PRIMKE_ZAGLAVLJE INNER JOIN
			PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk
	WHERE(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @dateStart AND @dateEnd) AND (PRIMKE_ZAGLAVLJE.pr_proknjizeno = 1)
	GROUP BY PRIMKE_STAVKE.ps_ar_id_fk

	SELECT SUM(IZDATNICE_STAVKE.is_kolicina) AS IzdatniceKolicina, IZDATNICE_STAVKE.is_ar_id_fk
	FROM IZDATNICE_ZAGLAVLJE INNER JOIN
			IZDATNICE_STAVKE ON IZDATNICE_ZAGLAVLJE.iz_id_pk = IZDATNICE_STAVKE.is_iz_id_fk
	WHERE (IZDATNICE_ZAGLAVLJE.iz_datum BETWEEN @dateStart AND @dateEnd) AND (IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 1)
	GROUP BY IZDATNICE_STAVKE.is_ar_id_fk

	SELECT SUM(RACUNI_STAVKE.rs_kolicina) AS UtrosakKolicina, ARTIKLI.ar_id_pk
	FROM RACUNI_ZAGLAVLJE INNER JOIN
		RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
		ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_vrijeme BETWEEN @dateStart AND @dateEnd)
	GROUP BY ARTIKLI.ar_id_pk

	SELECT SUM(INVENTURA_STAVKE.is_kol_razlika) AS InventuraKolicina, INVENTURA_STAVKE.is_ar_id_fk
	FROM INVENTURA_ZAGLAVLJE INNER JOIN
			INVENTURA_STAVKE ON INVENTURA_ZAGLAVLJE.iz_id_pk = INVENTURA_STAVKE.is_iz_id_fk
	WHERE (INVENTURA_ZAGLAVLJE.iz_datetime BETWEEN @dateStart AND @dateEnd) AND (INVENTURA_ZAGLAVLJE.iz_proknjizeno = 1)
	GROUP BY INVENTURA_STAVKE.is_ar_id_fk

	SELECT * FROM POCETNO_STANJE
END
GO



--
-- Definition for stored procedure Skladiste_Update_PROMJENA_CIJENE_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_PROMJENA_CIJENE_ALL]
(
	@pcz_id_pk int,
	@pcz_broj int,
	@pcz_pr_id_fk int, 
	@pcz_nadnevak Datetime,
	@pcz_description nvarchar(50),
	@pcz_zaduzenje_vpc decimal (12,2),
	@pcz_zaduzenje_pdv decimal (12,2),
	@pcz_zaduzenje_mpc decimal (12,2),
 	@pcz_proknjizeno bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_PROMJENA_CIJENE_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	------------
	update
		PROMJENA_CIJENE_ZAGLAVLJE
	set
		pcz_pr_id_fk = @pcz_pr_id_fk, 
		pcz_broj = @pcz_broj,
		pcz_nadnevak = @pcz_nadnevak,
		pcz_description =@pcz_description,
		pcz_zaduzenje_vpc = @pcz_zaduzenje_vpc,
		pcz_zaduzenje_pdv = @pcz_zaduzenje_pdv,
		pcz_zaduzenje_mpc = @pcz_zaduzenje_mpc,
		pcz_proknjizeno = @pcz_proknjizeno
	where
		pcz_id_pk = @pcz_id_pk
	------------

	delete from PROMJENA_CIJENE_STAVKE where pcs_pcz_id_fk = @pcz_id_pk
 
	------------ STAVKE ----------
	INSERT INTO PROMJENA_CIJENE_STAVKE
		(pcs_pcz_id_fk, pcs_ar_id_fk, pcs_ar_old_price_vpc, pcs_ar_old_pdv_id,  
		pcs_ar_old_price_mpc, pcs_ar_new_price_vpc, pcs_ar_new_pdv_id, pcs_ar_new_price_mpc,
		pcs_ar_kolicina_skladiste, pcs_ar_zaduzenje_vpc, pcs_ar_zaduzenje_pdv,pcs_ar_zaduzenje_mpc)
	SELECT 
		@pcz_id_pk, pcs_ar_id_fk, pcs_ar_old_price_vpc, pcs_ar_old_pdv_id,  
		pcs_ar_old_price_mpc, pcs_ar_new_price_vpc, pcs_ar_new_pdv_id, pcs_ar_new_price_mpc,
		pcs_ar_kolicina_skladiste, pcs_ar_zaduzenje_vpc, pcs_ar_zaduzenje_pdv,pcs_ar_zaduzenje_mpc
	FROM @Stavke_DTable

COMMIT
END
GO



--
-- Definition for stored procedure Skladiste_Set_ZAMJENA_ARTIKLA_SKLAD_DOKUMENTI : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_ZAMJENA_ARTIKLA_SKLAD_DOKUMENTI]
(
	@artikal_id_old int = null,
	@artikal_id_new int = null,
	@use_primke bit = null,
	@use_izdatnice bit = null,
	@use_inventure bit = null,
	@use_zpc bit = null
)
AS
if @use_primke IS NOT NULL
BEGIN  
	UPDATE PRIMKE_STAVKE SET ps_ar_id_fk = @artikal_id_new WHERE ps_ar_id_fk = @artikal_id_old	 
END
if @use_izdatnice IS NOT NULL
BEGIN  
	UPDATE IZDATNICE_STAVKE SET is_ar_id_fk = @artikal_id_new WHERE is_ar_id_fk = @artikal_id_old	 
END
if @use_inventure IS NOT NULL
BEGIN  
	UPDATE INVENTURA_STAVKE SET is_ar_id_fk = @artikal_id_new WHERE is_ar_id_fk = @artikal_id_old	 
END
if @use_zpc IS NOT NULL
BEGIN  
	 UPDATE PROMJENA_CIJENE_STAVKE SET pcs_ar_id_fk = @artikal_id_new WHERE pcs_ar_id_fk = @artikal_id_old
END
GO



--
-- Definition for stored procedure Skladiste_Insert_PROMJENA_CIJENE_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_PROMJENA_CIJENE_ALL]
(
	@RetVal_ID int output,
	@RetVal_BROJ int output,
	@pcz_broj int = NULL,
	@pcz_pr_id_fk int, 
	@pcz_nadnevak Datetime,
	@pcz_description nvarchar(50),
	@pcz_zaduzenje_vpc decimal (12,2),
	@pcz_zaduzenje_pdv decimal (12,2),
	@pcz_zaduzenje_mpc decimal (12,2),
	@pcz_proknjizeno bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_PROMJENA_CIJENE_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	------------
	declare @maxid as int
	select @maxid=max(pcz_broj) from PROMJENA_CIJENE_ZAGLAVLJE
	if @maxid is null
		begin
			SET @maxid=1
			SET @RetVal_BROJ=1
		end
	ELSE
		begin
			SET @maxid=@maxid+1
			SET @RetVal_BROJ=@maxid
		end
	------------
	if @pcz_broj is not null
		begin
			SET @RetVal_BROJ=@pcz_broj
		end
	------------
	insert into PROMJENA_CIJENE_ZAGLAVLJE
		(pcz_broj, pcz_pr_id_fk, pcz_nadnevak, pcz_description, pcz_zaduzenje_vpc, pcz_zaduzenje_pdv, pcz_zaduzenje_mpc, pcz_proknjizeno)
	values
		(@RetVal_BROJ, @pcz_pr_id_fk, @pcz_nadnevak, @pcz_description, @pcz_zaduzenje_vpc, @pcz_zaduzenje_pdv, @pcz_zaduzenje_mpc, @pcz_proknjizeno)
	SET @RetVal_ID = @@IDENTITY
 	------------ STAVKE ----------
	INSERT INTO PROMJENA_CIJENE_STAVKE
		(pcs_pcz_id_fk, pcs_ar_id_fk, pcs_ar_old_price_vpc, pcs_ar_old_pdv_id,  
		pcs_ar_old_price_mpc, pcs_ar_new_price_vpc, pcs_ar_new_pdv_id, pcs_ar_new_price_mpc,
		pcs_ar_kolicina_skladiste, pcs_ar_zaduzenje_vpc, pcs_ar_zaduzenje_pdv,pcs_ar_zaduzenje_mpc)
	SELECT 
		@RetVal_ID, pcs_ar_id_fk, pcs_ar_old_price_vpc, pcs_ar_old_pdv_id,  
		pcs_ar_old_price_mpc, pcs_ar_new_price_vpc, pcs_ar_new_pdv_id, pcs_ar_new_price_mpc,
		pcs_ar_kolicina_skladiste, pcs_ar_zaduzenje_vpc, pcs_ar_zaduzenje_pdv,pcs_ar_zaduzenje_mpc
	FROM @Stavke_DTable

COMMIT
END
GO






--
-- Definition for stored procedure Skladiste_Delete_PROMJENA_CIJENE_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_PROMJENA_CIJENE_ALL]
(
	@pcz_id_pk int
)
as
delete PROMJENA_CIJENE_STAVKE where pcs_pcz_id_fk = @pcz_id_pk
delete PROMJENA_CIJENE_ZAGLAVLJE where pcz_id_pk = @pcz_id_pk
GO




--
-- Definition for stored procedure Skladiste_Get_INIT_PROMJENA_CIJENE : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_PROMJENA_CIJENE]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(pcz_broj) from PROMJENA_CIJENE_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1
	declare @ID AS INT
	SELECT @ID=pcz_id_pk FROM PROMJENA_CIJENE_ZAGLAVLJE WHERE pcz_proknjizeno=0
	SELECT	PROMJENA_CIJENE_ZAGLAVLJE.*,   
			PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj
	FROM         PROMJENA_CIJENE_ZAGLAVLJE LEFT OUTER JOIN
                      PRIMKE_ZAGLAVLJE ON PROMJENA_CIJENE_ZAGLAVLJE.pcz_pr_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk
	WHERE (PROMJENA_CIJENE_ZAGLAVLJE.pcz_proknjizeno = 0)

	SELECT     PROMJENA_CIJENE_STAVKE.*, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk,GRUPE_ARTIKALA.ga_name, 
                    GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak,
					OLD_GRUPE_PDV.gpdv_name AS gpdv_old_name, OLD_GRUPE_PDV.gpdv_postotak AS gpdv_old_postotak,
					NEW_GRUPE_PDV.gpdv_name AS gpdv_new_name, NEW_GRUPE_PDV.gpdv_postotak AS gpdv_new_postotak
	FROM         PROMJENA_CIJENE_STAVKE LEFT OUTER JOIN
                    ARTIKLI ON PROMJENA_CIJENE_STAVKE.pcs_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                    GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
                    GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as OLD_GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_old_pdv_id = OLD_GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as NEW_GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_new_pdv_id = NEW_GRUPE_PDV.gpdv_id_pk
	WHERE	pcs_pcz_id_fk = @ID
END
GO



--
-- Definition for stored procedure Skladiste_Set_PROMJENA_CIJENE_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_PROMJENA_CIJENE_WRITE_MODE]
(
	@RetVal int output,
	@pcz_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT pcz_id_pk, pcz_proknjizeno FROM PROMJENA_CIJENE_ZAGLAVLJE WHERE pcz_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE PROMJENA_CIJENE_ZAGLAVLJE SET pcz_proknjizeno=0 WHERE pcz_id_pk=@pcz_id_pk
	END
END
GO





--
-- Definition for stored procedure Skladiste_Update_POCETNO_STANJE_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_POCETNO_STANJE_ALL]
(
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_POCETNO_STANJE_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN
	------------
	delete from POCETNO_STANJE
	------------ STAVKE ----------
	INSERT INTO POCETNO_STANJE
		(ps_ar_id_fk, ps_pdv_id_fk, 
		ps_pov_naknada,
		ps_vpc_nabavna, ps_nabava_ukupno_pdv, ps_nabava_ukupno_vpc, 
		ps_vpc, ps_mpc, ps_kolicina,
		ps_zaduzenje_vpc, ps_zaduzenje_pdv, ps_zaduzenje_mpc, 
		ps_uk_pov_naknada)
	SELECT 
		ps_ar_id_fk, ps_pdv_id_fk, 
		ps_pov_naknada,
		ps_vpc_nabavna, ps_nabava_ukupno_pdv, ps_nabava_ukupno_vpc, 
		ps_vpc, ps_mpc, ps_kolicina,
		ps_zaduzenje_vpc, ps_zaduzenje_pdv, ps_zaduzenje_mpc, 
		ps_uk_pov_naknada
	FROM @Stavke_DTable
COMMIT
END
GO



--
-- Definition for stored procedure Skladiste_Insert_POCETNO_STANJE : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_POCETNO_STANJE]
(
	@ps_ar_id_fk int,
	@ps_pdv_id_fk int,
	@ps_vpc decimal (12, 2),
	@ps_mpc decimal (12, 2),
	@ps_kolicina decimal (12, 3),
	@ps_vpc_nabavna decimal (12, 3),
	@ps_nabava_ukupno_pdv decimal (12, 2),
	@ps_nabava_ukupno_vpc decimal (12, 2),
	@ps_zaduzenje_vpc decimal (12, 2),
	@ps_zaduzenje_pdv decimal (12, 2),
	@ps_zaduzenje_mpc decimal (12, 2),
	@ps_pov_naknada decimal (12, 2),
	@ps_uk_pov_naknada decimal (12, 2)
)
as
insert into POCETNO_STANJE
	(ps_ar_id_fk, ps_pdv_id_fk,
	ps_vpc, ps_mpc, ps_kolicina, ps_vpc_nabavna, 
	ps_nabava_ukupno_pdv, ps_nabava_ukupno_vpc, 
	ps_zaduzenje_vpc, ps_zaduzenje_pdv, ps_zaduzenje_mpc, 
	ps_pov_naknada, ps_uk_pov_naknada)
values
	(@ps_ar_id_fk, @ps_pdv_id_fk,
	@ps_vpc, @ps_mpc, @ps_kolicina, @ps_vpc_nabavna, 
	@ps_nabava_ukupno_pdv, @ps_nabava_ukupno_vpc, 
	@ps_zaduzenje_vpc, @ps_zaduzenje_pdv, @ps_zaduzenje_mpc, 
	@ps_pov_naknada, @ps_uk_pov_naknada)
select scope_identity()
GO



--
-- Definition for stored procedure Skladiste_Update_NARUDZBENICA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_NARUDZBENICA_ALL]
(
	@nz_id_pk int,
	@nz_broj int,
	@nz_nadnevak Datetime,
	@nz_napomena nvarchar(50),
	@nz_dj_id_fk int,
	@nz_flag bit,
	@nz_proknjizeno bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_NARUDZBENICA_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	update
		NARUDZBENICA_ZAGLAVLJE
	set
		nz_broj = @nz_broj,
		nz_nadnevak = @nz_nadnevak,
		nz_napomena = @nz_napomena,
		nz_dj_id_fk = @nz_dj_id_fk,
		nz_flag = @nz_flag,
		nz_proknjizeno = @nz_proknjizeno
	where
		nz_id_pk = @nz_id_pk


	DELETE FROM NARUDZBENICA_STAVKE WHERE ns_nz_id_fk = @nz_id_pk
 
	------------ STAVKE ----------
	INSERT INTO NARUDZBENICA_STAVKE
		(ns_nz_id_fk, ns_artikal_id_fk, ns_kolicina)
	SELECT 
		@nz_id_pk, ns_artikal_id_fk, ns_kolicina
	FROM @Stavke_DTable


COMMIT
END
GO

--
-- Definition for stored procedure Skladiste_Insert_NARUDZBENICA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_NARUDZBENICA_ALL]
(
	@RetVal_ID int output,
	@RetVal_BROJ int output,
	@nz_nadnevak Datetime,
	@nz_dj_id_fk int,
	@nz_napomena nvarchar(50),
	@nz_flag bit,
	@nz_proknjizeno bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_NARUDZBENICA_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	------------
	declare @maxid as int
	select @maxid=max(nz_broj) from NARUDZBENICA_ZAGLAVLJE
	if @maxid is null
		begin
			SET @maxid=1
			SET @RetVal_BROJ=1
		end
	ELSE
		begin
			SET @maxid=@maxid+1
			SET @RetVal_BROJ=@maxid
		end
	------------
	insert into NARUDZBENICA_ZAGLAVLJE
		(nz_broj, nz_nadnevak, nz_dj_id_fk, nz_napomena, nz_flag, nz_proknjizeno)
	values
		(@RetVal_BROJ, @nz_nadnevak, @nz_dj_id_fk, @nz_napomena, @nz_flag, @nz_proknjizeno)
	SET @RetVal_ID = @@IDENTITY
 
 
	------------ STAVKE ----------
	INSERT INTO NARUDZBENICA_STAVKE
		(ns_nz_id_fk, ns_artikal_id_fk, ns_kolicina)
	SELECT 
		@RetVal_ID, ns_artikal_id_fk, ns_kolicina
	FROM @Stavke_DTable

COMMIT
END
GO

--
-- Definition for stored procedure Skladiste_Delete_NARUDZBENICA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_NARUDZBENICA_ALL]
(
	@nz_id_pk int
)
as
delete NARUDZBENICA_STAVKE where ns_nz_id_fk = @nz_id_pk
delete NARUDZBENICA_ZAGLAVLJE where nz_id_pk = @nz_id_pk
GO

--
-- Definition for stored procedure Skladiste_Update_INVENTURA_ALL : 
--
GO
create procedure [dbo].[Skladiste_Update_INVENTURA_ALL]
(
	@iz_id_pk int,
	@iz_datetime Datetime,
	@iz_napomena nvarchar(100),
	@iz_tot_pros_nab_vpc decimal (12, 2),
	@iz_vpc decimal (12, 2),
	@iz_pdv decimal (12, 2),
	@iz_mpc decimal (12, 2),
	@iz_proknjizeno bit,
	@iz_tot_pov_naknada decimal (12, 2),
	@iz_zat_tot_pros_nab_vpc decimal (12, 2),
	@iz_zat_vpc decimal (12, 2),
	@iz_zat_pdv decimal (12, 2),
	@iz_zat_mpc decimal (12, 2),
	@iz_zat_pov_naknada decimal (12, 2),
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_INVENTURA_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	------------
	update
		INVENTURA_ZAGLAVLJE
	set
		iz_datetime = @iz_datetime,
		iz_napomena = @iz_napomena,
		iz_tot_pros_nab_vpc = @iz_tot_pros_nab_vpc,
		iz_vpc = @iz_vpc,
		iz_pdv = @iz_pdv,
		iz_mpc = @iz_mpc,
		iz_proknjizeno = @iz_proknjizeno, 
		iz_tot_pov_naknada = @iz_tot_pov_naknada,
		iz_zat_vpc = @iz_zat_vpc,
		iz_zat_pdv = @iz_zat_pdv,
		iz_zat_mpc = @iz_zat_mpc,
		iz_zat_tot_pros_nab_vpc = @iz_zat_tot_pros_nab_vpc,
		iz_zat_pov_naknada = @iz_zat_pov_naknada
	where
		iz_id_pk = @iz_id_pk
	------------

	DELETE FROM INVENTURA_STAVKE WHERE is_iz_id_fk = @iz_id_pk

	------------ STAVKE ----------
	INSERT INTO INVENTURA_STAVKE
		(is_iz_id_fk, is_ar_id_fk, is_kol_blagajna, is_kol_zatecena,  
		is_kol_razlika, is_pros_nab_vpc, is_vpc, is_pdv_id_fk,
		is_mpc, is_tot_pros_nab_vpc, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, is_pov_naknada, is_tot_pov_naknada,  
		is_zat_tot_pros_nab_vpc, is_zat_osnovica, is_zat_pdv, 
		is_zat_ukupno, is_zat_pov_naknada)
	SELECT 
		@iz_id_pk, is_ar_id_fk, is_kol_blagajna, is_kol_zatecena,  
		is_kol_razlika, is_pros_nab_vpc, is_vpc, is_pdv_id_fk,
		is_mpc, is_tot_pros_nab_vpc, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, is_pov_naknada, is_tot_pov_naknada,  
		is_zat_tot_pros_nab_vpc, is_zat_osnovica, is_zat_pdv, 
		is_zat_ukupno, is_zat_pov_naknada
	FROM @Stavke_DTable

COMMIT
END
GO

--
-- Definition for stored procedure Skladiste_Insert_INVENTURA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_INVENTURA_ALL]
(
	@RetVal_ID int output,
	@RetVal_BROJ int output,
	@iz_datetime Datetime,
	@iz_napomena nvarchar(100),
	@iz_tot_pros_nab_vpc decimal (12, 2),
	@iz_vpc decimal (12, 2),
	@iz_pdv decimal (12, 2),
	@iz_mpc decimal (12, 2),
	@iz_proknjizeno bit,
	@iz_tot_pov_naknada decimal (12, 2),
	@iz_zat_tot_pros_nab_vpc decimal (12, 2),
	@iz_zat_vpc decimal (12, 2),
	@iz_zat_pdv decimal (12, 2),
	@iz_zat_mpc decimal (12, 2),
	@iz_zat_pov_naknada decimal (12, 2),
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_INVENTURA_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	------------
	declare @maxid as int
	select @maxid=max(iz_broj) from INVENTURA_ZAGLAVLJE
	if @maxid is null
		begin
			SET @maxid=1
			SET @RetVal_BROJ=1
		end
	ELSE
		begin
			SET @maxid=@maxid+1
			SET @RetVal_BROJ=@maxid
		end
	
	------------

	insert into INVENTURA_ZAGLAVLJE
		(iz_broj, iz_datetime, iz_napomena, iz_tot_pros_nab_vpc, iz_vpc, iz_pdv, iz_mpc, iz_proknjizeno, iz_tot_pov_naknada, iz_zat_vpc, iz_zat_pdv, iz_zat_mpc, iz_zat_pov_naknada, iz_zat_tot_pros_nab_vpc)
	values
		(@RetVal_BROJ, @iz_datetime, @iz_napomena, @iz_tot_pros_nab_vpc, @iz_vpc, @iz_pdv, @iz_mpc, @iz_proknjizeno, @iz_tot_pov_naknada, @iz_zat_vpc, @iz_zat_pdv, @iz_zat_mpc, @iz_zat_pov_naknada, @iz_zat_tot_pros_nab_vpc)
	SET @RetVal_ID = @@IDENTITY

	------------ STAVKE ----------
	INSERT INTO INVENTURA_STAVKE
		(is_iz_id_fk, is_ar_id_fk, is_kol_blagajna, is_kol_zatecena,  
		is_kol_razlika, is_pros_nab_vpc, is_vpc, is_pdv_id_fk,
		is_mpc, is_tot_pros_nab_vpc, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, is_pov_naknada, is_tot_pov_naknada,  
		is_zat_tot_pros_nab_vpc, is_zat_osnovica, is_zat_pdv, 
		is_zat_ukupno, is_zat_pov_naknada)
	SELECT 
		@RetVal_ID, is_ar_id_fk, is_kol_blagajna, is_kol_zatecena,  
		is_kol_razlika, is_pros_nab_vpc, is_vpc, is_pdv_id_fk,
		is_mpc, is_tot_pros_nab_vpc, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, is_pov_naknada, is_tot_pov_naknada,  
		is_zat_tot_pros_nab_vpc, is_zat_osnovica, is_zat_pdv, 
		is_zat_ukupno, is_zat_pov_naknada
	FROM @Stavke_DTable

COMMIT
END
GO



--
-- Definition for stored procedure Skladiste_Get_INVENTURA_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_INVENTURA_LIST]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
SELECT		INVENTURA_ZAGLAVLJE.*
FROM		INVENTURA_ZAGLAVLJE 
where		INVENTURA_ZAGLAVLJE.iz_proknjizeno = 1 AND INVENTURA_ZAGLAVLJE.iz_datetime BETWEEN @day_start AND @day_end 
-- REKAP POREZA - NABAVA
SELECT		SUM(INVENTURA_STAVKE.is_tot_pros_nab_vpc) AS OSNOVICA, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, INVENTURA_STAVKE.is_pdv_id_fk
FROM	INVENTURA_STAVKE inner JOIN
			INVENTURA_ZAGLAVLJE ON INVENTURA_STAVKE.is_iz_id_fk = INVENTURA_ZAGLAVLJE.iz_id_pk LEFT JOIN
			GRUPE_PDV ON INVENTURA_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
WHERE	(INVENTURA_ZAGLAVLJE.iz_proknjizeno=1 AND INVENTURA_ZAGLAVLJE.iz_datetime BETWEEN @day_start AND @day_end)
GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, INVENTURA_STAVKE.is_pdv_id_fk
ORDER BY GRUPE_PDV.gpdv_postotak
-- REKAP POREZA - ZADUZENJE
SELECT		SUM(INVENTURA_STAVKE.is_tot_ukupno) AS TOTAL, 
			SUM(INVENTURA_STAVKE.is_tot_pov_naknada) as POV_NAK, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, INVENTURA_STAVKE.is_pdv_id_fk
FROM	INVENTURA_STAVKE inner JOIN
			INVENTURA_ZAGLAVLJE ON INVENTURA_STAVKE.is_iz_id_fk = INVENTURA_ZAGLAVLJE.iz_id_pk LEFT JOIN
			GRUPE_PDV ON INVENTURA_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
WHERE	(INVENTURA_ZAGLAVLJE.iz_proknjizeno=1 AND INVENTURA_ZAGLAVLJE.iz_datetime BETWEEN @day_start AND @day_end)
GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, INVENTURA_STAVKE.is_pdv_id_fk
ORDER BY GRUPE_PDV.gpdv_postotak
END
GO


--
-- Definition for stored procedure Skladiste_Delete_INVENTURA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_INVENTURA_ALL]
(
	@iz_id_pk int
)
as
delete INVENTURA_STAVKE where is_iz_id_fk = @iz_id_pk
delete INVENTURA_ZAGLAVLJE where iz_id_pk = @iz_id_pk
GO


--
-- Definition for stored procedure Servis_Update_EXTERNAL_DATABASE : 
--
GO
CREATE procedure [dbo].[Servis_Update_EXTERNAL_DATABASE]
(
	@ext_id_pk int,
	@ext_name nvarchar(50), 
	@ext_description nvarchar(100), 
	@ext_db_host nvarchar(50), 
	@ext_db_name nvarchar(20), 
	@ext_db_user nvarchar(20), 
	@ext_db_password nvarchar(20),
	@ext_index int
)
as
update
	EXTERNAL_DATABASES
set
	ext_name = @ext_name, 
	ext_description = @ext_description, 
	ext_db_host = @ext_db_host, 
	ext_db_name = @ext_db_name, 
	ext_db_user = @ext_db_user, 
	ext_db_password = @ext_db_password,
	ext_index = @ext_index
where
	ext_id_pk = @ext_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_EXTERNAL_DATABASE : 
--
GO
CREATE procedure [dbo].[Servis_Insert_EXTERNAL_DATABASE]
(
	@ext_name nvarchar(50), 
	@ext_description nvarchar(100), 
	@ext_db_host nvarchar(50), 
	@ext_db_name nvarchar(20), 
	@ext_db_user nvarchar(20), 
	@ext_db_password nvarchar(20),
	@ext_index int
)
as
insert into EXTERNAL_DATABASES
	(ext_name, ext_description, ext_db_host, ext_db_name, ext_db_user, ext_db_password, ext_index)
values
	(@ext_name, @ext_description, @ext_db_host, @ext_db_name, @ext_db_user, @ext_db_password, @ext_index)
select scope_identity()
GO

--
-- Definition for stored procedure Servis_Get_EXTERNAL_DATABASES : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_EXTERNAL_DATABASES]
AS
Select * from EXTERNAL_DATABASES
GO

--
-- Definition for stored procedure Servis_Delete_EXTERNAL_DATABASE : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_EXTERNAL_DATABASE]
(
	@ext_id_pk int
)
AS
delete EXTERNAL_DATABASES where ext_id_pk = @ext_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_ACTIVITY_LOG : 
--
GO
CREATE procedure [dbo].[Servis_Insert_ACTIVITY_LOG]
(
	@ac_time datetime,
	@ac_korisnik nvarchar(50),
	@ac_action nvarchar(50),	
    @ac_description nvarchar(100)
)
as
insert into ACTIVITY_LOG
	(ac_time, ac_korisnik, ac_action, ac_description)
values
	(@ac_time, @ac_korisnik, @ac_action, @ac_description)

select scope_identity()
GO

--
-- Definition for stored procedure Servis_Get_ACTIVITY_LOG : 
--
GO
CREATE procedure [dbo].[Servis_Get_ACTIVITY_LOG]
(
	@date_start DateTime,
	@date_end DateTime
)
AS

BEGIN
	SELECT * FROM ACTIVITY_LOG 
	WHERE ACTIVITY_LOG.ac_time between  @date_start and @date_end
END
GO

--
-- Definition for stored procedure Servis_Delete_ACTIVITY_LOG_PERIOD : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_ACTIVITY_LOG_PERIOD]
(
	@day_start datetime,
	@day_end datetime
)
AS
delete ACTIVITY_LOG where ACTIVITY_LOG.ac_time BETWEEN @day_start AND @day_end
GO

--
-- Definition for stored procedure Servis_Delete_ACTIVITY_LOG : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_ACTIVITY_LOG]
(
@ac_id_pk int
)
AS
delete ACTIVITY_LOG where ac_id_pk = @ac_id_pk
GO

--
-- Definition for stored procedure Skladiste_Update_IZDATNICA_ALL : 
--
GO
create procedure [dbo].[Skladiste_Update_IZDATNICA_ALL]
(
	@iz_id_pk int,
	@iz_broj int,
	@iz_datum Datetime,
	@iz_mo_id_fk int,
	@iz_opis nvarchar(50),
	@iz_napomena nvarchar(50),
	@iz_proknjizeno bit,
	@iz_tot_pros_nab_vpc decimal (12, 2),
	@iz_vpc decimal (12, 2),
	@iz_pdv decimal (12, 2),
	@iz_mpc decimal (12, 2), 
	@iz_tot_pov_naknada decimal (12, 2),
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_IZDATNICE_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	------------
	update
		IZDATNICE_ZAGLAVLJE
	set
		iz_broj = @iz_broj,
		iz_datum = @iz_datum,
		iz_mo_id_fk = @iz_mo_id_fk,
		iz_opis = @iz_opis,
		iz_napomena = @iz_napomena,
		iz_proknjizeno = @iz_proknjizeno, 
		iz_tot_pros_nab_vpc = @iz_tot_pros_nab_vpc,
		iz_vpc = @iz_vpc,
		iz_pdv = @iz_pdv,
		iz_mpc = @iz_mpc,
		iz_tot_pov_naknada = @iz_tot_pov_naknada
	where
		iz_id_pk = @iz_id_pk
 

	delete from IZDATNICE_STAVKE where is_iz_id_fk = @iz_id_pk
 
	------------ STAVKE ----------
	INSERT INTO IZDATNICE_STAVKE
		(is_iz_id_fk, is_ar_id_fk, is_kolicina, is_pros_nab_vpc,  
		is_vpc, is_pdv_id_fk, is_mpc, is_tot_pros_nab_vpc,
		is_tot_osnovica, is_tot_pdv, is_tot_ukupno, 
		is_pov_naknada, is_tot_pov_naknada)
	SELECT 
		@iz_id_pk, is_ar_id_fk, is_kolicina, is_pros_nab_vpc,  
		is_vpc, is_pdv_id_fk, is_mpc, is_tot_pros_nab_vpc,
		is_tot_osnovica, is_tot_pdv, is_tot_ukupno, 
		is_pov_naknada, is_tot_pov_naknada
	FROM @Stavke_DTable

COMMIT
END
GO





--
-- Definition for stored procedure Skladiste_Insert_IZDATNICA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_IZDATNICA_ALL]
(
	@RetVal_ID int output,
	@iz_broj int,
	@iz_mo_id_fk int,
	@iz_datum Datetime,
	@iz_opis nvarchar(50),
	@iz_napomena nvarchar(50),
	@iz_proknjizeno bit,
	@iz_tot_pros_nab_vpc decimal (12, 2),
	@iz_vpc decimal (12, 2),
	@iz_pdv decimal (12, 2),
	@iz_mpc decimal (12, 2),
	@iz_tot_pov_naknada decimal (12, 2),
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_IZDATNICE_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	insert into IZDATNICE_ZAGLAVLJE
		(iz_broj, iz_datum, iz_mo_id_fk, iz_opis, iz_napomena, iz_proknjizeno, iz_tot_pros_nab_vpc, iz_vpc, iz_pdv, iz_mpc, iz_tot_pov_naknada)
	values
		(@iz_broj, @iz_datum, @iz_mo_id_fk, @iz_opis, @iz_napomena, @iz_proknjizeno, @iz_tot_pros_nab_vpc, @iz_vpc, @iz_pdv, @iz_mpc, @iz_tot_pov_naknada)
	SET @RetVal_ID = @@IDENTITY
 
	------------ STAVKE ----------
	INSERT INTO IZDATNICE_STAVKE
		(is_iz_id_fk, is_ar_id_fk, is_kolicina, is_pros_nab_vpc,  
		is_vpc, is_pdv_id_fk, is_mpc, is_tot_pros_nab_vpc,
		is_tot_osnovica, is_tot_pdv, is_tot_ukupno, 
		is_pov_naknada, is_tot_pov_naknada)
	SELECT 
		@RetVal_ID, is_ar_id_fk, is_kolicina, is_pros_nab_vpc,  
		is_vpc, is_pdv_id_fk, is_mpc, is_tot_pros_nab_vpc,
		is_tot_osnovica, is_tot_pdv, is_tot_ukupno, 
		is_pov_naknada, is_tot_pov_naknada
	FROM @Stavke_DTable

COMMIT
END
GO



--
-- Definition for stored procedure Skladiste_Delete_IZDATNICA_ALL : 
--
GO
create procedure [dbo].[Skladiste_Delete_IZDATNICA_ALL]
(
	@iz_id_pk int
)
as
delete IZDATNICE_STAVKE where is_iz_id_fk = @iz_id_pk
delete IZDATNICE_ZAGLAVLJE where iz_id_pk = @iz_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_MJESTA_OTPREME]
(
	@mo_id_pk Int
)
AS
SELECT * FROM IZDATNICE_ZAGLAVLJE WHERE iz_mo_id_fk = @mo_id_pk
GO



--
-- Definition for stored procedure Skladiste_Get_IZDATNICE_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_IZDATNICE_LIST]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
SELECT IZDATNICE_ZAGLAVLJE.*, MJESTA_OTPREME.mo_oznaka
FROM IZDATNICE_ZAGLAVLJE LEFT OUTER JOIN
				MJESTA_OTPREME ON IZDATNICE_ZAGLAVLJE.iz_mo_id_fk = MJESTA_OTPREME.mo_id_pk
where IZDATNICE_ZAGLAVLJE.iz_proknjizeno=1 AND IZDATNICE_ZAGLAVLJE.iz_datum BETWEEN @day_start AND @day_end
-- REKAP POREZA - NABAVA
SELECT		SUM(IZDATNICE_STAVKE.is_tot_pros_nab_vpc) AS OSNOVICA, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, IZDATNICE_STAVKE.is_pdv_id_fk
FROM	IZDATNICE_STAVKE inner JOIN
			IZDATNICE_ZAGLAVLJE ON IZDATNICE_STAVKE.is_iz_id_fk = IZDATNICE_ZAGLAVLJE.iz_id_pk LEFT JOIN
			GRUPE_PDV ON IZDATNICE_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
WHERE	(IZDATNICE_ZAGLAVLJE.iz_proknjizeno=1 AND IZDATNICE_ZAGLAVLJE.iz_datum BETWEEN @day_start AND @day_end)
GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, IZDATNICE_STAVKE.is_pdv_id_fk
ORDER BY GRUPE_PDV.gpdv_postotak
-- REKAP POREZA - ZADUZENJE
SELECT		SUM(IZDATNICE_STAVKE.is_tot_ukupno) AS TOTAL, 
			SUM(IZDATNICE_STAVKE.is_tot_pov_naknada) as POV_NAK, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, IZDATNICE_STAVKE.is_pdv_id_fk
FROM	IZDATNICE_STAVKE inner JOIN
			IZDATNICE_ZAGLAVLJE ON IZDATNICE_STAVKE.is_iz_id_fk = IZDATNICE_ZAGLAVLJE.iz_id_pk LEFT JOIN
			GRUPE_PDV ON IZDATNICE_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
WHERE	(IZDATNICE_ZAGLAVLJE.iz_proknjizeno=1 AND IZDATNICE_ZAGLAVLJE.iz_datum BETWEEN @day_start AND @day_end)
GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, IZDATNICE_STAVKE.is_pdv_id_fk
ORDER BY GRUPE_PDV.gpdv_postotak
END
GO

--
-- Definition for stored procedure Osnovno_Update_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_MJESTA_OTPREME]
(
	@mo_id_pk int,
	@mo_oznaka nvarchar(20),
	@mo_note nvarchar(20)
)
as
update
	MJESTA_OTPREME
set
	mo_oznaka = @mo_oznaka,
	mo_note = @mo_note
where
	mo_id_pk = @mo_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_MJESTA_OTPREME]
(
	@mo_oznaka nvarchar(20),
	@mo_note nvarchar(20)
)
as
insert into MJESTA_OTPREME
	(mo_oznaka, mo_note)
values
	(@mo_oznaka, @mo_note)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_MJESTA_OTPREME : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_MJESTA_OTPREME]
AS
Select * from MJESTA_OTPREME
GO

--
-- Definition for stored procedure Osnovno_Delete_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_MJESTA_OTPREME]
(
	@mo_id_pk int
)
as
delete from MJESTA_OTPREME where mo_id_pk = @mo_id_pk
GO

--
-- Definition for stored procedure Management_Insert_START_LOG : 
--
GO
CREATE procedure [dbo].[Management_Insert_START_LOG]
(

	@sp_nadnevak datetime,
	@sp_start datetime,
	@sp_ks_id_fk int
)
as
insert into START_LOG
	(sp_nadnevak, sp_start, sp_ks_id_fk)
values
	(@sp_nadnevak, @sp_start, @sp_ks_id_fk)
select scope_identity()
GO

--
-- Definition for stored procedure Management_Get_START_LOG : 
--
GO
CREATE procedure [dbo].[Management_Get_START_LOG]
(
	@sp_ks_id_fk int,
	@day_start DateTime,
	@day_end DateTime

)

as
if @sp_ks_id_fk is null
	SELECT     min(sp_id_pk) as sp_id_pk, sp_nadnevak, min(sp_start) as sp_start, convert(varchar(10),min(sp_start) , 108) as sp_time
	FROM         START_LOG
	WHERE (START_LOG.sp_nadnevak between  @day_start and @day_end)
	GROUP BY  sp_nadnevak
else
	SELECT     min(sp_id_pk) as sp_id_pk, sp_nadnevak, min(sp_start) as sp_start, convert(varchar(10),min(sp_start) , 108) as sp_time
	FROM         START_LOG
	WHERE (START_LOG.sp_nadnevak between  @day_start and @day_end) and sp_ks_id_fk = @sp_ks_id_fk
	GROUP BY  sp_nadnevak
GO


--
-- Definition for stored procedure Management_Update_PONUDA_STATUS : 
--
GO
CREATE procedure [dbo].[Management_Update_PONUDA_STATUS]
(
	@pnz_id_pk int,
	@pnz_status bit
)
as
update
	PONUDA_ZAGLAVLJE
set
	pnz_status = @pnz_status
where
	pnz_id_pk = @pnz_id_pk
GO

--
-- Definition for stored procedure Management_Update_PONUDA_ALL : 
--
GO
CREATE procedure [dbo].[Management_Update_PONUDA_ALL]
(
	@pnz_id_pk int,
	@pnz_broj int,
	@pnz_nadnevak datetime,
	@pnz_dj_id_fk int,
	@pnz_tv_id_fk int,
	@pnz_na_id_fk int,
	@pnz_napomena nvarchar(100),
	@pnz_status bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_PONUDA_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	update
		PONUDA_ZAGLAVLJE
	set
		pnz_broj = @pnz_broj,
		pnz_nadnevak = @pnz_nadnevak,
		pnz_dj_id_fk = @pnz_dj_id_fk,
		pnz_tv_id_fk = @pnz_tv_id_fk,
		pnz_na_id_fk = @pnz_na_id_fk, 
		pnz_napomena = @pnz_napomena,
		pnz_status = @pnz_status
	where
		pnz_id_pk = @pnz_id_pk

	delete from PONUDA_STAVKE where pns_ponuda_id_fk = @pnz_id_pk
 
	------------ STAVKE ----------
	INSERT INTO PONUDA_STAVKE
		(pns_ponuda_id_fk, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, 
		pns_pdv, pns_gpdv_id_fk,  
		pns_napomena, pns_popust, 
		pns_pov_nak, pns_tot_pov_nak)
	SELECT 
		@pnz_id_pk, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, 
		pns_pdv, pns_gpdv_id_fk,  
		pns_napomena, pns_popust, 
		pns_pov_nak, pns_tot_pov_nak
	FROM @Stavke_DTable

COMMIT
END
GO

--
-- Definition for stored procedure Management_Insert_PONUDA_ALL : 
--
GO
CREATE procedure [dbo].[Management_Insert_PONUDA_ALL]
(
	@RetVal_ID int output,
	@pnz_broj int,
	@pnz_nadnevak datetime,
	@pnz_dj_id_fk int,
	@pnz_tv_id_fk int,
	@pnz_na_id_fk int,
	@pnz_napomena nvarchar(100),
	@pnz_status bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_PONUDA_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	insert into PONUDA_ZAGLAVLJE
		(pnz_broj, pnz_nadnevak, pnz_dj_id_fk, pnz_tv_id_fk, pnz_na_id_fk, pnz_napomena, pnz_status)
	values
		(@pnz_broj, @pnz_nadnevak, @pnz_dj_id_fk, @pnz_tv_id_fk, @pnz_na_id_fk, @pnz_napomena, @pnz_status)
	SET @RetVal_ID = @@IDENTITY
 
	------------ STAVKE ----------
	INSERT INTO PONUDA_STAVKE
		(pns_ponuda_id_fk, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, 
		pns_pdv, pns_gpdv_id_fk,  
		pns_napomena, pns_popust, 
		pns_pov_nak, pns_tot_pov_nak)
	SELECT 
		@RetVal_ID, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, 
		pns_pdv, pns_gpdv_id_fk,  
		pns_napomena, pns_popust, 
		pns_pov_nak, pns_tot_pov_nak
	FROM @Stavke_DTable

COMMIT
END
GO

--
-- Definition for stored procedure Management_Get_PONUDA_BROJ_NEXT : 
--
GO
CREATE procedure [dbo].[Management_Get_PONUDA_BROJ_NEXT]
(
	@RetVal_Broj int output
)

as

select @RetVal_Broj = max(pnz_broj) from dbo.PONUDA_ZAGLAVLJE

BEGIN
	if  @RetVal_Broj IS null
		set @RetVal_Broj=1
	else
		set @RetVal_Broj=@RetVal_Broj+1
END
GO

--
-- Definition for stored procedure Management_Delete_PONUDA_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Management_Delete_PONUDA_ALL]
(
	@pnz_id_pk int
)
AS
delete from PONUDA_STAVKE where pns_ponuda_id_fk = @pnz_id_pk
delete from PONUDA_ZAGLAVLJE where pnz_id_pk = @pnz_id_pk
GO

--
-- Definition for stored procedure Izvjesca_Get_POSEBNO_IZVJESCE : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_POSEBNO_IZVJESCE]
(
	@day_start datetime,
	@day_end datetime,
	@DjelatnikID INT,
	@NacinPlacanjaID INT,
	@TvrtkaID INT,
	@NaruciteljID INT,
	@KasaID INT
)
AS
BEGIN
	declare @SQL VARCHAR(max)
	declare @Filter VARCHAR(max)
	set @Filter=''

	if not @DjelatnikID is null
		set @Filter=' and rz_djelatnik_id_fk ='+cast(@DjelatnikID as varchar(10))
	if not @NacinPlacanjaID is null
		set @Filter=@Filter+' and rz_placanje_id_fk ='+cast(@NacinPlacanjaID as varchar(10))
	if not @TvrtkaID is null
		set @Filter=@Filter+' and rz_tvrtka_id_fk ='+cast(@TvrtkaID as varchar(10))
	if not @NaruciteljID is null
		set @Filter=@Filter+' and rz_narucitelj_id_fk ='+cast(@NaruciteljID as varchar(10))
	if not @KasaID is null
		set @Filter=@Filter+' and rz_kasa_id_fk ='+cast(@KasaID as varchar(10))
	SET @SQL='SELECT  ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, 
					  RACUNI_STAVKE.rs_cijena, SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina, SUM(RACUNI_STAVKE.rs_iznos) AS Total 
				FROM  RACUNI_ZAGLAVLJE LEFT OUTER JOIN
                      RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
                      ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                      NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
				WHERE (RACUNI_ZAGLAVLJE.rz_dan between  '''+convert(varchar(10),@day_start,101)+''' and '''+convert(varchar(10),@day_end,101)+''' )'+@Filter+
				' GROUP BY ARTIKLI.ar_sifra, ARTIKLI.ar_naziv,  ARTIKLI.ar_jmj, RACUNI_STAVKE.rs_cijena'
execute (@SQL)

END
GO



--
-- Definition for stored procedure Skladiste_Update_PRIMKA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_PRIMKA_ALL]
(
	@pr_id_pk int,
	@pr_sys_broj int,
	@pr_broj nvarchar(25),
	@pr_pcz_id_fk int,
	@pr_dobavljac_id_fk int,
	@pr_datum Datetime,
	@pr_datum_knjizenja Datetime,
	@pr_datum_dospijeca Datetime,
	@pr_ukupno_marza decimal (12, 2),
	@pr_osnovica decimal (12, 2),
	@pr_PDV decimal (12, 2),
	@pr_ukupno decimal (12, 2),
	@pr_napomena nvarchar(50),
	@pr_storno_sign nvarchar(1),
	@pr_storno_id_fk int,
	@pr_proknjizeno bit,
	@pr_zaduzenje_vpc decimal (12, 2),
	@pr_zaduzenje_pdv decimal (12, 2),
	@pr_zaduzenje_mpc decimal (12, 2),
	@pr_zaduzenje_pov_naknada decimal (12, 2),
	@pr_status bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_PRIMKE_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN

	update
		PRIMKE_ZAGLAVLJE
	set
		pr_sys_broj = @pr_sys_broj,
		pr_broj = @pr_broj,
		pr_dobavljac_id_fk = @pr_dobavljac_id_fk,
		pr_pcz_id_fk = @pr_pcz_id_fk,
		pr_datum = @pr_datum,
		pr_datum_knjizenja = @pr_datum_knjizenja,
		pr_datum_dospijeca = @pr_datum_dospijeca,
		pr_ukupno_marza =@pr_ukupno_marza, 
		pr_osnovica =@pr_osnovica, 
		pr_PDV = @pr_PDV,
		pr_ukupno = @pr_ukupno,
		pr_napomena = @pr_napomena,
		pr_storno_sign = @pr_storno_sign,
		pr_storno_id_fk = @pr_storno_id_fk,
		pr_proknjizeno = @pr_proknjizeno,
		pr_zaduzenje_vpc = @pr_zaduzenje_vpc,
		pr_zaduzenje_pdv = @pr_zaduzenje_pdv,
		pr_zaduzenje_mpc = @pr_zaduzenje_mpc,
		pr_zaduzenje_pov_naknada = @pr_zaduzenje_pov_naknada,
		pr_status = @pr_status
	where
		pr_id_pk = @pr_id_pk


	DELETE FROM PRIMKE_STAVKE WHERE ps_pr_id_fk = @pr_id_pk
 
	------------ STAVKE ----------
	INSERT INTO PRIMKE_STAVKE
		(ps_pr_id_fk, ps_ar_id_fk, ps_ar_kolicina, ps_ar_cijena_vpc_osn,  
		ps_ar_rabat, ps_ar_cijena_vpc, ps_ar_pdv_id_fk, ps_ar_cijena_mpc,
		ps_ar_zavisni_trosak_vpc, ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_old_vpc, ps_old_pdv_id_fk, ps_old_mpc,  
		ps_calc_marza_JMJ, ps_calc_marza_percent, ps_calc_marza_ukupno, 
		ps_calc_vpc, ps_calc_pdv_id_fk, ps_calc_mpc, 
		ps_zaduzenje_vpc, ps_zaduzenje_pdv, ps_zaduzenje_mpc, 
		ps_pov_naknada, ps_tot_pov_naknada)
	SELECT 
		@pr_id_pk, ps_ar_id_fk, ps_ar_kolicina, ps_ar_cijena_vpc_osn,  
		ps_ar_rabat, ps_ar_cijena_vpc, ps_ar_pdv_id_fk, ps_ar_cijena_mpc,
		ps_ar_zavisni_trosak_vpc, ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_old_vpc, ps_old_pdv_id_fk, ps_old_mpc,  
		ps_calc_marza_JMJ, ps_calc_marza_percent, ps_calc_marza_ukupno,
		ps_calc_vpc, ps_calc_pdv_id_fk, ps_calc_mpc, 
		ps_zaduzenje_vpc, ps_zaduzenje_pdv, ps_zaduzenje_mpc, 
		ps_pov_naknada, ps_tot_pov_naknada
	FROM @Stavke_DTable

COMMIT
END
GO




--
-- Definition for stored procedure Skladiste_Update_PRIMKA_ZAGLAVLJE : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_PRIMKA_ZAGLAVLJE]
(
	@pr_id_pk int,
	@pr_sys_broj int,
	@pr_broj nvarchar(25),
	@pr_dobavljac_id_fk int,
	@pr_pcz_id_fk int,
	@pr_datum Datetime,
	@pr_datum_knjizenja Datetime,
	@pr_datum_dospijeca Datetime,
	@pr_osnovica decimal (12, 2),
	@pr_PDV decimal (12, 2),
	@pr_ukupno decimal (12, 2),
	@pr_napomena nvarchar(50),
	@pr_storno_sign nvarchar(1),
	@pr_storno_id_fk int,
	@pr_proknjizeno bit,
	@pr_zaduzenje_vpc decimal (12, 2),
	@pr_zaduzenje_pdv decimal (12, 2),
	@pr_zaduzenje_mpc decimal (12, 2),
	@pr_zaduzenje_pov_naknada decimal (12, 2),
	@pr_status bit
)
as
update
	PRIMKE_ZAGLAVLJE
set
	pr_sys_broj = @pr_sys_broj,
	pr_broj = @pr_broj,
	pr_dobavljac_id_fk = @pr_dobavljac_id_fk,
	pr_pcz_id_fk = @pr_pcz_id_fk,
	pr_datum = @pr_datum,
	pr_datum_knjizenja = @pr_datum_knjizenja,
	pr_datum_dospijeca = @pr_datum_dospijeca,
    pr_osnovica =@pr_osnovica, 
	pr_PDV = @pr_PDV,
	pr_ukupno = @pr_ukupno,
	pr_napomena = @pr_napomena,
	pr_storno_sign = @pr_storno_sign,
	pr_storno_id_fk = @pr_storno_id_fk,
	pr_proknjizeno = @pr_proknjizeno,
	pr_zaduzenje_vpc = @pr_zaduzenje_vpc,
	pr_zaduzenje_pdv = @pr_zaduzenje_pdv,
	pr_zaduzenje_mpc = @pr_zaduzenje_mpc,
	pr_zaduzenje_pov_naknada = @pr_zaduzenje_pov_naknada,
	pr_status = @pr_status
where
	pr_id_pk = @pr_id_pk
GO





--
-- Definition for stored procedure Skladiste_Set_PRIMKA_ZPC : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_PRIMKA_ZPC]
(
	@pr_id_pk int,
	@pr_pcz_id_fk int
)
AS
update dbo.PRIMKE_ZAGLAVLJE set	pr_pcz_id_fk = @pr_pcz_id_fk where pr_id_pk =@pr_id_pk
GO

--
-- Definition for stored procedure Skladiste_Set_PRIMKA_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_PRIMKA_WRITE_MODE]
(
	@RetVal int output,
	@pr_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT pr_id_pk, pr_proknjizeno FROM PRIMKE_ZAGLAVLJE WHERE pr_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE PRIMKE_ZAGLAVLJE SET pr_proknjizeno=0 WHERE pr_id_pk=@pr_id_pk
	END
END
GO



--
-- Definition for stored procedure Skladiste_Insert_PRIMKA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_PRIMKA_ALL]
(
	@RetVal_ID int output,
	@pr_sys_broj int,
	@pr_broj nvarchar(25),
	@pr_pcz_id_fk int,
	@pr_dobavljac_id_fk int,
	@pr_datum Datetime,
	@pr_datum_knjizenja Datetime,
	@pr_datum_dospijeca Datetime,
	@pr_ukupno_marza decimal (12, 2),
	@pr_osnovica decimal (12, 2),
	@pr_PDV decimal (12, 2),
	@pr_ukupno decimal (12, 2),
	@pr_napomena nvarchar(50),
	@pr_storno_sign nvarchar(1),
	@pr_storno_id_fk int,
	@pr_proknjizeno bit,
	@pr_zaduzenje_vpc decimal (12, 2),
	@pr_zaduzenje_pdv decimal (12, 2),
	@pr_zaduzenje_mpc decimal (12, 2),
	@pr_zaduzenje_pov_naknada decimal (12, 2),
	@pr_status bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_PRIMKE_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN
	------------
	insert into PRIMKE_ZAGLAVLJE
		(pr_sys_broj, pr_broj, pr_dobavljac_id_fk, pr_pcz_id_fk, pr_datum, pr_datum_knjizenja, pr_datum_dospijeca, pr_ukupno_marza, pr_osnovica, pr_PDV, pr_ukupno, pr_napomena, pr_storno_sign, pr_storno_id_fk, pr_proknjizeno, pr_zaduzenje_vpc, pr_zaduzenje_pdv, pr_zaduzenje_mpc, pr_zaduzenje_pov_naknada, pr_status)
	values
		(@pr_sys_broj, @pr_broj, @pr_dobavljac_id_fk, @pr_pcz_id_fk, @pr_datum, @pr_datum_knjizenja, @pr_datum_dospijeca, @pr_ukupno_marza, @pr_osnovica, @pr_PDV, @pr_ukupno, @pr_napomena, @pr_storno_sign, @pr_storno_id_fk, @pr_proknjizeno, @pr_zaduzenje_vpc, @pr_zaduzenje_pdv, @pr_zaduzenje_mpc, @pr_zaduzenje_pov_naknada, @pr_status)
	SET @RetVal_ID = @@IDENTITY
 	------------ STAVKE ----------
	INSERT INTO PRIMKE_STAVKE
		(ps_pr_id_fk, ps_ar_id_fk, ps_ar_kolicina, ps_ar_cijena_vpc_osn,  
		ps_ar_rabat, ps_ar_cijena_vpc, ps_ar_pdv_id_fk, ps_ar_cijena_mpc,
		ps_ar_zavisni_trosak_vpc, ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_old_vpc, ps_old_pdv_id_fk, ps_old_mpc,  
		ps_calc_marza_JMJ, ps_calc_marza_percent, ps_calc_marza_ukupno,
		ps_calc_vpc, ps_calc_pdv_id_fk, ps_calc_mpc, 
		ps_zaduzenje_vpc, ps_zaduzenje_pdv, ps_zaduzenje_mpc, 
		ps_pov_naknada, ps_tot_pov_naknada)
	SELECT 
		@RetVal_ID, ps_ar_id_fk, ps_ar_kolicina, ps_ar_cijena_vpc_osn,  
		ps_ar_rabat, ps_ar_cijena_vpc, ps_ar_pdv_id_fk, ps_ar_cijena_mpc,
		ps_ar_zavisni_trosak_vpc, ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_old_vpc, ps_old_pdv_id_fk, ps_old_mpc,  
		ps_calc_marza_JMJ, ps_calc_marza_percent, ps_calc_marza_ukupno,
		ps_calc_vpc, ps_calc_pdv_id_fk, ps_calc_mpc, 
		ps_zaduzenje_vpc, ps_zaduzenje_pdv, ps_zaduzenje_mpc, 
		ps_pov_naknada, ps_tot_pov_naknada
	FROM @Stavke_DTable
COMMIT
END
GO



--
-- Definition for stored procedure Skladiste_Get_PROMJENA_CIJENE_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_PROMJENA_CIJENE_LIST]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
SELECT		PROMJENA_CIJENE_ZAGLAVLJE.*,   
			PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj
FROM         PROMJENA_CIJENE_ZAGLAVLJE LEFT OUTER JOIN
                      PRIMKE_ZAGLAVLJE ON PROMJENA_CIJENE_ZAGLAVLJE.pcz_pr_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk
WHERE	PROMJENA_CIJENE_ZAGLAVLJE.pcz_proknjizeno = 1 AND 
		(PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak BETWEEN @day_start AND @day_end)

-- REKAP POREZA - OLD VALUES
SELECT SUM(PROMJENA_CIJENE_STAVKE.pcs_ar_old_price_mpc * PROMJENA_CIJENE_STAVKE.pcs_ar_kolicina_skladiste) AS TOTAL, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PROMJENA_CIJENE_STAVKE.pcs_ar_old_pdv_id
	FROM	PROMJENA_CIJENE_STAVKE inner JOIN
				PROMJENA_CIJENE_ZAGLAVLJE ON PROMJENA_CIJENE_STAVKE.pcs_pcz_id_fk = PROMJENA_CIJENE_ZAGLAVLJE.pcz_id_pk LEFT JOIN
				GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_old_pdv_id = GRUPE_PDV.gpdv_id_pk
	WHERE	(PROMJENA_CIJENE_ZAGLAVLJE.pcz_proknjizeno=1 AND PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak BETWEEN @day_start AND @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PROMJENA_CIJENE_STAVKE.pcs_ar_old_pdv_id
	ORDER BY GRUPE_PDV.gpdv_postotak

-- REKAP POREZA - NEW VALUES
SELECT SUM(PROMJENA_CIJENE_STAVKE.pcs_ar_new_price_mpc * PROMJENA_CIJENE_STAVKE.pcs_ar_kolicina_skladiste) AS TOTAL, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PROMJENA_CIJENE_STAVKE.pcs_ar_new_pdv_id
	FROM	PROMJENA_CIJENE_STAVKE inner JOIN
				PROMJENA_CIJENE_ZAGLAVLJE ON PROMJENA_CIJENE_STAVKE.pcs_pcz_id_fk = PROMJENA_CIJENE_ZAGLAVLJE.pcz_id_pk LEFT JOIN
				GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_new_pdv_id = GRUPE_PDV.gpdv_id_pk
	WHERE	(PROMJENA_CIJENE_ZAGLAVLJE.pcz_proknjizeno=1 AND PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak BETWEEN @day_start AND @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PROMJENA_CIJENE_STAVKE.pcs_ar_new_pdv_id
	ORDER BY GRUPE_PDV.gpdv_postotak
END
GO



--
-- Definition for stored procedure Skladiste_Delete_PRIMKA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_PRIMKA_ALL]
(
	@pr_id_pk int
)
as
delete PRIMKE_STAVKE where ps_pr_id_fk = @pr_id_pk
delete PRIMKE_ZAGLAVLJE where pr_id_pk = @pr_id_pk
GO

--
-- Definition for stored procedure Servis_Get_DNEVNI_POLOG_BY_NADNEVAK : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_DNEVNI_POLOG_BY_NADNEVAK]
(
	@dp_vrijeme DateTime
)
AS
SELECT * FROM DNEVNI_POLOG WHERE dp_vrijeme = @dp_vrijeme
GO

--
-- Definition for stored procedure Servis_Update_DNEVNI_POLOG : 
--
GO
CREATE procedure [dbo].[Servis_Update_DNEVNI_POLOG]
(
	@dp_vrijeme DateTime,
	@dp_iznos Decimal(12, 2)
)
as
BEGIN 
	DECLARE	@return_id int
	SELECT  TOP 1 @return_id = dp_id_pk FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @dp_vrijeme
	 IF @return_id IS NULL
		begin
			insert into DNEVNI_POLOG (dp_vrijeme, dp_iznos)	values	(@dp_vrijeme, @dp_iznos)
			select scope_identity()
		end
	else
	begin
		UPDATE DNEVNI_POLOG SET dp_iznos=@dp_iznos WHERE dp_id_pk= @return_id
		select @return_id
	end
END
GO

--
-- Definition for stored procedure Servis_Insert_DNEVNI_POLOG : 
--
GO
CREATE procedure [dbo].[Servis_Insert_DNEVNI_POLOG]
(
	@dp_vrijeme DateTime,
	@dp_iznos Decimal(12, 2)
)
as
BEGIN 
	DECLARE	@return_id int
	SELECT  TOP 1 @return_id = dp_id_pk FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @dp_vrijeme
	 IF @return_id IS NULL
		begin
			insert into DNEVNI_POLOG (dp_vrijeme, dp_iznos)	values	(@dp_vrijeme, @dp_iznos)
			select scope_identity()
		end
END
GO

--
-- Definition for stored procedure Servis_Get_DNEVNI_POLOG_LIST_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_DNEVNI_POLOG_LIST_ALL]
AS
Select * from DNEVNI_POLOG
GO

--
-- Definition for stored procedure Servis_Delete_DNEVNI_POLOG : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_DNEVNI_POLOG]
(
	@dp_id_pk int
)
AS
delete DNEVNI_POLOG where dp_id_pk = @dp_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_TOUCH_SCREEN_ARTIKAL : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_TOUCH_SCREEN_ARTIKAL]
(
	@gt_id_fk int,
	@ar_id_fk int,
	@gt_ar_order int
)
as
insert into GRUPE_TOUCH_SCREEN_ARTIKLI
	(gt_id_fk, ar_id_fk, gt_ar_order)
values
	(@gt_id_fk, @ar_id_fk, @gt_ar_order)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_TOUCH_SCREEN_GRUPE : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_TOUCH_SCREEN_GRUPE]
(
	@gt_id_pk Int
)
AS
SELECT * FROM GRUPE_TOUCH_SCREEN_ARTIKLI WHERE gt_id_fk = @gt_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN_BY_ARTIKAL_ID : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN_BY_ARTIKAL_ID]
(
	@ar_id_fk int
)
AS
delete GRUPE_TOUCH_SCREEN_ARTIKLI where ar_id_fk = @ar_id_fk
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL_ALL]
(
	@gt_id_fk int
)
AS
delete from GRUPE_TOUCH_SCREEN_ARTIKLI where gt_id_fk = @gt_id_fk
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL]
(
	@gt_id_fk int,
	@ar_id_fk int
)
AS
delete from GRUPE_TOUCH_SCREEN_ARTIKLI where gt_id_fk = @gt_id_fk and ar_id_fk = @ar_id_fk
GO

--
-- Definition for stored procedure Osnovno_Update_GRUPE_TOUCH_SCREEN : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_TOUCH_SCREEN]
(
	@gt_id_pk int,
	@gt_name nvarchar(30),
	@gt_active bit,
	@gt_order_index int,
	@gt_color_index int
)
as
update
	GRUPE_TOUCH_SCREEN
set
	gt_name = @gt_name,
	gt_active = @gt_active,
	gt_order_index = @gt_order_index,
	gt_color_index = @gt_color_index
where
	gt_id_pk = @gt_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_TOUCH_SCREEN : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_TOUCH_SCREEN]
(
	@gt_name nvarchar(30),
	@gt_active bit,
	@gt_order_index int,
	@gt_color_index int
)
as
insert into GRUPE_TOUCH_SCREEN
	(gt_name, gt_active, gt_order_index, gt_color_index)
values
	(@gt_name, @gt_active, @gt_order_index, @gt_color_index)
select scope_identity()
GO



--
-- Definition for stored procedure Osnovno_Get_GRUPE_TOUCH_SCREEN_ARTIKLI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_TOUCH_SCREEN_ARTIKLI]
(
	@ar_is_active bit = null
)
AS
SELECT     GRUPE_TOUCH_SCREEN.gt_id_pk, GRUPE_TOUCH_SCREEN.gt_name, GRUPE_TOUCH_SCREEN.gt_order_index, GRUPE_TOUCH_SCREEN.gt_color_index, 
		   CASE WHEN gt_active =0 THEN 'NE' ELSE 'DA' END AS gt_active_str ,GRUPE_TOUCH_SCREEN.gt_active, 
		   COUNT (TBL1.ar_id_pk ) AS broj_artikala
FROM       GRUPE_TOUCH_SCREEN LEFT OUTER JOIN
                GRUPE_TOUCH_SCREEN_ARTIKLI ON GRUPE_TOUCH_SCREEN.gt_id_pk = GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk LEFT OUTER JOIN
				(SELECT artikli.ar_id_pk FROM artikli WHERE @ar_is_active is null or  ARTIKLI.ar_is_active = 1) AS TBL1 ON GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk = TBL1.ar_id_pk
GROUP BY  GRUPE_TOUCH_SCREEN.gt_id_pk, GRUPE_TOUCH_SCREEN.gt_name, GRUPE_TOUCH_SCREEN.gt_active, GRUPE_TOUCH_SCREEN.gt_order_index, GRUPE_TOUCH_SCREEN.gt_color_index
ORDER BY GRUPE_TOUCH_SCREEN.gt_order_index

SELECT  GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk, GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk, GRUPE_TOUCH_SCREEN_ARTIKLI.gt_ar_order,  
		GRUPE_TOUCH_SCREEN.gt_id_pk, GRUPE_TOUCH_SCREEN.gt_name, GRUPE_TOUCH_SCREEN.gt_active, GRUPE_TOUCH_SCREEN.gt_color_index,
		ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv,ARTIKLI.ar_jmj, 
		ARTIKLI.ar_cijena_mpc_1, ARTIKLI.ar_color_index, ARTIKLI.ar_size_index
FROM    GRUPE_TOUCH_SCREEN_ARTIKLI INNER JOIN
                   GRUPE_TOUCH_SCREEN ON GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk = GRUPE_TOUCH_SCREEN.gt_id_pk INNER JOIN
                   ARTIKLI ON GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk = ARTIKLI.ar_id_pk
 WHERE  @ar_is_active is null or ARTIKLI.ar_is_active = 1
GO



--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN]
(
	@gt_id_pk int
)
AS
delete from GRUPE_TOUCH_SCREEN_ARTIKLI where gt_id_fk = @gt_id_pk
delete from GRUPE_TOUCH_SCREEN where gt_id_pk = @gt_id_pk
GO

--
-- Definition for stored procedure Servis_Update_ADMINISTRATOR : 
--
GO
CREATE procedure [dbo].[Servis_Update_ADMINISTRATOR]
(
	@adm_id_pk int,
	@adm_name nvarchar(50),
	@adm_password int,
	@adm_rf_id nvarchar(25)
)
as
update
	ADMINISTRATORS
set
	adm_name = @adm_name,
	adm_password = @adm_password,
	adm_rf_id = @adm_rf_id
where
	adm_id_pk = @adm_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_ADMINISTRATOR : 
--
GO
CREATE procedure [dbo].[Servis_Insert_ADMINISTRATOR]
(
	@adm_name nvarchar(50),
	@adm_password int,
	@adm_rf_id nvarchar(25)
)
as
insert into ADMINISTRATORS
	(adm_name, adm_password, adm_rf_id)
values
	(@adm_name, @adm_password, @adm_rf_id)
select scope_identity()
GO

--
-- Definition for stored procedure Servis_Delete_ADMINISTRATOR : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_ADMINISTRATOR]
(
	@adm_id_pk int
)
AS
delete ADMINISTRATORS where adm_id_pk = @adm_id_pk
GO

--
-- Definition for stored procedure Servis_Get_ADMINISTRATORS : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_ADMINISTRATORS]
AS
Select * from ADMINISTRATORS
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_ARTIKLI]
(
	@ar_id_pk Int
)
AS
SELECT * FROM RACUNI_STAVKE WHERE rs_artikal_id_fk = @ar_id_pk
SELECT * FROM GRUPE_TOUCH_SCREEN_ARTIKLI WHERE ar_id_fk = @ar_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_ARTIKLI_PDV_GRUPA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_ARTIKLI_PDV_GRUPA]
(
	@ar_pdv_fk_current int,
	@ar_pdv_fk_new int
)
as
update ARTIKLI
set ar_pdv_fk = @ar_pdv_fk_new
where ar_pdv_fk = @ar_pdv_fk_current
GO

--
-- Definition for stored procedure Osnovno_Update_ARTIKLI_CIJENA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_ARTIKLI_CIJENA]
(
	@ar_id_pk int,
	@ar_pdv_fk int,
	@ar_cijena_vpc decimal(10, 2),
	@ar_cijena_mpc_1 decimal(10, 2)
)
as
update
	ARTIKLI
set
	ar_pdv_fk = @ar_pdv_fk,
	ar_cijena_vpc = @ar_cijena_vpc,
	ar_cijena_mpc_1 = @ar_cijena_mpc_1
where
	ar_id_pk = @ar_id_pk
GO



--
-- Definition for stored procedure Osnovno_Update_ARTIKLI : 
--
GO

CREATE procedure [dbo].[Osnovno_Update_ARTIKLI]
(
	@ar_id_pk int,
	@ar_sifra nvarchar(15),
	@ar_barcode nvarchar(30),
	@ar_naziv nvarchar(50),
	@ar_jmj nvarchar(5),
	@ar_pdv_fk int,
	@ar_cijena_vpc decimal(10, 2),
	@ar_cijena_mpc_1 decimal(10, 2),
	@ar_cijena_mpc_2 decimal(10, 2),
	@ar_cijena_mpc_3 decimal(10, 2),
	@ar_min_kol decimal(10, 2),
	@ar_grupa_fk int,
	@ar_povratna_naknada decimal(10, 2), 
	@ar_description nvarchar(300),
	@ar_color_index int,
	@ar_size_index int,
	@ar_is_active bit,
	@ar_kat_id_fk int,
	@ar_kalo int,
	@ar_kpd_sifra nvarchar(10)
)
as
update
	ARTIKLI
set
	ar_sifra = @ar_sifra,
	ar_barcode = @ar_barcode,
	ar_naziv = @ar_naziv,
	ar_jmj = @ar_jmj,
	ar_pdv_fk = @ar_pdv_fk,
	ar_cijena_vpc = @ar_cijena_vpc,
	ar_cijena_mpc_1 = @ar_cijena_mpc_1,
	ar_cijena_mpc_2 = @ar_cijena_mpc_2,
	ar_cijena_mpc_3 = @ar_cijena_mpc_3,
	ar_min_kol = @ar_min_kol,
	ar_grupa_fk = @ar_grupa_fk,
	ar_povratna_naknada = @ar_povratna_naknada, 
	ar_description = @ar_description,
	ar_color_index = @ar_color_index,
	ar_size_index = @ar_size_index,
	ar_is_active = @ar_is_active,
	ar_kat_id_fk = @ar_kat_id_fk,
	ar_kalo = @ar_kalo,
	ar_kpd_sifra = @ar_kpd_sifra
where
	ar_id_pk = @ar_id_pk
GO




--
-- Definition for stored procedure Osnovno_Update_ARTIKLI_KPD_SIFRA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_ARTIKLI_KPD_SIFRA]
(
	@ar_id_pk int,
	@ar_kpd_sifra nvarchar(10)
)
as
update ARTIKLI
set ar_kpd_sifra = @ar_kpd_sifra
where ar_id_pk = @ar_id_pk
GO



--
-- Definition for stored procedure Osnovno_Insert_ARTIKLI : 
--
GO

CREATE procedure [dbo].[Osnovno_Insert_ARTIKLI]
(
	@ar_sifra nvarchar(15),
	@ar_barcode nvarchar(30),
	@ar_naziv nvarchar(50),
	@ar_jmj nvarchar(5),
	@ar_pdv_fk int,
	@ar_cijena_vpc decimal(10, 2),
	@ar_cijena_mpc_1 decimal(10, 2),
	@ar_cijena_mpc_2 decimal(10, 2),
	@ar_cijena_mpc_3 decimal(10, 2),
	@ar_min_kol decimal(10, 2),
	@ar_grupa_fk int,
	@ar_povratna_naknada decimal(10, 2), 
	@ar_description nvarchar(300),
	@ar_color_index int,
	@ar_size_index int,
	@ar_is_active bit,
	@ar_kat_id_fk int,
	@ar_kalo int,
	@ar_kpd_sifra nvarchar(10)
)
as

insert into ARTIKLI
	(ar_sifra, ar_barcode, ar_naziv, ar_jmj,
	ar_pdv_fk, ar_cijena_vpc,
	ar_cijena_mpc_1, ar_cijena_mpc_2, ar_cijena_mpc_3,
	ar_min_kol,
	ar_grupa_fk,
	ar_povratna_naknada, ar_description,  
	ar_color_index, ar_size_index, ar_is_active, ar_kat_id_fk, ar_kalo, ar_kpd_sifra)
values
	(@ar_sifra, @ar_barcode, @ar_naziv, @ar_jmj,
	@ar_pdv_fk, @ar_cijena_vpc,
	@ar_cijena_mpc_1, @ar_cijena_mpc_2, @ar_cijena_mpc_3,
	@ar_min_kol,
	@ar_grupa_fk,
	@ar_povratna_naknada, @ar_description, 
	@ar_color_index, @ar_size_index, @ar_is_active, @ar_kat_id_fk, @ar_kalo, @ar_kpd_sifra)
select scope_identity()
GO
GO



--
-- Definition for stored procedure Osnovno_DeleteInfo_GRUPE_PDV : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_GRUPE_PDV]
(
	@gpdv_id_pk Int
)
AS
SELECT * FROM ARTIKLI WHERE ar_pdv_fk = @gpdv_id_pk
SELECT * FROM RACUNI_STAVKE WHERE rs_gpdv_id_fk = @gpdv_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_GRUPE_ARTIKALA]
(
	@ga_id_pk Int
)
AS
SELECT * FROM ARTIKLI WHERE ar_grupa_fk = @ga_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_DOBAVLJACI]
(
	@do_id_pk Int
)
AS
SELECT * FROM PRIMKE_ZAGLAVLJE WHERE pr_dobavljac_id_fk = @do_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_ARTIKLI]
(
	@ar_id_pk int
)
as
delete from GRUPE_TOUCH_SCREEN_ARTIKLI where ar_id_fk = @ar_id_pk
delete from ARTIKLI where ar_id_pk = @ar_id_pk
GO

--
-- Definition for stored procedure Izvjesca_Get_TOP_LISTA_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_TOP_LISTA_ARTIKALA]
(
	@topNr int
)
AS
BEGIN
	SELECT TOP (@topNr) ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina
	FROM RACUNI_STAVKE LEFT OUTER JOIN
                      ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk
	GROUP BY ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv 
	ORDER BY Kolicina DESC
END
GO



--
-- Definition for stored procedure System_Get_ARTIKAL_KATEGORIJA : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_ARTIKAL_KATEGORIJA]
AS
Select * from SYS_ARTIKAL_KATEGORIJA
GO

--
-- Definition for stored procedure Osnovno_Update_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_ARTIKALA]
(
	@ga_id_pk int,
	@ga_name nvarchar(20),
	@ga_order_index int
)
as
update
	GRUPE_ARTIKALA
set
	ga_name = @ga_name,
	ga_order_index = @ga_order_index
where
	ga_id_pk = @ga_id_pk
GO


--
-- Definition for stored procedure Osnovno_Insert_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_ARTIKALA]
(
	@ga_name nvarchar(20),
	@ga_order_index int
)
as
insert into GRUPE_ARTIKALA
	(ga_name, ga_order_index)
values
	(@ga_name, @ga_order_index)
select scope_identity()
GO


--
-- Definition for stored procedure Osnovno_Get_GRUPE_ARTIKALA : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_ARTIKALA]
AS
Select * from GRUPE_ARTIKALA
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_GRUPE_ARTIKALA]
(
	@ga_id_pk int
)
as
UPDATE ARTIKLI set ar_grupa_fk = null where ar_grupa_fk = @ga_id_pk
delete from GRUPE_ARTIKALA where ga_id_pk = @ga_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_DOBAVLJACI]
(
	@do_id_pk int,
	@do_name nvarchar(50),
	@do_maticni_broj nvarchar(25),
	@do_oib nvarchar(25),	
	@do_adresa nvarchar(50),
	@do_mjesto nvarchar(50),
	@do_tel nvarchar(15),
	@do_fax nvarchar(15),
	@do_ziro_racun nvarchar(25),
	@do_kontakt_osoba nvarchar(25),
	@do_kontakt_osoba_mob nvarchar(15),
	@do_biljeska nvarchar(40)
)
as
update
	DOBAVLJACI
set
	do_name = @do_name,
	do_maticni_broj = @do_maticni_broj,
	do_adresa = @do_adresa,
	do_mjesto = @do_mjesto,
	do_tel = @do_tel,
	do_fax = @do_fax,
	do_ziro_racun = @do_ziro_racun,
	do_kontakt_osoba = @do_kontakt_osoba,
	do_kontakt_osoba_mob = @do_kontakt_osoba_mob,
	do_biljeska = @do_biljeska,
	do_oib = @do_oib
where
	do_id_pk = @do_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_DOBAVLJACI]
(
	@do_name nvarchar(25),
	@do_maticni_broj nvarchar(25),
	@do_oib nvarchar(25),	
    @do_adresa nvarchar(25),
	@do_mjesto nvarchar(25),
	@do_tel nvarchar(15),
	@do_fax nvarchar(15),
	@do_ziro_racun nvarchar(25),
	@do_kontakt_osoba nvarchar(25),
	@do_kontakt_osoba_mob nvarchar(15),
	@do_biljeska nvarchar(40)
)
as
insert into DOBAVLJACI
	(do_name, do_maticni_broj, do_adresa, do_mjesto, do_tel, do_fax, do_ziro_racun, do_kontakt_osoba, do_kontakt_osoba_mob, do_biljeska, do_oib)
values
	(@do_name, @do_maticni_broj, @do_adresa, @do_mjesto, @do_tel, @do_fax, @do_ziro_racun, @do_kontakt_osoba, @do_kontakt_osoba_mob, @do_biljeska, @do_oib)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_DOBAVLJACI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_DOBAVLJACI]
AS
Select * from DOBAVLJACI
GO

--
-- Definition for stored procedure Osnovno_Delete_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_DOBAVLJACI]
(
	@do_id_pk int
)
as
delete from DOBAVLJACI where do_id_pk = @do_id_pk
GO

--
-- Definition for stored procedure Izvjesca_Get_KNJIGA_ULAZNIH_RACUNA : 
--
GO
CREATE PROCEDURE [dbo].[Izvjesca_Get_KNJIGA_ULAZNIH_RACUNA]
(
	@day_start datetime,
	@day_end datetime
)
AS
SELECT		PRIMKE_ZAGLAVLJE.pr_id_pk, PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk, DOBAVLJACI.do_name, DOBAVLJACI.do_oib,
				PRIMKE_ZAGLAVLJE.pr_datum, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_ZAGLAVLJE.pr_datum_dospijeca, 
				PRIMKE_ZAGLAVLJE.pr_napomena,  
				PRIMKE_ZAGLAVLJE.pr_osnovica, PRIMKE_ZAGLAVLJE.pr_pdv, PRIMKE_ZAGLAVLJE.pr_ukupno, 
				sum(PRIMKE_STAVKE.ps_tot_osnovica) as count_osnovica, sum(PRIMKE_STAVKE.ps_tot_pdv) as count_pdv, sum(PRIMKE_STAVKE.ps_tot_ukupno) as count_ukupno
FROM		PRIMKE_ZAGLAVLJE INNER JOIN
				PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT OUTER JOIN
				DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
WHERE		(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @day_start AND @day_end)
group by    PRIMKE_ZAGLAVLJE.pr_id_pk, PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk, 
				PRIMKE_ZAGLAVLJE.pr_datum, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_ZAGLAVLJE.pr_datum_dospijeca, PRIMKE_ZAGLAVLJE.pr_osnovica, 
				PRIMKE_ZAGLAVLJE.pr_pdv, PRIMKE_ZAGLAVLJE.pr_ukupno, PRIMKE_ZAGLAVLJE.pr_napomena,  
				DOBAVLJACI.do_name, DOBAVLJACI.do_oib

SELECT		sum(PRIMKE_ZAGLAVLJE.pr_osnovica) as TOT_osnovica, sum(PRIMKE_ZAGLAVLJE.pr_pdv) as TOT_pdv, sum(PRIMKE_ZAGLAVLJE.pr_ukupno) as TOT_ukupno
FROM		PRIMKE_ZAGLAVLJE 
WHERE		(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @day_start AND @day_end)
GO

--
-- Definition for stored procedure Skladiste_Get_PROMJENA_CIJENE_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_PROMJENA_CIJENE_BY_ID]
(
	@pcz_id_pk int
)
AS
BEGIN
SELECT		PROMJENA_CIJENE_ZAGLAVLJE.*,   
			PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj
FROM        PROMJENA_CIJENE_ZAGLAVLJE LEFT OUTER JOIN
                      PRIMKE_ZAGLAVLJE ON PROMJENA_CIJENE_ZAGLAVLJE.pcz_pr_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk
WHERE		pcz_id_pk = @pcz_id_pk
END

BEGIN
	SELECT     PROMJENA_CIJENE_STAVKE.*, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk,GRUPE_ARTIKALA.ga_name, 
                    GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak,
					OLD_GRUPE_PDV.gpdv_name AS gpdv_old_name, OLD_GRUPE_PDV.gpdv_postotak AS gpdv_old_postotak,
					NEW_GRUPE_PDV.gpdv_name AS gpdv_new_name, NEW_GRUPE_PDV.gpdv_postotak AS gpdv_new_postotak
	FROM         PROMJENA_CIJENE_STAVKE LEFT OUTER JOIN
                    ARTIKLI ON PROMJENA_CIJENE_STAVKE.pcs_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                    GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
                    GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as OLD_GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_old_pdv_id = OLD_GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as NEW_GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_new_pdv_id = NEW_GRUPE_PDV.gpdv_id_pk
	WHERE	pcs_pcz_id_fk = @pcz_id_pk
END
GO





--
-- Definition for stored procedure Skladiste_Get_PRIMKE_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_PRIMKE_LIST]
(
	@day_start datetime,
	@day_end datetime,
	@pr_broj nvarchar(30)= null,
	@pr_dobavljac_id_fk int =null,
	@pr_status bit = null
)
AS
BEGIN
	SELECT		PRIMKE_ZAGLAVLJE.*,  DOBAVLJACI.do_name,
 				PRIMKE_ZAGLAVLJE_2.pr_sys_broj AS pr_sys_broj_storno,
				PRIMKE_ZAGLAVLJE_2.pr_broj AS pr_broj_storno,
				PROMJENA_CIJENE_ZAGLAVLJE.pcz_broj, PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak, 
				SUM(PRIMKE_STAVKE.ps_tot_osnovica) as count_osnovica, 
				SUM(PRIMKE_STAVKE.ps_tot_pdv) as count_pdv, 
				SUM(PRIMKE_STAVKE.ps_tot_ukupno) as count_ukupno,
				COUNT(PRIMKE_STAVKE.ps_id_pk) AS count_stavke
	FROM	PRIMKE_ZAGLAVLJE INNER JOIN
				PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT OUTER JOIN
				DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk LEFT OUTER JOIN	
				PROMJENA_CIJENE_ZAGLAVLJE ON PRIMKE_ZAGLAVLJE.pr_pcz_id_fk = PROMJENA_CIJENE_ZAGLAVLJE.pcz_id_pk LEFT OUTER JOIN 
				PRIMKE_ZAGLAVLJE as PRIMKE_ZAGLAVLJE_2 ON PRIMKE_ZAGLAVLJE.pr_storno_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk 
	WHERE	PRIMKE_ZAGLAVLJE.pr_proknjizeno=1 AND 
			PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @day_start AND @day_end AND
			(@pr_broj is null or (PRIMKE_ZAGLAVLJE.pr_broj = @pr_broj)) AND
			(@pr_dobavljac_id_fk is null or (PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = @pr_dobavljac_id_fk)) AND
			(@pr_status is null or (PRIMKE_ZAGLAVLJE.pr_status = @pr_status))
	group by    PRIMKE_ZAGLAVLJE.pr_id_pk, PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk, PRIMKE_ZAGLAVLJE.pr_pcz_id_fk, 
				PRIMKE_ZAGLAVLJE.pr_storno_sign, PRIMKE_ZAGLAVLJE.pr_storno_id_fk, PRIMKE_ZAGLAVLJE.pr_proknjizeno, 
				PRIMKE_ZAGLAVLJE.pr_datum, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_ZAGLAVLJE.pr_datum_dospijeca, PRIMKE_ZAGLAVLJE.pr_osnovica, 
				PRIMKE_ZAGLAVLJE.pr_pdv, PRIMKE_ZAGLAVLJE.pr_ukupno, PRIMKE_ZAGLAVLJE.pr_napomena, 
				PRIMKE_ZAGLAVLJE.pr_zaduzenje_vpc, PRIMKE_ZAGLAVLJE.pr_zaduzenje_pdv, PRIMKE_ZAGLAVLJE.pr_zaduzenje_mpc,
				PRIMKE_ZAGLAVLJE.pr_status, PRIMKE_ZAGLAVLJE.pr_ukupno_marza,
				DOBAVLJACI.do_name, PRIMKE_ZAGLAVLJE_2.pr_sys_broj, PRIMKE_ZAGLAVLJE_2.pr_broj, PRIMKE_ZAGLAVLJE.pr_zaduzenje_pov_naknada,
				PROMJENA_CIJENE_ZAGLAVLJE.pcz_broj, PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak

	-- REKAPITULACIJA POREZA PO NABAVI
	SELECT		SUM(PRIMKE_STAVKE.ps_tot_osnovica) AS OSNOVICA, 
				SUM(PRIMKE_STAVKE.ps_tot_pdv) as PDV, 
				SUM(PRIMKE_STAVKE.ps_tot_ukupno) as TOTAL, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PRIMKE_STAVKE.ps_ar_pdv_id_fk
	FROM	PRIMKE_ZAGLAVLJE inner JOIN
				PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT JOIN
				GRUPE_PDV ON PRIMKE_STAVKE.ps_ar_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
	WHERE	(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @day_start AND @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PRIMKE_STAVKE.ps_ar_pdv_id_fk

	-- REKAPITULACIJA POREZA PO ZADUZENJU
	SELECT		SUM(PRIMKE_STAVKE.ps_zaduzenje_vpc) AS OSNOVICA, 
				SUM(PRIMKE_STAVKE.ps_zaduzenje_pdv) as PDV, 
				SUM(PRIMKE_STAVKE.ps_zaduzenje_mpc) as TOTAL, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PRIMKE_STAVKE.ps_calc_pdv_id_fk
	FROM	PRIMKE_ZAGLAVLJE inner JOIN
				PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT JOIN
				GRUPE_PDV ON PRIMKE_STAVKE.ps_calc_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
	WHERE	(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @day_start AND @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, PRIMKE_STAVKE.ps_calc_pdv_id_fk
END
GO




--
-- Definition for stored procedure Skladiste_Get_PRIMKA_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_PRIMKA_BY_ID]
(
	@pr_id_pk int
)
AS
BEGIN
		SELECT	PRIMKE_ZAGLAVLJE.*, 
 					PRIMKE_ZAGLAVLJE_2.pr_sys_broj AS pr_sys_broj_storno,
					PRIMKE_ZAGLAVLJE_2.pr_broj AS pr_broj_storno,		
					PROMJENA_CIJENE_ZAGLAVLJE.pcz_broj, PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak, 
					DOBAVLJACI.do_name, DOBAVLJACI.do_maticni_broj, 
					DOBAVLJACI.do_oib, DOBAVLJACI.do_adresa, DOBAVLJACI.do_mjesto, 
					DOBAVLJACI.do_tel, DOBAVLJACI.do_fax, DOBAVLJACI.do_ziro_racun, 
					DOBAVLJACI.do_kontakt_osoba, DOBAVLJACI.do_kontakt_osoba_mob, DOBAVLJACI.do_biljeska
FROM	PRIMKE_ZAGLAVLJE LEFT OUTER JOIN
					PRIMKE_ZAGLAVLJE as PRIMKE_ZAGLAVLJE_2 ON PRIMKE_ZAGLAVLJE.pr_storno_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk LEFT OUTER JOIN	
					DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk LEFT OUTER JOIN 
					PROMJENA_CIJENE_ZAGLAVLJE ON PRIMKE_ZAGLAVLJE.pr_pcz_id_fk = PROMJENA_CIJENE_ZAGLAVLJE.pcz_id_pk
		where PRIMKE_ZAGLAVLJE.pr_id_pk = @pr_id_pk  
END

BEGIN
		SELECT		PRIMKE_STAVKE.*, 
	                ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_barcode, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
					GRUPE_ARTIKALA.ga_name, 
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak,
					CALC_GRUPE_PDV.gpdv_name AS gpdv_calc_name, CALC_GRUPE_PDV.gpdv_postotak AS gpdv_calc_postotak,
					OLD_GRUPE_PDV.gpdv_name AS gpdv_old_name, OLD_GRUPE_PDV.gpdv_postotak AS gpdv_old_postotak
		FROM	PRIMKE_STAVKE LEFT OUTER JOIN
                    GRUPE_PDV ON PRIMKE_STAVKE.ps_ar_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as CALC_GRUPE_PDV ON PRIMKE_STAVKE.ps_calc_pdv_id_fk = CALC_GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as OLD_GRUPE_PDV ON PRIMKE_STAVKE.ps_old_pdv_id_fk = OLD_GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                    ARTIKLI ON PRIMKE_STAVKE.ps_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                    GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	where	   ps_pr_id_fk = @pr_id_pk  
END
GO



--
-- Definition for stored procedure Skladiste_Get_PRIMKE_STAVKE_ARTIKAL_INFO_ZADNJA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_PRIMKE_STAVKE_ARTIKAL_INFO_ZADNJA]
(
 	@ps_ar_id_fk int
)
AS
SELECT TOP 1 
	PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_STAVKE.*, GRUPE_PDV.*
FROM PRIMKE_ZAGLAVLJE INNER JOIN
		PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT OUTER JOIN
		GRUPE_PDV ON PRIMKE_STAVKE.ps_ar_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
WHERE PRIMKE_STAVKE.ps_ar_id_fk = @ps_ar_id_fk
ORDER BY PRIMKE_ZAGLAVLJE.pr_datum_knjizenja DESC
GO



--
-- Definition for stored procedure Skladiste_Get_POCETNO_STANJE : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_POCETNO_STANJE]
AS
	SELECT     POCETNO_STANJE.*, ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
                    GRUPE_ARTIKALA.ga_name,
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM         POCETNO_STANJE LEFT OUTER JOIN
                      ARTIKLI ON POCETNO_STANJE.ps_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
					  GRUPE_PDV ON POCETNO_STANJE.ps_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
GO

--
-- Definition for stored procedure Skladiste_Get_IZDATNICA_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_IZDATNICA_BY_ID]
(
	@iz_id_pk int
)
AS
BEGIN
	SELECT IZDATNICE_ZAGLAVLJE.*, MJESTA_OTPREME.mo_oznaka
	FROM IZDATNICE_ZAGLAVLJE LEFT OUTER JOIN
          MJESTA_OTPREME ON IZDATNICE_ZAGLAVLJE.iz_mo_id_fk = MJESTA_OTPREME.mo_id_pk
	WHERE iz_id_pk = @iz_id_pk
END

BEGIN
	SELECT     IZDATNICE_STAVKE.*, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
                    GRUPE_ARTIKALA.ga_name,
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM         IZDATNICE_STAVKE LEFT OUTER JOIN
                      ARTIKLI ON IZDATNICE_STAVKE.is_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
						GRUPE_PDV ON IZDATNICE_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	WHERE is_iz_id_fk = @iz_id_pk
END
GO

--
-- Definition for stored procedure Skladiste_Set_IZDATNICA_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_IZDATNICA_WRITE_MODE]
(
	@RetVal int output,
	@iz_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT iz_id_pk, iz_proknjizeno FROM IZDATNICE_ZAGLAVLJE WHERE iz_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE IZDATNICE_ZAGLAVLJE SET iz_proknjizeno=0 WHERE iz_id_pk=@iz_id_pk
		EXECUTE dbo.Skladiste_Get_IZDATNICA_BY_ID @iz_id_pk
	END
END
GO

--
-- Definition for stored procedure Skladiste_Get_INVENTURA_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INVENTURA_BY_ID]
(
	@iz_id_pk int
)
AS
BEGIN
	SELECT INVENTURA_ZAGLAVLJE.*
			FROM INVENTURA_ZAGLAVLJE  
		where INVENTURA_ZAGLAVLJE.iz_id_pk = @iz_id_pk
END
BEGIN
		SELECT		INVENTURA_STAVKE.*, 
	                ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
					GRUPE_ARTIKALA.ga_name,
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
		FROM	INVENTURA_STAVKE LEFT OUTER JOIN
                    ARTIKLI ON INVENTURA_STAVKE.is_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                    GRUPE_PDV ON INVENTURA_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                    GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	where	   is_iz_id_fk = @iz_id_pk
END
GO

--
-- Definition for stored procedure Skladiste_Set_INVENTURA_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_INVENTURA_WRITE_MODE]
(
	@RetVal int output,
	@iz_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT iz_id_pk, iz_proknjizeno FROM INVENTURA_ZAGLAVLJE WHERE iz_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE INVENTURA_ZAGLAVLJE SET iz_proknjizeno=0 WHERE iz_id_pk=@iz_id_pk
		EXECUTE dbo.Skladiste_Get_INVENTURA_BY_ID @iz_id_pk
	END
END
GO

--
-- Definition for stored procedure Skladiste_Get_INIT_PRIMKA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_PRIMKA]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(pr_sys_broj) from PRIMKE_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1
	declare @ID AS INT
	SELECT @ID=pr_id_pk FROM PRIMKE_ZAGLAVLJE where pr_proknjizeno = 0 
END
BEGIN
		SELECT	PRIMKE_ZAGLAVLJE.*, 
 					PRIMKE_ZAGLAVLJE_2.pr_sys_broj AS pr_sys_broj_storno,
					PRIMKE_ZAGLAVLJE_2.pr_broj AS pr_broj_storno,	
					PROMJENA_CIJENE_ZAGLAVLJE.pcz_broj, PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak, 
					DOBAVLJACI.do_name, DOBAVLJACI.do_maticni_broj, 
					DOBAVLJACI.do_oib, DOBAVLJACI.do_adresa, DOBAVLJACI.do_mjesto, 
					DOBAVLJACI.do_tel, DOBAVLJACI.do_fax, DOBAVLJACI.do_ziro_racun, 
					DOBAVLJACI.do_kontakt_osoba, DOBAVLJACI.do_kontakt_osoba_mob, DOBAVLJACI.do_biljeska
		FROM	PRIMKE_ZAGLAVLJE LEFT OUTER JOIN
					PRIMKE_ZAGLAVLJE as PRIMKE_ZAGLAVLJE_2 ON PRIMKE_ZAGLAVLJE.pr_storno_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk LEFT OUTER JOIN	
					DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk  LEFT OUTER JOIN 
					PROMJENA_CIJENE_ZAGLAVLJE ON PRIMKE_ZAGLAVLJE.pr_pcz_id_fk = PROMJENA_CIJENE_ZAGLAVLJE.pcz_id_pk
	where PRIMKE_ZAGLAVLJE.pr_proknjizeno = 0 
END
BEGIN
		SELECT		PRIMKE_STAVKE.*, 
	                ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_sifra, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
					GRUPE_ARTIKALA.ga_name, 
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak,
					CALC_GRUPE_PDV.gpdv_name AS gpdv_calc_name, CALC_GRUPE_PDV.gpdv_postotak AS gpdv_calc_postotak,
					OLD_GRUPE_PDV.gpdv_name AS gpdv_old_name, OLD_GRUPE_PDV.gpdv_postotak AS gpdv_old_postotak
		FROM	PRIMKE_STAVKE LEFT OUTER JOIN
                    GRUPE_PDV ON PRIMKE_STAVKE.ps_ar_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as CALC_GRUPE_PDV ON PRIMKE_STAVKE.ps_calc_pdv_id_fk = CALC_GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					GRUPE_PDV as OLD_GRUPE_PDV ON PRIMKE_STAVKE.ps_old_pdv_id_fk = OLD_GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                    ARTIKLI ON PRIMKE_STAVKE.ps_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                    GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	where	   ps_pr_id_fk=@ID 
END
GO

--
-- Definition for stored procedure Skladiste_Get_INIT_IZDATNICA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_IZDATNICA]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(iz_broj) from IZDATNICE_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1
	declare @ID AS INT
	SELECT @ID=iz_id_pk FROM IZDATNICE_ZAGLAVLJE WHERE iz_proknjizeno=0
	SELECT IZDATNICE_ZAGLAVLJE.*, MJESTA_OTPREME.mo_oznaka
	FROM IZDATNICE_ZAGLAVLJE LEFT OUTER JOIN
          MJESTA_OTPREME ON IZDATNICE_ZAGLAVLJE.iz_mo_id_fk = MJESTA_OTPREME.mo_id_pk
	WHERE (IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 0)

	SELECT     IZDATNICE_STAVKE.*, ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
                    GRUPE_ARTIKALA.ga_name,
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM         IZDATNICE_STAVKE LEFT OUTER JOIN
                    GRUPE_PDV ON IZDATNICE_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                    ARTIKLI ON IZDATNICE_STAVKE.is_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                    GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	WHERE is_iz_id_fk=@ID
END
GO

--
-- Definition for stored procedure Skladiste_Get_INIT_INVENTURA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_INVENTURA]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(iz_broj) from INVENTURA_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1
	declare @ID AS INT
	SELECT @ID=iz_id_pk FROM INVENTURA_ZAGLAVLJE WHERE iz_proknjizeno=0
	SELECT INVENTURA_ZAGLAVLJE.*
			FROM INVENTURA_ZAGLAVLJE  
	WHERE (INVENTURA_ZAGLAVLJE.iz_proknjizeno = 0)
		SELECT		INVENTURA_STAVKE.*, 
	                ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
					GRUPE_ARTIKALA.ga_name,
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
		FROM	INVENTURA_STAVKE LEFT OUTER JOIN
                    ARTIKLI ON INVENTURA_STAVKE.is_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                    GRUPE_PDV ON INVENTURA_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                    GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	WHERE is_iz_id_fk=@ID
END
GO


--
-- Definition for stored procedure Osnovno_Update_GRUPE_PDV : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_PDV]
(
	@gpdv_id_pk int,
	@gpdv_name nvarchar(20),
	@gpdv_postotak decimal(6, 2)
)
as
update
	GRUPE_PDV
set
	gpdv_name = @gpdv_name,
	gpdv_postotak = @gpdv_postotak
where
	gpdv_id_pk = @gpdv_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_PDV : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_PDV]
(
	@gpdv_name nvarchar(20),
	@gpdv_postotak decimal(6, 2)
)
as
insert into GRUPE_PDV
	( gpdv_name, gpdv_postotak)
values
	( @gpdv_name, @gpdv_postotak)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_GRUPE_PDV : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_PDV]
AS
Select * from GRUPE_PDV
GO



--
-- Definition for stored procedure Osnovno_Get_ARTIKLI : 
--
GO

CREATE PROCEDURE [dbo].[Osnovno_Get_ARTIKLI]
(
	@ar_id_pk int = null,
	@ar_kat_id_fk int = null,
	@ar_sifra nvarchar(15) = null,
	@ar_barcode nvarchar(30) = null,
	@ar_grupa_fk int = null,
	@ar_is_active_DA bit = null,
	@ar_is_active_NE bit = null
)
AS
BEGIN
SELECT     ARTIKLI.*,  CASE WHEN ar_is_active =0 THEN 'NE' ELSE 'DA' END AS ar_is_active_str, 
		   GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_ARTIKALA.ga_name,
		   SYS_ARTIKAL_KATEGORIJA.syak_name
FROM       ARTIKLI LEFT OUTER JOIN
		   SYS_ARTIKAL_KATEGORIJA ON ARTIKLI.ar_kat_id_fk = SYS_ARTIKAL_KATEGORIJA.syak_id_pk LEFT OUTER JOIN
           GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
           GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
WHERE (@ar_barcode is null or (ARTIKLI.ar_barcode = @ar_barcode)) AND
      (@ar_is_active_DA is null or (ARTIKLI.ar_is_active = 1)) AND
      (@ar_is_active_NE is null or (ARTIKLI.ar_is_active = 0)) AND
      (@ar_kat_id_fk is null or (ARTIKLI.ar_kat_id_fk = @ar_kat_id_fk)) AND
      (@ar_sifra is null or (ARTIKLI.ar_sifra = @ar_sifra)) AND
      (@ar_grupa_fk is null or (ARTIKLI.ar_grupa_fk = @ar_grupa_fk)) AND
      (@ar_id_pk is null or (ARTIKLI.ar_id_pk = @ar_id_pk))
END
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_PDV : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_PDV]
(
@gpdv_id_pk int
)
AS
delete from GRUPE_PDV where gpdv_id_pk = @gpdv_id_pk
GO



--
-- Definition for stored procedure Management_Get_PONUDA_PRODANI_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Management_Get_PONUDA_PRODANI_ARTIKLI]
(
	@day_start datetime,
	@day_end datetime,
	@pnz_dj_id_fk int = null,
	@pnz_tv_id_fk int = null,
	@pnz_na_id_fk int = null,
	@pnz_id_pk int = null,
	@pnz_status bit = null
)
AS
BEGIN
	SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_grupa_fk,
			PONUDA_STAVKE.pns_cijena, 
			SUM(PONUDA_STAVKE.pns_iznos) AS Total, SUM(PONUDA_STAVKE.pns_kolicina) AS Kolicina, 
			SUM(PONUDA_STAVKE.pns_pdv) AS PDV, 
			GRUPE_ARTIKALA.ga_name,
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM PONUDA_ZAGLAVLJE LEFT OUTER JOIN
			PONUDA_STAVKE ON PONUDA_ZAGLAVLJE.pnz_id_pk = PONUDA_STAVKE.pns_ponuda_id_fk INNER JOIN
			GRUPE_PDV ON PONUDA_STAVKE.pns_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk  INNER JOIN
			ARTIKLI ON PONUDA_STAVKE.pns_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
			GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	WHERE (@day_start is null or (PONUDA_ZAGLAVLJE.pnz_nadnevak between @day_start and @day_end)) AND 
			(@pnz_dj_id_fk is null or (PONUDA_ZAGLAVLJE.pnz_dj_id_fk = @pnz_dj_id_fk)) AND 
			(@pnz_tv_id_fk is null or (PONUDA_ZAGLAVLJE.pnz_tv_id_fk = @pnz_tv_id_fk)) AND
			(@pnz_na_id_fk is null or (PONUDA_ZAGLAVLJE.pnz_na_id_fk = @pnz_na_id_fk)) AND
			(@pnz_id_pk is null or (PONUDA_ZAGLAVLJE.pnz_id_pk = @pnz_id_pk)) AND
			(@pnz_status is null or (PONUDA_ZAGLAVLJE.pnz_status = @pnz_status))
	 GROUP BY ARTIKLI.ar_grupa_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, 
	 		PONUDA_STAVKE.pns_cijena, GRUPE_ARTIKALA.ga_name,GRUPE_PDV.gpdv_name,GRUPE_PDV.gpdv_postotak
END
GO



--
-- Definition for stored procedure Skladiste_Get_ARTIKAL_INFO : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_ARTIKAL_INFO]
(
	@RetVal_pocstanje_kolicina decimal(12,3) output,
 	@RetVal_pocstanje_jedinicna_nabava_vpc decimal(12,3) output,
 	@RetVal_primke_kolicina decimal(12,3) output,
 	@RetVal_primke_uk_nabava_vpc decimal(12,3) output,
 	@RetVal_izdatnice_kolicina decimal(12,3) output,
 	@RetVal_izdatnice_uk_nabava_vpc decimal(12,3) output,
 	@RetVal_inventure_kolicina decimal(12,3) output,
 	@RetVal_inventure_uk_nabava_vpc decimal(12,3) output,
 	@RetVal_racuni_kolicina decimal(12,3) output,
	@ar_id_pk int,
	@dateStart datetime,
	@dateEnd datetime
)
AS
BEGIN
	---------------------------------------------
	--------------------------------------------- 
	--------------  ARTIKAL
	---------------------------------------------
	SELECT		ARTIKLI.*,  CASE WHEN ar_is_active =0 THEN 'NE' ELSE 'DA' END AS ar_is_active_str, 
			    GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_ARTIKALA.ga_name
	FROM		ARTIKLI LEFT OUTER JOIN
				GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
				GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	where		ar_id_pk = @ar_id_pk
	--------------------------------------------- 
	--------------  SVE STAVKE U PRIMKAMA
	---------------------------------------------
	SELECT     PRIMKE_STAVKE.* 
	FROM       PRIMKE_STAVKE LEFT OUTER JOIN
						  PRIMKE_ZAGLAVLJE ON PRIMKE_STAVKE.ps_pr_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk
	WHERE (PRIMKE_ZAGLAVLJE.pr_datum_knjizenja  between @dateStart and @dateEnd) AND (PRIMKE_STAVKE.ps_ar_id_fk = @ar_id_pk) AND PRIMKE_ZAGLAVLJE.pr_proknjizeno=1
	ORDER BY PRIMKE_ZAGLAVLJE.pr_datum_knjizenja
	--------------------------------------------- 
	--------------  POCETNO STANJE
	---------------------------------------------
	SELECT	@RetVal_pocstanje_kolicina = SUM( POCETNO_STANJE.ps_kolicina), 
			@RetVal_pocstanje_jedinicna_nabava_vpc = SUM( POCETNO_STANJE.ps_vpc_nabavna)
	FROM POCETNO_STANJE
	WHERE POCETNO_STANJE.ps_ar_id_fk = @ar_id_pk
	--------------------------------------------- 
	--------------  PRIMKA
	---------------------------------------------
	SELECT	@RetVal_primke_kolicina = SUM( PRIMKE_STAVKE.ps_ar_kolicina), 
			@RetVal_primke_uk_nabava_vpc = SUM( PRIMKE_STAVKE.ps_tot_osnovica)
	FROM PRIMKE_ZAGLAVLJE INNER JOIN
			PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk
	WHERE (PRIMKE_ZAGLAVLJE.pr_datum_knjizenja  between @dateStart and @dateEnd) AND (PRIMKE_STAVKE.ps_ar_id_fk = @ar_id_pk) AND PRIMKE_ZAGLAVLJE.pr_proknjizeno=1
	--------------------------------------------- 
	--------------  IZDATNICA
	---------------------------------------------
	SELECT	@RetVal_izdatnice_kolicina = SUM(IZDATNICE_STAVKE.is_kolicina),
			@RetVal_izdatnice_uk_nabava_vpc = SUM(IZDATNICE_STAVKE.is_tot_pros_nab_vpc)
	FROM IZDATNICE_ZAGLAVLJE INNER JOIN
			IZDATNICE_STAVKE ON IZDATNICE_ZAGLAVLJE.iz_id_pk = IZDATNICE_STAVKE.is_iz_id_fk
	WHERE (dbo.IZDATNICE_ZAGLAVLJE.iz_datum  between @dateStart and @dateEnd) AND(IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 1) AND (dbo.IZDATNICE_STAVKE.is_ar_id_fk = @ar_id_pk) 
	--------------------------------------------- 
	--------------  INVENTURA
	---------------------------------------------
	SELECT	@RetVal_inventure_kolicina = SUM( INVENTURA_STAVKE.is_kol_razlika),
			@RetVal_inventure_uk_nabava_vpc = SUM( INVENTURA_STAVKE.is_tot_pros_nab_vpc)    
	FROM INVENTURA_ZAGLAVLJE INNER JOIN
			INVENTURA_STAVKE ON INVENTURA_ZAGLAVLJE.iz_id_pk = INVENTURA_STAVKE.is_iz_id_fk
	WHERE (INVENTURA_ZAGLAVLJE.iz_datetime  between @dateStart and @dateEnd) AND (INVENTURA_STAVKE.is_ar_id_fk = @ar_id_pk) AND INVENTURA_ZAGLAVLJE.iz_proknjizeno=1
	--------------------------------------------- 
	--------------  RACUNI
	---------------------------------------------
	SELECT	@RetVal_racuni_kolicina = SUM(RACUNI_STAVKE.rs_kolicina) 
	FROM RACUNI_ZAGLAVLJE INNER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk
	WHERE (dbo.RACUNI_ZAGLAVLJE.rz_vrijeme between @dateStart and @dateEnd) AND (dbo.RACUNI_STAVKE.rs_artikal_id_fk = @ar_id_pk) 
END
GO





--
-- Definition for stored procedure Skladiste_Get_KARTICA_ARTIKLA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_KARTICA_ARTIKLA]
(
	@ar_id_pk int,
	@dateStart datetime,
	@dateEnd datetime
)
AS
BEGIN
 	--------------------------------------------- 
	--------------  ARTIKAL
	---------------------------------------------
	SELECT		ARTIKLI.*,  CASE WHEN ar_is_active =0 THEN 'NE' ELSE 'DA' END AS ar_is_active_str, 
			    GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_ARTIKALA.ga_name,
				SYS_ARTIKAL_KATEGORIJA.syak_name
	FROM		ARTIKLI LEFT OUTER JOIN
				SYS_ARTIKAL_KATEGORIJA ON ARTIKLI.ar_kat_id_fk = SYS_ARTIKAL_KATEGORIJA.syak_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
				GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
where		ar_id_pk = @ar_id_pk
	--------------------------------------------- 
	--------------  POCETNO STANJE
	---------------------------------------------
 	SELECT * FROM POCETNO_STANJE
	where POCETNO_STANJE.ps_ar_id_fk=@ar_id_pk 
	--------------------------------------------- 
	--------------  RACUNI
	---------------------------------------------
 	SELECT RACUNI_STAVKE.*, RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, 
			RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme,  
 
			RACUNI_ZAGLAVLJE.rz_dan
	FROM RACUNI_STAVKE INNER JOIN
			RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk
	where (RACUNI_STAVKE.rs_artikal_id_fk=@ar_id_pk) AND  (RACUNI_ZAGLAVLJE.rz_dan between @dateStart and @dateEnd)
	--------------------------------------------- 
	--------------  PRIMKE
	---------------------------------------------
	SELECT PRIMKE_STAVKE.*, DOBAVLJACI.do_name, 
			PRIMKE_ZAGLAVLJE.pr_id_pk, 
			PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, 
			PRIMKE_STAVKE.ps_tot_osnovica, 
			PRIMKE_STAVKE.ps_tot_pdv, PRIMKE_STAVKE.ps_tot_ukupno,
			PRIMKE_STAVKE.ps_calc_vpc, PRIMKE_STAVKE.ps_calc_mpc,
			PRIMKE_STAVKE.ps_zaduzenje_vpc, PRIMKE_STAVKE.ps_zaduzenje_pdv, PRIMKE_STAVKE.ps_zaduzenje_mpc
	FROM PRIMKE_STAVKE LEFT OUTER JOIN
			PRIMKE_ZAGLAVLJE ON PRIMKE_STAVKE.ps_pr_id_fk = PRIMKE_ZAGLAVLJE.pr_id_pk LEFT OUTER JOIN
			DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
	WHERE (PRIMKE_ZAGLAVLJE.pr_proknjizeno = 1) AND (PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @dateStart AND @dateEnd) AND 
			(PRIMKE_STAVKE.ps_ar_id_fk = @ar_id_pk)
	--------------------------------------------- 
	--------------  IZDATNICE
	---------------------------------------------
 	SELECT IZDATNICE_STAVKE.*, IZDATNICE_ZAGLAVLJE.*
	FROM IZDATNICE_STAVKE LEFT OUTER JOIN
			IZDATNICE_ZAGLAVLJE ON IZDATNICE_STAVKE.is_iz_id_fk = IZDATNICE_ZAGLAVLJE.iz_id_pk
	where IZDATNICE_ZAGLAVLJE.iz_proknjizeno=1 and  IZDATNICE_ZAGLAVLJE.iz_datum  between @dateStart and @dateEnd and IZDATNICE_STAVKE.is_ar_id_fk=@ar_id_pk
	--------------------------------------------- 
	--------------  INVENTURE
	---------------------------------------------
	SELECT INVENTURA_STAVKE.*, INVENTURA_ZAGLAVLJE.*
	FROM INVENTURA_STAVKE INNER JOIN
			INVENTURA_ZAGLAVLJE ON INVENTURA_STAVKE.is_iz_id_fk = INVENTURA_ZAGLAVLJE.iz_id_pk
	where INVENTURA_ZAGLAVLJE.iz_proknjizeno=1 and  INVENTURA_ZAGLAVLJE.iz_datetime  between @dateStart and @dateEnd and INVENTURA_STAVKE.is_ar_id_fk=@ar_id_pk
	--------------------------------------------- 
	--------------  ZPC
	---------------------------------------------
	SELECT PROMJENA_CIJENE_STAVKE.*, PROMJENA_CIJENE_ZAGLAVLJE.*,
					OLD_GRUPE_PDV.gpdv_name AS gpdv_old_name, OLD_GRUPE_PDV.gpdv_postotak AS gpdv_old_postotak,
					NEW_GRUPE_PDV.gpdv_name AS gpdv_new_name, NEW_GRUPE_PDV.gpdv_postotak AS gpdv_new_postotak
	FROM PROMJENA_CIJENE_STAVKE LEFT OUTER JOIN
			PROMJENA_CIJENE_ZAGLAVLJE ON PROMJENA_CIJENE_STAVKE.pcs_pcz_id_fk = PROMJENA_CIJENE_ZAGLAVLJE.pcz_id_pk LEFT OUTER JOIN
			GRUPE_PDV as OLD_GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_old_pdv_id = OLD_GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			GRUPE_PDV as NEW_GRUPE_PDV ON PROMJENA_CIJENE_STAVKE.pcs_ar_new_pdv_id = NEW_GRUPE_PDV.gpdv_id_pk
	where PROMJENA_CIJENE_ZAGLAVLJE.pcz_proknjizeno = 1 and PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak  between @dateStart and @dateEnd and PROMJENA_CIJENE_STAVKE.pcs_ar_id_fk=@ar_id_pk
END
GO




--
-- Definition for stored procedure Pregledi_Get_RACUNI_NEPOTPISANI_COUNT : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUNI_NEPOTPISANI_COUNT]
(
	@Nefisk_Racuni_Count AS INT OUTPUT,
	@Nefisk_Top_Vrijeme AS DATETIME OUTPUT,
	@Nefisk_Napojnice_Count AS INT OUTPUT,
	@Nefisk_Napojnice_Top_Vrijeme AS DATETIME OUTPUT
)
AS
BEGIN
	SELECT	@Nefisk_Racuni_Count =count(distinct TBL.rz_id_pk), @Nefisk_Top_Vrijeme = min(TBL.rz_vrijeme)
	FROM	
		(SELECT * FROM dbo.RACUNI_ZAGLAVLJE WHERE (RACUNI_ZAGLAVLJE.rz_fis_jir is null AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AS TBL
	SELECT	@Nefisk_Napojnice_Count = count(distinct TBL.rz_id_pk), @Nefisk_Napojnice_Top_Vrijeme = min(TBL.rz_vrijeme)
	FROM	
		(SELECT * FROM dbo.RACUNI_ZAGLAVLJE WHERE (RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0 and RACUNI_ZAGLAVLJE.rz_vrijeme>= DATEADD(HOUR, -48, GETDATE()))) AS TBL
END
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_NARUCITELJI]
(
	@na_id_pk Int
)
AS
SELECT * FROM RACUNI_ZAGLAVLJE WHERE rz_narucitelj_id_fk = @na_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_DJELATNIK : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_DJELATNIK]
(
	@dj_id_pk Int
)
AS
SELECT * FROM RACUNI_ZAGLAVLJE WHERE rz_djelatnik_id_fk = @dj_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_OSOBA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_OSOBA]
(
    @rz_id_pk int,
    @rz_narucitelj_id_fk int
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_narucitelj_id_fk = @rz_narucitelj_id_fk
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_NAPOMENA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_NAPOMENA]
(
    @rz_id_pk int,
    @rz_napomena nvarchar(200)
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_napomena = @rz_napomena
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_ARCHIVE_POVEZNICA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_ARCHIVE_POVEZNICA]
(
    @rz_id_pk int,
    @rz_fis_racun_source_id int
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_fis_racun_source_id = @rz_fis_racun_source_id
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_TVRTKA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_TVRTKA]
(
	@rz_id_pk int,
	@rz_tvrtka_id_fk int
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_tvrtka_id_fk = @rz_tvrtka_id_fk
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_DATUM_DOSPIJECA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_DATUM_DOSPIJECA]
(
	@rz_id_pk int,
	@rz_datum_dospijeca datetime
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_datum_dospijeca = @rz_datum_dospijeca
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Izvjesca_Get_PROMET_PO_MESECIMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PROMET_PO_MESECIMA]
AS
SELECT	count(distinct rz_id_pk) as BR_RACUNA, T.GODINA as GODINA, T.MJESEC as MJESEC, SUM(PDV) AS PDV , SUM(TOTAL) AS TOTAL 
FROM (
		SELECT  RACUNI_ZAGLAVLJE.rz_id_pk ,RACUNI_ZAGLAVLJE.rz_dan,rz_broj,MONTH(RACUNI_ZAGLAVLJE.rz_dan) as MJESEC,year(RACUNI_ZAGLAVLJE.rz_dan) as GODINA,
				CAST(SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END / (100 + CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL
		FROM dbo.RACUNI_ZAGLAVLJE left join
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk
				GROUP BY RACUNI_ZAGLAVLJE.rz_dan,gpdv_postotak,rz_broj,RACUNI_ZAGLAVLJE.rz_id_pk) AS T 
		GROUP BY T.GODINA,t.MJESEC
		ORDER BY GODINA ,MJESEC
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODAJA_ARTIKALA_PO_SATIMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODAJA_ARTIKALA_PO_SATIMA]
(
	@day_start datetime,
	@day_end datetime
)
AS
SELECT	sum(rz_iznos) as Total, count(distinct RACUNI_ZAGLAVLJE.rz_id_pk ) as BR_RACUNA, datepart(HH,rz_vrijeme) as Hour
FROM	RACUNI_ZAGLAVLJE
WHERE rz_dan BETWEEN @day_start and @day_end
group by  datepart(HH,rz_vrijeme)
order by datepart(HH,rz_vrijeme)
GO

--
-- Definition for stored procedure Djelatnik_Update_RACUN_FISKAL_ZKI : 
--
GO
CREATE procedure [dbo].[Djelatnik_Update_RACUN_FISKAL_ZKI]
(
	@rz_id_pk int,
	@rz_fis_zastitni_kod nvarchar(50)
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_fis_zastitni_kod = @rz_fis_zastitni_kod
where
	rz_id_pk = @rz_id_pk
GO





--
-- Definition for stored procedure Djelatnik_Update_RACUN_FISKAL_NAPOJNICA : 
--
GO
CREATE procedure [dbo].[Djelatnik_Update_RACUN_FISKAL_NAPOJNICA]
(
	@rz_id_pk int,
    @rz_fis_nap_uuid nvarchar(50),
	@rz_fis_nap_vrijeme_slanja datetime, 
	@rz_fis_nap_vrijeme_obrade datetime,
    @rz_fis_nap_iznos decimal(12,2),
	@rz_fis_nap_pl_id_fk int,
	@rz_fis_nap_naknadna_dostava bit, 
	@rz_fis_nap_fiskalizirano bit, 
	@rz_fis_nap_np nvarchar(1)
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_fis_nap_uuid = @rz_fis_nap_uuid,
	rz_fis_nap_vrijeme_slanja = @rz_fis_nap_vrijeme_slanja, 
	rz_fis_nap_vrijeme_obrade = @rz_fis_nap_vrijeme_obrade, 
	rz_fis_nap_iznos = @rz_fis_nap_iznos, 
	rz_fis_nap_pl_id_fk = @rz_fis_nap_pl_id_fk,  
	rz_fis_nap_naknadna_dostava = @rz_fis_nap_naknadna_dostava, 
	rz_fis_nap_fiskalizirano = @rz_fis_nap_fiskalizirano, 
	rz_fis_nap_np = @rz_fis_nap_np
where
	rz_id_pk = @rz_id_pk
GO



--
-- Definition for stored procedure Djelatnik_Update_RACUN_FISKAL : 
--
GO
CREATE procedure [dbo].[Djelatnik_Update_RACUN_FISKAL]
(
	@rz_id_pk int,
    @rz_fis_uuid nvarchar(50),
	@rz_fis_vrijeme_slanja datetime, 
	@rz_fis_vrijeme_obrade datetime,
	@rz_fis_jir nvarchar(50), 
	@rz_fis_paragon_broj nvarchar(50),  
	@rz_fis_naknadna_dostava bit, 
	@rz_fis_storno_sign nvarchar(1), 
	@rz_fis_racun_source_id int,
	@rz_fis_np nvarchar(1)
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_fis_uuid = @rz_fis_uuid,
	rz_fis_vrijeme_slanja = @rz_fis_vrijeme_slanja, 
	rz_fis_vrijeme_obrade = @rz_fis_vrijeme_obrade, 
	rz_fis_jir = @rz_fis_jir, 
	rz_fis_paragon_broj = @rz_fis_paragon_broj,  
	rz_fis_naknadna_dostava = @rz_fis_naknadna_dostava, 
	rz_fis_storno_sign = @rz_fis_storno_sign, 
	rz_fis_racun_source_id = @rz_fis_racun_source_id,
	rz_fis_np = @rz_fis_np
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Djelatnik_Update_RACUN_DATUM_ISPORUKE : 
--
GO
CREATE procedure [dbo].[Djelatnik_Update_RACUN_DATUM_ISPORUKE]
(
	@rz_id_pk int,
	@rz_nadnevak_isporuke datetime
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_nadnevak_isporuke = @rz_nadnevak_isporuke
where
	rz_id_pk = @rz_id_pk
GO


--
-- Definition for stored procedure Djelatnik_Insert_RACUN_ALL : 
--
GO

CREATE procedure [dbo].[Djelatnik_Insert_RACUN_ALL]
(
	@RetVal_BillNr int output,
	@RetVal_BillNrFull nvarchar(50) output,
	@RetVal_BillID int output,
    @rz_sufix nvarchar(50),
	@rz_vrijeme datetime,
	@rz_dan datetime,
	@rz_nadnevak_isporuke datetime,
	@rz_kasa_id_fk int,
	@rz_djelatnik_id_fk int,
	@rz_tvrtka_id_fk int,
	@rz_narucitelj_id_fk int,
	@rz_placanje_id_fk int,
	@rz_pl_1_id_fk int,
	@rz_pl_2_id_fk int,
	@rz_pl_3_id_fk int,
	@rz_pdv decimal(10, 2),
	@rz_iznos_bez_popusta decimal(10, 2),
	@rz_popust decimal(10, 2),
	@rz_iznos decimal(10, 2),
	@rz_pl_1_iznos decimal(10, 2),
	@rz_pl_2_iznos decimal(10, 2),
	@rz_pl_3_iznos decimal(10, 2),
	@rz_datum_dospijeca datetime,
	@rz_napomena nvarchar(300),
	@rz_fis_vrijeme_slanja datetime, 
	@rz_fis_vrijeme_obrade datetime, 
	@rz_fis_uuid nvarchar(50),
    @rz_fis_zastitni_kod nvarchar(50),
	@rz_fis_jir nvarchar(50), 
	@rz_fis_paragon_broj nvarchar(50),  
	@rz_fis_ozn_pos_pros nvarchar(50), 
	@rz_fis_ozn_nap_uredaja nvarchar(50), 
	@rz_fis_naknadna_dostava bit, 
	@rz_fis_storno_sign nvarchar(1), 
	@rz_fis_racun_source_id int,
	@rz_fis_np nvarchar(1),
	@rz_tot_pov_naknada decimal(10, 2),
	@rz_fis_nap_uuid nvarchar(50),
	@rz_fis_nap_vrijeme_slanja datetime, 
	@rz_fis_nap_vrijeme_obrade datetime, 
	@rz_fis_nap_iznos decimal(12, 2),
	@rz_fis_nap_pl_id_fk int,
	@rz_fis_nap_np nvarchar(1),
	@rz_fis_nap_fiskalizirano bit,
	@rz_fis_nap_naknadna_dostava bit, 
   --------------------------------
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_RACUNI_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN
	-----------------
	SELECT @RetVal_BillNr = MAX(rz_broj) from RACUNI_ZAGLAVLJE
	IF @RetVal_BillNr IS null SET @RetVal_BillNr = 1 ELSE SET @RetVal_BillNr = @RetVal_BillNr + 1
	SET @RetVal_BillNrFull = CAST(@RetVal_BillNr AS VARCHAR) + '-' + @rz_fis_ozn_pos_pros + '-' + @rz_fis_ozn_nap_uredaja
	-----------------
	INSERT INTO RACUNI_ZAGLAVLJE 
		(rz_broj, rz_broj_full, rz_vrijeme, rz_dan, rz_nadnevak_isporuke, rz_djelatnik_id_fk, rz_kasa_id_fk, rz_tvrtka_id_fk, rz_narucitelj_id_fk, rz_placanje_id_fk, rz_pl_1_id_fk, rz_pl_2_id_fk, rz_pl_3_id_fk, rz_pdv, rz_iznos_bez_popusta, rz_popust, rz_iznos, rz_pl_1_iznos, rz_pl_2_iznos, rz_pl_3_iznos, rz_datum_dospijeca, rz_napomena, rz_fis_vrijeme_slanja, rz_fis_vrijeme_obrade, rz_fis_uuid, rz_fis_zastitni_kod, rz_fis_jir, rz_fis_paragon_broj,  rz_fis_ozn_pos_pros, rz_fis_ozn_nap_uredaja, rz_fis_naknadna_dostava, rz_fis_storno_sign, rz_fis_racun_source_id, rz_fis_np, rz_tot_pov_naknada, rz_fis_nap_uuid, rz_fis_nap_vrijeme_slanja, rz_fis_nap_vrijeme_obrade, rz_fis_nap_iznos, rz_fis_nap_pl_id_fk, rz_fis_nap_np, rz_fis_nap_fiskalizirano, rz_fis_nap_naknadna_dostava)
	VALUES
		(@RetVal_BillNr, @RetVal_BillNrFull, @rz_vrijeme, @rz_dan, @rz_nadnevak_isporuke, @rz_djelatnik_id_fk, @rz_kasa_id_fk, @rz_tvrtka_id_fk, @rz_narucitelj_id_fk, @rz_placanje_id_fk, @rz_pl_1_id_fk, @rz_pl_2_id_fk, @rz_pl_3_id_fk, @rz_pdv, @rz_iznos_bez_popusta, @rz_popust, @rz_iznos, @rz_pl_1_iznos, @rz_pl_2_iznos, @rz_pl_3_iznos, @rz_datum_dospijeca, @rz_napomena, @rz_fis_vrijeme_slanja, @rz_fis_vrijeme_obrade, @rz_fis_uuid, @rz_fis_zastitni_kod, @rz_fis_jir, @rz_fis_paragon_broj, @rz_fis_ozn_pos_pros, @rz_fis_ozn_nap_uredaja, @rz_fis_naknadna_dostava, @rz_fis_storno_sign, @rz_fis_racun_source_id, @rz_fis_np, @rz_tot_pov_naknada, @rz_fis_nap_uuid, @rz_fis_nap_vrijeme_slanja, @rz_fis_nap_vrijeme_obrade, @rz_fis_nap_iznos, @rz_fis_nap_pl_id_fk, @rz_fis_nap_np, @rz_fis_nap_fiskalizirano, @rz_fis_nap_naknadna_dostava)
	SET @RetVal_BillID = @@IDENTITY
	------------ STAVKE ----------
	INSERT INTO RACUNI_STAVKE
		(rs_racun_id_fk, rs_artikal_id_fk, 
		rs_cijena_bez_popusta, rs_cijena, rs_kolicina,
		rs_iznos_bez_popusta, rs_iznos, 
		rs_pdv, rs_gpdv_id_fk,  
		rs_description, rs_popust, 
		rs_pov_naknada, rs_tot_pov_naknada)
	SELECT 
		@RetVal_BillID, rs_artikal_id_fk, 
		rs_cijena_bez_popusta, rs_cijena, rs_kolicina,
		rs_iznos_bez_popusta, rs_iznos, 
		rs_pdv, rs_gpdv_id_fk,  
		rs_description, rs_popust, 
		rs_pov_naknada, rs_tot_pov_naknada
	FROM @Stavke_DTable

COMMIT
END
GO



--
-- Definition for stored procedure Servis_Update_KASA : 
--
GO
CREATE procedure [dbo].[Servis_Update_KASA]
(
	@ks_id_pk int,
	@ks_name nvarchar(20),
	@ks_description nvarchar(50)
)
as
update
	KASE
set
	ks_name = @ks_name,
	ks_description = @ks_description
where
	ks_id_pk = @ks_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_KASA : 
--
GO
CREATE procedure [dbo].[Servis_Insert_KASA]
(
	@ks_name nvarchar(20),
	@ks_description nvarchar(50)
)
as
insert into KASE
	(ks_name, ks_description)
values
	(@ks_name, @ks_description)
select scope_identity()
GO

--
-- Definition for stored procedure Servis_Get_KASE : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_KASE]
AS
Select * from KASE
GO

--
-- Definition for stored procedure Servis_Delete_KASA : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_KASA]
(
	@ks_id_pk int
)
AS
delete KASE where ks_id_pk = @ks_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NARUCITELJI]
(
	@na_id_pk int,
	@na_ime nvarchar(25),
	@na_oib nvarchar(15),
	@na_tvrtka_fk int,
	@na_djelatno_mjesto nvarchar(20),
	@na_tel_u_tvrtci nvarchar(15),
	@na_tel nvarchar(15),
	@na_mob nvarchar(15),
	@na_kucna_adresa nvarchar(25),
	@na_mjesto nvarchar(25),
	@na_biljeska nvarchar(40)
)
as
update
	NARUCITELJI
set
	na_ime = @na_ime,
	na_oib = @na_oib,
	na_tvrtka_fk = @na_tvrtka_fk,
	na_djelatno_mjesto = @na_djelatno_mjesto,
	na_tel_u_tvrtci = @na_tel_u_tvrtci,
	na_tel = @na_tel,
	na_mob = @na_mob,
	na_kucna_adresa = @na_kucna_adresa,
	na_mjesto = @na_mjesto,
	na_biljeska = @na_biljeska
where
	na_id_pk = @na_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_NARUCITELJI]
(
	@na_ime nvarchar(25),
	@na_oib nvarchar(15),
	@na_tvrtka_fk int,
	@na_djelatno_mjesto nvarchar(20),
	@na_tel_u_tvrtci nvarchar(15),
	@na_tel nvarchar(15),
	@na_mob nvarchar(15),
	@na_kucna_adresa nvarchar(25),
	@na_mjesto nvarchar(25),
	@na_biljeska nvarchar(40)
)
as
insert into NARUCITELJI
	(na_ime, na_oib, na_tvrtka_fk, na_djelatno_mjesto, na_tel_u_tvrtci, na_tel, na_mob, na_kucna_adresa, na_mjesto, na_biljeska)
values
	(@na_ime, @na_oib, @na_tvrtka_fk, @na_djelatno_mjesto, @na_tel_u_tvrtci, @na_tel, @na_mob, @na_kucna_adresa, @na_mjesto, @na_biljeska)
select scope_identity()
GO


--
-- Definition for stored procedure Osnovno_DeleteInfo_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_TVRTKE]
(
	@tv_id_pk Int
)
AS
SELECT * FROM RACUNI_ZAGLAVLJE WHERE rz_tvrtka_id_fk = @tv_id_pk
SELECT * FROM NARUCITELJI WHERE na_tvrtka_fk = @tv_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_NARUCITELJI]
(
	@na_id_pk int
)
as
delete from NARUCITELJI where na_id_pk = @na_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_TVRTKE]
(
	@tv_id_pk int,
	@tv_ime nvarchar(50),
	@tv_adresa nvarchar(50),
	@tv_adresa_broj nvarchar(5),
	@tv_mjesto nvarchar(50),
	@tv_mjesto_postanski_broj nvarchar(10),
	@tv_maticni_broj nvarchar(25),
	@tv_oib nvarchar(25),
	@tv_iban nvarchar(25),
	@tv_tel nvarchar(15),
	@tv_email nvarchar(50),
	@tv_kontakt_osoba nvarchar(20),
	@tv_odgoda_placanja int,
	@tv_stop_tvrtka bit,
	@tv_note nvarchar(40),
	@tv_state nvarchar(50),
	@tv_porezni_broj nvarchar(50),
	@tv_sifra nvarchar(30)
)
as
update
	TVRTKE
set
	tv_ime = @tv_ime,
	tv_adresa = @tv_adresa,
	tv_mjesto = @tv_mjesto,
	tv_maticni_broj = @tv_maticni_broj,
	tv_mjesto_postanski_broj = @tv_mjesto_postanski_broj,
	tv_tel = @tv_tel,
	tv_adresa_broj = @tv_adresa_broj,
	tv_iban = @tv_iban,
	tv_kontakt_osoba = @tv_kontakt_osoba,
	tv_email = @tv_email,
	tv_odgoda_placanja = @tv_odgoda_placanja,
	tv_stop_tvrtka = @tv_stop_tvrtka,
	tv_note = @tv_note,
	tv_oib = @tv_oib,
	tv_state = @tv_state,
	tv_porezni_broj = @tv_porezni_broj,
	tv_sifra = @tv_sifra 
where
	tv_id_pk = @tv_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_TVRTKE]
(
	@tv_ime nvarchar(50),
	@tv_adresa nvarchar(50),
	@tv_adresa_broj nvarchar(5),
	@tv_mjesto nvarchar(50),
	@tv_mjesto_postanski_broj nvarchar(10),
	@tv_maticni_broj nvarchar(25),
	@tv_oib nvarchar(25),
	@tv_iban nvarchar(25),
	@tv_tel nvarchar(15),
	@tv_email nvarchar(50),
	@tv_kontakt_osoba nvarchar(20),
	@tv_odgoda_placanja int,
	@tv_stop_tvrtka bit,
	@tv_note nvarchar(40),
	@tv_state nvarchar(50),
	@tv_porezni_broj nvarchar(50),
	@tv_sifra nvarchar(30)
)
as
insert into TVRTKE
	(tv_ime, tv_adresa, tv_mjesto, tv_maticni_broj, tv_iban, tv_tel, tv_email, tv_adresa_broj, tv_kontakt_osoba, tv_mjesto_postanski_broj, tv_odgoda_placanja, tv_stop_tvrtka, tv_note, tv_oib, tv_state, tv_porezni_broj, tv_sifra)
values
	(@tv_ime, @tv_adresa, @tv_mjesto, @tv_maticni_broj, @tv_iban, @tv_tel, @tv_email, @tv_adresa_broj, @tv_kontakt_osoba, @tv_mjesto_postanski_broj, @tv_odgoda_placanja, @tv_stop_tvrtka, @tv_note, @tv_oib, @tv_state, @tv_porezni_broj, @tv_sifra)
select scope_identity()
GO
GO


--
-- Definition for stored procedure Osnovno_Get_TVRTKE : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_TVRTKE]
(
	@tv_id_pk int = NULL
)
AS
Select * from TVRTKE
where (@tv_id_pk is null or (TVRTKE.tv_id_pk = @tv_id_pk))
GO



--
-- Definition for stored procedure Osnovno_Get_NARUCITELJI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NARUCITELJI]
(
	@na_tvrtka_fk int = NULL
)
AS
SELECT NARUCITELJI.na_id_pk, NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_tvrtka_fk, NARUCITELJI.na_djelatno_mjesto, NARUCITELJI.na_tel_u_tvrtci, 
       NARUCITELJI.na_tel, NARUCITELJI.na_mob, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska, 
       TVRTKE.tv_ime
FROM   NARUCITELJI LEFT JOIN
       TVRTKE ON NARUCITELJI.na_tvrtka_fk = TVRTKE.tv_id_pk
WHERE
		(@na_tvrtka_fk is null or (NARUCITELJI.na_tvrtka_fk = @na_tvrtka_fk))
GO

--
-- Definition for stored procedure Osnovno_Delete_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_TVRTKE]
(
	@tv_id_pk int
)
as
delete from TVRTKE where tv_id_pk = @tv_id_pk
GO

--
-- Definition for stored procedure Skladiste_Get_NARUDZBENICA_ZAGLAVLJE : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_NARUDZBENICA_ZAGLAVLJE]
(
	@day_start datetime,
	@day_end datetime,
	@nz_flag bit = null
)
AS
BEGIN
SELECT NARUDZBENICA_ZAGLAVLJE.*, DJELATNICI.dj_name
FROM NARUDZBENICA_ZAGLAVLJE LEFT OUTER JOIN
				DJELATNICI ON NARUDZBENICA_ZAGLAVLJE.nz_dj_id_fk = DJELATNICI.dj_id_pk
where NARUDZBENICA_ZAGLAVLJE.nz_proknjizeno=1 AND 
	  NARUDZBENICA_ZAGLAVLJE.nz_nadnevak BETWEEN @day_start AND @day_end AND
	  (@nz_flag is null or (NARUDZBENICA_ZAGLAVLJE.nz_flag = @nz_flag))
END
GO

--
-- Definition for stored procedure Skladiste_Get_NARUDZBENICA_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_NARUDZBENICA_BY_ID]
(
	@nz_id_pk int
)
AS
BEGIN
SELECT NARUDZBENICA_ZAGLAVLJE.*, DJELATNICI.dj_name
FROM NARUDZBENICA_ZAGLAVLJE LEFT OUTER JOIN
				DJELATNICI ON NARUDZBENICA_ZAGLAVLJE.nz_dj_id_fk = DJELATNICI.dj_id_pk
where NARUDZBENICA_ZAGLAVLJE.nz_id_pk = @nz_id_pk  
END
BEGIN
SELECT		NARUDZBENICA_STAVKE.*, 
            ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
			GRUPE_ARTIKALA.ga_name
	FROM	NARUDZBENICA_STAVKE LEFT OUTER JOIN
			ARTIKLI ON NARUDZBENICA_STAVKE.ns_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
            GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
	where	ns_nz_id_fk = @nz_id_pk 
END
GO

--
-- Definition for stored procedure Skladiste_Set_NARUDZBENICA_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_NARUDZBENICA_WRITE_MODE]
(
	@RetVal int output,
	@nz_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT nz_id_pk, nz_proknjizeno FROM NARUDZBENICA_ZAGLAVLJE WHERE nz_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE NARUDZBENICA_ZAGLAVLJE SET nz_proknjizeno=0 WHERE nz_id_pk=@nz_id_pk
		EXECUTE dbo.Skladiste_Get_NARUDZBENICA_BY_ID @nz_id_pk
	END
END
GO

--
-- Definition for stored procedure Skladiste_Get_INIT_NARUDZBENICA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_NARUDZBENICA]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(nz_broj) from NARUDZBENICA_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1
	declare @ID AS INT
	SELECT @ID=nz_id_pk FROM NARUDZBENICA_ZAGLAVLJE where nz_proknjizeno = 0 
END
BEGIN
	SELECT NARUDZBENICA_ZAGLAVLJE.*, DJELATNICI.dj_name
	FROM NARUDZBENICA_ZAGLAVLJE LEFT OUTER JOIN
					DJELATNICI ON NARUDZBENICA_ZAGLAVLJE.nz_dj_id_fk = DJELATNICI.dj_id_pk
	where NARUDZBENICA_ZAGLAVLJE.nz_id_pk = @ID 
END
BEGIN
	SELECT		NARUDZBENICA_STAVKE.*, 
				ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_jmj, ARTIKLI.ar_grupa_fk, 
				GRUPE_ARTIKALA.ga_name
		FROM	NARUDZBENICA_STAVKE LEFT OUTER JOIN
				ARTIKLI ON NARUDZBENICA_STAVKE.ns_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
				GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
		where	ns_nz_id_fk = @ID
END
GO

--
-- Definition for stored procedure Osnovno_Update_DJELATNICI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_DJELATNICI]
(
	@dj_id_pk int,
	@dj_name nvarchar(30),
	@dj_oib nvarchar(20),
	@dj_sifra nvarchar(10),
	@dj_barcode nvarchar(30),
	@dj_adresa nvarchar(30),
	@dj_mjesto nvarchar(30),
	@dj_tel nvarchar(15),
	@dj_mob nvarchar(15),
	@dj_work_start datetime,
	@dj_work_end datetime,
	@dj_active bit,
	@dj_note nvarchar(40),
	@dj_oznaka nvarchar(20),
	@dj_status nvarchar(1)
)
as
update
	DJELATNICI
set
	dj_name = @dj_name,
	dj_oib = @dj_oib,
	dj_sifra = @dj_sifra,
	dj_barcode = @dj_barcode,
	dj_adresa = @dj_adresa,
	dj_mjesto = @dj_mjesto,
	dj_tel = @dj_tel,
	dj_mob = @dj_mob,
	dj_work_start = @dj_work_start,
	dj_work_end = @dj_work_end,
	dj_active = @dj_active,
	dj_note = @dj_note, 
	dj_oznaka = @dj_oznaka,
	dj_status = @dj_status
where
	dj_id_pk = @dj_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_DJELATNICI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_DJELATNICI]
(
	@dj_name nvarchar(30),
	@dj_oib nvarchar(20),
	@dj_sifra nvarchar(10),
	@dj_barcode nvarchar(30),
	@dj_adresa nvarchar(30),
	@dj_mjesto nvarchar(30),
	@dj_tel nvarchar(15),
	@dj_mob nvarchar(15),
	@dj_work_start datetime,
	@dj_work_end datetime,
	@dj_active bit,
	@dj_note nvarchar(40),
	@dj_oznaka nvarchar(20),
	@dj_status nvarchar(1)
)
as
insert into DJELATNICI
	(dj_name, dj_oib, dj_sifra, dj_barcode, dj_adresa, dj_mjesto, dj_tel, dj_mob, dj_work_start, dj_work_end, dj_active, dj_note, dj_oznaka, dj_status)
values
	(@dj_name, @dj_oib, @dj_sifra, @dj_barcode, @dj_adresa, @dj_mjesto, @dj_tel, @dj_mob, @dj_work_start, @dj_work_end, @dj_active, @dj_note ,@dj_oznaka, @dj_status)
select scope_identity()
GO


--
-- Definition for stored procedure Osnovno_Delete_DJELATNICI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_DJELATNICI]
(
	@dj_id_pk int
)
as
delete from DJELATNICI where dj_id_pk = @dj_id_pk
GO

--
-- Definition for stored procedure Management_Get_PONUDA_ZAGLAVLJE : 
--
GO
CREATE PROCEDURE [dbo].[Management_Get_PONUDA_ZAGLAVLJE]
(
	@day_start datetime,
	@day_end datetime,
	@pnz_dj_id_fk int = null,
	@pnz_tv_id_fk int = null,
	@pnz_na_id_fk int = null,
	@pnz_id_pk int = null,
	@pnz_status bit = null
)
AS
BEGIN
	SELECT PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_dj_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_na_id_fk,
			PONUDA_ZAGLAVLJE.pnz_napomena, PONUDA_ZAGLAVLJE.pnz_status, 
			DJELATNICI.dj_name, DJELATNICI.dj_oib, DJELATNICI.dj_sifra, DJELATNICI.dj_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_oib, 
			NARUCITELJI.na_ime,
			sum(PONUDA_STAVKE.pns_pdv) as count_pdv, 
			sum(PONUDA_STAVKE.pns_tot_pov_nak) as count_pov_nak, 
			sum(PONUDA_STAVKE.pns_iznos) as count_ukupno  
	FROM PONUDA_ZAGLAVLJE LEFT OUTER JOIN
			PONUDA_STAVKE ON PONUDA_ZAGLAVLJE.pnz_id_pk = PONUDA_STAVKE.pns_ponuda_id_fk LEFT OUTER JOIN
			TVRTKE ON PONUDA_ZAGLAVLJE.pnz_tv_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
			NARUCITELJI ON PONUDA_ZAGLAVLJE.pnz_na_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
			DJELATNICI ON PONUDA_ZAGLAVLJE.pnz_dj_id_fk = DJELATNICI.dj_id_pk
	WHERE  (PONUDA_ZAGLAVLJE.pnz_nadnevak BETWEEN @day_start AND @day_end) AND
			(@pnz_id_pk is null or (PONUDA_ZAGLAVLJE.pnz_id_pk = @pnz_id_pk)) and
			(@pnz_dj_id_fk is null or (PONUDA_ZAGLAVLJE.pnz_dj_id_fk = @pnz_dj_id_fk)) and
			(@pnz_na_id_fk is null or (PONUDA_ZAGLAVLJE.pnz_na_id_fk = @pnz_na_id_fk)) and
			(@pnz_tv_id_fk is null or (PONUDA_ZAGLAVLJE.pnz_tv_id_fk = @pnz_tv_id_fk)) and
			(@pnz_status is null or (PONUDA_ZAGLAVLJE.pnz_status = @pnz_status))
	GROUP BY  PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_na_id_fk, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_dj_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_napomena, PONUDA_ZAGLAVLJE.pnz_status, 
			DJELATNICI.dj_name, DJELATNICI.dj_oib, DJELATNICI.dj_sifra, DJELATNICI.dj_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, NARUCITELJI.na_ime
END
GO

--
-- Definition for stored procedure Osnovno_Get_DJELATNICI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_DJELATNICI]
(
	@active_only bit = null
)
AS
Select * from DJELATNICI 
WHERE (@active_only is null or (DJELATNICI.dj_active = 1))
GO



--
-- Definition for stored procedure Skladiste_Get_KNJIGA_POPISA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_KNJIGA_POPISA]
(
	@dateStart datetime,
	@dateEnd datetime
)
AS
BEGIN
 	--------------------------------------------- 
	--------------  POCETNO STANJE
	---------------------------------------------
	SELECT SUM(ps_zaduzenje_mpc) AS ps_zaduzenje_mpc_total, 
		   SUM(ps_zaduzenje_pdv) AS ps_zaduzenje_pdv FROM POCETNO_STANJE
	--------------------------------------------- 
	--------------  PRIMKE
	---------------------------------------------
	SELECT PRIMKE_ZAGLAVLJE.*, DOBAVLJACI.do_name
	FROM PRIMKE_ZAGLAVLJE LEFT OUTER JOIN
		DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
	where PRIMKE_ZAGLAVLJE.pr_proknjizeno = 1 and PRIMKE_ZAGLAVLJE.pr_datum_knjizenja between @dateStart and @dateEnd
	--------------------------------------------- 
	--------------  IZDATNICE
	---------------------------------------------
	SELECT * FROM IZDATNICE_ZAGLAVLJE
	where  IZDATNICE_ZAGLAVLJE.iz_proknjizeno=1 and IZDATNICE_ZAGLAVLJE.iz_datum between @dateStart and @dateEnd
	--------------------------------------------- 
	--------------  INVENTURE
	---------------------------------------------
	SELECT * FROM INVENTURA_ZAGLAVLJE
	where  INVENTURA_ZAGLAVLJE.iz_proknjizeno=1 and INVENTURA_ZAGLAVLJE.iz_datetime between @dateStart and @dateEnd
	--------------------------------------------- 
	--------------  DNEVNI PROMETI (BEZ VIRMANA)
	---------------------------------------------
	SELECT T2.rz_dan, PDV_BEZ_POPUSTA, PDV, TOTAL_BEZ_POPUSTA, TOTAL, count(distinct RACUNI_ZAGLAVLJE.rz_id_pk) as BR_RACUNA FROM (
	SELECT	t.rz_dan, 
		    SUM(PDV) AS PDV, 
			SUM(PDV_BEZ_POPUSTA) AS PDV_BEZ_POPUSTA, 
			SUM(TOTAL) AS TOTAL, 
			SUM(TOTAL_BEZ_POPUSTA) AS TOTAL_BEZ_POPUSTA 
			FROM (
		SELECT  RACUNI_ZAGLAVLJE.rz_dan,
				CAST(SUM(RACUNI_STAVKE.rs_iznos - RACUNI_STAVKE.rs_tot_pov_naknada)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
				CAST(SUM(RACUNI_STAVKE.rs_iznos_bez_popusta - RACUNI_STAVKE.rs_tot_pov_naknada)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV_BEZ_POPUSTA, 
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_iznos_bez_popusta) AS TOTAL_BEZ_POPUSTA
		FROM dbo.RACUNI_ZAGLAVLJE left join
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @dateStart and @dateEnd) AND ARTIKLI.ar_kat_id_fk = 1 and not NACINI_PLACANJA.np_category_fk = 3 AND ar_kat_id_fk = 1
		GROUP BY RACUNI_ZAGLAVLJE.rz_dan,gpdv_postotak) AS t
		GROUP BY t.rz_dan) AS T2 LEFT JOIN 			
		RACUNI_ZAGLAVLJE on t2.rz_dan=RACUNI_ZAGLAVLJE.rz_dan 
		GROUP BY T2.rz_dan, PDV_BEZ_POPUSTA, PDV, TOTAL, TOTAL_BEZ_POPUSTA
	--------------------------------------------- 
	--------------  RACUNI ZAGLAVLJE (VIRMANI)
	---------------------------------------------
	SELECT T1.rz_id_pk, T1.rz_broj_full, T1.rz_vrijeme, T1.rz_tvrtka_id_fk, T1.tv_ime, 
		   SUM(T1.PDV) AS PDV, 
		   SUM(T1.PDV_BEZ_POPUSTA) AS PDV_BEZ_POPUSTA, 
		   SUM(T1.rz_iznos) AS TOTAL, 
		   SUM(T1.rz_iznos_bez_popusta) AS TOTAL_BEZ_POPUSTA 
		FROM (
			SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, 
				   RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, TVRTKE.tv_ime, 
				   SUM(RACUNI_STAVKE.rs_iznos_bez_popusta) AS rz_iznos_bez_popusta, 
				   SUM(RACUNI_STAVKE.rs_iznos) AS rz_iznos, 
				   CAST(SUM(RACUNI_STAVKE.rs_iznos - RACUNI_STAVKE.rs_tot_pov_naknada)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
				   CAST(SUM(RACUNI_STAVKE.rs_iznos_bez_popusta - RACUNI_STAVKE.rs_tot_pov_naknada)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV_BEZ_POPUSTA
			FROM RACUNI_ZAGLAVLJE LEFT JOIN
						RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk INNER JOIN				
						ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
						GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk 
				where  (RACUNI_ZAGLAVLJE.rz_dan between @dateStart and @dateEnd) AND  NACINI_PLACANJA.np_category_fk = 3 AND ar_kat_id_fk = 1
			GROUP BY RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, TVRTKE.tv_ime, GRUPE_PDV.gpdv_postotak
			 ) as T1
	 GROUP BY rz_id_pk, rz_broj_full, rz_vrijeme, rz_tvrtka_id_fk, tv_ime
	--------------------------------------------- 
	--------------  ZPC
	---------------------------------------------
	SELECT * FROM PROMJENA_CIJENE_ZAGLAVLJE
	where  PROMJENA_CIJENE_ZAGLAVLJE.pcz_proknjizeno = 1 and PROMJENA_CIJENE_ZAGLAVLJE.pcz_nadnevak between @dateStart and @dateEnd
END
GO



--
-- Definition for stored procedure Pregledi_Get_RACUNI_ZAGLAVLJE_DISTINCT : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUNI_ZAGLAVLJE_DISTINCT]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@use_naknadno_potpisani bit = null,
	@use_nepotpisani bit = null,
	@use_paragon bit = null,
	@use_kartice bit = null,
	@use_storno bit = null,
	@use_sve_tvrtke bit = null,
	@pay_type_id int = null,
	@tvrtka_id int = null,
	@djelatnik_id int = null,
	@kasa_id int = null,
	@artikal_id int = null,
	@grupa_artikala_id int = null,
	@narucitelj_id int = null,
	@Popust_Included bit = null,
	@Popust_Excluded bit = null,
	@Napojnice_Exists bit = null,
	@Napojnice_Not_Exists bit = null
)
AS
SELECT DISTINCT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, 
			RACUNI_ZAGLAVLJE.rz_placanje_id_fk, RACUNI_ZAGLAVLJE.rz_pl_1_id_fk, RACUNI_ZAGLAVLJE.rz_pl_2_id_fk, RACUNI_ZAGLAVLJE.rz_pl_3_id_fk, NACINI_PLACANJA.np_category_fk, 
			RACUNI_ZAGLAVLJE.rz_kasa_id_fk, RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk, 
			RACUNI_ZAGLAVLJE.rz_iznos_bez_popusta, RACUNI_ZAGLAVLJE.rz_popust, RACUNI_ZAGLAVLJE.rz_pdv, RACUNI_ZAGLAVLJE.rz_iznos,
			RACUNI_ZAGLAVLJE.rz_datum_dospijeca, RACUNI_ZAGLAVLJE.rz_nadnevak_isporuke, 
			RACUNI_ZAGLAVLJE.rz_napomena, RACUNI_ZAGLAVLJE.rz_tot_pov_naknada, 
			RACUNI_ZAGLAVLJE.rz_fis_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_vrijeme_obrade, 
			RACUNI_ZAGLAVLJE.rz_fis_uuid, RACUNI_ZAGLAVLJE.rz_fis_zastitni_kod, RACUNI_ZAGLAVLJE.rz_fis_jir, RACUNI_ZAGLAVLJE.rz_fis_paragon_broj, 
			RACUNI_ZAGLAVLJE.rz_fis_ozn_pos_pros, RACUNI_ZAGLAVLJE.rz_fis_ozn_nap_uredaja, 
			RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava, CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
			RACUNI_ZAGLAVLJE.rz_fis_storno_sign, RACUNI_ZAGLAVLJE.rz_fis_racun_source_id, RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full, RACUNI_ZAGLAVLJE.rz_fis_np, 
			NACINI_PLACANJA.np_name, KASE.ks_name, 
			NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska,
			DJELATNICI.dj_name, DJELATNICI.dj_oznaka, DJELATNICI.dj_oib, DJELATNICI.dj_status, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj, TVRTKE.tv_sifra,
			NP1.np_name AS NP_NAZIV_1,RACUNI_ZAGLAVLJE.rz_pl_1_iznos, NP2.np_name AS NP_NAZIV_2,RACUNI_ZAGLAVLJE.rz_pl_2_iznos, NP3.np_name AS NP_NAZIV_3,RACUNI_ZAGLAVLJE.rz_pl_3_iznos,
			RACUNI_ZAGLAVLJE.rz_fis_nap_uuid, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_nap_iznos, 
			RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk, RACUNI_ZAGLAVLJE.rz_fis_nap_np, RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano,
			RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_obrade, 
			NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str
FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
			DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
			NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
			TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
			RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN	
			NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 
where (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end) AND
			(@use_naknadno_potpisani is null or (not RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AND 
			(@use_nepotpisani is null or (RACUNI_ZAGLAVLJE.rz_fis_jir is null AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AND
			(@use_paragon is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end AND NOT RACUNI_ZAGLAVLJE.rz_fis_paragon_broj is null)) AND 
			(@use_kartice is null or (NACINI_PLACANJA.np_category_fk = 1)) AND 
			(@use_storno is null or (RACUNI_ZAGLAVLJE.rz_fis_storno_sign='S')) AND 
			(@use_sve_tvrtke is null or (NOT RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk IS NULL)) AND 
			(@pay_type_id is null or (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @pay_type_id)) AND 
			(@tvrtka_id is null or (RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = @tvrtka_id)) AND 
			(@djelatnik_id is null or (RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = @djelatnik_id)) AND 
			(@kasa_id is null or (RACUNI_ZAGLAVLJE.rz_kasa_id_fk = @kasa_id)) AND 
			(@narucitelj_id is null or (RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = @narucitelj_id)) AND 
 			(@artikal_id is null or (RACUNI_STAVKE.rs_artikal_id_fk = @artikal_id)) AND
 			(@grupa_artikala_id is null or (ARTIKLI.ar_grupa_fk = @grupa_artikala_id)) AND
			(@Popust_Included is null or not (RACUNI_ZAGLAVLJE.rz_popust = 0)) AND
			(@Popust_Excluded is null or (RACUNI_ZAGLAVLJE.rz_popust = 0)) AND
			(@Napojnice_Exists is null or not (RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0)) AND
			(@Napojnice_Not_Exists is null or (RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0)) 
GO



--
-- Definition for stored procedure Pregledi_Get_RACUNI_ZAGLAVLJE_DETALJNO : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUNI_ZAGLAVLJE_DETALJNO]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@vrijeme_start datetime = null,
	@vrijeme_end datetime = null,
	@broj_start int = null,
	@broj_end int = null
)
AS
BEGIN

	-- lista racuna
	SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, 
			RACUNI_ZAGLAVLJE.rz_placanje_id_fk, RACUNI_ZAGLAVLJE.rz_pl_1_id_fk, RACUNI_ZAGLAVLJE.rz_pl_2_id_fk, RACUNI_ZAGLAVLJE.rz_pl_3_id_fk, NACINI_PLACANJA.np_category_fk, 
			RACUNI_ZAGLAVLJE.rz_kasa_id_fk, RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk, 
			RACUNI_ZAGLAVLJE.rz_iznos_bez_popusta, RACUNI_ZAGLAVLJE.rz_popust, RACUNI_ZAGLAVLJE.rz_pdv, RACUNI_ZAGLAVLJE.rz_iznos,
			RACUNI_ZAGLAVLJE.rz_datum_dospijeca, RACUNI_ZAGLAVLJE.rz_nadnevak_isporuke, 
			RACUNI_ZAGLAVLJE.rz_napomena, RACUNI_ZAGLAVLJE.rz_tot_pov_naknada, 
			RACUNI_ZAGLAVLJE.rz_fis_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_vrijeme_obrade, 
			RACUNI_ZAGLAVLJE.rz_fis_uuid, RACUNI_ZAGLAVLJE.rz_fis_zastitni_kod, RACUNI_ZAGLAVLJE.rz_fis_jir, RACUNI_ZAGLAVLJE.rz_fis_paragon_broj, 
			RACUNI_ZAGLAVLJE.rz_fis_ozn_pos_pros, RACUNI_ZAGLAVLJE.rz_fis_ozn_nap_uredaja, 
			RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava, CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
			RACUNI_ZAGLAVLJE.rz_fis_storno_sign, RACUNI_ZAGLAVLJE.rz_fis_racun_source_id, RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full, RACUNI_ZAGLAVLJE.rz_fis_np, 
			NACINI_PLACANJA.np_name, KASE.ks_name, 
			NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska,
			DJELATNICI.dj_name, DJELATNICI.dj_oznaka, DJELATNICI.dj_oib, DJELATNICI.dj_status, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj, TVRTKE.tv_sifra,
			NP1.np_name AS NP_NAZIV_1,RACUNI_ZAGLAVLJE.rz_pl_1_iznos, NP2.np_name AS NP_NAZIV_2,RACUNI_ZAGLAVLJE.rz_pl_2_iznos, NP3.np_name AS NP_NAZIV_3,RACUNI_ZAGLAVLJE.rz_pl_3_iznos,
			RACUNI_ZAGLAVLJE.rz_fis_nap_uuid, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_nap_iznos, 
			RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk, RACUNI_ZAGLAVLJE.rz_fis_nap_np, RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano,
			RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_obrade, 
			NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
						NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN	
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
			            NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 
	WHERE	(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@vrijeme_start is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @vrijeme_start and @vrijeme_end)) AND 
			(@broj_start is null or (RACUNI_ZAGLAVLJE.rz_broj between @broj_start and @broj_end)) 

	SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, 
			RACUNI_ZAGLAVLJE.rz_placanje_id_fk, RACUNI_ZAGLAVLJE.rz_pl_1_id_fk, RACUNI_ZAGLAVLJE.rz_pl_2_id_fk, RACUNI_ZAGLAVLJE.rz_pl_3_id_fk, NACINI_PLACANJA.np_category_fk, 
			RACUNI_ZAGLAVLJE.rz_kasa_id_fk, RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk, 
			RACUNI_ZAGLAVLJE.rz_iznos_bez_popusta, RACUNI_ZAGLAVLJE.rz_popust, RACUNI_ZAGLAVLJE.rz_pdv, RACUNI_ZAGLAVLJE.rz_iznos,
			RACUNI_ZAGLAVLJE.rz_datum_dospijeca, RACUNI_ZAGLAVLJE.rz_nadnevak_isporuke, 
			RACUNI_ZAGLAVLJE.rz_napomena, RACUNI_ZAGLAVLJE.rz_tot_pov_naknada, 
			RACUNI_ZAGLAVLJE.rz_fis_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_vrijeme_obrade, 
			RACUNI_ZAGLAVLJE.rz_fis_uuid, RACUNI_ZAGLAVLJE.rz_fis_zastitni_kod, RACUNI_ZAGLAVLJE.rz_fis_jir, RACUNI_ZAGLAVLJE.rz_fis_paragon_broj, 
			RACUNI_ZAGLAVLJE.rz_fis_ozn_pos_pros, RACUNI_ZAGLAVLJE.rz_fis_ozn_nap_uredaja, 
			RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava, CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
			RACUNI_ZAGLAVLJE.rz_fis_storno_sign, RACUNI_ZAGLAVLJE.rz_fis_racun_source_id, RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full, RACUNI_ZAGLAVLJE.rz_fis_np, 
			NACINI_PLACANJA.np_name, KASE.ks_name, 
			NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska,
			DJELATNICI.dj_name, DJELATNICI.dj_oznaka, DJELATNICI.dj_oib, DJELATNICI.dj_status, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj, TVRTKE.tv_sifra,
			NP1.np_name AS NP_NAZIV_1,RACUNI_ZAGLAVLJE.rz_pl_1_iznos, NP2.np_name AS NP_NAZIV_2,RACUNI_ZAGLAVLJE.rz_pl_2_iznos, NP3.np_name AS NP_NAZIV_3,RACUNI_ZAGLAVLJE.rz_pl_3_iznos, 
			RACUNI_ZAGLAVLJE.rz_fis_nap_uuid, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_nap_iznos, 
			RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk, RACUNI_ZAGLAVLJE.rz_fis_nap_np, RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano,
			RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_obrade, 
			NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str,
			ARTIKLI.ar_id_pk, ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_jmj,
			RACUNI_STAVKE.rs_cijena_bez_popusta, RACUNI_STAVKE.rs_popust, RACUNI_STAVKE.rs_cijena, RACUNI_STAVKE.rs_kolicina, 
			RACUNI_STAVKE.rs_iznos_bez_popusta, RACUNI_STAVKE.rs_pdv, RACUNI_STAVKE.rs_iznos,
			RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak,
			RACUNI_STAVKE.rs_description, RACUNI_STAVKE.rs_pov_naknada, RACUNI_STAVKE.rs_tot_pov_naknada
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
						GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
						ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
						NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk  LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
			            NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 
	WHERE	(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@vrijeme_start is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @vrijeme_start and @vrijeme_end)) AND 
			(@broj_start is null or (RACUNI_ZAGLAVLJE.rz_broj between @broj_start and @broj_end)) 

	-- po svim porezima
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
	FROM	RACUNI_ZAGLAVLJE inner JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@vrijeme_start is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @vrijeme_start and @vrijeme_end)) AND 
			(@broj_start is null or (RACUNI_ZAGLAVLJE.rz_broj between @broj_start and @broj_end)) 
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
END
GO


--
-- Definition for stored procedure Pregledi_Get_RACUNI_ZAGLAVLJE : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUNI_ZAGLAVLJE]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@use_naknadno_potpisani bit = null,
	@use_nepotpisani bit = null,
	@use_paragon bit = null,
	@use_kartice bit = null,
	@use_storno bit = null,
	@use_sve_tvrtke bit = null,
	@pay_type_id int = null,
	@tvrtka_id int = null,
	@djelatnik_id int = null,
	@kasa_id int = null,
	@narucitelj_id int = null,
	@rz_id_pk int = null,
	@use_nap_nepotpisani bit = null
)
AS
SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, 
			RACUNI_ZAGLAVLJE.rz_placanje_id_fk, RACUNI_ZAGLAVLJE.rz_pl_1_id_fk, RACUNI_ZAGLAVLJE.rz_pl_2_id_fk, RACUNI_ZAGLAVLJE.rz_pl_3_id_fk, NACINI_PLACANJA.np_category_fk, 
			RACUNI_ZAGLAVLJE.rz_kasa_id_fk, RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk, 
			RACUNI_ZAGLAVLJE.rz_iznos_bez_popusta, RACUNI_ZAGLAVLJE.rz_popust, RACUNI_ZAGLAVLJE.rz_pdv, RACUNI_ZAGLAVLJE.rz_iznos,
			RACUNI_ZAGLAVLJE.rz_datum_dospijeca, RACUNI_ZAGLAVLJE.rz_nadnevak_isporuke, 
			RACUNI_ZAGLAVLJE.rz_napomena, RACUNI_ZAGLAVLJE.rz_tot_pov_naknada, 
			RACUNI_ZAGLAVLJE.rz_fis_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_vrijeme_obrade, 
			RACUNI_ZAGLAVLJE.rz_fis_uuid, RACUNI_ZAGLAVLJE.rz_fis_zastitni_kod, RACUNI_ZAGLAVLJE.rz_fis_jir, RACUNI_ZAGLAVLJE.rz_fis_paragon_broj, 
			RACUNI_ZAGLAVLJE.rz_fis_ozn_pos_pros, RACUNI_ZAGLAVLJE.rz_fis_ozn_nap_uredaja, 
			RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava, CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
			RACUNI_ZAGLAVLJE.rz_fis_storno_sign, RACUNI_ZAGLAVLJE.rz_fis_racun_source_id, RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full, RACUNI_ZAGLAVLJE.rz_fis_np, 
			NACINI_PLACANJA.np_name, KASE.ks_name, 
			NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska,
			DJELATNICI.dj_name, DJELATNICI.dj_oznaka, DJELATNICI.dj_oib, DJELATNICI.dj_status, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj, TVRTKE.tv_sifra,
			NP1.np_name AS NP_NAZIV_1,RACUNI_ZAGLAVLJE.rz_pl_1_iznos, NP2.np_name AS NP_NAZIV_2,RACUNI_ZAGLAVLJE.rz_pl_2_iznos, NP3.np_name AS NP_NAZIV_3,RACUNI_ZAGLAVLJE.rz_pl_3_iznos,
			RACUNI_ZAGLAVLJE.rz_fis_nap_uuid, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_nap_iznos, 
			RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk, RACUNI_ZAGLAVLJE.rz_fis_nap_np, RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano,
			RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_obrade, 
			NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
			CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str
FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
			DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
			NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
			TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
			RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN	
			NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN 
			NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 
where (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end) AND
			(@use_naknadno_potpisani is null or (not RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AND 
			(@use_nepotpisani is null or (RACUNI_ZAGLAVLJE.rz_fis_jir is null AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AND
			(@use_paragon is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end AND NOT RACUNI_ZAGLAVLJE.rz_fis_paragon_broj is null)) AND 
			(@use_kartice is null or (NACINI_PLACANJA.np_category_fk = 1)) AND 
			(@use_storno is null or (RACUNI_ZAGLAVLJE.rz_fis_storno_sign='S')) AND 
			(@use_sve_tvrtke is null or (NOT RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk IS NULL)) AND 
			(@pay_type_id is null or (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @pay_type_id)) AND 
			(@tvrtka_id is null or (RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = @tvrtka_id)) AND 
			(@djelatnik_id is null or (RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = @djelatnik_id)) AND 
			(@kasa_id is null or (RACUNI_ZAGLAVLJE.rz_kasa_id_fk = @kasa_id)) AND 
			(@narucitelj_id is null or (RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = @narucitelj_id)) AND
			(@rz_id_pk is null or (RACUNI_ZAGLAVLJE.rz_id_pk = @rz_id_pk)) AND
		    (@use_nap_nepotpisani is null or (RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0))
GO



--
-- Definition for stored procedure Osnovno_Delete_NACINI_PLACANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_NACINI_PLACANJA]
(
	@np_id_pk int
)
as
delete from NACINI_PLACANJA where np_id_pk = @np_id_pk
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODAJA_ARTIKLA_PO_DANIMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODAJA_ARTIKLA_PO_DANIMA]
(
	@ar_id_pk int,
	@day_start datetime,
	@day_end datetime
)
AS

BEGIN
select rz_dan, sum(KOLICINA) as KOLICINA, SUM(PDV) AS PDV, SUM(TOTAL) AS TOTAL, SUM(POV_NAK) AS POV_NAK 
		FROM (
SELECT     RACUNI_ZAGLAVLJE.rz_dan, 
	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , SUM(RACUNI_STAVKE.rs_tot_pov_naknada) AS POV_NAK, 
	CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
	SUM(RACUNI_STAVKE.rs_kolicina) AS KOLICINA
FROM       RACUNI_ZAGLAVLJE INNER JOIN
                      RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
					  ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
					  GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
                      NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
WHERE      (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_STAVKE.rs_artikal_id_fk = @ar_id_pk)
GROUP BY   RACUNI_ZAGLAVLJE.rz_dan,gpdv_postotak
) AS t GROUP BY rz_dan

SELECT   SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, SUM(RACUNI_STAVKE.rs_tot_pov_naknada) AS POV_NAK,
	CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
	SUM(RACUNI_STAVKE.rs_kolicina) AS KOLICINA
FROM       RACUNI_ZAGLAVLJE INNER JOIN
                      RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
					  ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
					  GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
                      NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
WHERE      (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_STAVKE.rs_artikal_id_fk = @ar_id_pk)
GROUP BY   gpdv_postotak

END
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODANI_ARTIKLI_PO_PDV_GRUPAMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODANI_ARTIKLI_PO_PDV_GRUPAMA]
(
	@day_start datetime,
	@day_end datetime
)
AS

BEGIN
	Select * from GRUPE_PDV
END

BEGIN
	SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_grupa_fk, GRUPE_ARTIKALA.ga_name, RACUNI_STAVKE.rs_cijena,
		RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_PDV.gpdv_id_pk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak,
		SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina, 
		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
		SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
		CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
		RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
        ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
        GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
        GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
        NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end)
	GROUP BY ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, RACUNI_STAVKE.rs_cijena, GRUPE_ARTIKALA.ga_name, gpdv_postotak, ARTIKLI.ar_grupa_fk,RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_PDV.gpdv_id_pk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	ORDER BY ARTIKLI.ar_sifra
END
BEGIN
	SELECT	GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk,
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK,
				CAST(((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada)) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) AS DECIMAL(12, 2)) AS PDV
	FROM	RACUNI_STAVKE  LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk=ARTIKLI.ar_id_pk  LEFT JOIN
                GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
                GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk RIGHT OUTER JOIN
                RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
                NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE     (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end)
	GROUP BY  GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
	order by  GRUPE_ARTIKALA.ga_name
END
BEGIN
	-- po svim porezima
	SELECT	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk,
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK,
				CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV
	FROM	RACUNI_ZAGLAVLJE inner JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end) AND (NOT (NACINI_PLACANJA.np_category_fk = 4))
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
END
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODANI_ARTIKLI_PO_GRUPI : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODANI_ARTIKLI_PO_GRUPI]
(
	@ar_grupa_fk int,
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
	SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_grupa_fk, RACUNI_STAVKE.rs_cijena, GRUPE_ARTIKALA.ga_name, 
			SUM(RACUNI_STAVKE.rs_iznos) AS Total, 
			SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina, 
			SUM(RACUNI_STAVKE.rs_tot_pov_naknada) AS PovNaknada, 
			SUM(RACUNI_STAVKE.rs_pdv) AS PDV
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND ARTIKLI.ar_grupa_fk = @ar_grupa_fk
	GROUP BY ARTIKLI.ar_grupa_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, RACUNI_STAVKE.rs_cijena, GRUPE_ARTIKALA.ga_name

	-- po svim porezima
	SELECT	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, 
			SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
			SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK,
			CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV
	FROM	RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
					ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
					GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end) AND ARTIKLI.ar_grupa_fk = @ar_grupa_fk
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
END
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODANI_ARTIKLI_PO_GRUPAMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODANI_ARTIKLI_PO_GRUPAMA]
(
	@day_start datetime,
	@day_end datetime
)
AS

BEGIN
	Select * from GRUPE_ARTIKALA
END

BEGIN
	SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_grupa_fk, GRUPE_ARTIKALA.ga_name, RACUNI_STAVKE.rs_cijena, 
		SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina, 
		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
		SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
		CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
		RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
        ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
        GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
        GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
        NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end)
	GROUP BY ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, RACUNI_STAVKE.rs_cijena, GRUPE_ARTIKALA.ga_name, gpdv_postotak, ARTIKLI.ar_grupa_fk
	ORDER BY ARTIKLI.ar_sifra
END

BEGIN
	SELECT	GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk,
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK,
				CAST(((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada)) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) AS DECIMAL(12, 2)) AS PDV
	FROM	RACUNI_STAVKE  LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk=ARTIKLI.ar_id_pk  LEFT JOIN
                GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
                GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk RIGHT OUTER JOIN
                RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
                NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE     (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end)
	GROUP BY  GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
	order by  GRUPE_ARTIKALA.ga_name
END

BEGIN
	-- po svim porezima
	SELECT	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk,
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK,
				CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV
	FROM	RACUNI_ZAGLAVLJE inner JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end) AND (NOT (NACINI_PLACANJA.np_category_fk = 4))
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
END
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODANI_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODANI_ARTIKLI]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
	SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_grupa_fk, RACUNI_STAVKE.rs_cijena, GRUPE_ARTIKALA.ga_name, 
			SUM(RACUNI_STAVKE.rs_iznos) AS Total, SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina, 
			SUM(RACUNI_STAVKE.rs_tot_pov_naknada) AS PovNaknada, SUM(RACUNI_STAVKE.rs_pdv) AS PDV
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end)
	GROUP BY ARTIKLI.ar_grupa_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, RACUNI_STAVKE.rs_cijena, GRUPE_ARTIKALA.ga_name

	-- po svim porezima
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
			SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK,
			CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
	FROM	RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
					GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk

END
GO

--
-- Definition for stored procedure Izvjesca_Get_KNJIGA_IZLAZNIH_RACUNA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_KNJIGA_IZLAZNIH_RACUNA]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN

	SELECT rz_dan, SUM(PDV) AS PDV, SUM(TOTAL) AS TOTAL, SUM(POV_NAK) AS POV_NAK FROM (

	SELECT RACUNI_ZAGLAVLJE.rz_dan, 
		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
		CAST((SUM(RACUNI_STAVKE.rs_iznos)- SUM(RACUNI_STAVKE.rs_tot_pov_naknada)) * CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV
	FROM dbo.RACUNI_ZAGLAVLJE left join
			   RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
			   ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
			   GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
		NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk 
	WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end) and not NACINI_PLACANJA.np_category_fk = 3
	GROUP BY RACUNI_ZAGLAVLJE.rz_dan,gpdv_postotak) AS t GROUP BY rz_dan

	SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, 
		RACUNI_ZAGLAVLJE.rz_dan, RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, RACUNI_ZAGLAVLJE.rz_placanje_id_fk, 
        RACUNI_ZAGLAVLJE.rz_iznos, RACUNI_ZAGLAVLJE.rz_pdv, RACUNI_ZAGLAVLJE.rz_popust, RACUNI_ZAGLAVLJE.rz_tot_pov_naknada, 
        RACUNI_ZAGLAVLJE.rz_iznos_bez_popusta, RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, 
        RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk, DJELATNICI.dj_name, 
        NACINI_PLACANJA.np_name, TVRTKE.tv_ime, NARUCITELJI.na_ime, NACINI_PLACANJA.np_category_fk, TVRTKE.tv_adresa, 
        TVRTKE.tv_mjesto, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, RACUNI_ZAGLAVLJE.rz_datum_dospijeca,  
        RACUNI_ZAGLAVLJE.rz_napomena
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk LEFT OUTER JOIN
            NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
			NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
            TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end) and NACINI_PLACANJA.np_category_fk = 3

	-- po svim porezima
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
	FROM	RACUNI_ZAGLAVLJE inner JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk

END
GO



--
-- Definition for stored procedure Osnovno_Update_NACINI_PLACANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NACINI_PLACANJA]
(
	@np_id_pk int,
	@np_name nvarchar(20),
	@np_category_fk int,
	@np_kar_provizija decimal(6, 2),
	@np_sort int,
	@np_index int,
	@np_active bit
)
as
update
	NACINI_PLACANJA
set
	np_name = @np_name,
	np_category_fk = @np_category_fk,
	np_kar_provizija = @np_kar_provizija,
	np_sort = @np_sort,
	np_index = @np_index,
	np_active = @np_active
where
	np_id_pk = @np_id_pk
GO


--
-- Definition for stored procedure Osnovno_Insert_NACINI_PLACANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_NACINI_PLACANJA]
(
	@RetVal int output,
	@np_name nvarchar(20),
	@np_category_fk int,
	@np_kar_provizija decimal(6, 2),
	@np_sort int,
	@np_index int,
	@np_active bit
)
as
insert into NACINI_PLACANJA
	(np_name, np_category_fk, np_kar_provizija, np_sort, np_index, np_active)
values
	(@np_name, @np_category_fk, @np_kar_provizija, @np_sort, @np_index, @np_active)
set @RetVal = scope_identity()
GO

--
-- Definition for stored procedure Izvjesca_Get_FINANCIJSKO_BY_DJELATNIK_ID : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_FINANCIJSKO_BY_DJELATNIK_ID]
(
	@RET_DNEVNI_POLOG AS DECIMAL (12,2) OUTPUT,
	@day datetime,
	@rz_djelatnik_id_fk int
)
AS
BEGIN
-- po nacinima placanja
SELECT np_id_pk, np_name, np_category_fk, sypl_name_long, SUM(TOTAL) AS TOTAL FROM (
		SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, np_category_fk, sypl_name_long,
			SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, SUM(RACUNI_ZAGLAVLJE.rz_pdv) AS PDV
		FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT JOIN
			SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day) AND (RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = @rz_djelatnik_id_fk)
		GROUP BY NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_id_pk,np_category_fk, sypl_name_long
) AS T GROUP BY np_id_pk,np_name, np_category_fk, sypl_name_long ORDER BY TOTAL DESC
-- po detaljnim nacinima placanja
SELECT np_id_pk, np_name, np_category_fk, sypl_name_long, SUM(TOTAL) AS TOTAL FROM (
	SELECT NP1.np_id_pk, NP1.np_name, np_category_fk, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL
	FROM RACUNI_ZAGLAVLJE inner  JOIN
			NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
			SYS_PLACANJA ON NP1.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
	WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day) AND (RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = @rz_djelatnik_id_fk)
	GROUP BY NP1.np_name, NP1.np_id_pk,np_category_fk, sypl_name_long
union all
	SELECT NP2.np_id_pk, NP2.np_name, np_category_fk, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL
	FROM RACUNI_ZAGLAVLJE inner  JOIN
			NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
			SYS_PLACANJA ON NP2.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
	WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day) AND (RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = @rz_djelatnik_id_fk)
	GROUP BY NP2.np_name, NP2.np_id_pk,np_category_fk, sypl_name_long
union all
	SELECT NP3.np_id_pk, NP3.np_name, np_category_fk, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL
	FROM RACUNI_ZAGLAVLJE inner  JOIN
			NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
			SYS_PLACANJA ON NP3.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
	WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day) AND (RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = @rz_djelatnik_id_fk)
	GROUP BY NP3.np_name, NP3.np_id_pk,np_category_fk, sypl_name_long
) AS T GROUP BY np_id_pk,np_name, np_category_fk, sypl_name_long ORDER BY TOTAL DESC
-- dnevni polog
SELECT @RET_DNEVNI_POLOG = dp_iznos FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @day
END
GO


--
-- Definition for stored procedure Izvjesca_Get_FINANCIJSKO : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_FINANCIJSKO]
(
	@use_po_djelatnicima bit,
	@use_po_kategorijama_artikala bit,
	@use_po_grupama_artikala bit,
	@use_po_kasama bit,
	@use_po_vrstama_placanja bit,
	@is_dnevni_izvjestaj bit,
	@RET_DNEVNI_POLOG AS DECIMAL (12,2) OUTPUT,
	@RET_GOTOVINA_BLAGAJNA AS DECIMAL (12,2) OUTPUT,
	@day_start datetime,
	@day_end datetime
)
AS
-------------------------------------------------------------------
---------------------------------- PO DJELATNICIMA
-------------------------------------------------------------------
if @use_po_djelatnicima = 1
BEGIN
	-- po djelatnicima
	SELECT dj_id_pk, dj_name, SUM(TOTAL)AS TOTAL FROM (
			SELECT SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, DJELATNICI.dj_id_pk, DJELATNICI.dj_name
			FROM RACUNI_ZAGLAVLJE INNER JOIN
				 NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk INNER JOIN
				 DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
			GROUP BY DJELATNICI.dj_id_pk, DJELATNICI.dj_name
	) AS T GROUP BY dj_id_pk, dj_name ORDER BY TOTAL DESC
	-- po djelatnicima i nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, dj_name, SUM(TOTAL) AS TOTAL, np_sort FROM (
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, dj_name,
					SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
				   NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk left join
				   DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk =DJELATNICI.dj_id_pk left join
				   SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, dj_name
	) AS T GROUP BY np_id_pk, np_name, sypl_name_long, dj_name, np_sort ORDER BY np_sort ASC
	-- po djelatnicima i detaljnim nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, dj_name, SUM(TOTAL) AS TOTAL, np_sort FROM (
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, dj_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NACINI_PLACANJA.np_id_pk left join
					DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, dj_name
		union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, dj_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NACINI_PLACANJA.np_id_pk left join
					DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, dj_name
		union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, dj_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NACINI_PLACANJA.np_id_pk left join
					DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, dj_name
	) AS T WHERE np_id_pk is not null 
	GROUP BY np_id_pk, sypl_name_long, np_name, np_sort, dj_name ORDER BY np_sort ASC
END
-------------------------------------------------------------------
---------------------------------- PO KATEGORIJAMA ARTIKALA
-------------------------------------------------------------------
if @use_po_kategorijama_artikala = 1
BEGIN
	--Po kategorijama
	SELECT KATEGORIJA_ARTIKALA,SUM(TOTAL) AS TOTAL FROM (
		SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL,CASE WHEN ARTIKLI.ar_kat_id_fk =1 THEN 'ROBA' ELSE 'USLUGA' END AS KATEGORIJA_ARTIKALA
		FROM	RACUNI_STAVKE  LEFT JOIN
					ARTIKLI ON  RACUNI_STAVKE.rs_artikal_id_fk =ARTIKLI.ar_id_pk LEFT JOIN
					RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
		WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
		GROUP BY	ARTIKLI.ar_kat_id_fk
	) AS T GROUP BY KATEGORIJA_ARTIKALA ORDER BY TOTAL DESC
	---- po svim porezima svake kategorije artikla
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
			SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
			CAST(((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada)) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) AS DECIMAL(12, 2)) AS PDV, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, ARTIKLI.ar_kat_id_fk, CASE WHEN ARTIKLI.ar_kat_id_fk =1 THEN 'ROBA' ELSE 'USLUGA' END AS KATEGORIJA_ARTIKALA
	FROM	RACUNI_STAVKE LEFT OUTER JOIN
					ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
					GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
					RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, 
					RACUNI_STAVKE.rs_gpdv_id_fk, ARTIKLI.ar_kat_id_fk
    ORDER BY GRUPE_PDV.gpdv_postotak
END
-------------------------------------------------------------------
---------------------------------- PO GRUPAMA ARTIKALA
-------------------------------------------------------------------
if @use_po_grupama_artikala = 1
BEGIN
	---- Po grupama artikala
	SELECT  GRUPA_ARTIKALA, SUM(TOTAL) AS TOTAL FROM (
			SELECT	GRUPE_ARTIKALA.ga_name as GRUPA_ARTIKALA, SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL
			FROM	RACUNI_STAVKE  LEFT JOIN
						ARTIKLI ON  RACUNI_STAVKE.rs_artikal_id_fk =ARTIKLI.ar_id_pk LEFT JOIN
						GRUPE_ARTIKALA ON  ARTIKLI.ar_grupa_fk =GRUPE_ARTIKALA.ga_id_pk LEFT JOIN
						RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
			WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
			GROUP BY GRUPE_ARTIKALA.ga_name
	)AS T GROUP BY GRUPA_ARTIKALA ORDER BY TOTAL DESC
	-- po svim porezima svake grupe posebno
	SELECT			SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
					SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
					CAST(((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada)) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) AS DECIMAL(12, 2)) AS PDV, 
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
	FROM		RACUNI_STAVKE  LEFT JOIN
					ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk=ARTIKLI.ar_id_pk  LEFT JOIN
					GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
					GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk RIGHT OUTER JOIN
					RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE		(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end) 
	GROUP BY	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
END
-------------------------------------------------------------------
---------------------------------- PO KASAMA
-------------------------------------------------------------------
if @use_po_kasama = 1
BEGIN
	-- po kasama
	select sum(TOTAL) AS TOTAL ,ks_name FROM(
			SELECT SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, KASE.ks_name
			FROM  RACUNI_ZAGLAVLJE INNER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT JOIN
					KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk
			WHERE	(RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY KASE.ks_name 
	) AS T GROUP BY ks_name ORDER BY ks_name ASC
	-- po svim porezima svake kase zasebno
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) AS POV_NAK,
				CAST(((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada)) * CASE WHEN gpdv_postotak IS NULL 
					THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) AS DECIMAL(12, 2)) AS PDV, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, KASE.ks_id_pk, KASE.ks_name, KASE.ks_description
	FROM	KASE INNER JOIN
				RACUNI_ZAGLAVLJE ON KASE.ks_id_pk = RACUNI_ZAGLAVLJE.rz_kasa_id_fk LEFT OUTER JOIN
				RACUNI_STAVKE LEFT OUTER JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk ON 
				RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, KASE.ks_id_pk, KASE.ks_name, KASE.ks_description
	ORDER BY KASE.ks_name DESC
	-- po kasama i nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, ks_name, SUM(TOTAL) AS TOTAL, np_sort FROM (
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name,
					SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
				   NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk left join
				   KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk =KASE.ks_id_pk left join
				   SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
	) AS T GROUP BY np_id_pk, np_name, sypl_name_long, ks_name, np_sort ORDER BY np_sort ASC
	-- po kasama i detaljnim nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, ks_name, SUM(TOTAL) AS TOTAL, np_sort FROM (
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NACINI_PLACANJA.np_id_pk left join
					KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk =KASE.ks_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
		union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NACINI_PLACANJA.np_id_pk left join
					KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk =KASE.ks_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
		union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NACINI_PLACANJA.np_id_pk left join
					KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk =KASE.ks_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
	) AS T WHERE np_id_pk is not null 
	GROUP BY np_id_pk, sypl_name_long, np_name, np_sort, ks_name ORDER BY np_sort ASC
END
-------------------------------------------------------------------
---------------------------------- PO VRSTAMA PLACANJA
-------------------------------------------------------------------
if @use_po_vrstama_placanja = 1
BEGIN
	-- po osnovnim nacinima placanja
	SELECT np_id_pk, np_name, np_category_fk, sypl_name_long, SUM(TOTAL) AS TOTAL, np_sort FROM (
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_sort, np_category_fk, sypl_name_long,
					SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL 
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT JOIN
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk 
			WHERE	(RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, np_category_fk, sypl_name_long
	) AS T GROUP BY np_id_pk,np_name, np_sort, np_category_fk, sypl_name_long ORDER BY np_sort ASC
	-- po detaljnim nacinima placanja
	SELECT np_id_pk, np_name, np_category_fk, sypl_name_long, SUM(TOTAL) AS TOTAL, np_sort, sypl_sort FROM (
			SELECT NP1.np_id_pk, NP1.np_name, NP1.np_sort, np_category_fk, sypl_sort, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE inner JOIN
					NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
					SYS_PLACANJA ON NP1.np_category_fk = SYS_PLACANJA.sypl_id_pk 
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NP1.np_name, NP1.np_id_pk, NP1.np_sort, np_category_fk, sypl_sort, sypl_name_long
		union all
			SELECT NP2.np_id_pk, NP2.np_name, NP2.np_sort, np_category_fk, sypl_sort, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL
 			FROM RACUNI_ZAGLAVLJE inner JOIN
					NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
					SYS_PLACANJA ON NP2.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
			GROUP BY NP2.np_name, NP2.np_id_pk, NP2.np_sort, np_category_fk, sypl_sort, sypl_name_long
		union all
			SELECT NP3.np_id_pk, NP3.np_name, NP3.np_sort, np_category_fk, sypl_sort, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL
			FROM RACUNI_ZAGLAVLJE inner JOIN
					NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
					SYS_PLACANJA ON NP3.np_category_fk = SYS_PLACANJA.sypl_id_pk 
			WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
			GROUP BY NP3.np_name, NP3.np_id_pk, NP3.np_sort, np_category_fk, sypl_sort, sypl_name_long
	) AS T GROUP BY np_id_pk, np_name, np_sort, np_category_fk, sypl_sort, sypl_name_long ORDER BY np_sort ASC
	-- po svim porezima svake vrste placanja
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
					SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK,
					CAST(((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada)) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) AS DECIMAL(12, 2)) AS PDV, 
					GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name
	FROM		RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					RACUNI_STAVKE LEFT OUTER JOIN
					ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
					GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk ON 
					RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE		(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name
END
-------------------------------------------------------------------
---------------------------------- PO SVIM POREZIMA
-------------------------------------------------------------------
BEGIN
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
	FROM	RACUNI_ZAGLAVLJE inner JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpdv_id_fk
END
-------------------------------------------------------------------
---------------------------------- UKUPAN BROJ, PRVI I ZADNJI RACUN
-------------------------------------------------------------------
BEGIN
SELECT	T.BrojRacuna, RACUNI_ZAGLAVLJE.rz_broj AS PocetniRacun, RACUNI_ZAGLAVLJE.rz_broj_full AS PocetniRacunFull, RZ2.rz_broj AS ZavrsniRacun, RZ2.rz_broj_full AS ZavrsniRacunFull FROM (
			SELECT	min(rz_broj) as PocetniRacun, max(rz_broj) as ZavrsniRacun, count(distinct rz_id_pk) AS BrojRacuna FROM 
			RACUNI_ZAGLAVLJE WHERE (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end) )as T LEFT JOIN 
				RACUNI_ZAGLAVLJE ON T.PocetniRacun = RACUNI_ZAGLAVLJE.rz_broj LEFT JOIN
				RACUNI_ZAGLAVLJE AS RZ2 ON T.ZavrsniRacun=RZ2.rz_broj
END
-------------------------------------------------------------------
---------------------------------- DNEVNI POLOG - STANJE GOTOVINE
-------------------------------------------------------------------
if @is_dnevni_izvjestaj = 1
BEGIN
	-- dnevni polog
	SELECT @RET_DNEVNI_POLOG=dp_iznos FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @day_start
	-- ukupna vrijednost samo gotovinskog placanja i koliko treba biti u kasi
	DECLARE @KASA_NP1 DECIMAL(12,2)
	DECLARE @KASA_NP2 DECIMAL(12,2)
	DECLARE @KASA_NP3 DECIMAL(12,2)
	-- prvi, drugi i treci nacin placanja u racunu
	SELECT @KASA_NP1 = SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) 
			FROM dbo.RACUNI_ZAGLAVLJE left join
						  NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day_start) and NACINI_PLACANJA.np_category_fk=2
	SELECT @KASA_NP2 = SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) 
			FROM dbo.RACUNI_ZAGLAVLJE left join
						  NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day_start) and NACINI_PLACANJA.np_category_fk=2
	SELECT @KASA_NP3 = SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) 
			FROM dbo.RACUNI_ZAGLAVLJE left join
						  NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day_start) and NACINI_PLACANJA.np_category_fk=2
	-- zbroji sva 3 placanja i polog u STANJE U BLAGAJNI
	if @KASA_NP1 is null
		set @KASA_NP1 = 0
	if @KASA_NP2 is null
		set @KASA_NP2 = 0
	if @KASA_NP3 is null
		set @KASA_NP3 = 0
	if @RET_DNEVNI_POLOG is null
		set @RET_DNEVNI_POLOG = 0
	set @RET_GOTOVINA_BLAGAJNA = @KASA_NP1 + @KASA_NP2 + @KASA_NP3 + @RET_DNEVNI_POLOG
END
GO



--
-- Definition for stored procedure Izvjesca_Get_FINANCIJSKO_NAPOJNICE : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_FINANCIJSKO_NAPOJNICE]
(
	@is_period_dnevni bit = null,
	@is_period_vrijeme bit = null,
	@is_period_nadnevak bit = null,
	@day_start datetime,
	@day_end datetime,
	@use_shift bit = null,
	@shift_min_start int = null,
	@shift_min_end int = null
)
AS
	SELECT np_id_pk, np_name, np_sort, SUM(TOTAL) AS TOTAL,
	       sypl_id_pk, sypl_name_short, sypl_name_long, sypl_sort, rz_djelatnik_id_fk, dj_name FROM (
				SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_sort, 
				       SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_short, SYS_PLACANJA.sypl_name_long, SYS_PLACANJA.sypl_sort,  
				       RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, dj_name, 
						SUM(RACUNI_ZAGLAVLJE.rz_fis_nap_iznos) AS TOTAL
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NACINI_PLACANJA.np_id_pk left join
						DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk =DJELATNICI.dj_id_pk left join
						SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
				WHERE   (NOT RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0) AND 
						(@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
						(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))

				GROUP BY NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, dj_name,
				RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_short, SYS_PLACANJA.sypl_name_long, SYS_PLACANJA.sypl_sort
	) AS T GROUP BY np_id_pk, np_name, sypl_name_long, dj_name, np_sort, rz_djelatnik_id_fk, sypl_id_pk, sypl_name_short, sypl_sort ORDER BY np_sort ASC
GO



--
-- Definition for stored procedure Osnovno_Get_NACINI_PLACANJA : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NACINI_PLACANJA]
(
	@np_active bit = NULL
)
AS
SELECT NACINI_PLACANJA.*, 
	   SYS_PLACANJA.sypl_name_long, SYS_PLACANJA.sypl_name_short
FROM   NACINI_PLACANJA LEFT JOIN
       SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
WHERE
 	   (@np_active is null or (NACINI_PLACANJA.np_active = @np_active))
ORDER BY np_sort
GO

--
-- Definition for stored procedure Management_Get_PONUDA_BY_ID : 
--
GO
CREATE procedure [dbo].[Management_Get_PONUDA_BY_ID]
(
	@pnz_id_pk int
)
AS
BEGIN
	SELECT PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_dj_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_na_id_fk,
			PONUDA_ZAGLAVLJE.pnz_napomena, PONUDA_ZAGLAVLJE.pnz_status, 
			DJELATNICI.dj_name, DJELATNICI.dj_oib, DJELATNICI.dj_sifra, DJELATNICI.dj_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_oib, 
			NARUCITELJI.na_ime,
			sum(PONUDA_STAVKE.pns_pdv) as count_pdv, 
			sum(PONUDA_STAVKE.pns_tot_pov_nak) as count_pov_nak, 
			sum(PONUDA_STAVKE.pns_iznos) as count_ukupno  
	FROM PONUDA_ZAGLAVLJE LEFT OUTER JOIN
			PONUDA_STAVKE ON PONUDA_ZAGLAVLJE.pnz_id_pk = PONUDA_STAVKE.pns_ponuda_id_fk LEFT OUTER JOIN
			TVRTKE ON PONUDA_ZAGLAVLJE.pnz_tv_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
			NARUCITELJI ON PONUDA_ZAGLAVLJE.pnz_na_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
			DJELATNICI ON PONUDA_ZAGLAVLJE.pnz_dj_id_fk = DJELATNICI.dj_id_pk
	WHERE (@pnz_id_pk is null or (PONUDA_ZAGLAVLJE.pnz_id_pk = @pnz_id_pk))
	GROUP BY  PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_na_id_fk, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_dj_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_napomena, PONUDA_ZAGLAVLJE.pnz_status, 
			DJELATNICI.dj_name, DJELATNICI.dj_oib, DJELATNICI.dj_sifra, DJELATNICI.dj_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, NARUCITELJI.na_ime


	SELECT PONUDA_STAVKE.*, 
		ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj,
		GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM PONUDA_STAVKE LEFT OUTER JOIN
			ARTIKLI ON PONUDA_STAVKE.pns_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			GRUPE_PDV ON PONUDA_STAVKE.pns_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk
	WHERE (PONUDA_STAVKE.pns_ponuda_id_fk = @pnz_id_pk)
END
GO




--
-- Definition for stored procedure Pregledi_Get_RACUN_BY_ID : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUN_BY_ID]
(
	@rz_id_pk int
)
AS
BEGIN

SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, 
			RACUNI_ZAGLAVLJE.rz_placanje_id_fk, RACUNI_ZAGLAVLJE.rz_pl_1_id_fk, RACUNI_ZAGLAVLJE.rz_pl_2_id_fk, RACUNI_ZAGLAVLJE.rz_pl_3_id_fk, NACINI_PLACANJA.np_category_fk, 
			RACUNI_ZAGLAVLJE.rz_kasa_id_fk, RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk, RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk, RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk, 
			RACUNI_ZAGLAVLJE.rz_iznos_bez_popusta, RACUNI_ZAGLAVLJE.rz_popust, RACUNI_ZAGLAVLJE.rz_pdv, RACUNI_ZAGLAVLJE.rz_iznos,
			RACUNI_ZAGLAVLJE.rz_datum_dospijeca, RACUNI_ZAGLAVLJE.rz_nadnevak_isporuke, 
			RACUNI_ZAGLAVLJE.rz_napomena, RACUNI_ZAGLAVLJE.rz_tot_pov_naknada, 
			RACUNI_ZAGLAVLJE.rz_fis_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_vrijeme_obrade, 
			RACUNI_ZAGLAVLJE.rz_fis_uuid, RACUNI_ZAGLAVLJE.rz_fis_zastitni_kod, RACUNI_ZAGLAVLJE.rz_fis_jir, RACUNI_ZAGLAVLJE.rz_fis_paragon_broj, 
			RACUNI_ZAGLAVLJE.rz_fis_ozn_pos_pros, RACUNI_ZAGLAVLJE.rz_fis_ozn_nap_uredaja, 
			RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava, CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
			RACUNI_ZAGLAVLJE.rz_fis_storno_sign, RACUNI_ZAGLAVLJE.rz_fis_racun_source_id, RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full, RACUNI_ZAGLAVLJE.rz_fis_np, 
			NACINI_PLACANJA.np_name, KASE.ks_name, 
			NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska,
			DJELATNICI.dj_name, DJELATNICI.dj_oznaka, DJELATNICI.dj_oib, DJELATNICI.dj_status, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_state, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj, TVRTKE.tv_sifra,
			NP1.np_name AS NP_NAZIV_1,RACUNI_ZAGLAVLJE.rz_pl_1_iznos, NP2.np_name AS NP_NAZIV_2,RACUNI_ZAGLAVLJE.rz_pl_2_iznos, NP3.np_name AS NP_NAZIV_3,RACUNI_ZAGLAVLJE.rz_pl_3_iznos,
			RACUNI_ZAGLAVLJE.rz_fis_nap_uuid, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_slanja, RACUNI_ZAGLAVLJE.rz_fis_nap_iznos, 
			RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk, RACUNI_ZAGLAVLJE.rz_fis_nap_np, RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano,
			RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava, RACUNI_ZAGLAVLJE.rz_fis_nap_vrijeme_obrade, 
			NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA	 
FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
			DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
			NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
			TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
			RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN	
			NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN 
			NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk	
where (@rz_id_pk is null or (RACUNI_ZAGLAVLJE.rz_id_pk = @rz_id_pk))

SELECT     RACUNI_STAVKE.*, ARTIKLI.ar_sifra, ARTIKLI.ar_kpd_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_description, ARTIKLI.ar_jmj, ARTIKLI.ar_barcode, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
FROM         RACUNI_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk
	where
		rs_racun_id_fk = @rz_id_pk
END
GO



--
-- Definition for stored procedure Izvjesca_Get_REKAPITULACIJA_POREZA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_REKAPITULACIJA_POREZA]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
	SELECT		
				SUM(RACUNI_STAVKE.rs_iznos_bez_popusta) AS TOTAL_BEZ_POPUSTA, 
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				SUM(RACUNI_STAVKE.rs_tot_pov_naknada) as POV_NAK, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) - SUM(RACUNI_STAVKE.rs_tot_pov_naknada))* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END)AS DECIMAL(12,2)) AS PDV, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM	RACUNI_ZAGLAVLJE inner JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
END
GO


--
-- Definition for stored procedure xxx_Custom_AGROLAGUNA_Pregledi_Get_RACUNI_STAVKE_PO_GRUPI_ARTIKALA : 
--
GO
CREATE procedure [dbo].[xxx_Custom_AGROLAGUNA_Pregledi_Get_RACUNI_STAVKE_PO_GRUPI_ARTIKALA]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@grupa_artikala_id int = null
)
AS
BEGIN
	SELECT RACUNI_ZAGLAVLJE.*, RACUNI_STAVKE.*, ARTIKLI.*,NACINI_PLACANJA.np_name, KASE.ks_name, DJELATNICI.dj_name
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
						GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
						ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						DJELATNICI ON RACUNI_ZAGLAVLJE.rz_djelatnik_id_fk = DJELATNICI.dj_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
 	 		(@grupa_artikala_id is null or (ARTIKLI.ar_grupa_fk = @grupa_artikala_id))
END
GO




--
-- Definition for stored procedure xxx_Custom_M2PAY_Get_Transakcije : 
--
GO
CREATE procedure [dbo].[xxx_Custom_M2PAY_Get_Transakcije]
(
	@m2pay_id_pk int = null,
	@m2pay_rz_id_fk int = null,
	@m2pay_vrijeme_start datetime,
	@m2pay_vrijeme_end datetime,
	@m2pay_Var_PRINT_STATUS nvarchar(20) = null,
	@m2pay_Var_PRINT_Transaction_Type nvarchar(20) = null
)
AS
SELECT x_cust_KART_PLACANJE_M2PAY.*, RACUNI_ZAGLAVLJE.*
FROM x_cust_KART_PLACANJE_M2PAY LEFT OUTER JOIN
						RACUNI_ZAGLAVLJE ON x_cust_KART_PLACANJE_M2PAY.m2pay_rz_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk 
where (x_cust_KART_PLACANJE_M2PAY.m2pay_vrijeme between @m2pay_vrijeme_start and @m2pay_vrijeme_end) AND
		(@m2pay_id_pk is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_id_pk = @m2pay_id_pk)) AND 
		(@m2pay_rz_id_fk is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_rz_id_fk = @m2pay_rz_id_fk)) AND
		(@m2pay_Var_PRINT_STATUS is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_Var_PRINT_STATUS = @m2pay_Var_PRINT_STATUS)) AND
		(@m2pay_Var_PRINT_Transaction_Type is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_Var_PRINT_Transaction_Type = @m2pay_Var_PRINT_Transaction_Type))
GO



--
-- Definition for stored procedure xxx_Custom_KARTICE_M2PAY_Insert_Transakcija : 
--
GO
CREATE procedure [dbo].[xxx_Custom_KARTICE_M2PAY_Insert_Transakcija]
(
    @m2pay_rz_id_fk int,
    @m2pay_vrijeme datetime,
    @m2pay_Var_transactionResultId nvarchar(30),
    @m2pay_Var_RESULT_transactionID nvarchar(40),
    @m2pay_Var_RESULT_FinStatus nvarchar(20),
    @m2pay_Var_PRINT_merchantName nvarchar(50),
    @m2pay_Var_PRINT_merchantAddress nvarchar(50),
    @m2pay_Var_PRINT_Time datetime,
    @m2pay_Var_PRINT_STATUS nvarchar(20),
    @m2pay_Var_PRINT_Transaction_Type nvarchar(20),
    @m2pay_Var_PRINT_Iznos decimal(10, 2),
    @m2pay_Var_PRINT_Tip decimal(10, 2),
    @m2pay_Var_PRINT_Ukupno decimal(10, 2),
    @m2pay_Var_PRINT_ID_Terminala nvarchar(20),
    @m2pay_Var_PRINT_ID_Trgovca nvarchar(20),
    @m2pay_Var_PRINT_ID_KARTICA_Name nvarchar(20),
    @m2pay_Var_PRINT_ID_KARTICA_ID nvarchar(20),
    @m2pay_Var_PRINT_Nacin_Unosa nvarchar(20),
    @m2pay_Var_PRINT_Provjere nvarchar(20),
    @m2pay_Var_PRINT_Vrsta_Kartice nvarchar(20),
    @m2pay_Var_PRINT_Broj_Odobrenja nvarchar(20),
    @m2pay_Var_PRINT_GUID nvarchar(50),
    @m2pay_Var_PRINT_GUID_STORNO_PRODAJE nvarchar(50),
    @m2pay_Var_PRINT_RRN nvarchar(20),
    @m2pay_Var_PRINT_AID nvarchar(20),
    @m2pay_Var_PRINT_TVR nvarchar(20),
    @m2pay_Var_PRINT_IAD nvarchar(50),
    @m2pay_Var_PRINT_TSI nvarchar(20),
    @m2pay_Var_PRINT_ARC nvarchar(20)
)
as
insert into x_cust_KART_PLACANJE_M2PAY
	(m2pay_rz_id_fk, m2pay_vrijeme, m2pay_Var_transactionResultId,
	m2pay_Var_RESULT_transactionID, m2pay_Var_RESULT_FinStatus,  
	m2pay_Var_PRINT_merchantName, m2pay_Var_PRINT_merchantAddress, 
	m2pay_Var_PRINT_Time, m2pay_Var_PRINT_STATUS, m2pay_Var_PRINT_Transaction_Type, 
	m2pay_Var_PRINT_Iznos, m2pay_Var_PRINT_Tip, m2pay_Var_PRINT_Ukupno, 
	m2pay_Var_PRINT_ID_Terminala, m2pay_Var_PRINT_ID_Trgovca, 
	m2pay_Var_PRINT_ID_KARTICA_Name, m2pay_Var_PRINT_ID_KARTICA_ID, 
	m2pay_Var_PRINT_Nacin_Unosa, m2pay_Var_PRINT_Provjere,
	m2pay_Var_PRINT_Vrsta_Kartice, m2pay_Var_PRINT_Broj_Odobrenja,
	m2pay_Var_PRINT_GUID, m2pay_Var_PRINT_GUID_STORNO_PRODAJE,  
	m2pay_Var_PRINT_RRN, m2pay_Var_PRINT_AID, m2pay_Var_PRINT_TVR, 
	m2pay_Var_PRINT_IAD, m2pay_Var_PRINT_TSI, m2pay_Var_PRINT_ARC)
values
	(@m2pay_rz_id_fk, @m2pay_vrijeme, @m2pay_Var_transactionResultId,
	@m2pay_Var_RESULT_transactionID, @m2pay_Var_RESULT_FinStatus,  
	@m2pay_Var_PRINT_merchantName, @m2pay_Var_PRINT_merchantAddress, 
	@m2pay_Var_PRINT_Time, @m2pay_Var_PRINT_STATUS, @m2pay_Var_PRINT_Transaction_Type, 
	@m2pay_Var_PRINT_Iznos, @m2pay_Var_PRINT_Tip, @m2pay_Var_PRINT_Ukupno, 
	@m2pay_Var_PRINT_ID_Terminala, @m2pay_Var_PRINT_ID_Trgovca, 
	@m2pay_Var_PRINT_ID_KARTICA_Name, @m2pay_Var_PRINT_ID_KARTICA_ID, 
	@m2pay_Var_PRINT_Nacin_Unosa, @m2pay_Var_PRINT_Provjere,
	@m2pay_Var_PRINT_Vrsta_Kartice, @m2pay_Var_PRINT_Broj_Odobrenja,
	@m2pay_Var_PRINT_GUID, @m2pay_Var_PRINT_GUID_STORNO_PRODAJE,  
	@m2pay_Var_PRINT_RRN, @m2pay_Var_PRINT_AID, @m2pay_Var_PRINT_TVR, 
	@m2pay_Var_PRINT_IAD, @m2pay_Var_PRINT_TSI, @m2pay_Var_PRINT_ARC)
select scope_identity()
GO



--
-- Definition for stored procedure Djelatnik_Init_ALL_WORKING_TABLES : 
--
GO
CREATE PROCEDURE [dbo].[Djelatnik_Init_ALL_WORKING_TABLES]
AS
exec Osnovno_Get_ARTIKLI @ar_is_active_DA = 1
exec Osnovno_Get_DJELATNICI @active_only = 1
exec Osnovno_Get_NACINI_PLACANJA @np_active = 1
exec Servis_Get_ADMINISTRATORS
exec Osnovno_Get_GRUPE_TOUCH_SCREEN_ARTIKLI @ar_is_active = 1
exec System_Get_SYS_PLACANJA
GO

