--
-- Definition for stored procedure System_TEST_DATABASE : 
--
GO
CREATE PROCEDURE [dbo].[System_TEST_DATABASE]
(
	@RetIznos int output
)
AS
	set @RetIznos = 1
GO

--
-- Definition for stored procedure System_Update_SYS_VERSION : 
--
GO
CREATE procedure [dbo].[System_Update_SYS_VERSION]
(
	@syvs_nr_1 int,
	@syvs_nr_2 int,
	@syvs_nr_3 int
)
as
update
	SYS_VERSION
set
	syvs_nr_1 = @syvs_nr_1,
	syvs_nr_2 = @syvs_nr_2,
	syvs_nr_3 = @syvs_nr_3
GO

--
-- Definition for stored procedure System_Get_SYS_VERSION : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_VERSION]
AS
Select * from SYS_VERSION
GO

--
-- Definition for stored procedure System_Get_SYS_JMJ : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_JMJ]
AS
Select * from SYS_JMJ
GO

--
-- Definition for stored procedure System_Get_PRINTERI : 
--
GO
CREATE procedure [dbo].[System_Get_PRINTERI]
AS
Select * from SYS_PRINTERI
GO


--
-- Definition for stored procedure System_Get_SYS_PLACANJA : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_PLACANJA]
AS
Select * from SYS_PLACANJA
GO


--
-- Definition for stored procedure System_DATABASE_REINDEX : 
--
GO
CREATE PROCEDURE [dbo].[System_DATABASE_REINDEX]
		AS
		DECLARE @TableName varchar(255)
		DECLARE TableCursor CURSOR FOR
		SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_TYPE = 'base table'
		OPEN TableCursor
		FETCH NEXT FROM TableCursor INTO @TableName
		WHILE @@FETCH_STATUS = 0
		BEGIN
		PRINT 'Reindexing ' + @TableName
		DBCC DBREINDEX(@TableName,' ',90)
		FETCH NEXT FROM TableCursor INTO @TableName
		END
		CLOSE TableCursor
		DEALLOCATE TableCursor
GO

--
-- Definition for stored procedure Skladiste_Update_INVENTURA_ALL : 
--
GO
create procedure [dbo].[Skladiste_Update_INVENTURA_ALL]
(
	@in_id_pk int,
	@in_broj int,
	@in_nadnevak Datetime,
	@in_napomena nvarchar(70),
	@in_knjizenje bit,
	@in_proknjizeno bit,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_INVENTURA_STAVKE READONLY
    --------------------------------
)
as

begin tran

	update
		INVENTURA_ZAGLAVLJE
	set
		in_broj = @in_broj,
		in_nadnevak = @in_nadnevak,
		in_napomena = @in_napomena,
		in_knjizenje = @in_knjizenje,
		in_proknjizeno = @in_proknjizeno
	where
		in_id_pk = @in_id_pk

	delete INVENTURA_STAVKE where ins_in_id_fk = @in_id_pk

	------------ STAVKE ----------
	INSERT INTO INVENTURA_STAVKE 
		(ins_in_id_fk, ins_sir_id_fk, 
		ins_sir_stanje_zateceno, ins_sir_stanje_kasa,
		ins_sir_stanje_razlika, ins_sir_prosj_nab_cijena, 
		ins_fin_stanje_zateceno, ins_fin_stanje_kasa, 
		ins_fin_stanje_razlika, ins_pov_nak_razlika)
	SELECT 
		@in_id_pk, ins_sir_id_fk, 
		ins_sir_stanje_zateceno, ins_sir_stanje_kasa,
		ins_sir_stanje_razlika, ins_sir_prosj_nab_cijena, 
		ins_fin_stanje_zateceno, ins_fin_stanje_kasa, 
		ins_fin_stanje_razlika, ins_pov_nak_razlika
	FROM @Stavke_DTable

commit
GO


--
-- Definition for stored procedure Skladiste_Insert_INVENTURA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_INVENTURA_ALL]
(
	@RetVal_ID int output,
	@in_broj int,
	@in_nadnevak Datetime,
	@in_napomena nvarchar(70),
	@in_knjizenje bit,
	@in_proknjizeno bit,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_INVENTURA_STAVKE READONLY
    --------------------------------
)
as

begin tran

	insert into INVENTURA_ZAGLAVLJE
		(in_nadnevak, in_broj, in_napomena, in_knjizenje, in_proknjizeno)
	values
		(@in_nadnevak, @in_broj, @in_napomena, @in_knjizenje, @in_proknjizeno)
	SET @RetVal_ID=@@IDENTITY

	------------ STAVKE ----------
	INSERT INTO INVENTURA_STAVKE 
		(ins_in_id_fk, ins_sir_id_fk, 
		ins_sir_stanje_zateceno, ins_sir_stanje_kasa,
		ins_sir_stanje_razlika, ins_sir_prosj_nab_cijena, 
		ins_fin_stanje_zateceno, ins_fin_stanje_kasa, 
		ins_fin_stanje_razlika, ins_pov_nak_razlika)
	SELECT 
		@RetVal_ID, ins_sir_id_fk, 
		ins_sir_stanje_zateceno, ins_sir_stanje_kasa,
		ins_sir_stanje_razlika, ins_sir_prosj_nab_cijena, 
		ins_fin_stanje_zateceno, ins_fin_stanje_kasa, 
		ins_fin_stanje_razlika, ins_pov_nak_razlika
	FROM @Stavke_DTable

commit
GO

--
-- Definition for stored procedure Skladiste_Get_INVENTURE_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_INVENTURE_LIST]
AS
SELECT     in_id_pk, in_broj, in_nadnevak, in_knjizenje, CASE WHEN in_knjizenje =0 THEN 'NE' ELSE 'DA' END AS in_knjizenje_str, in_napomena
FROM         INVENTURA_ZAGLAVLJE
where INVENTURA_ZAGLAVLJE.in_proknjizeno=1  
GO

--
-- Definition for stored procedure Skladiste_Delete_INVENTURA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_INVENTURA_ALL]
(
	@in_id_pk int
)
as
delete INVENTURA_STAVKE where ins_in_id_fk = @in_id_pk
delete INVENTURA_ZAGLAVLJE where in_id_pk = @in_id_pk
GO

--
-- Definition for stored procedure Servis_Update_EXTERNAL_DATABASE : 
--
GO
CREATE procedure [dbo].[Servis_Update_EXTERNAL_DATABASE]
(
	@ext_id_pk int,
	@ext_name nvarchar(50), 
	@ext_description nvarchar(100), 
	@ext_db_host nvarchar(50), 
	@ext_db_name nvarchar(20), 
	@ext_db_user nvarchar(20), 
	@ext_db_password nvarchar(20),
	@ext_index int
)
as
update
	EXTERNAL_DATABASES
set
	ext_name = @ext_name, 
	ext_description = @ext_description, 
	ext_db_host = @ext_db_host, 
	ext_db_name = @ext_db_name, 
	ext_db_user = @ext_db_user, 
	ext_db_password = @ext_db_password,
	ext_index = @ext_index
where
	ext_id_pk = @ext_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_EXTERNAL_DATABASE : 
--
GO
CREATE procedure [dbo].[Servis_Insert_EXTERNAL_DATABASE]
(
	@ext_name nvarchar(50), 
	@ext_description nvarchar(100), 
	@ext_db_host nvarchar(50), 
	@ext_db_name nvarchar(20), 
	@ext_db_user nvarchar(20), 
	@ext_db_password nvarchar(20),
	@ext_index int

)
as
insert into EXTERNAL_DATABASES
	(ext_name, ext_description, ext_db_host, ext_db_name, ext_db_user, ext_db_password, ext_index)
values
	(@ext_name, @ext_description, @ext_db_host, @ext_db_name, @ext_db_user, @ext_db_password, @ext_index)
select scope_identity()
GO

--
-- Definition for stored procedure Servis_Get_EXTERNAL_DATABASES : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_EXTERNAL_DATABASES]
AS
Select * from EXTERNAL_DATABASES
GO

--
-- Definition for stored procedure Servis_Delete_EXTERNAL_DATABASE : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_EXTERNAL_DATABASE]
(
	@ext_id_pk int
)
AS
delete EXTERNAL_DATABASES where ext_id_pk = @ext_id_pk
GO

--
-- Definition for stored procedure Servis_Update_ADMINISTRATOR : 
--
GO
CREATE procedure [dbo].[Servis_Update_ADMINISTRATOR]
(
	@adm_id_pk int,
	@adm_name nvarchar(50),
	@adm_password int,
	@adm_rf_id nvarchar(25)
)
as
update
	ADMINISTRATORS
set
	adm_name = @adm_name,
	adm_password = @adm_password,
	adm_rf_id = @adm_rf_id
where
	adm_id_pk = @adm_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_ADMINISTRATOR : 
--
GO
CREATE procedure [dbo].[Servis_Insert_ADMINISTRATOR]
(
	@adm_name nvarchar(50),
	@adm_password int,
	@adm_rf_id nvarchar(25)
)
as
insert into ADMINISTRATORS
	(adm_name, adm_password, adm_rf_id)
values
	(@adm_name, @adm_password, @adm_rf_id)
select scope_identity()
GO

--
-- Definition for stored procedure Servis_Get_ADMINISTRATORS : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_ADMINISTRATORS]
AS
Select * from ADMINISTRATORS
GO

--
-- Definition for stored procedure Servis_Delete_ADMINISTRATOR : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_ADMINISTRATOR]
(
	@adm_id_pk int
)
AS
delete ADMINISTRATORS where adm_id_pk = @adm_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_ACTIVITY_LOG : 
--
GO
CREATE procedure [dbo].[Servis_Insert_ACTIVITY_LOG]
(
	@ac_time datetime,
	@ac_korisnik nvarchar(50),
	@ac_action nvarchar(50),	
    @ac_description nvarchar(100)
)
as
insert into ACTIVITY_LOG
	(ac_time, ac_korisnik, ac_action, ac_description)
values
	(@ac_time, @ac_korisnik, @ac_action, @ac_description)
select scope_identity()
GO

--
-- Definition for stored procedure Servis_Get_ACTIVITY_LOG : 
--
GO
CREATE procedure [dbo].[Servis_Get_ACTIVITY_LOG]
(
	@date_start DateTime,
	@date_end DateTime
)
AS
BEGIN
	SELECT * FROM ACTIVITY_LOG 
	WHERE ACTIVITY_LOG.ac_time between @date_start and @date_end
END
GO

--
-- Definition for stored procedure Servis_Delete_ACTIVITY_LOG_PERIOD : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_ACTIVITY_LOG_PERIOD]
(
	@day_start datetime,
	@day_end datetime
)
AS
delete ACTIVITY_LOG where ACTIVITY_LOG.ac_time BETWEEN @day_start AND @day_end
GO

--
-- Definition for stored procedure Servis_Delete_ACTIVITY_LOG : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_ACTIVITY_LOG]
(
@ac_id_pk int
)
AS
delete ACTIVITY_LOG where ac_id_pk = @ac_id_pk
GO

--
-- Definition for stored procedure Skladiste_Update_OTPIS_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_OTPIS_ALL]
(
	@ot_id_pk int,
	@ot_broj int,
	@ot_datum Datetime,
	@ot_opis nvarchar(50),
	@ot_napomena nvarchar(50),
	@ot_dopusteni bit,
	@ot_proknjizeno bit,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_OTPISI_STAVKE READONLY
    --------------------------------
)
as

begin tran
	update
		OTPISI_ZAGLAVLJE
	set
		ot_broj= @ot_broj,
		ot_datum = @ot_datum,
		ot_opis = @ot_opis,
		ot_napomena = @ot_napomena,
		ot_proknjizeno = @ot_proknjizeno,
		ot_dopusteni = @ot_dopusteni
	where
		ot_id_pk = @ot_id_pk

	delete OTPISI_STAVKE where os_ot_id_fk = @ot_id_pk

	------------ STAVKE ----------
	INSERT INTO OTPISI_STAVKE 
		(os_ot_id_fk, os_si_id_fk, 
		os_pdv_id_fk, os_si_cijena,
		os_si_kolicina, os_tot_osnovica, 
		os_tot_pdv, os_tot_ukupno, 
		os_tot_pov_nak)
	SELECT 
		@ot_id_pk, os_si_id_fk, 
		os_pdv_id_fk, os_si_cijena,
		os_si_kolicina, os_tot_osnovica, 
		os_tot_pdv, os_tot_ukupno, 
		os_tot_pov_nak
	FROM @Stavke_DTable

commit
GO




--
-- Definition for stored procedure Skladiste_Insert_OTPIS_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_OTPIS_ALL]
(
	@RetVal_ID int output,
	@ot_broj int,
	@ot_datum Datetime,
	@ot_opis nvarchar(50),
	@ot_napomena nvarchar(50),
	@ot_proknjizeno bit,
	@ot_dopusteni bit,
	@ot_time_created Datetime,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_OTPISI_STAVKE READONLY
    --------------------------------
)
as

begin tran

	insert into OTPISI_ZAGLAVLJE
		(ot_broj, ot_datum, ot_opis, ot_napomena, ot_proknjizeno, ot_dopusteni, ot_time_created)
	values
		(@ot_broj, @ot_datum, @ot_opis, @ot_napomena, @ot_proknjizeno, @ot_dopusteni, @ot_time_created)
	SET @RetVal_ID=@@IDENTITY


	------------ STAVKE ----------
	INSERT INTO OTPISI_STAVKE 
		(os_ot_id_fk, os_si_id_fk, 
		os_pdv_id_fk, os_si_cijena,
		os_si_kolicina, os_tot_osnovica, 
		os_tot_pdv, os_tot_ukupno, 
		os_tot_pov_nak)
	SELECT 
		@RetVal_ID, os_si_id_fk, 
		os_pdv_id_fk, os_si_cijena,
		os_si_kolicina, os_tot_osnovica, 
		os_tot_pdv, os_tot_ukupno, 
		os_tot_pov_nak
	FROM @Stavke_DTable

commit
GO




--
-- Definition for stored procedure Skladiste_Get_OTPISI_LIST_NEPROKNJIZENI : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_OTPISI_LIST_NEPROKNJIZENI]
AS
SELECT * FROM OTPISI_ZAGLAVLJE where OTPISI_ZAGLAVLJE.ot_proknjizeno = 0
GO

--
-- Definition for stored procedure Skladiste_Get_OTPISI_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_OTPISI_LIST]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
	SELECT OTPISI_ZAGLAVLJE.ot_id_pk, OTPISI_ZAGLAVLJE.ot_broj, OTPISI_ZAGLAVLJE.ot_datum, OTPISI_ZAGLAVLJE.ot_opis, 
			OTPISI_ZAGLAVLJE.ot_napomena, OTPISI_ZAGLAVLJE.ot_proknjizeno, OTPISI_ZAGLAVLJE.ot_time_created, sum(OTPISI_STAVKE.os_tot_osnovica) as count_osnovica, 
			sum(OTPISI_STAVKE.os_tot_pdv) as count_pdv, sum(OTPISI_STAVKE.os_tot_ukupno) as count_ukupno, sum(OTPISI_STAVKE.os_tot_pov_nak) as count_pov_nak
FROM OTPISI_ZAGLAVLJE INNER JOIN
			OTPISI_STAVKE ON OTPISI_ZAGLAVLJE.ot_id_pk = OTPISI_STAVKE.os_ot_id_fk
	where OTPISI_ZAGLAVLJE.ot_proknjizeno=1  and (OTPISI_ZAGLAVLJE.ot_datum BETWEEN @day_start AND @day_end)
	GROUP BY OTPISI_ZAGLAVLJE.ot_id_pk, OTPISI_ZAGLAVLJE.ot_broj, OTPISI_ZAGLAVLJE.ot_datum, OTPISI_ZAGLAVLJE.ot_opis, 
			OTPISI_ZAGLAVLJE.ot_napomena, OTPISI_ZAGLAVLJE.ot_time_created,OTPISI_ZAGLAVLJE.ot_proknjizeno
END
GO

--
-- Definition for stored procedure Skladiste_Delete_OTPIS_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_OTPIS_ALL]
(
	@ot_id_pk int
)
as
delete OTPISI_stavke where os_ot_id_fk = @ot_id_pk
delete OTPISI_ZAGLAVLJE where ot_id_pk = @ot_id_pk
GO

--
-- Definition for stored procedure Skladiste_Update_IZDATNICA_ALL : 
--
GO
create procedure [dbo].[Skladiste_Update_IZDATNICA_ALL]
(
	@iz_id_pk int,
	@iz_broj int,
	@iz_datum Datetime,
	@iz_mo_id_fk int,
	@iz_opis nvarchar(50),
	@iz_napomena nvarchar(50),
	@iz_proknjizeno bit,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_IZDATNICE_STAVKE READONLY
    --------------------------------
)
as
begin tran
	update
		IZDATNICE_ZAGLAVLJE
	set
		iz_broj = @iz_broj,
		iz_datum = @iz_datum,
		iz_mo_id_fk = @iz_mo_id_fk,
		iz_opis = @iz_opis,
		iz_napomena = @iz_napomena,
		iz_proknjizeno = @iz_proknjizeno
	where
		iz_id_pk = @iz_id_pk

	delete IZDATNICE_STAVKE where is_iz_id_fk = @iz_id_pk

	------------ STAVKE ----------
	INSERT INTO IZDATNICE_STAVKE 
		(is_iz_id_fk, is_si_id_fk, 
		is_pdv_id_fk, is_cijena,
		is_kolicina, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, 
		is_tot_pov_nak)
	SELECT 
		@iz_id_pk, is_si_id_fk, 
		is_pdv_id_fk, is_cijena,
		is_kolicina, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, 
		is_tot_pov_nak
	FROM @Stavke_DTable

commit
GO






--
-- Definition for stored procedure Skladiste_Insert_IZDATNICA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_IZDATNICA_ALL]
(
	@RetVal_ID int output,
	@iz_broj int,
	@iz_mo_id_fk int,
	@iz_datum Datetime,
	@iz_opis nvarchar(50),
	@iz_napomena nvarchar(50),
	@iz_proknjizeno bit,
	@iz_time_created Datetime,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_IZDATNICE_STAVKE READONLY
    --------------------------------
)
as
begin tran

	insert into IZDATNICE_ZAGLAVLJE
		(iz_broj, iz_datum, iz_mo_id_fk, iz_opis, iz_napomena, iz_proknjizeno, iz_time_created)
	values
		(@iz_broj, @iz_datum, @iz_mo_id_fk, @iz_opis, @iz_napomena, @iz_proknjizeno, @iz_time_created)
	SET @RetVal_ID=@@IDENTITY

	------------ STAVKE ----------
	INSERT INTO IZDATNICE_STAVKE 
		(is_iz_id_fk, is_si_id_fk, 
		is_pdv_id_fk, is_cijena,
		is_kolicina, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, 
		is_tot_pov_nak)
	SELECT 
		@RetVal_ID, is_si_id_fk, 
		is_pdv_id_fk, is_cijena,
		is_kolicina, is_tot_osnovica, 
		is_tot_pdv, is_tot_ukupno, 
		is_tot_pov_nak
	FROM @Stavke_DTable

commit
GO






--
-- Definition for stored procedure Skladiste_Delete_IZDATNICA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_IZDATNICA_ALL]
(
	@iz_id_pk int
)
as
delete IZDATNICE_STAVKE where is_iz_id_fk = @iz_id_pk
delete IZDATNICE_ZAGLAVLJE where iz_id_pk = @iz_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_MJESTA_OTPREME]
(
	@mo_id_pk Int
)
AS
SELECT * FROM IZDATNICE_ZAGLAVLJE WHERE iz_mo_id_fk = @mo_id_pk
GO

--
-- Definition for stored procedure Skladiste_Update_PRIMKA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_PRIMKA_ALL]
(
	@pr_id_pk int,
	@pr_sys_broj int,
	@pr_broj nvarchar(25),
	@pr_dobavljac_id_fk int,
	@pr_datum Datetime,
	@pr_datum_knjizenja Datetime,
	@pr_datum_dospijeca Datetime,
	@pr_osnovica decimal (12, 2),
	@pr_PDV decimal (12, 2),
	@pr_ukupno decimal (12, 2),
	@pr_povratna_naknada decimal (12, 2),
	@pr_napomena nvarchar(50),
	@pr_proknjizeno bit,
	@pr_status bit,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_PRIMKE_STAVKE READONLY
    --------------------------------
)
as

begin tran

	update
		PRIMKE_ZAGLAVLJE
	set
		pr_broj = @pr_broj,
		pr_sys_broj = @pr_sys_broj,
		pr_dobavljac_id_fk = @pr_dobavljac_id_fk,
		pr_datum = @pr_datum,
		pr_datum_knjizenja = @pr_datum_knjizenja,
		pr_datum_dospijeca = @pr_datum_dospijeca,
		pr_osnovica =@pr_osnovica, 
		pr_PDV = @pr_PDV,
		pr_ukupno = @pr_ukupno,
		pr_povratna_naknada = @pr_povratna_naknada,
		pr_napomena = @pr_napomena,
		pr_proknjizeno = @pr_proknjizeno,
		pr_status = @pr_status
	where
		pr_id_pk = @pr_id_pk


	delete PRIMKE_STAVKE where ps_pr_id_fk = @pr_id_pk

	------------ STAVKE ----------
	INSERT INTO PRIMKE_STAVKE 
		(ps_pr_id_fk, ps_si_id_fk, 
		ps_si_nabavljena_kolicina, ps_si_cijena_osnovna_netto,
		ps_rabat_postotak, ps_pdv_id_fk, 
		ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_si_povratna_naknada,
		ps_tot_povratna_naknada)
	SELECT 
		@pr_id_pk, ps_si_id_fk, 
		ps_si_nabavljena_kolicina, ps_si_cijena_osnovna_netto,
		ps_rabat_postotak, ps_pdv_id_fk, 
		ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_si_povratna_naknada,
		ps_tot_povratna_naknada
	FROM @Stavke_DTable

commit
GO




--
-- Definition for stored procedure Skladiste_Set_ZAMJENA_SIROVINE_SKLAD_DOKUMENTI : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_ZAMJENA_SIROVINE_SKLAD_DOKUMENTI]
(
	@sirovina_id_old int = null,
	@sirovina_id_new int = null,
	@use_primke bit = null,
	@use_izdatnice bit = null,
	@use_otpisi bit = null,
	@use_inventure bit = null
)
AS
if @use_primke IS NOT NULL
BEGIN  
	UPDATE PRIMKE_STAVKE SET ps_si_id_fk = @sirovina_id_new WHERE ps_si_id_fk = @sirovina_id_old	 
END

if @use_izdatnice IS NOT NULL
BEGIN  
	UPDATE IZDATNICE_STAVKE SET is_si_id_fk = @sirovina_id_new WHERE is_si_id_fk = @sirovina_id_old	 
END
if @use_otpisi IS NOT NULL
BEGIN  
	 UPDATE OTPISI_STAVKE SET os_si_id_fk = @sirovina_id_new WHERE os_si_id_fk = @sirovina_id_old
END
if @use_inventure IS NOT NULL
BEGIN  
	UPDATE INVENTURA_STAVKE SET ins_sir_id_fk = @sirovina_id_new WHERE ins_sir_id_fk = @sirovina_id_old	 
END
GO




--
-- Definition for stored procedure Skladiste_Set_PRIMKA_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_PRIMKA_WRITE_MODE]
(
	@RetVal int output,
	@pr_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT pr_id_pk, pr_proknjizeno FROM PRIMKE_ZAGLAVLJE WHERE pr_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE PRIMKE_ZAGLAVLJE SET pr_proknjizeno=0 WHERE pr_id_pk=@pr_id_pk
	END
END
GO

--
-- Definition for stored procedure Skladiste_Insert_PRIMKA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_PRIMKA_ALL]
(
	@RetVal_ID int output,
	@pr_sys_broj int,
	@pr_broj nvarchar(25),
	@pr_dobavljac_id_fk int,
	@pr_datum Datetime,
	@pr_datum_knjizenja Datetime,
	@pr_datum_dospijeca Datetime,
	@pr_osnovica decimal (12, 2),
	@pr_PDV decimal (12, 2),
	@pr_ukupno decimal (12, 2),
	@pr_povratna_naknada decimal (12, 2),
	@pr_napomena nvarchar(50),
	@pr_proknjizeno bit,
	@pr_time_created Datetime,
	@pr_status bit,
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_PRIMKE_STAVKE READONLY
    --------------------------------
)
as

begin tran

	insert into PRIMKE_ZAGLAVLJE
		(pr_sys_broj, pr_broj, pr_dobavljac_id_fk, pr_datum, pr_datum_knjizenja, pr_datum_dospijeca, pr_osnovica, pr_PDV, pr_ukupno, pr_povratna_naknada, pr_napomena, pr_proknjizeno, pr_time_created, pr_status)
	values
		(@pr_sys_broj, @pr_broj, @pr_dobavljac_id_fk, @pr_datum, @pr_datum_knjizenja, @pr_datum_dospijeca, @pr_osnovica, @pr_PDV, @pr_ukupno, @pr_povratna_naknada, @pr_napomena, @pr_proknjizeno,@pr_time_created, @pr_status)
	SET @RetVal_ID=@@IDENTITY

		------------ STAVKE ----------
	INSERT INTO PRIMKE_STAVKE 
		(ps_pr_id_fk, ps_si_id_fk, 
		ps_si_nabavljena_kolicina, ps_si_cijena_osnovna_netto,
		ps_rabat_postotak, ps_pdv_id_fk, 
		ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_si_povratna_naknada,
		ps_tot_povratna_naknada)
	SELECT 
		@RetVal_ID, ps_si_id_fk, 
		ps_si_nabavljena_kolicina, ps_si_cijena_osnovna_netto,
		ps_rabat_postotak, ps_pdv_id_fk, 
		ps_tot_osnovica, ps_tot_pdv, 
		ps_tot_ukupno, ps_si_povratna_naknada,
		ps_tot_povratna_naknada
	FROM @Stavke_DTable

commit
GO




--
-- Definition for stored procedure Skladiste_Delete_PRIMKA_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_PRIMKA_ALL]
(
	@pr_id_pk int
)
as
delete PRIMKE_STAVKE where ps_pr_id_fk = @pr_id_pk
delete PRIMKE_ZAGLAVLJE where pr_id_pk = @pr_id_pk
GO






--
-- Definition for stored procedure Skladiste_Insert_PRIMKA_EXTERNAL_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Insert_PRIMKA_EXTERNAL_ALL]
(
	@RetVal_ID int output,
	@pez_source nvarchar(20),
	@pez_dob_naziv nvarchar(50),
	@pez_dob_adresa nvarchar(50),
	@pez_dob_mjesto nvarchar(50),
	@pez_dob_oib nvarchar(20),
	@pez_dob_iban nvarchar(20),
	@pez_broj nvarchar(30),
	@pez_datum datetime,
	@pez_datum_dospijeca datetime,
	@pez_datum_knjizenja datetime,
	@pez_datum_isporuke datetime,
	@pez_uk_VPC decimal(12, 2),
	@pez_uk_PDV decimal(12, 2),
	@pez_uk_POV_NAK decimal(12, 2),
	@pez_uk_MPC decimal(12, 2),
	@pez_note_1 nvarchar(50),
	@pez_note_2 nvarchar(50),
	@pez_note_3 nvarchar(50),
	@pez_note_4 nvarchar(50),
	@pez_status nvarchar(50),
	@pez_napomena nvarchar(50),
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_PRIMKE_EXTERNAL_STAVKE READONLY
    --------------------------------
)
as
begin tran
	insert into PRIMKE_EXTERNAL_ZAGLAVLJE
		(pez_source, pez_dob_naziv, pez_dob_adresa, pez_dob_mjesto, pez_dob_oib, pez_dob_iban,
		pez_broj,
		pez_datum, pez_datum_dospijeca, pez_datum_knjizenja, pez_datum_isporuke,
		pez_uk_VPC, pez_uk_PDV, pez_uk_POV_NAK, pez_uk_MPC,
		pez_note_1, pez_note_2, pez_note_3, pez_note_4,
		pez_status, pez_napomena)
	values
		(@pez_source, @pez_dob_naziv, @pez_dob_adresa, @pez_dob_mjesto, @pez_dob_oib, @pez_dob_iban,
		@pez_broj,
		@pez_datum, @pez_datum_dospijeca, @pez_datum_knjizenja, @pez_datum_isporuke,
		@pez_uk_VPC, @pez_uk_PDV, @pez_uk_POV_NAK, @pez_uk_MPC,
		@pez_note_1, @pez_note_2, @pez_note_3, @pez_note_4,
		@pez_status, @pez_napomena)

	SET @RetVal_ID=@@IDENTITY

		------------ STAVKE ----------
	INSERT INTO PRIMKE_EXTERNAL_STAVKE 
		(pes_pez_id_fk,
		pes_si_sifra, pes_si_barcode, pes_si_naziv, pes_si_jmj,
		pes_si_cijena_vpc, pes_si_pov_nak,
		pes_kolicina,
		pes_rabat_postotak, pes_porez_postotak,
		pes_uk_VPC, pes_uk_PDV, pes_uk_POV_NAK, pes_uk_MPC)
	SELECT 
		@RetVal_ID,
		pes_si_sifra, pes_si_barcode, pes_si_naziv, pes_si_jmj,
		pes_si_cijena_vpc, pes_si_pov_nak,
		pes_kolicina,
		pes_rabat_postotak, pes_porez_postotak,
		pes_uk_VPC, pes_uk_PDV, pes_uk_POV_NAK, pes_uk_MPC
	FROM @Stavke_DTable
commit
GO





--
-- Definition for stored procedure Skladiste_Update_PRIMKA_EXTERNAL_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Update_PRIMKA_EXTERNAL_ALL]
(
	@pez_id_pk int,
	@pez_source nvarchar(20),
	@pez_dob_naziv nvarchar(50),
	@pez_dob_adresa nvarchar(50),
	@pez_dob_mjesto nvarchar(50),
	@pez_dob_oib nvarchar(20),
	@pez_dob_iban nvarchar(20),
	@pez_broj nvarchar(30),
	@pez_datum datetime,
	@pez_datum_dospijeca datetime,
	@pez_datum_knjizenja datetime,
	@pez_datum_isporuke datetime,
	@pez_uk_VPC decimal(12, 2),
	@pez_uk_PDV decimal(12, 2),
	@pez_uk_POV_NAK decimal(12, 2),
	@pez_uk_MPC decimal(12, 2),
	@pez_note_1 nvarchar(50),
	@pez_note_2 nvarchar(50),
	@pez_note_3 nvarchar(50),
	@pez_note_4 nvarchar(50),
	@pez_status nvarchar(50),
	@pez_napomena nvarchar(50),
	--------------------------------
   	@Stavke_DTable BPOStype_DTable_PRIMKE_EXTERNAL_STAVKE READONLY
    --------------------------------
)
as
begin tran
	update
		PRIMKE_EXTERNAL_ZAGLAVLJE
	set
		pez_source = @pez_source,
		pez_dob_naziv = @pez_dob_naziv,
		pez_dob_adresa = @pez_dob_adresa,
		pez_dob_mjesto = @pez_dob_mjesto,
		pez_dob_oib = @pez_dob_oib,
		pez_dob_iban = @pez_dob_iban,
		pez_broj = @pez_broj,
		pez_datum = @pez_datum,
		pez_datum_dospijeca = @pez_datum_dospijeca,
		pez_datum_knjizenja = @pez_datum_knjizenja,
		pez_datum_isporuke = @pez_datum_isporuke,
		pez_uk_VPC = @pez_uk_VPC,
		pez_uk_PDV = @pez_uk_PDV,
		pez_uk_POV_NAK = @pez_uk_POV_NAK,
		pez_uk_MPC = @pez_uk_MPC,
		pez_note_1 = @pez_note_1,
		pez_note_2 = @pez_note_2,
		pez_note_3 = @pez_note_3,
		pez_note_4 = @pez_note_4,
		pez_status = @pez_status,
		pez_napomena = @pez_napomena
	where
		pez_id_pk = @pez_id_pk

	delete PRIMKE_EXTERNAL_STAVKE where pes_pez_id_fk = @pez_id_pk

	------------ STAVKE ----------
	INSERT INTO PRIMKE_EXTERNAL_STAVKE 
		(pes_pez_id_fk,
		pes_si_sifra, pes_si_barcode, pes_si_naziv, pes_si_jmj,
		pes_si_cijena_vpc, pes_si_pov_nak,
		pes_kolicina,
		pes_rabat_postotak, pes_porez_postotak,
		pes_uk_VPC, pes_uk_PDV, pes_uk_POV_NAK, pes_uk_MPC)
	SELECT 
		@pez_id_pk,
		pes_si_sifra, pes_si_barcode, pes_si_naziv, pes_si_jmj,
		pes_si_cijena_vpc, pes_si_pov_nak,
		pes_kolicina,
		pes_rabat_postotak, pes_porez_postotak,
		pes_uk_VPC, pes_uk_PDV, pes_uk_POV_NAK, pes_uk_MPC
	FROM @Stavke_DTable
commit
GO




--
-- Definition for stored procedure Skladiste_Delete_PRIMKA_EXTERNAL_ALL : 
--
GO
CREATE procedure [dbo].[Skladiste_Delete_PRIMKA_EXTERNAL_ALL]
(
	@pez_id_pk int
)
as
delete PRIMKE_EXTERNAL_STAVKE where pes_pez_id_fk = @pez_id_pk
delete PRIMKE_EXTERNAL_ZAGLAVLJE where pez_id_pk = @pez_id_pk
GO




--
-- Definition for stored procedure Skladiste_Get_PRIMKE_EXTERNAL_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_PRIMKE_EXTERNAL_LIST]
(
	@pez_id_pk int = null,
	@pez_datum_start datetime= null,
	@pez_datum_end datetime= null,
	@pez_source nvarchar(20)= null,
	@pez_dob_oib nvarchar(20)= null,
	@pez_dob_naziv nvarchar(50)= null,
	@pez_broj nvarchar(30)= null,
	@pez_status nvarchar(20)= null
)
AS
BEGIN
SELECT PRIMKE_EXTERNAL_ZAGLAVLJE.* 
FROM	PRIMKE_EXTERNAL_ZAGLAVLJE 
WHERE
		(@pez_datum_start is null or (PRIMKE_EXTERNAL_ZAGLAVLJE.pez_datum BETWEEN @pez_datum_start AND @pez_datum_end)) AND 
		(@pez_id_pk is null or (PRIMKE_EXTERNAL_ZAGLAVLJE.pez_id_pk = @pez_id_pk)) AND
		(@pez_source is null or (PRIMKE_EXTERNAL_ZAGLAVLJE.pez_source = @pez_source)) AND
		(@pez_dob_oib is null or (PRIMKE_EXTERNAL_ZAGLAVLJE.pez_dob_oib = @pez_dob_oib)) AND
		(@pez_dob_naziv is null or (PRIMKE_EXTERNAL_ZAGLAVLJE.pez_dob_naziv = @pez_dob_naziv)) AND
		(@pez_broj is null or (PRIMKE_EXTERNAL_ZAGLAVLJE.pez_broj = @pez_broj)) AND
		(@pez_status is null or (PRIMKE_EXTERNAL_ZAGLAVLJE.pez_status = @pez_status))
END
GO



--
-- Definition for stored procedure Skladiste_Get_PRIMKA_EXTERNAL_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_PRIMKA_EXTERNAL_BY_ID]
(
	@pez_id_pk int
)
AS
BEGIN
	SELECT PRIMKE_EXTERNAL_ZAGLAVLJE.* 
	FROM	PRIMKE_EXTERNAL_ZAGLAVLJE
			where pez_id_pk = @pez_id_pk
END
BEGIN
	SELECT PRIMKE_EXTERNAL_STAVKE.* 
	FROM	PRIMKE_EXTERNAL_STAVKE
			where pes_pez_id_fk = @pez_id_pk
END
GO





--
-- Definition for stored procedure Osnovno_DeleteInfo_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_DOBAVLJACI]
(
	@do_id_pk Int
)
AS
SELECT * FROM PRIMKE_ZAGLAVLJE WHERE pr_dobavljac_id_fk = @do_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_SMJENA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_SMJENA]
(
	@sm_id_pk int,
	@sm_name nvarchar(50),
	@sm_start datetime,
	@sm_end datetime
)
as
update SMJENE
set
	sm_name = @sm_name,
	sm_start = @sm_start,
	sm_end = @sm_end
where
	sm_id_pk = @sm_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_SMJENA : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_SMJENA]
(
	@sm_name nvarchar(50),
	@sm_start datetime,
	@sm_end datetime
)
as
insert into SMJENE
	( sm_name, sm_start, sm_end)
values
	( @sm_name, @sm_start, @sm_end)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_SMJENE : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_SMJENE]
AS
Select * from SMJENE
GO

--
-- Definition for stored procedure Osnovno_Delete_SMJENA : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_SMJENA]
(
	@sm_id_pk int
)
as
delete SMJENE where sm_id_pk = @sm_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_NARUDZBE_SLIJEDOVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NARUDZBE_SLIJEDOVI]
(
	@ns_id_pk int,
	@ns_naziv_long nvarchar(30),
	@ns_naziv_short nvarchar(1)
)
as
update
	NARUDZBE_SLIJEDOVI
set
	ns_naziv_long = @ns_naziv_long,
	ns_naziv_short = @ns_naziv_short
where
	ns_id_pk = @ns_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_NARUDZBE_PRIORITY : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NARUDZBE_PRIORITY]
(
	@ns_id_pk int,
	@ns_priority int
)
as
update
	NARUDZBE_SLIJEDOVI
set
	ns_priority = @ns_priority
where
	ns_id_pk = @ns_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_NARUDZBE_SLIJEDOVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_NARUDZBE_SLIJEDOVI]
(
	@RetVal_ID int output,
	@RetVal_PRIORITY int output,
	@ns_naziv_long nvarchar(30),
	@ns_naziv_short nvarchar(1)
)
as
select @RetVal_PRIORITY=max(ns_priority) from dbo.NARUDZBE_SLIJEDOVI
if  @RetVal_PRIORITY IS null
	set @RetVal_PRIORITY=1
else
	set @RetVal_PRIORITY=@RetVal_PRIORITY+1

insert into NARUDZBE_SLIJEDOVI
	(ns_naziv_long, ns_naziv_short, ns_priority)
values
	(@ns_naziv_long, @ns_naziv_short, @RetVal_PRIORITY)
SET @RetVal_ID=@@IDENTITY
GO

--
-- Definition for stored procedure Osnovno_Get_NARUDZBE_SLIJEDOVI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NARUDZBE_SLIJEDOVI]
AS
Select * from NARUDZBE_SLIJEDOVI order by NARUDZBE_SLIJEDOVI.ns_priority
GO

--
-- Definition for stored procedure Osnovno_Delete_NARUDZBE_SLIJEDOVI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_NARUDZBE_SLIJEDOVI]
(
@ns_id_pk int
)
AS
delete NARUDZBE_SLIJEDOVI where ns_id_pk = @ns_id_pk
GO

--
-- Definition for stored procedure Skladiste_Get_IZDATNICE_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_IZDATNICE_LIST]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
	SELECT IZDATNICE_ZAGLAVLJE.iz_id_pk, IZDATNICE_ZAGLAVLJE.iz_broj, IZDATNICE_ZAGLAVLJE.iz_mo_id_fk, IZDATNICE_ZAGLAVLJE.iz_datum, MJESTA_OTPREME.mo_oznaka,
				IZDATNICE_ZAGLAVLJE.iz_opis, IZDATNICE_ZAGLAVLJE.iz_napomena, IZDATNICE_ZAGLAVLJE.iz_proknjizeno, IZDATNICE_ZAGLAVLJE.iz_time_created, 
				sum(IZDATNICE_STAVKE.is_tot_osnovica) as count_osnovica, sum(IZDATNICE_STAVKE.is_tot_pdv) as count_pdv, 
				sum(IZDATNICE_STAVKE.is_tot_ukupno) as count_ukupno, sum(IZDATNICE_STAVKE.is_tot_pov_nak) as count_pov_nak
FROM IZDATNICE_ZAGLAVLJE LEFT OUTER JOIN
                IZDATNICE_STAVKE ON IZDATNICE_ZAGLAVLJE.iz_id_pk = IZDATNICE_STAVKE.is_iz_id_fk LEFT OUTER JOIN
				MJESTA_OTPREME ON IZDATNICE_ZAGLAVLJE.iz_mo_id_fk = MJESTA_OTPREME.mo_id_pk
	where IZDATNICE_ZAGLAVLJE.iz_proknjizeno=1 and (IZDATNICE_ZAGLAVLJE.iz_datum BETWEEN @day_start AND @day_end)  
	group by IZDATNICE_ZAGLAVLJE.iz_id_pk, IZDATNICE_ZAGLAVLJE.iz_broj, IZDATNICE_ZAGLAVLJE.iz_mo_id_fk, IZDATNICE_ZAGLAVLJE.iz_datum, 
				IZDATNICE_ZAGLAVLJE.iz_opis, IZDATNICE_ZAGLAVLJE.iz_napomena, IZDATNICE_ZAGLAVLJE.iz_proknjizeno, MJESTA_OTPREME.mo_oznaka, 
                IZDATNICE_ZAGLAVLJE.iz_time_created
END
GO

--
-- Definition for stored procedure Osnovno_Update_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_MJESTA_OTPREME]
(
	@mo_id_pk int,
	@mo_oznaka nvarchar(20),
	@mo_note nvarchar(20)
)
as
update
	MJESTA_OTPREME
set
	mo_oznaka = @mo_oznaka,
	mo_note = @mo_note
where
	mo_id_pk = @mo_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_MJESTA_OTPREME]
(
	@mo_oznaka nvarchar(20),
	@mo_note nvarchar(20)
)
as
insert into MJESTA_OTPREME
	(mo_oznaka, mo_note)
values
	(@mo_oznaka, @mo_note)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_MJESTA_OTPREME : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_MJESTA_OTPREME]
AS
Select * from MJESTA_OTPREME
GO

--
-- Definition for stored procedure Osnovno_Delete_MJESTA_OTPREME : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_MJESTA_OTPREME]
(
	@mo_id_pk int
)
as
delete MJESTA_OTPREME where mo_id_pk = @mo_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_NARUDZBE_NAPOMENE_ARTIKLI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Insert_NARUDZBE_NAPOMENE_ARTIKLI]
(
	@ar_id_fk int,
	@nr_id_fk int
)
as
insert into NARUDZBE_NAPOMENE_ARTIKLI
	(ar_id_fk, nr_id_fk)
values
	( @ar_id_fk, @nr_id_fk)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_NARUDZBE_NAPOMENE : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_NARUDZBE_NAPOMENE]
(
	@nr_id_pk Int
)
AS
SELECT * FROM NARUDZBE_NAPOMENE_ARTIKLI WHERE nr_id_fk = @nr_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_NARUDZBE_NAPOMENE_ARTIKLI_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_NARUDZBE_NAPOMENE_ARTIKLI_ALL]
(
@ar_id_fk int
)
AS
delete NARUDZBE_NAPOMENE_ARTIKLI 
where ar_id_fk = @ar_id_fk
GO

--
-- Definition for stored procedure Osnovno_Delete_NARUDZBE_NAPOMENE_ARTIKLI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_NARUDZBE_NAPOMENE_ARTIKLI]
(
@ar_id_fk int,
@nr_id_fk int
)
AS
delete NARUDZBE_NAPOMENE_ARTIKLI 
where ar_id_fk = @ar_id_fk and nr_id_fk = @nr_id_fk
GO

--
-- Definition for stored procedure Osnovno_Update_NARUDZBE_NAPOMENE : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NARUDZBE_NAPOMENE]
(
	@nr_id_pk int,
	@nr_napomena nvarchar(30)
)
as
update
	NARUDZBE_NAPOMENE
set
	nr_napomena = @nr_napomena
where
	nr_id_pk = @nr_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_NARUDZBE_NAPOMENE : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_NARUDZBE_NAPOMENE]
(
	@nr_napomena nvarchar(30)
)
as
insert into NARUDZBE_NAPOMENE
	( nr_napomena)
values
	( @nr_napomena)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_NARUDZBE_NAPOMENE_BY_ARTIKAL_ID : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NARUDZBE_NAPOMENE_BY_ARTIKAL_ID]
(
	@ar_id_fk int 
)
as
Select NARUDZBE_NAPOMENE_ARTIKLI.nr_id_fk, NARUDZBE_NAPOMENE.nr_napomena
from NARUDZBE_NAPOMENE_ARTIKLI LEFT OUTER JOIN
		NARUDZBE_NAPOMENE ON NARUDZBE_NAPOMENE.nr_id_pk = NARUDZBE_NAPOMENE_ARTIKLI.nr_id_fk
where
ar_id_fk = @ar_id_fk
GO




--
-- Definition for stored procedure Osnovno_Get_NARUDZBE_NAPOMENE_FULL : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NARUDZBE_NAPOMENE_FULL]
AS
Select	NARUDZBE_NAPOMENE.nr_id_pk, NARUDZBE_NAPOMENE.nr_napomena, COUNT(NARUDZBE_NAPOMENE_ARTIKLI.nr_id_fk) AS 'BrArt'
FROM    NARUDZBE_NAPOMENE LEFT OUTER JOIN
		NARUDZBE_NAPOMENE_ARTIKLI ON NARUDZBE_NAPOMENE.nr_id_pk = NARUDZBE_NAPOMENE_ARTIKLI.nr_id_fk
GROUP BY NARUDZBE_NAPOMENE.nr_id_pk, NARUDZBE_NAPOMENE.nr_napomena

SELECT		ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_cijena, SYS_ARTIKLI_KATEGORIJE.syak_name, COUNT(NARUDZBE_NAPOMENE_ARTIKLI.ar_id_fk) AS 'BrNap'
FROM		ARTIKLI LEFT OUTER JOIN
                SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT OUTER JOIN
				NARUDZBE_NAPOMENE_ARTIKLI ON ARTIKLI.ar_id_pk = NARUDZBE_NAPOMENE_ARTIKLI.ar_id_fk
GROUP BY	ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_cijena, SYS_ARTIKLI_KATEGORIJE.syak_name

SELECT     NARUDZBE_NAPOMENE.nr_napomena, ARTIKLI.ar_sifra
FROM       NARUDZBE_NAPOMENE_ARTIKLI INNER JOIN
			ARTIKLI ON NARUDZBE_NAPOMENE_ARTIKLI.ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
            NARUDZBE_NAPOMENE ON NARUDZBE_NAPOMENE.nr_id_pk = NARUDZBE_NAPOMENE_ARTIKLI.nr_id_fk
GO



--
-- Definition for stored procedure Osnovno_Delete_NARUDZBE_NAPOMENE : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_NARUDZBE_NAPOMENE]
(
@nr_id_pk int
)
AS

delete from NARUDZBE_NAPOMENE_ARTIKLI where nr_id_fk = @nr_id_pk
delete from NARUDZBE_NAPOMENE where nr_id_pk = @nr_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_TOUCH_SCREEN_ARTIKAL : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_TOUCH_SCREEN_ARTIKAL]
(
	@gt_id_fk int,
	@ar_id_fk int,
	@gt_ar_order int
)
as
insert into GRUPE_TOUCH_SCREEN_ARTIKLI
	(gt_id_fk, ar_id_fk, gt_ar_order)
values
	(@gt_id_fk, @ar_id_fk, @gt_ar_order)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_TOUCH_SCREEN_GRUPE : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_TOUCH_SCREEN_GRUPE]
(
	@gt_id_pk Int
)
AS
SELECT * FROM GRUPE_TOUCH_SCREEN_ARTIKLI WHERE gt_id_fk = @gt_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN_BY_ARTIKAL_ID : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN_BY_ARTIKAL_ID]
(
	@ar_id_fk int
)
AS
delete GRUPE_TOUCH_SCREEN_ARTIKLI where ar_id_fk = @ar_id_fk
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL_ALL]
(
	@gt_id_fk int
)
AS
delete GRUPE_TOUCH_SCREEN_ARTIKLI where gt_id_fk = @gt_id_fk
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN_ARTIKAL]
(
	@gt_id_fk int,
	@ar_id_fk int
)
AS
delete GRUPE_TOUCH_SCREEN_ARTIKLI where gt_id_fk = @gt_id_fk and ar_id_fk = @ar_id_fk
GO

--
-- Definition for stored procedure Osnovno_Update_GRUPE_TOUCH_SCREEN : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_TOUCH_SCREEN]
(
	@gt_id_pk int,
	@gt_name nvarchar(30),
	@gt_active bit,
	@gt_order_index int,
	@gt_color_index int
)
as
update
	GRUPE_TOUCH_SCREEN
set
	gt_name = @gt_name,
	gt_active = @gt_active,
	gt_order_index = @gt_order_index,
	gt_color_index = @gt_color_index
where
	gt_id_pk = @gt_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_TOUCH_SCREEN : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_TOUCH_SCREEN]
(
	@gt_name nvarchar(30),
	@gt_active bit,
	@gt_order_index int,
	@gt_color_index int
)
as
insert into GRUPE_TOUCH_SCREEN
	(gt_name, gt_active, gt_order_index, gt_color_index)
values
	(@gt_name, @gt_active, @gt_order_index, @gt_color_index)
select scope_identity()
GO



--
-- Definition for stored procedure Osnovno_Get_GRUPE_TOUCH_SCREEN_ARTIKLI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_TOUCH_SCREEN_ARTIKLI]
(
	@Sifra_Pocetna int = null,
	@Sifra_Zavrsna int = null,
	@ar_is_active bit = null,
	@articles_with_images bit = null
)
AS

SELECT	GRUPE_TOUCH_SCREEN.gt_id_pk, GRUPE_TOUCH_SCREEN.gt_name, GRUPE_TOUCH_SCREEN.gt_order_index, GRUPE_TOUCH_SCREEN.gt_color_index, 
		CASE WHEN gt_active =0 THEN 'NE' ELSE 'DA' END AS gt_active_str ,GRUPE_TOUCH_SCREEN.gt_active, 
		COUNT (TBL1.ar_id_pk ) AS broj_artikala
FROM GRUPE_TOUCH_SCREEN LEFT OUTER JOIN
                GRUPE_TOUCH_SCREEN_ARTIKLI ON GRUPE_TOUCH_SCREEN.gt_id_pk = GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk LEFT OUTER JOIN
				(SELECT artikli.ar_id_pk FROM artikli 
				WHERE (@ar_is_active is null or ARTIKLI.ar_is_active = 1) AND
					  (@Sifra_Pocetna is null or ARTIKLI.ar_sifra >= @Sifra_Pocetna) AND
					  (@Sifra_Zavrsna is null or ARTIKLI.ar_sifra <= @Sifra_Zavrsna)
				) AS TBL1 ON GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk = TBL1.ar_id_pk
group by GRUPE_TOUCH_SCREEN.gt_id_pk, GRUPE_TOUCH_SCREEN.gt_name, GRUPE_TOUCH_SCREEN.gt_active,
		 GRUPE_TOUCH_SCREEN.gt_order_index, GRUPE_TOUCH_SCREEN.gt_color_index
order by GRUPE_TOUCH_SCREEN.gt_order_index

if NOT @articles_with_images IS NULL
SELECT		GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk, GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk, GRUPE_TOUCH_SCREEN_ARTIKLI.gt_ar_order,  
			GRUPE_TOUCH_SCREEN.gt_id_pk, GRUPE_TOUCH_SCREEN.gt_name, GRUPE_TOUCH_SCREEN.gt_active, GRUPE_TOUCH_SCREEN.gt_color_index,
			ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_kategorija_fk, 
			ARTIKLI.ar_cijena, ARTIKLI.ar_index, ARTIKLI.ar_color_index, ARTIKLI.ar_size_index, 
			SYS_ARTIKLI_KATEGORIJE.syak_name
FROM    GRUPE_TOUCH_SCREEN_ARTIKLI LEFT OUTER JOIN
			GRUPE_TOUCH_SCREEN ON GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk = GRUPE_TOUCH_SCREEN.gt_id_pk LEFT OUTER JOIN
			ARTIKLI ON GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk
WHERE (@ar_is_active is null or (ARTIKLI.ar_is_active = 1)) AND
			(@Sifra_Pocetna is null or (ARTIKLI.ar_sifra >= @Sifra_Pocetna)) AND
			(@Sifra_Zavrsna is null or (ARTIKLI.ar_sifra <= @Sifra_Zavrsna))

if @articles_with_images IS NULL
SELECT		GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk, GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk, GRUPE_TOUCH_SCREEN_ARTIKLI.gt_ar_order,  
			GRUPE_TOUCH_SCREEN.gt_id_pk, GRUPE_TOUCH_SCREEN.gt_name, GRUPE_TOUCH_SCREEN.gt_active, GRUPE_TOUCH_SCREEN.gt_color_index,
			ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_kategorija_fk, 
			ARTIKLI.ar_cijena, ARTIKLI.ar_index, ARTIKLI.ar_color_index, ARTIKLI.ar_size_index, 
			SYS_ARTIKLI_KATEGORIJE.syak_name
FROM    GRUPE_TOUCH_SCREEN_ARTIKLI LEFT OUTER JOIN
			GRUPE_TOUCH_SCREEN ON GRUPE_TOUCH_SCREEN_ARTIKLI.gt_id_fk = GRUPE_TOUCH_SCREEN.gt_id_pk LEFT OUTER JOIN
			ARTIKLI ON GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk
WHERE (@ar_is_active is null or (ARTIKLI.ar_is_active = 1)) AND
			(@Sifra_Pocetna is null or (ARTIKLI.ar_sifra >= @Sifra_Pocetna)) AND
			(@Sifra_Zavrsna is null or (ARTIKLI.ar_sifra <= @Sifra_Zavrsna))
GO



--
-- Definition for stored procedure Osnovno_Delete_GRUPE_TOUCH_SCREEN : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_TOUCH_SCREEN]
(
@gt_id_pk int
)
AS

delete from GRUPE_TOUCH_SCREEN_ARTIKLI where gt_id_fk = @gt_id_pk
delete from GRUPE_TOUCH_SCREEN where gt_id_pk = @gt_id_pk
GO

--
-- Definition for stored procedure Management_Insert_START_LOG : 
--
GO
CREATE procedure [dbo].[Management_Insert_START_LOG]
(

	@sp_nadnevak datetime,
	@sp_start datetime,
	@sp_ks_id_fk int
)
as
insert into START_LOG
	(sp_nadnevak, sp_start, sp_ks_id_fk)
values
	(@sp_nadnevak, @sp_start, @sp_ks_id_fk)
select scope_identity()
GO

--
-- Definition for stored procedure Management_Get_START_LOG : 
--
GO
CREATE procedure [dbo].[Management_Get_START_LOG]
(
	@sp_ks_id_fk int,
	@day_start DateTime,
	@day_end DateTime

)

as
if @sp_ks_id_fk is null
	SELECT     min(sp_id_pk) as sp_id_pk, sp_nadnevak, min(sp_start) as sp_start, convert(varchar(10),min(sp_start) , 108) as sp_time
	FROM         START_LOG
	WHERE (START_LOG.sp_nadnevak between  @day_start and @day_end)
	GROUP BY  sp_nadnevak
else
	SELECT     min(sp_id_pk) as sp_id_pk, sp_nadnevak, min(sp_start) as sp_start, convert(varchar(10),min(sp_start) , 108) as sp_time
	FROM         START_LOG
	WHERE (START_LOG.sp_nadnevak between  @day_start and @day_end) and sp_ks_id_fk = @sp_ks_id_fk
	GROUP BY  sp_nadnevak
GO

--
-- Definition for stored procedure Management_Update_RESERVATION_ZAGLAVLJE_CHECK_IN : 
--
GO
CREATE procedure [dbo].[Management_Update_RESERVATION_ZAGLAVLJE_CHECK_IN]
(
	@rzz_id_pk int,
	@rzz_check_in bit
)
as
update
	RESERVATION_ZAGLAVLJE
set
	rzz_check_in = @rzz_check_in
where
	rzz_id_pk = @rzz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RESERVATION_ALL : 
--
GO
CREATE procedure [dbo].[Management_Update_RESERVATION_ALL]
(
	@rzz_id_pk int,
	@rzz_kn_id_fk int,
	@rzz_st_id_fk int,
	@rzz_date datetime,
	@rzz_date_time datetime,
	@rzz_date_creation datetime,
	@rzz_ukupno decimal(12,2),
	@rzz_description nvarchar(100),
	@rzz_person_name nvarchar(50),
	@rzz_person_mob nvarchar(20),
	@rzz_check_in bit,
	--------------------------------
	@Stavke_DTable BPOStype_DTable_RESERVATION_STAVKE READONLY
	--------------------------------
)
as
begin tran

	update
		RESERVATION_ZAGLAVLJE
	set
		rzz_kn_id_fk = @rzz_kn_id_fk, 
		rzz_st_id_fk = @rzz_st_id_fk, 
		rzz_date = @rzz_date, 
		rzz_date_time = @rzz_date_time, 
		rzz_date_creation = @rzz_date_creation, 
		rzz_ukupno = @rzz_ukupno, 
		rzz_description = @rzz_description, 
		rzz_person_name = @rzz_person_name, 
		rzz_person_mob = @rzz_person_mob,
		rzz_check_in = @rzz_check_in
	where
		rzz_id_pk = @rzz_id_pk

	delete from RESERVATION_STAVKE where rzs_rzz_id_fk = @rzz_id_pk

	------------ STAVKE ----------
	INSERT INTO RESERVATION_STAVKE 
		(rzs_rzz_id_fk, rzs_ar_id_fk, 
		rzs_napomena, rzs_cijena,
		rzs_kolicina, rzs_ukupno)
	SELECT 
		@rzz_id_pk, rzs_ar_id_fk, 
		rzs_napomena, rzs_cijena,
		rzs_kolicina, rzs_ukupno
	FROM @Stavke_DTable

commit
GO

--
-- Definition for stored procedure Management_Insert_RESERVATION_ALL : 
--
GO
CREATE procedure [dbo].[Management_Insert_RESERVATION_ALL]
(
@RetVal_ID int output,
@rzz_kn_id_fk int,
@rzz_st_id_fk int,
@rzz_date datetime,
@rzz_date_time datetime,
@rzz_date_creation datetime,
@rzz_ukupno decimal(12,2),
@rzz_description nvarchar(100),
@rzz_person_name nvarchar(50),
@rzz_person_mob nvarchar(20),
@rzz_check_in bit,
--------------------------------
@Stavke_DTable BPOStype_DTable_RESERVATION_STAVKE READONLY
--------------------------------
)
as

begin tran

	insert into RESERVATION_ZAGLAVLJE
		(rzz_kn_id_fk, rzz_st_id_fk, rzz_date, rzz_date_time, rzz_date_creation, rzz_ukupno, rzz_description, rzz_person_name, rzz_person_mob, rzz_check_in)
	values
		(@rzz_kn_id_fk, @rzz_st_id_fk, @rzz_date, @rzz_date_time, @rzz_date_creation, @rzz_ukupno, @rzz_description, @rzz_person_name, @rzz_person_mob, @rzz_check_in)
	SET @RetVal_ID=@@IDENTITY

	------------ STAVKE ----------
	INSERT INTO RESERVATION_STAVKE 
		(rzs_rzz_id_fk, rzs_ar_id_fk, 
		rzs_napomena, rzs_cijena,
		rzs_kolicina, rzs_ukupno)
	SELECT 
		@RetVal_ID, rzs_ar_id_fk, 
		rzs_napomena, rzs_cijena,
		rzs_kolicina, rzs_ukupno
	FROM @Stavke_DTable

commit
GO

--
-- Definition for stored procedure Management_Delete_RESERVATION_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Management_Delete_RESERVATION_ALL]
(
	@rzz_id_pk int
)
AS
delete from RESERVATION_STAVKE where rzs_rzz_id_fk = @rzz_id_pk
delete from RESERVATION_ZAGLAVLJE where rzz_id_pk = @rzz_id_pk
GO

--
-- Definition for stored procedure Management_Update_PONUDA_ALL : 
--
GO
CREATE procedure [dbo].[Management_Update_PONUDA_ALL]
(
	@pnz_id_pk int,
	@pnz_broj int,
	@pnz_nadnevak datetime,
	@pnz_kn_id_fk int,
	@pnz_tv_id_fk int,
	@pnz_napomena nvarchar(100),
	--------------------------------
	@Stavke_DTable BPOStype_DTable_PONUDA_STAVKE READONLY
	--------------------------------
)
as

begin tran
	update
		PONUDA_ZAGLAVLJE
	set
		pnz_broj = @pnz_broj,
		pnz_nadnevak = @pnz_nadnevak,
		pnz_kn_id_fk = @pnz_kn_id_fk,
		pnz_tv_id_fk = @pnz_tv_id_fk,
		pnz_napomena = @pnz_napomena
	where
		pnz_id_pk = @pnz_id_pk

	delete from PONUDA_STAVKE where pns_ponuda_id_fk = @pnz_id_pk

	------------ STAVKE ----------
	INSERT INTO PONUDA_STAVKE 
		(pns_ponuda_id_fk, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, pns_pdv,
		pns_pnp, pns_gpdv_id_fk,
		pns_gpnp_id_fk, pns_popust)
	SELECT 
		@pnz_id_pk, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, pns_pdv,
		pns_pnp, pns_gpdv_id_fk,
		pns_gpnp_id_fk, pns_popust
	FROM @Stavke_DTable

commit
GO

--
-- Definition for stored procedure Management_Insert_PONUDA_ALL : 
--
GO
CREATE procedure [dbo].[Management_Insert_PONUDA_ALL]
(
@RetVal_ID int output,
@pnz_broj int,
@pnz_nadnevak datetime,
@pnz_kn_id_fk int,
@pnz_tv_id_fk int,
@pnz_napomena nvarchar(100),
--------------------------------
@Stavke_DTable BPOStype_DTable_PONUDA_STAVKE READONLY
--------------------------------
)
as
begin tran

	insert into PONUDA_ZAGLAVLJE
		(pnz_broj, pnz_nadnevak, pnz_kn_id_fk, pnz_tv_id_fk, pnz_napomena)
	values
		(@pnz_broj, @pnz_nadnevak, @pnz_kn_id_fk, @pnz_tv_id_fk, @pnz_napomena)
	SET @RetVal_ID=@@IDENTITY

	------------ STAVKE ----------
	INSERT INTO PONUDA_STAVKE 
		(pns_ponuda_id_fk, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, pns_pdv,
		pns_pnp, pns_gpdv_id_fk,
		pns_gpnp_id_fk, pns_popust)
	SELECT 
		@RetVal_ID, pns_artikal_id_fk, 
		pns_cijena_bez_popusta, pns_cijena, pns_kolicina,
		pns_iznos_bez_popusta, pns_iznos, pns_pdv,
		pns_pnp, pns_gpdv_id_fk,
		pns_gpnp_id_fk, pns_popust
	FROM @Stavke_DTable

commit
GO

--
-- Definition for stored procedure Management_Delete_PONUDA_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Management_Delete_PONUDA_ALL]
(
	@pnz_id_pk int
)
AS
delete from PONUDA_STAVKE where pns_ponuda_id_fk = @pnz_id_pk
delete from PONUDA_ZAGLAVLJE where pnz_id_pk = @pnz_id_pk
GO

--
-- Definition for stored procedure Management_Update_NABAVNI_NALOG_ALL : 
--
GO
CREATE procedure [dbo].[Management_Update_NABAVNI_NALOG_ALL]
(
	@nnz_id_pk int,
	@nnz_broj int,
	@nnz_nadnevak datetime,
	@nnz_kn_id_fk int,
	@nnz_do_id_fk int,
	@nnz_napomena nvarchar(100),
	--------------------------------
	@Stavke_DTable BPOStype_DTable_NABAVNI_NALOG_STAVKE READONLY
	--------------------------------
)
as

begin tran

	update
		NABAVNI_NALOG_ZAGLAVLJE
	set
		nnz_broj = @nnz_broj,
		nnz_nadnevak = @nnz_nadnevak,
		nnz_kn_id_fk = @nnz_kn_id_fk,
		nnz_do_id_fk = @nnz_do_id_fk,
		nnz_napomena= @nnz_napomena
	where
		nnz_id_pk = @nnz_id_pk

	delete from NABAVNI_NALOG_STAVKE where nns_nabavni_nalog_id_fk = @nnz_id_pk

	------------ STAVKE ----------
	INSERT INTO NABAVNI_NALOG_STAVKE 
		(nns_nabavni_nalog_id_fk, nns_sirovina_id_fk, 
		nns_stanje_skladista, nns_kolicina)
	SELECT 
		@nnz_id_pk, nns_sirovina_id_fk, 
		nns_stanje_skladista, nns_kolicina
	FROM @Stavke_DTable

commit
GO

--
-- Definition for stored procedure Management_Insert_NABAVNI_NALOG_ALL : 
--
GO
CREATE procedure [dbo].[Management_Insert_NABAVNI_NALOG_ALL]
(
@RetVal_ID int output,
@nnz_broj int,
@nnz_nadnevak datetime,
@nnz_kn_id_fk int,
@nnz_do_id_fk int,
@nnz_napomena nvarchar(100),
--------------------------------
@Stavke_DTable BPOStype_DTable_NABAVNI_NALOG_STAVKE READONLY
--------------------------------
)
as
begin tran

	insert into NABAVNI_NALOG_ZAGLAVLJE
		(nnz_broj, nnz_nadnevak, nnz_kn_id_fk, nnz_do_id_fk, nnz_napomena)
	values
		(@nnz_broj, @nnz_nadnevak, @nnz_kn_id_fk, @nnz_do_id_fk, @nnz_napomena)
	SET @RetVal_ID=@@IDENTITY

	------------ STAVKE ----------
	INSERT INTO NABAVNI_NALOG_STAVKE 
		(nns_nabavni_nalog_id_fk, nns_sirovina_id_fk, 
		nns_stanje_skladista, nns_kolicina)
	SELECT 
		@RetVal_ID, nns_sirovina_id_fk, 
		nns_stanje_skladista, nns_kolicina
	FROM @Stavke_DTable

commit
GO


--
-- Definition for stored procedure Skladiste_Get_PRIMKE_LIST : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_PRIMKE_LIST]
(
	@day_start datetime,
	@day_end datetime,
	@pr_broj nvarchar(30)= null,
	@pr_dobavljac_id_fk int =null,
	@pr_status bit = null
)
AS
BEGIN
	SELECT		PRIMKE_ZAGLAVLJE.pr_id_pk, PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk, DOBAVLJACI.do_name,
				PRIMKE_ZAGLAVLJE.pr_datum, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_ZAGLAVLJE.pr_datum_dospijeca, 
				PRIMKE_ZAGLAVLJE.pr_napomena, PRIMKE_ZAGLAVLJE.pr_status, 
				PRIMKE_ZAGLAVLJE.pr_proknjizeno, PRIMKE_ZAGLAVLJE.pr_time_created,
				PRIMKE_ZAGLAVLJE.pr_osnovica, PRIMKE_ZAGLAVLJE.pr_pdv, PRIMKE_ZAGLAVLJE.pr_ukupno, PRIMKE_ZAGLAVLJE.pr_povratna_naknada, 
				sum(PRIMKE_STAVKE.ps_tot_osnovica) as count_osnovica, sum(PRIMKE_STAVKE.ps_tot_pdv) as count_pdv, 
				sum(PRIMKE_STAVKE.ps_tot_ukupno) as count_ukupno, sum(PRIMKE_STAVKE.ps_tot_povratna_naknada) as count_povratna_naknada,
				COUNT(PRIMKE_STAVKE.ps_id_pk) AS count_stavke
	FROM	PRIMKE_ZAGLAVLJE INNER JOIN
				PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT OUTER JOIN
				DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
	WHERE  PRIMKE_ZAGLAVLJE.pr_proknjizeno=1 and 
				(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @day_start AND @day_end) AND 
				(@pr_broj is null or (PRIMKE_ZAGLAVLJE.pr_broj = @pr_broj)) AND
				(@pr_dobavljac_id_fk is null or (PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = @pr_dobavljac_id_fk)) AND
				(@pr_status is null or (PRIMKE_ZAGLAVLJE.pr_status = @pr_status))
	group by    PRIMKE_ZAGLAVLJE.pr_id_pk, PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk, 
				PRIMKE_ZAGLAVLJE.pr_datum, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_ZAGLAVLJE.pr_datum_dospijeca, PRIMKE_ZAGLAVLJE.pr_osnovica, 
				PRIMKE_ZAGLAVLJE.pr_pdv, PRIMKE_ZAGLAVLJE.pr_ukupno, PRIMKE_ZAGLAVLJE.pr_povratna_naknada, PRIMKE_ZAGLAVLJE.pr_napomena, 
				PRIMKE_ZAGLAVLJE.pr_proknjizeno, PRIMKE_ZAGLAVLJE.pr_status, DOBAVLJACI.do_name, PRIMKE_ZAGLAVLJE.pr_time_created
END
GO


--
-- Definition for stored procedure Osnovno_Update_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_DOBAVLJACI]
(
	@do_id_pk int,
	@do_name nvarchar(50),
	@do_maticni_broj nvarchar(25),
	@do_oib nvarchar(25),	
	@do_adresa nvarchar(50),
	@do_mjesto nvarchar(50),
	@do_tel nvarchar(15),
	@do_fax nvarchar(15),
	@do_ziro_racun nvarchar(25),
	@do_kontakt_osoba nvarchar(25),
	@do_kontakt_osoba_mob nvarchar(15),
	@do_biljeska nvarchar(40),
	@do_state nvarchar(50),
	@do_porezni_broj nvarchar(50), 
	@do_sifra nvarchar(25)
)
as
update
	DOBAVLJACI
set
	do_name = @do_name,
	do_maticni_broj = @do_maticni_broj,
	do_adresa = @do_adresa,
	do_mjesto = @do_mjesto,
	do_tel = @do_tel,
	do_fax = @do_fax,
	do_ziro_racun = @do_ziro_racun,
	do_kontakt_osoba = @do_kontakt_osoba,
	do_kontakt_osoba_mob = @do_kontakt_osoba_mob,
	do_biljeska = @do_biljeska,
	do_oib = @do_oib,
	do_state = @do_state,
	do_porezni_broj = @do_porezni_broj, 
	do_sifra = @do_sifra
where
	do_id_pk = @do_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_DOBAVLJACI]
(
	@do_name nvarchar(50),
	@do_maticni_broj nvarchar(25),
	@do_oib nvarchar(25),	
    @do_adresa nvarchar(50),
	@do_mjesto nvarchar(50),
	@do_tel nvarchar(15),
	@do_fax nvarchar(15),
	@do_ziro_racun nvarchar(25),
	@do_kontakt_osoba nvarchar(25),
	@do_kontakt_osoba_mob nvarchar(15),
	@do_biljeska nvarchar(40),
	@do_time_inserted datetime,
	@do_state nvarchar(50),
	@do_porezni_broj nvarchar(50),
	@do_sifra nvarchar(25)
)
as
insert into DOBAVLJACI
	(do_name, do_maticni_broj, do_adresa, do_mjesto, do_tel, do_fax, do_ziro_racun, do_kontakt_osoba, do_kontakt_osoba_mob, do_biljeska, do_time_inserted, do_oib, do_state, do_porezni_broj, do_sifra)
values
	(@do_name, @do_maticni_broj, @do_adresa, @do_mjesto, @do_tel, @do_fax, @do_ziro_racun, @do_kontakt_osoba, @do_kontakt_osoba_mob, @do_biljeska, @do_time_inserted, @do_oib, @do_state, @do_porezni_broj, @do_sifra)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_DOBAVLJACI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_DOBAVLJACI]
(
	@do_sifra nvarchar(25) = null,
	@do_oib nvarchar(25) = null
)
AS
Select * from DOBAVLJACI
WHERE
	(@do_sifra is null or (DOBAVLJACI.do_sifra = @do_sifra)) AND 
	(@do_oib is null or (DOBAVLJACI.do_oib = @do_oib))
GO



--
-- Definition for stored procedure Osnovno_Delete_DOBAVLJACI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_DOBAVLJACI]
(
	@do_id_pk int
)
as
delete DOBAVLJACI where do_id_pk = @do_id_pk
GO




--
-- Definition for stored procedure Osnovno_Insert_SIROVINE_EXTERNAL : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_SIROVINE_EXTERNAL]
(
	@sxt_type_id int,
	@sxt_sifra nvarchar(20),
	@sxt_barcode_ean nvarchar(20),
	@sxt_naziv nvarchar(50),
	@sxt_jmj nvarchar(10),
	@sxt_jmj_paket_kol decimal(10, 3),
	@sxt_grupa nvarchar(30),
	@sxt_napomena nvarchar(50),
	@sxt_sir_id_fk int
)
as
insert into SIROVINE_EXTERANAL
	(sxt_type_id, sxt_sifra, sxt_barcode_ean, sxt_naziv, sxt_jmj, sxt_jmj_paket_kol, sxt_grupa, sxt_napomena, sxt_sir_id_fk)
values
	(@sxt_type_id, @sxt_sifra, @sxt_barcode_ean, @sxt_naziv, @sxt_jmj, @sxt_jmj_paket_kol, @sxt_grupa, @sxt_napomena, @sxt_sir_id_fk)
select scope_identity()
GO



--
-- Definition for stored procedure Osnovno_Update_SIROVINE_EXTERNAL : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_SIROVINE_EXTERNAL]
(
	@sxt_type_id int,
	@sxt_id_pk int,
	@sxt_sifra nvarchar(20),
	@sxt_barcode_ean nvarchar(20),
	@sxt_naziv nvarchar(50),
	@sxt_jmj nvarchar(10),
	@sxt_jmj_paket_kol decimal(10, 3),
	@sxt_grupa nvarchar(30),
	@sxt_napomena nvarchar(50),
	@sxt_sir_id_fk int
)
as
update
	SIROVINE_EXTERANAL
set
	sxt_type_id = @sxt_type_id,
	sxt_sifra = @sxt_sifra,
	sxt_barcode_ean = @sxt_barcode_ean,
	sxt_naziv = @sxt_naziv,
	sxt_jmj = @sxt_jmj,
	sxt_jmj_paket_kol = @sxt_jmj_paket_kol,
	sxt_grupa = @sxt_grupa,
	sxt_napomena = @sxt_napomena,
	sxt_sir_id_fk = @sxt_sir_id_fk
where
	sxt_id_pk = @sxt_id_pk
GO



--
-- Definition for stored procedure Osnovno_Get_SIROVINE_EXTERNAL : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_SIROVINE_EXTERNAL]
AS
SELECT SIROVINE.si_id_pk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, SIROVINE.si_min_kolicina, 
                      SIROVINE.si_povratna_naknada, SIROVINE.si_kalo, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, SIROVINE.si_time_inserted, SIROVINE.si_active
FROM   SIROVINE LEFT OUTER JOIN 
       SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
       GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
order by SIROVINE.si_ime
SELECT  SIROVINE_EXTERANAL.*, SIROVINE.*, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name
FROM   SIROVINE_EXTERANAL LEFT OUTER JOIN 
       SIROVINE ON SIROVINE_EXTERANAL.sxt_sir_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN 
       SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
       GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
GO



--
-- Definition for stored procedure Osnovno_Delete_SIROVINE_EXTERNAL : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_SIROVINE_EXTERNAL]
(
	@sxt_id_pk int
)
as
delete SIROVINE_EXTERANAL where sxt_id_pk = @sxt_id_pk
GO




--
-- Definition for stored procedure Management_Delete_NABAVNI_NALOG_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Management_Delete_NABAVNI_NALOG_ALL]
(
	@nnz_id_pk int
)
AS
delete from NABAVNI_NALOG_STAVKE where nns_nabavni_nalog_id_fk = @nnz_id_pk
delete from NABAVNI_NALOG_ZAGLAVLJE where nnz_id_pk = @nnz_id_pk
GO

--
-- Definition for stored procedure Management_Delete_NARUDZBA_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Management_Delete_NARUDZBA_ALL]
(
	@nz_id_pk int
)
AS
delete from NARUDZBE_STAVKE where ns_nz_id_fk = @nz_id_pk
delete from NARUDZBE_ZAGLAVLJE where nz_id_pk = @nz_id_pk
GO

--
-- Definition for stored procedure Konobar_Insert_NARUDZBA_ALL : 
--
GO
CREATE procedure [dbo].[Konobar_Insert_NARUDZBA_ALL]
(
	@RetVal_BrojFull int output,
	@RetVal_BrojDnevni int output,
	@RetVal_ID int output,
	@nz_action_type nvarchar(15),
	@nz_vrijeme datetime,
	@nz_dan datetime,
	@nz_kasa_id_fk int,
	@nz_konobar_id_fk int,
	@nz_stol_id_fk int,
	@nz_iznos decimal(10, 2),
	@nz_popust decimal(10, 2),
	@nz_iznos_bez_popusta decimal(10, 2),
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_NARUDZBE_STAVKE READONLY
    --------------------------------
)
AS


begin tran

select @RetVal_BrojFull = max(nz_broj_full) from NARUDZBE_ZAGLAVLJE
select @RetVal_BrojDnevni = max(nz_broj_dnevni) from NARUDZBE_ZAGLAVLJE where nz_dan = @nz_dan
-- AKO BROJ NE POSTOJI - STAVI DA JE 1
BEGIN
	if  @RetVal_BrojFull is null
		SET @RetVal_BrojFull = 1
	else
		SET @RetVal_BrojFull = @RetVal_BrojFull + 1
END
BEGIN
	if  @RetVal_BrojDnevni is null
		SET @RetVal_BrojDnevni = 1
	else
		SET @RetVal_BrojDnevni = @RetVal_BrojDnevni + 1
END
BEGIN
	-- INSERT ZAGLAVLJE
	INSERT INTO NARUDZBE_ZAGLAVLJE 
		(nz_action_type, nz_broj_full, nz_broj_dnevni, nz_vrijeme, nz_dan, nz_kasa_id_fk, nz_konobar_id_fk, nz_stol_id_fk, nz_iznos, nz_popust, nz_iznos_bez_popusta)
	VALUES
		(@nz_action_type, @RetVal_BrojFull, @RetVal_BrojDnevni, @nz_vrijeme, @nz_dan, @nz_kasa_id_fk, @nz_konobar_id_fk, @nz_stol_id_fk, @nz_iznos, @nz_popust, @nz_iznos_bez_popusta)
	SET @RetVal_ID=@@IDENTITY
END
BEGIN
SET @RetVal_BrojDnevni = @RetVal_BrojDnevni + 1

		------------ STAVKE ----------
	INSERT INTO NARUDZBE_STAVKE 
		(ns_nz_id_fk, ns_ar_id_fk, 
		ns_napomena, ns_ar_cijena,
		ns_kolicina, ns_iznos, 
		ns_slijed, ns_popust, 
		ns_iznos_bez_popusta, ns_mi_id_fk,
		ns_vrijeme_izdavanja, ns_vrijeme_prihvacanja,
		ns_vrijeme_spremnosti, ns_vrijeme_dostave,
		ns_status)
	SELECT 
		@RetVal_ID, ns_ar_id_fk, 
		ns_napomena, ns_ar_cijena,
		ns_kolicina, ns_iznos, 
		ns_slijed, ns_popust, 
		ns_iznos_bez_popusta, ns_mi_id_fk,
		ns_vrijeme_izdavanja, ns_vrijeme_prihvacanja,
		ns_vrijeme_spremnosti, ns_vrijeme_dostave,
		ns_status
	FROM @Stavke_DTable
END
commit
GO



--
-- Definition for stored procedure Konobar_Update_NARUDZBA_ALL : 
--
GO
CREATE procedure [dbo].[Konobar_Update_NARUDZBA_ALL]
(
	@nz_id_pk int,
	@nz_action_type nvarchar(15),
	@nz_vrijeme datetime,
	@nz_dan datetime,
	@nz_kasa_id_fk int,
	@nz_konobar_id_fk int,
	@nz_stol_id_fk int,
	@nz_iznos decimal(10, 2),
	@nz_popust decimal(10, 2),
	@nz_iznos_bez_popusta decimal(10, 2),
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_NARUDZBE_STAVKE READONLY
    --------------------------------
)
AS

begin tran

	update
		NARUDZBE_ZAGLAVLJE
	set
		nz_action_type = @nz_action_type,
		nz_vrijeme = @nz_vrijeme,
		nz_dan = @nz_dan,
		nz_kasa_id_fk = @nz_kasa_id_fk,
		nz_konobar_id_fk = @nz_konobar_id_fk,
		nz_stol_id_fk = @nz_stol_id_fk,
		nz_iznos = @nz_iznos,
		nz_popust = @nz_popust,
		nz_iznos_bez_popusta = @nz_iznos_bez_popusta
	where
		nz_id_pk = @nz_id_pk

	delete NARUDZBE_STAVKE where ns_nz_id_fk = @nz_id_pk

	------------ STAVKE ----------
	INSERT INTO NARUDZBE_STAVKE 
		(ns_nz_id_fk, ns_ar_id_fk, 
		ns_napomena, ns_ar_cijena,
		ns_kolicina, ns_iznos, 
		ns_slijed, ns_popust, 
		ns_iznos_bez_popusta, ns_mi_id_fk,
		ns_vrijeme_izdavanja, ns_vrijeme_prihvacanja,
		ns_vrijeme_spremnosti, ns_vrijeme_dostave,
		ns_status)
	SELECT 
		@nz_id_pk, ns_ar_id_fk, 
		ns_napomena, ns_ar_cijena,
		ns_kolicina, ns_iznos, 
		ns_slijed, ns_popust, 
		ns_iznos_bez_popusta, ns_mi_id_fk,
		ns_vrijeme_izdavanja, ns_vrijeme_prihvacanja,
		ns_vrijeme_spremnosti, ns_vrijeme_dostave,
		ns_status
	FROM @Stavke_DTable

commit
GO



--
-- Definition for stored procedure Konobar_Update_NARUDZBA_STAVKA : 
--
GO
CREATE procedure [dbo].[Konobar_Update_NARUDZBA_STAVKA]
(
	@ns_id_pk int,
	@ns_nz_id_fk int,
	@ns_ar_id_fk int,
	@ns_napomena nvarchar(50),
	@ns_ar_cijena decimal(12, 2),
	@ns_kolicina decimal(12, 4),
	@ns_iznos decimal(12, 2),
	@ns_slijed nvarchar(15),
	@ns_popust decimal(12, 2),
	@ns_iznos_bez_popusta decimal(12, 2),
	@ns_mi_id_fk int,
	@ns_vrijeme_izdavanja datetime,
	@ns_vrijeme_prihvacanja datetime,
	@ns_vrijeme_spremnosti datetime,
	@ns_vrijeme_dostave datetime,
	@ns_status nvarchar(15)
)
AS
update
	NARUDZBE_STAVKE
set
	ns_nz_id_fk = @ns_nz_id_fk,
	ns_ar_id_fk = @ns_ar_id_fk,
	ns_napomena = @ns_napomena,
	ns_ar_cijena = @ns_ar_cijena,
	ns_kolicina = @ns_kolicina,
	ns_iznos = @ns_iznos,
	ns_slijed = @ns_slijed,
	ns_popust = @ns_popust,
	ns_iznos_bez_popusta = @ns_iznos_bez_popusta,
	ns_mi_id_fk = @ns_mi_id_fk,
	ns_vrijeme_izdavanja = @ns_vrijeme_izdavanja,
	ns_vrijeme_prihvacanja = @ns_vrijeme_prihvacanja,
	ns_vrijeme_spremnosti = @ns_vrijeme_spremnosti,
	ns_vrijeme_dostave = @ns_vrijeme_dostave,
	ns_status = @ns_status
where
	ns_id_pk = @ns_id_pk
GO




--
-- Definition for stored procedure Management_Update_KONZUMACIJA_RACUN_POVEZNICA : 
--
GO
CREATE procedure [dbo].[Management_Update_KONZUMACIJA_RACUN_POVEZNICA]
(
	@kzz_id_pk int,
	@kzz_racun_id_fk int
)
as
update
	KONZUMACIJA_ZAGLAVLJE
set
	kzz_racun_id_fk = @kzz_racun_id_fk
where
	kzz_id_pk = @kzz_id_pk
GO

--
-- Definition for stored procedure Management_Delete_KONZUMACIJA_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Management_Delete_KONZUMACIJA_ALL]
(
	@kzz_id_pk int
)
AS
delete from KONZUMACIJA_STAVKE where kzs_kzz_id_fk = @kzz_id_pk
delete from KONZUMACIJA_ZAGLAVLJE where kzz_id_pk = @kzz_id_pk
GO

--
-- Definition for stored procedure Konobar_Update_KONZUMACIJA_RACUN : 
--
GO
CREATE procedure [dbo].[Konobar_Update_KONZUMACIJA_RACUN]
(
	@kzz_id_pk int,
	@kzz_racun_id_fk int
)
as
update 
	KONZUMACIJA_ZAGLAVLJE
set
	kzz_racun_id_fk = @kzz_racun_id_fk
where
	kzz_id_pk = @kzz_id_pk
GO

--
-- Definition for stored procedure Konobar_Insert_KONZUMACIJA_ALL : 
--
GO
CREATE procedure [dbo].[Konobar_Insert_KONZUMACIJA_ALL]
(
	@RetVal_BrojFull int output,
	@RetVal_BrojDnevni int output,
	@RetVal_ID int output,
	@kzz_racun_id_fk int,
	@kzz_konobar_id_fk int,
	@kzz_stol_id_fk int,
	@kzz_tvrtka_id_fk int,
	@kzz_narucitelj_id_fk int,
	@kzz_kasa_id_fk int,
	@kzz_vrijeme datetime,
	@kzz_nadnevak datetime,
	@kzz_popust decimal(12, 2),
	@kzz_iznos_bez_popusta decimal(12, 2),
	@kzz_iznos decimal(12, 2),
	@kzz_pdv decimal(12, 2),
	@kzz_pnp decimal(12, 2),
	@kzz_napomena nvarchar(50),
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_KONZUMACIJA_STAVKE READONLY
    --------------------------------
)
AS
select @RetVal_BrojFull = max(kzz_broj_full) from KONZUMACIJA_ZAGLAVLJE
select @RetVal_BrojDnevni = max(kzz_broj_dnevni) from KONZUMACIJA_ZAGLAVLJE where kzz_nadnevak = @kzz_nadnevak
-- AKO BROJ NE POSTOJI - STAVI DA JE 1
BEGIN
	if  @RetVal_BrojFull is null
		SET @RetVal_BrojFull = 1
	else
		SET @RetVal_BrojFull = @RetVal_BrojFull + 1
END
BEGIN
	if  @RetVal_BrojDnevni is null
		SET @RetVal_BrojDnevni = 1
	else
		SET @RetVal_BrojDnevni = @RetVal_BrojDnevni + 1
END
BEGIN
	-- INSERT ZAGLAVLJE
	INSERT INTO KONZUMACIJA_ZAGLAVLJE 
		(kzz_racun_id_fk, kzz_konobar_id_fk, kzz_stol_id_fk, kzz_tvrtka_id_fk, kzz_narucitelj_id_fk, kzz_kasa_id_fk, kzz_vrijeme, kzz_nadnevak, kzz_broj_dnevni, kzz_broj_full, kzz_popust, kzz_iznos_bez_popusta, kzz_iznos, kzz_pdv, kzz_pnp, kzz_napomena)
	VALUES
		(@kzz_racun_id_fk, @kzz_konobar_id_fk, @kzz_stol_id_fk, @kzz_tvrtka_id_fk, @kzz_narucitelj_id_fk, @kzz_kasa_id_fk, @kzz_vrijeme, @kzz_nadnevak, @RetVal_BrojDnevni, @RetVal_BrojFull, @kzz_popust, @kzz_iznos_bez_popusta, @kzz_iznos, @kzz_pdv, @kzz_pnp, @kzz_napomena)
	SET @RetVal_ID=@@IDENTITY
END
BEGIN
	------------ STAVKE ----------
	INSERT INTO KONZUMACIJA_STAVKE
		(kzs_kzz_id_fk, kzs_artikal_id_fk, 
		kzs_kolicina, kzs_cijena_bez_popusta,
		kzs_cijena, kzs_popust, 
		kzs_iznos_bez_popusta, kzs_iznos, 
		kzs_pdv, kzs_pnp, 
		kzs_gpdv_id_fk, kzs_gpnp_id_fk, 
		kzs_napomena)
	SELECT 
		@RetVal_ID, kzs_artikal_id_fk, 
		kzs_kolicina, kzs_cijena_bez_popusta,
		kzs_cijena, kzs_popust, 
		kzs_iznos_bez_popusta, kzs_iznos, 
		kzs_pdv, kzs_pnp, 
		kzs_gpdv_id_fk, kzs_gpnp_id_fk, 
		kzs_napomena
	FROM @Stavke_DTable
END
GO



--
-- Definition for stored procedure Konobar_Update_OTVORENI_RACUN_ZAGLAVLJE : 
--
GO
CREATE procedure [dbo].[Konobar_Update_OTVORENI_RACUN_ZAGLAVLJE]
(@wks_id_pk int,
 @wks_is_used bit,
 @wks_konobar_id_fk int,
 @wks_stol_id_fk int
)
AS
UPDATE OTVORENI_RACUNI_ZAGLAVLJE 
SET 
	wks_is_used = @wks_is_used,
	wks_konobar_id_fk = @wks_konobar_id_fk,
	wks_stol_id_fk = @wks_stol_id_fk
WHERE wks_id_pk = @wks_id_pk
GO




--
-- Definition for stored procedure Konobar_Update_OTVORENI_RACUN_STAVKA : 
--
GO
CREATE procedure [dbo].[Konobar_Update_OTVORENI_RACUN_STAVKA]
(
 @wkss_id_pk int,
 @wkss_nar_vrijeme_spremnosti datetime
)
AS
UPDATE OTVORENI_RACUNI_STAVKE 
SET 
	wkss_nar_vrijeme_spremnosti = @wkss_nar_vrijeme_spremnosti
WHERE wkss_id_pk = @wkss_id_pk
GO




--
-- Definition for stored procedure Konobar_Get_OTVORENI_RACUN_STOL_INFO : 
--
GO
CREATE PROCEDURE [dbo].[Konobar_Get_OTVORENI_RACUN_STOL_INFO]
(	
	@RetVal int output,
 	@RetVal_konobar int output,	
	@RetVal_in_use bit output,	
    @wks_stol_id_fk int
)
AS
SELECT @RetVal = wks_id_pk, @RetVal_konobar = wks_konobar_id_fk, @RetVal_in_use = wks_is_used 
FROM OTVORENI_RACUNI_ZAGLAVLJE 
WHERE OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk = @wks_stol_id_fk
GO


--
-- Definition for stored procedure Management_Delete_OTVORENI_RACUNI_ALL : 
--
GO
CREATE procedure [dbo].[Management_Delete_OTVORENI_RACUNI_ALL]
as
delete OTVORENI_RACUNI_STAVKE
delete OTVORENI_RACUNI_ZAGLAVLJE
GO


--
-- Definition for stored procedure Konobar_Update_OTVORENI_RACUN_ALL : 
--
GO
CREATE procedure [dbo].[Konobar_Update_OTVORENI_RACUN_ALL]
(
    @wks_id_pk int,
    @wks_napomena nvarchar(200),
    @wks_vrijeme datetime,
	@wks_is_used bit,
    --------------------------------
   	@Stavke_DTable BPOStype_DTable_OTVORENI_RACUNI_STAVKE READONLY
    --------------------------------
)
AS

begin tran

	UPDATE OTVORENI_RACUNI_ZAGLAVLJE SET 
			wks_napomena = @wks_napomena, 
			wks_vrijeme = @wks_vrijeme, 
			wks_is_used = @wks_is_used 
	WHERE wks_id_pk = @wks_id_pk
	------------------------------
	DELETE FROM OTVORENI_RACUNI_STAVKE WHERE wkss_wks_id_fk = @wks_id_pk
	------------ STAVKE ----------
	INSERT INTO OTVORENI_RACUNI_STAVKE
		(wkss_wks_id_fk, wkss_artikal_id_fk, 
		wkss_pdv_id_fk, wkss_pnp_id_fk, 
		wkss_kolicina, wkss_popust, 
		wkss_cijena_bez_popusta, wkss_cijena,
		wkss_pdv, wkss_pnp, 
		wkss_iznos_bez_popusta, wkss_iznos, 
		wkss_nar_ns_id_pk, wkss_nar_naruceno, 
		wkss_nar_status, wkss_nar_napomena, 
		wkss_nar_vrijeme_izdavanja, wkss_nar_vrijeme_prihvacanja, 
		wkss_nar_vrijeme_spremnosti, wkss_nar_vrijeme_dostave, 
		wkss_nar_slijed_priority, wkss_nar_slijed_name, wkss_nar_slijed_oznaka)
	SELECT 
		@wks_id_pk, wkss_artikal_id_fk, 
		wkss_pdv_id_fk, wkss_pnp_id_fk, 
		wkss_kolicina, wkss_popust, 
		wkss_cijena_bez_popusta, wkss_cijena,
		wkss_pdv, wkss_pnp, 
		wkss_iznos_bez_popusta, wkss_iznos, 
		wkss_nar_ns_id_pk, wkss_nar_naruceno, 
		wkss_nar_status, wkss_nar_napomena, 
		wkss_nar_vrijeme_izdavanja, wkss_nar_vrijeme_prihvacanja, 
		wkss_nar_vrijeme_spremnosti, wkss_nar_vrijeme_dostave, 
		wkss_nar_slijed_priority, wkss_nar_slijed_name, wkss_nar_slijed_oznaka
	FROM @Stavke_DTable
	
commit
GO

--
-- Definition for stored procedure Konobar_Delete_OTVORENI_RACUN_ALL : 
--
GO
CREATE procedure [dbo].[Konobar_Delete_OTVORENI_RACUN_ALL]
(
    @wks_id_pk int
)
AS
DELETE FROM OTVORENI_RACUNI_STAVKE WHERE wkss_wks_id_fk = @wks_id_pk
DELETE FROM OTVORENI_RACUNI_ZAGLAVLJE WHERE wks_id_pk = @wks_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_NORMATIVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NORMATIVI]
(
	@no_id_pk int,
	@no_article_id_fk int,
	@no_sirovina_id_fk int,
	@no_kolicina decimal(10, 4)
)
as
update
	NORMATIVI
set
	no_article_id_fk = @no_article_id_fk,
    no_sirovina_id_fk = @no_sirovina_id_fk,
    no_kolicina = @no_kolicina
where
	no_id_pk = @no_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_NORMATIVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_NORMATIVI]
(
	@no_article_id_fk int,
	@no_sirovina_id_fk int,
	@no_kolicina decimal(10, 4)
)
as
insert into NORMATIVI
	(no_article_id_fk, no_sirovina_id_fk, no_kolicina)
values
	(@no_article_id_fk, @no_sirovina_id_fk, @no_kolicina)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_SIROVINE : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_SIROVINE]
(
	@si_id_pk Int
)
AS
SELECT * FROM PRIMKE_STAVKE WHERE ps_si_id_fk = @si_id_pk
SELECT * FROM OTPISI_STAVKE WHERE os_si_id_fk = @si_id_pk
SELECT * FROM IZDATNICE_STAVKE WHERE is_si_id_fk = @si_id_pk
SELECT * FROM NORMATIVI WHERE no_sirovina_id_fk = @si_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_NORMATIVI_BY_ARTICLE_ID : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_NORMATIVI_BY_ARTICLE_ID]
(
	@no_article_id_fk int
)
as
delete NORMATIVI where no_article_id_fk = @no_article_id_fk
GO

--
-- Definition for stored procedure Osnovno_Delete_NORMATIVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_NORMATIVI]
(
	@no_id_pk int
)
as
delete NORMATIVI where no_id_pk = @no_id_pk
GO


--
-- Definition for stored procedure Osnovno_Update_SIROVINE : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_SIROVINE]
(
	@si_id_pk int,
	@si_type int,
	@si_ime nvarchar(50),
	@si_jmj nvarchar(5),
	@si_pdv_id_fk int,
	@si_grupa_fk int,
	@si_kategorija_fk int,
	@si_min_kolicina decimal(10, 3),
	@si_povratna_naknada decimal(10, 2),
	@si_kalo decimal(10, 2),
	@si_active bit,
	@si_sifra nvarchar(20)
)
as
update
	SIROVINE
set
	si_type = @si_type,
	si_sifra = @si_sifra,
	si_ime = @si_ime,
	si_jmj = @si_jmj,
	si_pdv_id_fk = @si_pdv_id_fk,
	si_grupa_fk = @si_grupa_fk,
	si_kategorija_fk = @si_kategorija_fk,
	si_min_kolicina = @si_min_kolicina,
	si_povratna_naknada = @si_povratna_naknada,
	si_kalo = @si_kalo,
	si_active = @si_active
where
	si_id_pk = @si_id_pk
GO



--
-- Definition for stored procedure Osnovno_Update_SIROVINE_PDV_GRUPA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_SIROVINE_PDV_GRUPA]
(
	@ar_pdv_fk_current int,
	@ar_pdv_fk_new int
)
as
update SIROVINE
set si_pdv_id_fk = @ar_pdv_fk_new
where si_pdv_id_fk = @ar_pdv_fk_current
GO



--
-- Definition for stored procedure Osnovno_Insert_SIROVINE : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_SIROVINE]
(
	@si_type int,
	@si_ime nvarchar(50),
	@si_jmj nvarchar(5),
	@si_pdv_id_fk int,
	@si_grupa_fk int,
	@si_kategorija_fk int,
	@si_min_kolicina decimal(10, 3),
	@si_povratna_naknada decimal(10, 2),
	@si_kalo decimal(10, 2),
	@si_active bit,
	@si_sifra nvarchar(20)
)
as
insert into SIROVINE
	(si_type, si_ime, si_sifra, si_jmj, si_pdv_id_fk, si_grupa_fk, si_kategorija_fk, si_min_kolicina, si_povratna_naknada, si_kalo, si_active)
values
	(@si_type, @si_ime, @si_sifra, @si_jmj, @si_pdv_id_fk, @si_grupa_fk, @si_kategorija_fk, @si_min_kolicina, @si_povratna_naknada, @si_kalo, @si_active)
select scope_identity()
GO


--
-- Definition for stored procedure Osnovno_Get_NORMATIVI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NORMATIVI]
@ARTICAL_ID INT
AS
SELECT     NORMATIVI.no_id_pk, NORMATIVI.no_article_id_fk, NORMATIVI.no_sirovina_id_fk, SIROVINE.si_ime, SIROVINE.si_jmj, NORMATIVI.no_kolicina
FROM       NORMATIVI INNER JOIN
                      SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk
WHERE      NORMATIVI.no_article_id_fk = @ARTICAL_ID
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_GRUPE_SIROVINA : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_GRUPE_SIROVINA]
(
	@gs_id_pk Int
)
AS
SELECT * FROM SIROVINE WHERE si_grupa_fk = @gs_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_SIROVINE : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_SIROVINE]
(
	@si_id_pk int
)
as
delete from SIROVINE_EXTERANAL where sxt_sir_id_fk = @si_id_pk
delete from NORMATIVI where no_sirovina_id_fk = @si_id_pk
delete SIROVINE where si_id_pk = @si_id_pk
GO


--
-- Definition for stored procedure Osnovno_Update_GRUPE_SIROVINA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_SIROVINA]
(
	@gs_id_pk int,
	@gs_name nvarchar(20),
	@gs_order_index int,
	@gs_sysk_id_fk int
)
as
update
	GRUPE_SIROVINA
set
	gs_name = @gs_name,
	gs_order_index = @gs_order_index,
	gs_sysk_id_fk = @gs_sysk_id_fk
where
	gs_id_pk = @gs_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_SIROVINA : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_SIROVINA]
(
	@gs_name nvarchar(20),
	@gs_order_index int,
	@gs_sysk_id_fk int
)
as
insert into GRUPE_SIROVINA
	(gs_name, gs_order_index, gs_sysk_id_fk)
values
	(@gs_name, @gs_order_index, @gs_sysk_id_fk)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_SIROVINA : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_GRUPE_SIROVINA]
(
	@gs_id_pk int
)
as

UPDATE SIROVINE set si_grupa_fk = null where si_grupa_fk = @gs_id_pk

delete GRUPE_SIROVINA where gs_id_pk = @gs_id_pk
GO

--
-- Definition for stored procedure System_Get_SYS_SIROVINE_KATEGORIJE : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_SIROVINE_KATEGORIJE]
AS
Select * from SYS_SIROVINE_KATEGORIJE
GO



--
-- Definition for stored procedure Skladiste_Set_INVENTURA_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_INVENTURA_WRITE_MODE]
(
	@RetVal int output,
	@in_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT in_id_pk, in_proknjizeno FROM INVENTURA_ZAGLAVLJE WHERE in_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE INVENTURA_ZAGLAVLJE SET in_proknjizeno=0 WHERE in_id_pk=@in_id_pk
		EXECUTE dbo.Skladiste_Get_INVENTURA_BY_ID @in_id_pk
	END
END
GO



--
-- Definition for stored procedure Skladiste_Get_INIT_INVENTURA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_INVENTURA]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(in_broj) from INVENTURA_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1

	declare @ID AS INT

	SELECT @ID=in_id_pk FROM INVENTURA_ZAGLAVLJE WHERE in_proknjizeno=0

	SELECT INVENTURA_ZAGLAVLJE.in_id_pk, INVENTURA_ZAGLAVLJE.in_broj, INVENTURA_ZAGLAVLJE.in_nadnevak, 
		   INVENTURA_ZAGLAVLJE.in_knjizenje, INVENTURA_ZAGLAVLJE.in_napomena, INVENTURA_ZAGLAVLJE.in_proknjizeno 
	FROM INVENTURA_ZAGLAVLJE
	WHERE (INVENTURA_ZAGLAVLJE.in_proknjizeno = 0)

	SELECT	INVENTURA_STAVKE.ins_id_pk, INVENTURA_STAVKE.ins_in_id_fk, INVENTURA_STAVKE.ins_sir_id_fk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_povratna_naknada,  
						  SIROVINE.si_kategorija_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, SIROVINE.si_grupa_fk, GRUPE_SIROVINA.gs_name, SIROVINE.si_min_kolicina,
						  INVENTURA_STAVKE.ins_sir_stanje_zateceno, INVENTURA_STAVKE.ins_sir_stanje_kasa, INVENTURA_STAVKE.ins_sir_stanje_razlika, 
						  INVENTURA_STAVKE.ins_sir_prosj_nab_cijena, 
						  INVENTURA_STAVKE.ins_fin_stanje_zateceno, INVENTURA_STAVKE.ins_fin_stanje_kasa, INVENTURA_STAVKE.ins_fin_stanje_razlika, INVENTURA_STAVKE.ins_pov_nak_razlika
	FROM	INVENTURA_STAVKE LEFT JOIN
						  SIROVINE ON INVENTURA_STAVKE.ins_sir_id_fk = SIROVINE.si_id_pk LEFT JOIN   
						  GRUPE_SIROVINA on SIROVINE.si_grupa_fk=GRUPE_SIROVINA.gs_id_pk LEFT JOIN 
						  SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk 
	where	INVENTURA_STAVKE.ins_in_id_fk = @ID
END
GO


--
-- Definition for stored procedure Skladiste_Get_INVENTURA_BY_ID : 
--
GO
CREATE PROCEDURE [dbo].[Skladiste_Get_INVENTURA_BY_ID]
(
	@in_id_pk int
)
AS
SELECT     in_id_pk, in_broj, in_nadnevak, in_knjizenje, in_proknjizeno, in_napomena,
				CASE WHEN in_knjizenje =0 THEN 'NE' ELSE 'DA' END AS in_knjizenje_str
FROM        INVENTURA_ZAGLAVLJE
where		INVENTURA_ZAGLAVLJE.in_id_pk = @in_id_pk

SELECT		INVENTURA_STAVKE.ins_id_pk, INVENTURA_STAVKE.ins_in_id_fk, INVENTURA_STAVKE.ins_sir_id_fk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_povratna_naknada,  
					  SIROVINE.si_kategorija_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, SIROVINE.si_grupa_fk, GRUPE_SIROVINA.gs_name, SIROVINE.si_min_kolicina,
                      INVENTURA_STAVKE.ins_sir_stanje_zateceno, INVENTURA_STAVKE.ins_sir_stanje_kasa, INVENTURA_STAVKE.ins_sir_stanje_razlika, 
					  INVENTURA_STAVKE.ins_sir_prosj_nab_cijena, 
					  INVENTURA_STAVKE.ins_fin_stanje_zateceno, INVENTURA_STAVKE.ins_fin_stanje_kasa, INVENTURA_STAVKE.ins_fin_stanje_razlika, INVENTURA_STAVKE.ins_pov_nak_razlika
FROM		INVENTURA_STAVKE LEFT JOIN
                      SIROVINE ON INVENTURA_STAVKE.ins_sir_id_fk = SIROVINE.si_id_pk LEFT JOIN   
					  GRUPE_SIROVINA on SIROVINE.si_grupa_fk=GRUPE_SIROVINA.gs_id_pk LEFT JOIN 
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk 
where		INVENTURA_STAVKE.ins_in_id_fk = @in_id_pk
GO



--
-- Definition for stored procedure Osnovno_Get_SIROVINE : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_SIROVINE]
(
	@si_id_pk int = NULL,
	@si_active_DA bit = null,
	@si_active_NE bit = null,
	@si_type_materijal bit = NULL,
	@si_type_trosak bit = NULL,
	@si_ime nvarchar(20) = NULL
)
AS
SELECT SIROVINE.si_id_pk, SIROVINE.si_type, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_pdv_id_fk, SIROVINE.si_kategorija_fk, SIROVINE.si_min_kolicina, 
                      SIROVINE.si_povratna_naknada, SIROVINE.si_kalo, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, SIROVINE.si_time_inserted, SIROVINE.si_active,
					  GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
FROM   SIROVINE LEFT OUTER JOIN 
       SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
       GRUPE_PDV ON SIROVINE.si_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
       GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
WHERE  
		(@si_id_pk is null or (SIROVINE.si_id_pk = @si_id_pk)) AND 
		(@si_type_materijal is null or (SIROVINE.si_type = 0)) AND 
		(@si_type_trosak is null or (SIROVINE.si_type = 1)) AND 
		(@si_ime is null or (SIROVINE.si_ime = @si_ime)) AND 
		(@si_active_DA is null or (SIROVINE.si_active = 1)) AND
		(@si_active_NE is null or (SIROVINE.si_active = 0)) 
GO


--
-- Definition for stored procedure Osnovno_Get_GRUPE_SIROVINA : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_SIROVINA]
AS
SELECT     GRUPE_SIROVINA.*, SYS_SIROVINE_KATEGORIJE.sysk_name
FROM       GRUPE_SIROVINA LEFT OUTER JOIN
		   SYS_SIROVINE_KATEGORIJE ON GRUPE_SIROVINA.gs_sysk_id_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
GO



--
-- Definition for stored procedure Osnovno_DeleteInfo_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_ARTIKLI]
(
	@ar_id_pk Int
)
AS
SELECT * FROM RACUNI_STAVKE WHERE rs_artikal_id_fk = @ar_id_pk
SELECT * FROM OTVORENI_RACUNI_STAVKE WHERE wkss_artikal_id_fk = @ar_id_pk
SELECT * FROM NORMATIVI WHERE no_article_id_fk = @ar_id_pk
SELECT * FROM NARUDZBE_NAPOMENE_ARTIKLI WHERE ar_id_fk = @ar_id_pk
SELECT * FROM GRUPE_TOUCH_SCREEN_ARTIKLI WHERE ar_id_fk = @ar_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_ARTIKLI_PNP_GRUPA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_ARTIKLI_PNP_GRUPA]
(
	@ar_pnp_fk_current int,
	@ar_pnp_fk_new int
)
as
update ARTIKLI
set ar_pnp_fk = @ar_pnp_fk_new
where ar_pnp_fk = @ar_pnp_fk_current
GO

--
-- Definition for stored procedure Osnovno_Update_ARTIKLI_PDV_GRUPA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_ARTIKLI_PDV_GRUPA]
(
	@ar_pdv_fk_current int,
	@ar_pdv_fk_new int
)
as
update ARTIKLI
set ar_pdv_fk = @ar_pdv_fk_new
where ar_pdv_fk = @ar_pdv_fk_current
GO




--
-- Definition for stored procedure Osnovno_Update_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_ARTIKLI]
(
	@ar_id_pk int,
	@ar_sifra int,
	@ar_type int,
	@ar_naziv nvarchar(50),
	@ar_jmj nvarchar(5),
	@ar_cijena decimal(10, 2),
	@ar_cijena_popust decimal(10, 2),
	@ar_cijena_popust_2 decimal(10, 2),
	@ar_cijena_popust_3 decimal(10, 2),
	@ar_kategorija_fk int,
	@ar_grupa_fk int,
	@ar_pdv_fk int,
	@ar_pnp_fk int,
	@ar_mjesto_izdavanja_fk int,
	@ar_grupa_pica_fk int,
	@ar_description nvarchar(300),
	@ar_is_active bit,
	@ar_barcode nvarchar(30),
	@ar_color_index int,
	@ar_size_index int,
	@ar_index int,
	@ar_kpd_sifra nvarchar(10)
)
as
update
	ARTIKLI
set
	ar_sifra = @ar_sifra,
	ar_type = @ar_type,
	ar_naziv = @ar_naziv,
	ar_jmj = @ar_jmj,
	ar_cijena = @ar_cijena,
	ar_cijena_popust = @ar_cijena_popust,
	ar_cijena_popust_2 = @ar_cijena_popust_2,
	ar_cijena_popust_3 = @ar_cijena_popust_3,
	ar_kategorija_fk = @ar_kategorija_fk,
	ar_grupa_fk = @ar_grupa_fk,
	ar_pdv_fk = @ar_pdv_fk,
	ar_pnp_fk = @ar_pnp_fk,
	ar_mjesto_izdavanja_fk = @ar_mjesto_izdavanja_fk,
	ar_grupa_pica_fk = @ar_grupa_pica_fk, 
	ar_description = @ar_description,
	ar_is_active = @ar_is_active,
	ar_barcode = @ar_barcode,
	ar_color_index = @ar_color_index,
	ar_size_index = @ar_size_index,
	ar_index = @ar_index,
	ar_kpd_sifra = @ar_kpd_sifra
where
	ar_id_pk = @ar_id_pk
GO



--
-- Definition for stored procedure Osnovno_Insert_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_ARTIKLI]
(
	@ar_sifra int,
	@ar_type int,
	@ar_naziv nvarchar(50),
	@ar_jmj nvarchar(5),
	@ar_cijena decimal(10, 2),
	@ar_cijena_popust decimal(10, 2),
	@ar_cijena_popust_2 decimal(10, 2),
	@ar_cijena_popust_3 decimal(10, 2),
	@ar_kategorija_fk int,
	@ar_grupa_fk int,
	@ar_pdv_fk int,
	@ar_pnp_fk int,
	@ar_mjesto_izdavanja_fk int,
	@ar_grupa_pica_fk int,
    @ar_time_inserted DateTime,
	@ar_description nvarchar(300),
	@ar_is_active bit,
	@ar_barcode nvarchar(30),
	@ar_color_index int,
	@ar_size_index int,
	@ar_index int,
	@ar_kpd_sifra nvarchar(10)
)
as
insert into ARTIKLI
	(ar_sifra, ar_type, ar_naziv, ar_jmj, ar_cijena, ar_cijena_popust, ar_cijena_popust_2, ar_cijena_popust_3, ar_kategorija_fk, ar_grupa_fk, ar_pdv_fk, ar_pnp_fk, ar_mjesto_izdavanja_fk, ar_grupa_pica_fk, ar_time_inserted, ar_description, ar_is_active, ar_barcode, ar_color_index, ar_size_index , ar_index, ar_kpd_sifra)
values
	(@ar_sifra, @ar_type, @ar_naziv, @ar_jmj, @ar_cijena, @ar_cijena_popust, @ar_cijena_popust_2, @ar_cijena_popust_3, @ar_kategorija_fk, @ar_grupa_fk, @ar_pdv_fk, @ar_pnp_fk, @ar_mjesto_izdavanja_fk, @ar_grupa_pica_fk, @ar_time_inserted, @ar_description, @ar_is_active, @ar_barcode, @ar_color_index, @ar_size_index, @ar_index, @ar_kpd_sifra)
select scope_identity()
GO




--
-- Definition for stored procedure Osnovno_Update_ARTIKLI_KPD_SIFRA : 
--
CREATE procedure [dbo].[Osnovno_Update_ARTIKLI_KPD_SIFRA]
(
	@ar_id_pk int,
	@ar_kpd_sifra nvarchar(10)
)
as
update ARTIKLI
set ar_kpd_sifra = @ar_kpd_sifra
where ar_id_pk = @ar_id_pk
GO



--
-- Definition for stored procedure Osnovno_DeleteInfo_MJESTA_IZDAVANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_MJESTA_IZDAVANJA]
(
	@mi_id_pk Int
)
AS
SELECT * FROM ARTIKLI WHERE ar_mjesto_izdavanja_fk = @mi_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_GRUPE_PNP : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_GRUPE_PNP]
(
	@gpnp_id_pk Int
)
AS
SELECT * FROM ARTIKLI WHERE ar_pnp_fk = @gpnp_id_pk
SELECT * FROM RACUNI_STAVKE WHERE rs_gpnp_id_fk = @gpnp_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_GRUPE_PDV : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_GRUPE_PDV]
(
	@gpdv_id_pk Int
)
AS
SELECT * FROM ARTIKLI WHERE ar_pdv_fk = @gpdv_id_pk
SELECT * FROM RACUNI_STAVKE WHERE rs_gpdv_id_fk = @gpdv_id_pk
SELECT * FROM PRIMKE_STAVKE WHERE ps_pdv_id_fk = @gpdv_id_pk
SELECT * FROM OTPISI_STAVKE WHERE os_pdv_id_fk = @gpdv_id_pk
SELECT * FROM IZDATNICE_STAVKE WHERE is_pdv_id_fk = @gpdv_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_GRUPE_ARTIKALA]
(
	@ga_id_pk Int
)
AS
SELECT * FROM ARTIKLI WHERE ar_grupa_fk = @ga_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_ARTIKLI]
(
	@ar_id_pk int
)
as

delete from NORMATIVI where no_article_id_fk = @ar_id_pk
delete from NARUDZBE_NAPOMENE_ARTIKLI where ar_id_fk = @ar_id_pk
delete from GRUPE_TOUCH_SCREEN_ARTIKLI where ar_id_fk = @ar_id_pk

delete ARTIKLI where ar_id_pk = @ar_id_pk
GO


--
-- Definition for stored procedure Management_Get_NARUDZBE_UTROSAK_SIROVINE : 
--
GO
CREATE procedure [dbo].[Management_Get_NARUDZBE_UTROSAK_SIROVINE]
(
	@day_start datetime,
	@day_end datetime,
	@Action_Type nvarchar(15) = null,
	@ns_mi_id_fk int = null,
	@nz_kasa_id_fk int = null,
	@nz_konobar_id_fk int = null,
	@nz_stol_id_fk int = null,
	@Sirovina_Kategorija_ID int = null,
	@Sirovina_Grupa_ID int = null,
	@KonobarID int = null,
	@StolID int = null,
	@KasaID int = null
)
AS
BEGIN
	SELECT SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, 
		   SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name,
           SUM(NARUDZBE_STAVKE.ns_kolicina * NORMATIVI.no_kolicina) AS KOLICINA
	FROM NARUDZBE_ZAGLAVLJE LEFT OUTER JOIN
           NARUDZBE_STAVKE ON NARUDZBE_ZAGLAVLJE.nz_id_pk = NARUDZBE_STAVKE.ns_nz_id_fk LEFT OUTER JOIN
           ARTIKLI ON NARUDZBE_STAVKE.ns_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
           NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
           SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
           SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
		   GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
	WHERE (NARUDZBE_ZAGLAVLJE.nz_dan between  @day_start and @day_end) AND 
		(@ns_mi_id_fk is null or (NARUDZBE_STAVKE.ns_mi_id_fk = @ns_mi_id_fk)) AND 
		(@nz_kasa_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk = @nz_kasa_id_fk)) AND
		(@nz_konobar_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk = @nz_konobar_id_fk)) AND
		(@nz_stol_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_stol_id_fk = @nz_stol_id_fk)) AND 
		(@Sirovina_Kategorija_ID is null or (SIROVINE.si_kategorija_fk = @Sirovina_Kategorija_ID)) AND
		(@Sirovina_Grupa_ID is null or (SIROVINE.si_grupa_fk = @Sirovina_Grupa_ID))  AND
		(@KonobarID is null or (NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk = @KonobarID)) AND
		(@KasaID is null or (NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk = @KasaID)) AND
		(@StolID is null or (NARUDZBE_ZAGLAVLJE.nz_stol_id_fk = @StolID)) AND
		(@Action_Type is null or (NARUDZBE_ZAGLAVLJE.nz_action_type = @Action_Type))
	GROUP BY  SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name
END
GO



--
-- Definition for stored procedure Management_Get_NARUDZBE_UTROSAK_SIROVINE_NARUDZBE_RACUNI : 
--
GO
CREATE procedure [dbo].[Management_Get_NARUDZBE_UTROSAK_SIROVINE_NARUDZBE_RACUNI]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
	-- UTROSAK PO NARUDZBAMA
	SELECT SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name,
           SUM(NARUDZBE_STAVKE.ns_kolicina * NORMATIVI.no_kolicina) AS KOLICINA
	FROM NARUDZBE_ZAGLAVLJE LEFT OUTER JOIN
           NARUDZBE_STAVKE ON NARUDZBE_ZAGLAVLJE.nz_id_pk = NARUDZBE_STAVKE.ns_nz_id_fk LEFT OUTER JOIN
           ARTIKLI ON NARUDZBE_STAVKE.ns_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
           NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
           SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
           SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
		   GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
	WHERE (NARUDZBE_ZAGLAVLJE.nz_dan between  @day_start and @day_end)
	GROUP BY  SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name
	-- UTROSAK PO RACUNIMA
	SELECT SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, 
           SUM(RACUNI_STAVKE.rs_kolicina * NORMATIVI.no_kolicina) AS KOLICINA
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
           RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
           ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
           NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
           SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
           SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
		   GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY  SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name
END
GO

--
-- Definition for stored procedure Management_Get_KONZUMACIJA_UTROSAK_SIROVINE : 
--
GO
CREATE procedure [dbo].[Management_Get_KONZUMACIJA_UTROSAK_SIROVINE]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
	SELECT SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, 
           SUM(KONZUMACIJA_STAVKE.kzs_kolicina * NORMATIVI.no_kolicina) AS KOLICINA
	FROM KONZUMACIJA_ZAGLAVLJE LEFT OUTER JOIN
           KONZUMACIJA_STAVKE ON KONZUMACIJA_ZAGLAVLJE.kzz_id_pk = KONZUMACIJA_STAVKE.kzs_kzz_id_fk LEFT OUTER JOIN
           ARTIKLI ON KONZUMACIJA_STAVKE.kzs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
           NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
           SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
           SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE (KONZUMACIJA_ZAGLAVLJE.kzz_nadnevak between  @day_start and @day_end)
	GROUP BY  SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SYS_SIROVINE_KATEGORIJE.sysk_name
END
GO

--
-- Definition for stored procedure Izvjesca_Get_TOP_LISTA_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_TOP_LISTA_ARTIKALA]
(
	@topNr int
)
AS
BEGIN
	SELECT TOP (@topNr) ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina
	FROM RACUNI_STAVKE LEFT OUTER JOIN
                      ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk
	GROUP BY ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv 
	ORDER BY Kolicina DESC
END
GO

--
-- Definition for stored procedure Osnovno_Update_MJESTA_IZDAVANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_MJESTA_IZDAVANJA]
(
	@mi_id_pk int,
	@mi_oznaka nvarchar(20),
	@mi_note nvarchar(20),
	@mi_vezano bit,
	@mi_vezano_ispis bit
)
as
update
	MJESTA_IZDAVANJA
set
	mi_oznaka = @mi_oznaka,
	mi_note = @mi_note,
	mi_vezano = @mi_vezano,
	mi_vezano_ispis = @mi_vezano_ispis
where
	mi_id_pk = @mi_id_pk
GO


--
-- Definition for stored procedure Osnovno_Insert_MJESTA_IZDAVANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_MJESTA_IZDAVANJA]
(
	@mi_oznaka nvarchar(20),
	@mi_note nvarchar(20),
	@mi_vezano bit,
	@mi_vezano_ispis bit

)
as
insert into MJESTA_IZDAVANJA
	(mi_oznaka, mi_note, mi_vezano, mi_vezano_ispis)
values
	(@mi_oznaka, @mi_note, @mi_vezano, @mi_vezano_ispis)
select scope_identity()


--
-- Definition for stored procedure Osnovno_Get_MJESTA_IZDAVANJA : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_MJESTA_IZDAVANJA]
AS
Select * from MJESTA_IZDAVANJA
GO

--
-- Definition for stored procedure Osnovno_Delete_MJESTA_IZDAVANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_MJESTA_IZDAVANJA]
(
	@mi_id_pk int
)
as

UPDATE ARTIKLI set ar_mjesto_izdavanja_fk = null where ar_mjesto_izdavanja_fk = @mi_id_pk

DELETE MJESTA_IZDAVANJA where mi_id_pk = @mi_id_pk
GO




--
-- Definition for stored procedure Osnovno_Update_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_ARTIKALA]
(
	@ga_id_pk int,
	@ga_name nvarchar(20),
	@ga_order_index int,
	@ga_syak_id_fk int
)
as
update
	GRUPE_ARTIKALA
set
	ga_name = @ga_name,
	ga_order_index = @ga_order_index,
	ga_syak_id_fk = @ga_syak_id_fk
where
	ga_id_pk = @ga_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_ARTIKALA]
(
	@ga_name nvarchar(20),
	@ga_order_index int,
	@ga_syak_id_fk int
)
as
insert into GRUPE_ARTIKALA
	(ga_name, ga_order_index, ga_syak_id_fk)
values
	(@ga_name, @ga_order_index, @ga_syak_id_fk)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_ARTIKALA : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_GRUPE_ARTIKALA]
(
	@ga_id_pk int
)
as

UPDATE ARTIKLI set ar_grupa_fk = null where ar_grupa_fk = @ga_id_pk

delete GRUPE_ARTIKALA where ga_id_pk = @ga_id_pk
GO

--
-- Definition for stored procedure System_Get_SYS_PICE_KATEGORIJE : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_PICE_KATEGORIJE]
AS
Select * from SYS_PICE_KATEGORIJE
GO

--
-- Definition for stored procedure System_Get_SYS_ARTIKLI_KATEGORIJE : 
--
GO
CREATE PROCEDURE [dbo].[System_Get_SYS_ARTIKLI_KATEGORIJE]
AS
Select * from SYS_ARTIKLI_KATEGORIJE
GO



--
-- Definition for stored procedure Osnovno_Get_GRUPE_ARTIKALA : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_ARTIKALA]
AS
BEGIN
SELECT     GRUPE_ARTIKALA.*, SYS_ARTIKLI_KATEGORIJE.syak_name
FROM         GRUPE_ARTIKALA LEFT OUTER JOIN
             SYS_ARTIKLI_KATEGORIJE ON GRUPE_ARTIKALA.ga_syak_id_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk
END
GO



--
-- Definition for stored procedure Management_Get_NARUDZBE_PRODANI_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Management_Get_NARUDZBE_PRODANI_ARTIKLI]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@Action_Type nvarchar(15) = null,
	@ns_mi_id_fk int = null,
	@nz_kasa_id_fk int = null,
	@nz_konobar_id_fk int = null,
	@nz_stol_id_fk int = null,
	@Artikal_Kategorija_ID int = null,
	@Artikal_Grupa_ID int = null,
	@KonobarID int = null,
	@StolID int = null,
	@KasaID int = null
)
AS
SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, 
		SUM(NARUDZBE_STAVKE.ns_iznos) AS Total, SUM(NARUDZBE_STAVKE.ns_kolicina) AS Kolicina, 
		ARTIKLI.ar_kategorija_fk, NARUDZBE_STAVKE.ns_ar_cijena, 
		SYS_ARTIKLI_KATEGORIJE.syak_name, GRUPE_ARTIKALA.ga_name
FROM NARUDZBE_ZAGLAVLJE LEFT OUTER JOIN
		NARUDZBE_STAVKE ON NARUDZBE_ZAGLAVLJE.nz_id_pk = NARUDZBE_STAVKE.ns_nz_id_fk INNER JOIN
		ARTIKLI ON NARUDZBE_STAVKE.ns_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
		SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT OUTER JOIN
		GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk
WHERE (NARUDZBE_ZAGLAVLJE.nz_dan between @day_start and @day_end) AND 
		(@ns_mi_id_fk is null or (NARUDZBE_STAVKE.ns_mi_id_fk = @ns_mi_id_fk)) AND 
		(@nz_kasa_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk = @nz_kasa_id_fk)) AND
		(@nz_konobar_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk = @nz_konobar_id_fk)) AND
		(@nz_stol_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_stol_id_fk = @nz_stol_id_fk)) AND 
		(@Artikal_Kategorija_ID is null or (ARTIKLI.ar_kategorija_fk = @Artikal_Kategorija_ID)) AND
		(@Artikal_Grupa_ID is null or (ARTIKLI.ar_grupa_fk = @Artikal_Grupa_ID))  AND
		(@KonobarID is null or (NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk = @KonobarID)) AND
		(@KasaID is null or (NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk = @KasaID)) AND
		(@StolID is null or (NARUDZBE_ZAGLAVLJE.nz_stol_id_fk = @StolID)) AND
		(@Action_Type is null or (NARUDZBE_ZAGLAVLJE.nz_action_type = @Action_Type))
GROUP BY ARTIKLI.ar_kategorija_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, 
		NARUDZBE_STAVKE.ns_ar_cijena, SYS_ARTIKLI_KATEGORIJE.syak_name, GRUPE_ARTIKALA.ga_name
GO


--
-- Definition for stored procedure Management_Get_KONZUMACIJA_PRODANI_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Management_Get_KONZUMACIJA_PRODANI_ARTIKLI]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@kzz_konobar_id_fk int = null,
	@kzz_stol_id_fk int = null
)
AS
SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, 
		SUM(KONZUMACIJA_STAVKE.kzs_iznos) AS Total, SUM(KONZUMACIJA_STAVKE.kzs_kolicina) AS Kolicina, 
		ARTIKLI.ar_kategorija_fk, KONZUMACIJA_STAVKE.kzs_cijena, 
		SYS_ARTIKLI_KATEGORIJE.syak_name
FROM KONZUMACIJA_ZAGLAVLJE LEFT OUTER JOIN
		KONZUMACIJA_STAVKE ON KONZUMACIJA_ZAGLAVLJE.kzz_id_pk = KONZUMACIJA_STAVKE.kzs_kzz_id_fk INNER JOIN
		ARTIKLI ON KONZUMACIJA_STAVKE.kzs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
		SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk
WHERE (KONZUMACIJA_ZAGLAVLJE.kzz_nadnevak between @day_start and @day_end) AND 
		(@kzz_konobar_id_fk is null or (KONZUMACIJA_ZAGLAVLJE.kzz_konobar_id_fk = @kzz_konobar_id_fk)) AND
		(@kzz_stol_id_fk is null or (KONZUMACIJA_ZAGLAVLJE.kzz_stol_id_fk = @kzz_stol_id_fk))
GROUP BY ARTIKLI.ar_kategorija_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, SYS_ARTIKLI_KATEGORIJE.syak_name, KONZUMACIJA_STAVKE.kzs_cijena
GO

--
-- Definition for stored procedure Osnovno_Update_GRUPE_PNP : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_PNP]
(
	@gpnp_id_pk int,
	@gpnp_name nvarchar(20),
	@gpnp_postotak decimal(6, 2)
)
as
update
	GRUPE_PNP
set
	gpnp_name = @gpnp_name,
	gpnp_postotak = @gpnp_postotak
where
	gpnp_id_pk = @gpnp_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_PNP : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_PNP]
(
	@gpnp_name nvarchar(20),
	@gpnp_postotak decimal(6, 2)
)
as
insert into GRUPE_PNP
	(gpnp_name, gpnp_postotak)
values
	(@gpnp_name, @gpnp_postotak)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_GRUPE_PNP : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_PNP]
AS
Select * from GRUPE_PNP
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_PNP : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_PNP]
(
@gpnp_id_pk int
)
AS
delete GRUPE_PNP where gpnp_id_pk = @gpnp_id_pk
GO

--
-- Definition for stored procedure Skladiste_Get_STANJE_SKLADISTA_KOLICINE : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_STANJE_SKLADISTA_KOLICINE]
(
	@dateStart datetime,
	@dateEnd datetime
)
AS
BEGIN
	SELECT SIROVINE.si_id_pk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, SIROVINE.si_min_kolicina, 
			SIROVINE.si_time_inserted, GRUPE_SIROVINA.gs_name, SYS_SIROVINE_KATEGORIJE.sysk_name
	FROM SIROVINE LEFT OUTER JOIN
			GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT OUTER JOIN
			SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE SIROVINE.si_active = 1
	
	SELECT SUM(PRIMKE_STAVKE.ps_si_nabavljena_kolicina) AS PrimkeKolicina, PRIMKE_STAVKE.ps_si_id_fk
	FROM PRIMKE_ZAGLAVLJE INNER JOIN
			PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk
	WHERE(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @dateStart AND @dateEnd) AND (PRIMKE_ZAGLAVLJE.pr_proknjizeno = 1)
	GROUP BY PRIMKE_STAVKE.ps_si_id_fk

	SELECT SUM(IZDATNICE_STAVKE.is_kolicina) AS IzdatniceKolicina, IZDATNICE_STAVKE.is_si_id_fk
	FROM IZDATNICE_ZAGLAVLJE INNER JOIN
			IZDATNICE_STAVKE ON IZDATNICE_ZAGLAVLJE.iz_id_pk = IZDATNICE_STAVKE.is_iz_id_fk
	WHERE (IZDATNICE_ZAGLAVLJE.iz_datum BETWEEN @dateStart AND @dateEnd) AND (IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 1)
	GROUP BY IZDATNICE_STAVKE.is_si_id_fk

	SELECT SUM(OTPISI_STAVKE.os_si_kolicina) AS OtpisiKolicina, OTPISI_STAVKE.os_si_id_fk
	FROM OTPISI_ZAGLAVLJE INNER JOIN
			OTPISI_STAVKE ON OTPISI_ZAGLAVLJE.ot_id_pk = OTPISI_STAVKE.os_ot_id_fk
	WHERE (OTPISI_ZAGLAVLJE.ot_datum BETWEEN @dateStart AND @dateEnd) AND (OTPISI_ZAGLAVLJE.ot_proknjizeno = 1)
	GROUP BY OTPISI_STAVKE.os_si_id_fk

	SELECT SUM(NORMATIVI.no_kolicina * RACUNI_STAVKE.rs_kolicina) AS UtrosakKolicina, SIROVINE.si_id_pk
	FROM RACUNI_ZAGLAVLJE INNER JOIN
		RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
		ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
		NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
		SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_vrijeme BETWEEN @dateStart AND @dateEnd)
	GROUP BY SIROVINE.si_id_pk

	SELECT SUM(INVENTURA_STAVKE.ins_sir_stanje_razlika) AS InventuraKolicina, INVENTURA_STAVKE.ins_sir_id_fk
	FROM INVENTURA_ZAGLAVLJE INNER JOIN
			INVENTURA_STAVKE ON INVENTURA_ZAGLAVLJE.in_id_pk = INVENTURA_STAVKE.ins_in_id_fk
	WHERE (INVENTURA_ZAGLAVLJE.in_nadnevak BETWEEN @dateStart AND @dateEnd) AND (INVENTURA_ZAGLAVLJE.in_knjizenje = 1) AND (INVENTURA_ZAGLAVLJE.in_proknjizeno = 1)
	GROUP BY INVENTURA_STAVKE.ins_sir_id_fk
END
GO


--
-- Definition for stored procedure Pregledi_Get_RACUNI_NEPOTPISANI_COUNT : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUNI_NEPOTPISANI_COUNT]
(
	@Nefisk_Racuni_Count AS INT OUTPUT,
	@Nefisk_Top_Vrijeme AS DATETIME OUTPUT,
	@Nefisk_Napojnice_Count AS INT OUTPUT,
	@Nefisk_Napojnice_Top_Vrijeme AS DATETIME OUTPUT,
	@Nefisk_ERacun_Count AS INT OUTPUT,
	@Nefisk_ERacun_Top_Vrijeme AS DATETIME OUTPUT
)
AS
BEGIN
	SELECT	@Nefisk_Racuni_Count =count(distinct TBL.rz_id_pk), @Nefisk_Top_Vrijeme = min(TBL.rz_vrijeme)
	FROM	
		(SELECT * FROM dbo.RACUNI_ZAGLAVLJE WHERE (RACUNI_ZAGLAVLJE.rz_fis_type = 1 AND RACUNI_ZAGLAVLJE.rz_fis_jir is null)) AS TBL
	SELECT	@Nefisk_Napojnice_Count = count(distinct TBL.rz_id_pk), @Nefisk_Napojnice_Top_Vrijeme = min(TBL.rz_vrijeme)
	FROM	
		(SELECT * FROM dbo.RACUNI_ZAGLAVLJE WHERE (RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0 and RACUNI_ZAGLAVLJE.rz_vrijeme>= DATEADD(HOUR, -48, GETDATE()))) AS TBL
 	SELECT	@Nefisk_ERacun_Count =count(distinct TBL.rz_id_pk), @Nefisk_ERacun_Top_Vrijeme = min(TBL.rz_vrijeme)
	FROM	
		(SELECT * FROM dbo.RACUNI_ZAGLAVLJE WHERE (RACUNI_ZAGLAVLJE.rz_fis_type = 2 AND RACUNI_ZAGLAVLJE.rz_fis2_id is null)) AS TBL
END
GO


--
-- Definition for stored procedure Osnovno_DeleteInfo_STOLOVI : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_STOLOVI]
(
	@st_id_pk Int
)
AS
SELECT * FROM RACUNI_ZAGLAVLJE WHERE rz_stol_id_fk = @st_id_pk
SELECT * FROM OTVORENI_RACUNI_ZAGLAVLJE WHERE wks_stol_id_fk = @st_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_NARUCITELJI]
(
	@na_id_pk Int
)
AS
SELECT * FROM RACUNI_ZAGLAVLJE WHERE rz_narucitelj_id_fk = @na_id_pk
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_KONOBAR : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_KONOBAR]
(
	@kn_id_pk Int
)
AS
SELECT * FROM RACUNI_ZAGLAVLJE WHERE rz_konobar_id_fk = @kn_id_pk
SELECT * FROM OTVORENI_RACUNI_ZAGLAVLJE WHERE wks_konobar_id_fk = @kn_id_pk
GO


--
-- Definition for stored procedure Management_Update_RACUN_OSOBA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_OSOBA]
(
    @rz_id_pk int,
    @rz_narucitelj_id_fk int
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_narucitelj_id_fk = @rz_narucitelj_id_fk
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_NAPOMENA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_NAPOMENA]
(
    @rz_id_pk int,
    @rz_napomena nvarchar(200)
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_napomena = @rz_napomena
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_ARCHIVE_POVEZNICA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_ARCHIVE_POVEZNICA]
(
    @rz_id_pk int,
    @rz_fis_racun_source_id int
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_fis_racun_source_id = @rz_fis_racun_source_id
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_TVRTKA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_TVRTKA]
(
	@rz_id_pk int,
	@rz_tvrtka_id_fk int
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_tvrtka_id_fk = @rz_tvrtka_id_fk
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Management_Update_RACUN_DATUM_DOSPIJECA : 
--
GO
CREATE procedure [dbo].[Management_Update_RACUN_DATUM_DOSPIJECA]
(
	@rz_id_pk int,
	@rz_datum_dospijeca datetime
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_datum_dospijeca = @rz_datum_dospijeca
where
	rz_id_pk = @rz_id_pk
GO

--
-- Definition for stored procedure Konobar_Update_RACUN_FISKAL_ZKI : 
--
GO
CREATE procedure [dbo].[Konobar_Update_RACUN_FISKAL_ZKI]
(
	@rz_id_pk int,
	@rz_fis_zastitni_kod nvarchar(50)
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_fis_zastitni_kod = @rz_fis_zastitni_kod
where
	rz_id_pk = @rz_id_pk
GO




--
-- Definition for stored procedure Konobar_Update_RACUN_FISKAL_NAPOJNICA : 
--
GO
CREATE procedure [dbo].[Konobar_Update_RACUN_FISKAL_NAPOJNICA]
(
	@rz_id_pk int,
    @rz_fis_nap_uuid nvarchar(50),
	@rz_fis_nap_vrijeme_slanja datetime, 
	@rz_fis_nap_vrijeme_obrade datetime,
    @rz_fis_nap_iznos decimal(12,2),
	@rz_fis_nap_pl_id_fk int,
	@rz_fis_nap_naknadna_dostava bit, 
	@rz_fis_nap_fiskalizirano bit, 
	@rz_fis_nap_np nvarchar(1)
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_fis_nap_uuid = @rz_fis_nap_uuid,
	rz_fis_nap_vrijeme_slanja = @rz_fis_nap_vrijeme_slanja, 
	rz_fis_nap_vrijeme_obrade = @rz_fis_nap_vrijeme_obrade, 
	rz_fis_nap_iznos = @rz_fis_nap_iznos, 
	rz_fis_nap_pl_id_fk = @rz_fis_nap_pl_id_fk,  
	rz_fis_nap_naknadna_dostava = @rz_fis_nap_naknadna_dostava, 
	rz_fis_nap_fiskalizirano = @rz_fis_nap_fiskalizirano, 
	rz_fis_nap_np = @rz_fis_nap_np
where
	rz_id_pk = @rz_id_pk
GO




--
-- Definition for stored procedure Konobar_Update_RACUN_FISKAL : 
--
GO
CREATE procedure [dbo].[Konobar_Update_RACUN_FISKAL]
(
	@rz_id_pk int,
    @rz_fis_uuid nvarchar(50),
	@rz_fis_vrijeme_slanja datetime, 
	@rz_fis_vrijeme_obrade datetime,
	@rz_fis_jir nvarchar(50), 
	@rz_fis_paragon_broj nvarchar(50),  
	@rz_fis_naknadna_dostava bit, 
	@rz_fis_storno_sign nvarchar(1), 
	@rz_fis_racun_source_id int,
	@rz_fis_np nvarchar(1)
)
as
update
	RACUNI_ZAGLAVLJE
set
    rz_fis_uuid = @rz_fis_uuid,
	rz_fis_vrijeme_slanja = @rz_fis_vrijeme_slanja, 
	rz_fis_vrijeme_obrade = @rz_fis_vrijeme_obrade, 
	rz_fis_jir = @rz_fis_jir, 
	rz_fis_paragon_broj = @rz_fis_paragon_broj,  
	rz_fis_naknadna_dostava = @rz_fis_naknadna_dostava, 
	rz_fis_storno_sign = @rz_fis_storno_sign, 
	rz_fis_racun_source_id = @rz_fis_racun_source_id,
	rz_fis_np = @rz_fis_np
where
	rz_id_pk = @rz_id_pk
GO



--
-- Definition for stored procedure Konobar_Insert_RACUN_ALL : 
--
GO
CREATE procedure [dbo].[Konobar_Insert_RACUN_ALL]
(
	@RetVal_BillNr int output,
	@RetVal_BillNrFull nvarchar(50) output,
	@RetVal_ID int output,
	@rz_vrijeme datetime,
	@rz_day datetime,
	@rz_kasa_id_fk int,
	@rz_konobar_id_fk int,
	@rz_stol_id_fk int,
	@rz_placanje_id_fk int,
	@rz_iznos decimal(10, 2),
	@rz_pdv decimal(10, 2),
	@rz_pnp decimal(10, 2),
	@rz_popust decimal(10, 2),
	@rz_iznos_bez_popusta decimal(10, 2),
	@rz_tvrtka_id_fk int,
	@rz_narucitelj_id_fk int,
	@rz_datum_dospijeca datetime,
	@rz_nadnevak_isporuke datetime,
	@rz_napomena nvarchar(200),
    @rz_fis_uuid nvarchar(50),
    @rz_fis_zastitni_kod nvarchar(50),
	@rz_fis_vrijeme_slanja datetime, 
	@rz_fis_vrijeme_obrade datetime, 
	@rz_fis_jir nvarchar(50), 
	@rz_fis_paragon_broj nvarchar(50),  
	@rz_fis_ozn_pos_pros nvarchar(50), 
	@rz_fis_ozn_nap_uredaja nvarchar(50), 
	@rz_fis_naknadna_dostava bit, 
	@rz_fis_storno_sign nvarchar(1), 
	@rz_fis_racun_source_id int,
	@rz_fis_np nvarchar(1),
	@rz_pl_1_id_fk int,
	@rz_pl_1_iznos decimal(10, 2),
	@rz_pl_2_id_fk int,
	@rz_pl_2_iznos decimal(10, 2),
	@rz_pl_3_id_fk int,
	@rz_pl_3_iznos decimal(10, 2),
    @rz_fis_nap_uuid nvarchar(50),
	@rz_fis_nap_vrijeme_slanja datetime, 
	@rz_fis_nap_vrijeme_obrade datetime, 
	@rz_fis_nap_iznos decimal(12, 2),
	@rz_fis_nap_pl_id_fk int,
	@rz_fis_nap_np nvarchar(1),
	@rz_fis_nap_fiskalizirano bit,
	@rz_fis_nap_naknadna_dostava bit,
	@rz_fis2_id nvarchar(12),
	@rz_fis2_posrednik nvarchar(15),
	@rz_fis2_br_narudzbenice nvarchar(30),
	@rz_fis_type int,
   --------------------------------
   	@Stavke_DTable BPOStype_DTable_RACUNI_STAVKE READONLY
    --------------------------------
)
AS
BEGIN
BEGIN TRAN
	-----------------
	SELECT @RetVal_BillNr = MAX(rz_broj) from RACUNI_ZAGLAVLJE
	IF @RetVal_BillNr IS null SET @RetVal_BillNr = 1 ELSE SET @RetVal_BillNr = @RetVal_BillNr + 1
	SET @RetVal_BillNrFull = CAST(@RetVal_BillNr AS VARCHAR) + '-' + @rz_fis_ozn_pos_pros + '-' + @rz_fis_ozn_nap_uredaja
	-----------------
	insert into RACUNI_ZAGLAVLJE 
		(rz_broj, rz_vrijeme, rz_kasa_id_fk, rz_konobar_id_fk, rz_stol_id_fk, rz_placanje_id_fk, rz_iznos, rz_pdv, rz_pnp, rz_popust, rz_iznos_bez_popusta, rz_tvrtka_id_fk, rz_narucitelj_id_fk, rz_dan,rz_broj_full, rz_datum_dospijeca, rz_nadnevak_isporuke, rz_napomena, rz_fis_uuid, rz_fis_zastitni_kod, rz_fis_vrijeme_slanja, rz_fis_vrijeme_obrade, rz_fis_jir, rz_fis_paragon_broj, rz_fis_ozn_pos_pros, rz_fis_ozn_nap_uredaja, rz_fis_naknadna_dostava, rz_fis_storno_sign, rz_fis_racun_source_id, rz_fis_np, rz_pl_1_id_fk, rz_pl_1_iznos, rz_pl_2_id_fk, rz_pl_2_iznos, rz_pl_3_id_fk, rz_pl_3_iznos, rz_fis_nap_uuid, rz_fis_nap_vrijeme_slanja, rz_fis_nap_vrijeme_obrade, rz_fis_nap_iznos, rz_fis_nap_pl_id_fk, rz_fis_nap_np, rz_fis_nap_fiskalizirano, rz_fis_nap_naknadna_dostava, rz_fis2_id, rz_fis2_posrednik, rz_fis2_br_narudzbenice, rz_fis_type)
	values
		(@RetVal_BillNr, @rz_vrijeme, @rz_kasa_id_fk, @rz_konobar_id_fk, @rz_stol_id_fk, @rz_placanje_id_fk, @rz_iznos, @rz_pdv, @rz_pnp, @rz_popust, @rz_iznos_bez_popusta, @rz_tvrtka_id_fk, @rz_narucitelj_id_fk, @rz_day, @RetVal_BillNrFull, @rz_datum_dospijeca, @rz_nadnevak_isporuke, @rz_napomena, @rz_fis_uuid, @rz_fis_zastitni_kod, @rz_fis_vrijeme_slanja, @rz_fis_vrijeme_obrade, @rz_fis_jir, @rz_fis_paragon_broj, @rz_fis_ozn_pos_pros, @rz_fis_ozn_nap_uredaja, @rz_fis_naknadna_dostava, @rz_fis_storno_sign, @rz_fis_racun_source_id, @rz_fis_np, @rz_pl_1_id_fk, @rz_pl_1_iznos, @rz_pl_2_id_fk, @rz_pl_2_iznos, @rz_pl_3_id_fk, @rz_pl_3_iznos, @rz_fis_nap_uuid, @rz_fis_nap_vrijeme_slanja, @rz_fis_nap_vrijeme_obrade, @rz_fis_nap_iznos, @rz_fis_nap_pl_id_fk, @rz_fis_nap_np, @rz_fis_nap_fiskalizirano, @rz_fis_nap_naknadna_dostava, @rz_fis2_id, @rz_fis2_posrednik, @rz_fis2_br_narudzbenice, @rz_fis_type)
	SET @RetVal_ID = @@IDENTITY
	------------ STAVKE ----------
	INSERT INTO RACUNI_STAVKE
		(rs_racun_id_fk, rs_artikal_id_fk, 
		rs_cijena_bez_popusta, rs_cijena, rs_kolicina,
		rs_iznos_bez_popusta, rs_iznos, 
		rs_pdv, rs_pnp, 
		rs_gpdv_id_fk, rs_gpnp_id_fk, 
		rs_narudzba_napomena, rs_popust)
	SELECT 
		@RetVal_ID, rs_artikal_id_fk, 
		rs_cijena_bez_popusta, rs_cijena, rs_kolicina,
		rs_iznos_bez_popusta, rs_iznos, 
		rs_pdv, rs_pnp, 
		rs_gpdv_id_fk, rs_gpnp_id_fk, 
		rs_narudzba_napomena, rs_popust
	FROM @Stavke_DTable

COMMIT
END
GO


--
-- Definition for stored procedure Izvjesca_Get_PRODAJA_ARTIKALA_PO_SATIMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODAJA_ARTIKALA_PO_SATIMA]
(
	@day_start datetime,
	@day_end datetime
)
AS

SELECT	sum(rz_iznos) as Total, count(distinct RACUNI_ZAGLAVLJE.rz_id_pk ) as BR_RACUNA, datepart(HH,rz_vrijeme) as Hour
FROM	RACUNI_ZAGLAVLJE
WHERE rz_dan BETWEEN @day_start and @day_end
group by  datepart(HH,rz_vrijeme)
order by datepart(HH,rz_vrijeme)
GO

--
-- Definition for stored procedure Osnovno_Update_TERASE_STOLOVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_TERASE_STOLOVI]
(
	@st_id_pk int,
	@ts_id_fk int,
	@st_pos_x int,
	@st_pos_y int
)
as

update
	STOLOVI
set
	ts_id_fk = @ts_id_fk,
	st_pos_x = @st_pos_x,
	st_pos_y = @st_pos_y
where
	st_id_pk = @st_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_STOLOVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_STOLOVI]
(
	@st_id_pk int,
	@st_name int,
	@st_description nvarchar(20),
	@st_shape_id int
)
as
update
	STOLOVI
set
	st_name = @st_name,
	st_description = @st_description,
	st_shape_id = @st_shape_id
where
	st_id_pk = @st_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_STOLOVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_STOLOVI]
(
	@st_name int,
	@st_description nvarchar(20),
	@st_shape_id int
)
as
insert into STOLOVI
	(st_name, st_description, st_shape_id)
values
	(@st_name, @st_description, @st_shape_id)
select scope_identity()
GO



--
-- Definition for stored procedure Osnovno_Get_STOLOVI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_STOLOVI]
(
	@st_name int = NULL,
	@bez_terase bit = NULL
)
AS
Select * from STOLOVI
where 
	(@st_name is null or (STOLOVI.st_name = @st_name)) AND
	(@bez_terase is null or (STOLOVI.ts_id_fk is null))
GO

--
-- Definition for stored procedure Osnovno_DeleteInfo_TERASE : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_TERASE]
(
	@ts_id_pk Int
)
AS
SELECT * FROM STOLOVI WHERE ts_id_fk = @ts_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_STOLOVI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_STOLOVI]
(
	@st_id_pk int
)
as
delete STOLOVI where st_id_pk = @st_id_pk
GO



--
-- Definition for stored procedure Osnovno_Delete_STOLOVI_FROM_TERASE : 
--
CREATE procedure [dbo].[Osnovno_Delete_STOLOVI_FROM_TERASE]
as
update STOLOVI set ts_id_fk = NULL
update STOLOVI set st_pos_x = NULL
update STOLOVI set st_pos_y = NULL
GO


--
-- Definition for stored procedure Management_Get_RESERVATION_FREE_TABLES_BY_DAY : 
--
GO
CREATE PROCEDURE [dbo].[Management_Get_RESERVATION_FREE_TABLES_BY_DAY]
(
	@rzz_date datetime
)
AS
BEGIN
select * from STOLOVI where st_id_pk not in 
	(SELECT rzz_st_id_fk FROM  RESERVATION_ZAGLAVLJE where rzz_date=@rzz_date)
END
GO

--
-- Definition for stored procedure Osnovno_Update_TERASE : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_TERASE]
(
	@ts_id_pk int,
	@ts_name nvarchar(20),
	@ts_active bit
)
as
update
	TERASE
set
	ts_name = @ts_name,
	ts_active = @ts_active
where
	ts_id_pk = @ts_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_TERASE : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_TERASE]
(
	@ts_name nvarchar(20),
	@ts_active bit
)
as
insert into TERASE
	( ts_name, ts_active)
values
	( @ts_name, @ts_active)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_TERASE_STOLOVI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_TERASE_STOLOVI]
AS

SELECT * from TERASE where not ts_active=0

SELECT * from STOLOVI
GO

--
-- Definition for stored procedure Osnovno_Get_TERASE : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_TERASE]
AS
SELECT TERASE.ts_id_pk, TERASE.ts_name, CASE WHEN ts_active =0 THEN 'NE' ELSE 'DA' END AS ts_active_str ,TERASE.ts_active
from TERASE
GO

--
-- Definition for stored procedure Osnovno_Delete_TERASE : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_TERASE]
(
@ts_id_pk int
)
AS

UPDATE STOLOVI set ts_id_fk = null where ts_id_fk = @ts_id_pk

delete TERASE where ts_id_pk = @ts_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NARUCITELJI]
(
	@na_id_pk int,
	@na_ime nvarchar(25),
	@na_oib nvarchar(15),
	@na_tvrtka_fk int,
	@na_djelatno_mjesto nvarchar(20),
	@na_tel_u_tvrtci nvarchar(15),
	@na_tel nvarchar(15),
	@na_mob nvarchar(15),
	@na_kucna_adresa nvarchar(25),
	@na_mjesto nvarchar(25),
	@na_biljeska nvarchar(40),
	@na_kartica nvarchar(25),
	@na_popust decimal(5,2)
)
as
update
	NARUCITELJI
set
	na_ime = @na_ime,
	na_oib = @na_oib,
	na_tvrtka_fk = @na_tvrtka_fk,
	na_djelatno_mjesto = @na_djelatno_mjesto,
	na_tel_u_tvrtci = @na_tel_u_tvrtci,
	na_tel = @na_tel,
	na_mob = @na_mob,
	na_kucna_adresa = @na_kucna_adresa,
	na_mjesto = @na_mjesto,
	na_biljeska = @na_biljeska,
	na_kartica = @na_kartica,
	na_popust = @na_popust
where
	na_id_pk = @na_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_NARUCITELJI]
(
	@na_ime nvarchar(25),
	@na_oib nvarchar(15),
	@na_tvrtka_fk int,
	@na_djelatno_mjesto nvarchar(20),
	@na_tel_u_tvrtci nvarchar(15),
	@na_tel nvarchar(15),
	@na_mob nvarchar(15),
	@na_kucna_adresa nvarchar(25),
	@na_mjesto nvarchar(25),
	@na_biljeska nvarchar(40),
	@na_kartica nvarchar(25),
	@na_popust decimal(5,2)
)
as
insert into NARUCITELJI
	(na_ime, na_oib, na_tvrtka_fk, na_djelatno_mjesto, na_tel_u_tvrtci, na_tel, na_mob, na_kucna_adresa, na_mjesto, na_biljeska, na_kartica, na_popust)
values
	(@na_ime, @na_oib, @na_tvrtka_fk, @na_djelatno_mjesto, @na_tel_u_tvrtci, @na_tel, @na_mob, @na_kucna_adresa, @na_mjesto, @na_biljeska, @na_kartica, @na_popust)
select scope_identity()
GO



--
-- Definition for stored procedure Osnovno_DeleteInfo_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_DeleteInfo_TVRTKE]
(
	@tv_id_pk Int
)
AS
SELECT * FROM RACUNI_ZAGLAVLJE WHERE rz_tvrtka_id_fk = @tv_id_pk
SELECT * FROM NARUCITELJI WHERE na_tvrtka_fk = @tv_id_pk
GO

--
-- Definition for stored procedure Osnovno_Delete_NARUCITELJI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_NARUCITELJI]
(
	@na_id_pk int
)
as
delete NARUCITELJI where na_id_pk = @na_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_TVRTKE]
(
	@tv_id_pk int,
	@tv_ime nvarchar(50),
	@tv_adresa nvarchar(50),
	@tv_adresa_broj nvarchar(5),
	@tv_mjesto nvarchar(50),
	@tv_mjesto_postanski_broj int,
	@tv_maticni_broj nvarchar(25),
	@tv_oib nvarchar(25),
	@tv_iban nvarchar(25),
	@tv_tel nvarchar(15),
	@tv_email nvarchar(50),
	@tv_kontakt_osoba nvarchar(20),
	@tv_odgoda_placanja int,
	@tv_stop_tvrtka bit,
	@tv_note nvarchar(40),
	@tv_time_inserted Datetime,
	@tv_state nvarchar(50),
	@tv_porezni_broj nvarchar(50),
	@tv_sifra nvarchar(30)
)
as
update
	TVRTKE
set
	tv_ime = @tv_ime,
	tv_adresa = @tv_adresa,
	tv_mjesto = @tv_mjesto,
	tv_maticni_broj = @tv_maticni_broj,
	tv_mjesto_postanski_broj = @tv_mjesto_postanski_broj,
	tv_tel = @tv_tel,
	tv_adresa_broj = @tv_adresa_broj,
	tv_iban = @tv_iban,
	tv_kontakt_osoba = @tv_kontakt_osoba,
	tv_email = @tv_email,
	tv_odgoda_placanja = @tv_odgoda_placanja,
	tv_stop_tvrtka = @tv_stop_tvrtka,
	tv_note = @tv_note,
	tv_oib = @tv_oib,
	tv_state = @tv_state,
	tv_porezni_broj = @tv_porezni_broj,
	tv_sifra = @tv_sifra
where
	tv_id_pk = @tv_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_TVRTKE]
(
	@tv_ime nvarchar(50),
	@tv_adresa nvarchar(50),
	@tv_adresa_broj nvarchar(5),
	@tv_mjesto nvarchar(50),
	@tv_mjesto_postanski_broj int,
	@tv_maticni_broj nvarchar(25),
	@tv_oib nvarchar(25),
	@tv_iban nvarchar(25),
	@tv_tel nvarchar(15),
	@tv_email nvarchar(50),
	@tv_kontakt_osoba nvarchar(20),
	@tv_odgoda_placanja int,
	@tv_stop_tvrtka bit,
	@tv_note nvarchar(40),
	@tv_time_inserted Datetime,
	@tv_state nvarchar(50),
	@tv_porezni_broj nvarchar(50),
	@tv_sifra nvarchar(30)
)
as
insert into TVRTKE
	(tv_ime, tv_adresa, tv_mjesto, tv_maticni_broj, tv_iban, tv_tel, tv_email, tv_adresa_broj, tv_kontakt_osoba, tv_mjesto_postanski_broj, tv_odgoda_placanja, tv_stop_tvrtka, tv_note, tv_time_inserted, tv_oib, tv_state, tv_porezni_broj, tv_sifra)
values
	(@tv_ime, @tv_adresa, @tv_mjesto, @tv_maticni_broj, @tv_iban, @tv_tel, @tv_email, @tv_adresa_broj, @tv_kontakt_osoba, @tv_mjesto_postanski_broj, @tv_odgoda_placanja, @tv_stop_tvrtka, @tv_note, @tv_time_inserted, @tv_oib, @tv_state, @tv_porezni_broj, @tv_sifra)
select scope_identity()
GO


--
-- Definition for stored procedure Osnovno_Get_TVRTKE : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_TVRTKE]
(
	@tv_id_pk int = NULL
)
AS
Select * from TVRTKE
where (@tv_id_pk is null or (TVRTKE.tv_id_pk = @tv_id_pk))
GO



--
-- Definition for stored procedure Osnovno_Get_NARUCITELJI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NARUCITELJI]
(
	@na_tvrtka_fk int = NULL,
	@na_kartica nvarchar(25) = NULL
)
AS
SELECT NARUCITELJI.na_id_pk, NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_tvrtka_fk, NARUCITELJI.na_djelatno_mjesto, NARUCITELJI.na_tel_u_tvrtci, 
       NARUCITELJI.na_tel, NARUCITELJI.na_mob, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska, 
       NARUCITELJI.na_kartica, NARUCITELJI.na_popust, TVRTKE.tv_ime
FROM   NARUCITELJI LEFT JOIN
       TVRTKE ON NARUCITELJI.na_tvrtka_fk = TVRTKE.tv_id_pk
WHERE
		(@na_tvrtka_fk is null or (NARUCITELJI.na_tvrtka_fk = @na_tvrtka_fk)) AND
		(@na_kartica is null or (NARUCITELJI.na_kartica = @na_kartica))
GO

--
-- Definition for stored procedure Osnovno_Delete_TVRTKE : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_TVRTKE]
(
	@tv_id_pk int
)
as
delete TVRTKE where tv_id_pk = @tv_id_pk
GO



--
-- Definition for stored procedure Skladiste_Get_SIROVINA_INFO : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_SIROVINA_INFO]
(
 	@si_id_pk int,
	@dateEnd datetime,
	@dateEnd_Racuni_Vrijeme datetime,
	@dateEnd_Racuni_Nadnevak datetime
)
AS
BEGIN

	-- DETALJI SIROVINE
	SELECT SIROVINE.*, GRUPE_SIROVINA.gs_name, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM SIROVINE LEFT JOIN
          GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT JOIN
          GRUPE_PDV ON SIROVINE.si_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
          SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE si_id_pk = @si_id_pk

	-- STAVKE PRIMKE PRIJE ZAVRSNOG DATUMA
	SELECT PRIMKE_ZAGLAVLJE.*, DOBAVLJACI.do_name, PRIMKE_STAVKE.*
	FROM PRIMKE_ZAGLAVLJE INNER JOIN
			PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT OUTER JOIN
			DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
	WHERE (PRIMKE_ZAGLAVLJE.pr_datum_knjizenja <= @dateEnd) AND (PRIMKE_STAVKE.ps_si_id_fk = @si_id_pk) AND (PRIMKE_ZAGLAVLJE.pr_proknjizeno = 1)
	ORDER BY PRIMKE_ZAGLAVLJE.pr_datum_knjizenja 

 	-- STAVKE IZDATNICE PRIJE ZAVRSNOG DATUMA
	SELECT IZDATNICE_ZAGLAVLJE.*, IZDATNICE_STAVKE.*
	FROM IZDATNICE_ZAGLAVLJE INNER JOIN
			IZDATNICE_STAVKE ON IZDATNICE_ZAGLAVLJE.iz_id_pk = IZDATNICE_STAVKE.is_iz_id_fk
	WHERE (IZDATNICE_ZAGLAVLJE.iz_datum <= @dateEnd) AND (IZDATNICE_STAVKE.is_si_id_fk = @si_id_pk) AND (IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 1)
	ORDER BY IZDATNICE_ZAGLAVLJE.iz_datum

	-- STAVKE OTPISI PRIJE ZAVRSNOG DATUMA
	SELECT OTPISI_ZAGLAVLJE.*, OTPISI_STAVKE.*
	FROM OTPISI_ZAGLAVLJE INNER JOIN
			OTPISI_STAVKE ON OTPISI_ZAGLAVLJE.ot_id_pk = OTPISI_STAVKE.os_ot_id_fk
	WHERE (OTPISI_ZAGLAVLJE.ot_datum <= @dateEnd) AND (OTPISI_STAVKE.os_si_id_fk = @si_id_pk) AND (OTPISI_ZAGLAVLJE.ot_proknjizeno = 1)
	ORDER BY OTPISI_ZAGLAVLJE.ot_datum

	-- STAVKE INVENTURE PRIJE ZAVRSNOG DATUMA
	SELECT INVENTURA_ZAGLAVLJE.*, INVENTURA_STAVKE.* 
	FROM INVENTURA_ZAGLAVLJE INNER JOIN
			INVENTURA_STAVKE ON INVENTURA_ZAGLAVLJE.in_id_pk = INVENTURA_STAVKE.ins_in_id_fk
	where (INVENTURA_ZAGLAVLJE.in_nadnevak <= @dateEnd) AND (INVENTURA_STAVKE.ins_sir_id_fk = @si_id_pk) AND (INVENTURA_ZAGLAVLJE.in_knjizenje = 1) AND (INVENTURA_ZAGLAVLJE.in_proknjizeno = 1)

	-- UTROSAK PO NORMATIVU PRIJE ZAVRSNOG DATUMA (DNEVNA PRODAJA)
	SELECT RACUNI_ZAGLAVLJE.rz_dan, SIROVINE.si_id_pk, 
			SUM (NORMATIVI.no_kolicina * RACUNI_STAVKE.rs_kolicina) AS UTROSENA_KOLICINA
	FROM RACUNI_ZAGLAVLJE INNER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
			NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
			SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk INNER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (SIROVINE.si_id_pk = @si_id_pk) AND 
			(@dateEnd_Racuni_Vrijeme IS NULL OR (RACUNI_ZAGLAVLJE.rz_vrijeme <= @dateEnd_Racuni_Vrijeme)) AND 
			(@dateEnd_Racuni_Nadnevak IS NULL OR (RACUNI_ZAGLAVLJE.rz_dan <= @dateEnd_Racuni_Nadnevak))
	GROUP BY RACUNI_ZAGLAVLJE.rz_dan, SIROVINE.si_id_pk  
	ORDER BY RACUNI_ZAGLAVLJE.rz_dan

	-- UTROSAK PO NORMATIVU PRIJE ZAVRSNOG DATUMA (ZA SVAKI RACUN)
	SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full,   
			RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, RACUNI_ZAGLAVLJE.rz_iznos,
			RACUNI_ZAGLAVLJE.rz_placanje_id_fk, 
 			SUM (NORMATIVI.no_kolicina * RACUNI_STAVKE.rs_kolicina) AS UTROSENA_KOLICINA
	FROM RACUNI_ZAGLAVLJE INNER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
			NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
			SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk INNER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (SIROVINE.si_id_pk = @si_id_pk) AND 
			(@dateEnd_Racuni_Vrijeme IS NULL OR (RACUNI_ZAGLAVLJE.rz_vrijeme <= @dateEnd_Racuni_Vrijeme)) AND 
			(@dateEnd_Racuni_Nadnevak IS NULL OR (RACUNI_ZAGLAVLJE.rz_dan <= @dateEnd_Racuni_Nadnevak))
	GROUP BY RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full,   
			RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, RACUNI_ZAGLAVLJE.rz_iznos, RACUNI_ZAGLAVLJE.rz_placanje_id_fk
	ORDER BY RACUNI_ZAGLAVLJE.rz_vrijeme

	-- NACINI PLACANJA
	SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_category_fk, NACINI_PLACANJA.np_kar_provizija, 
       SYS_PLACANJA.sypl_name_long, SYS_PLACANJA.sypl_name_short
	FROM   NACINI_PLACANJA LEFT JOIN
       SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
END
GO



--
-- Definition for stored procedure Skladiste_Get_SIROVINA_INFO_BASIC : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_SIROVINA_INFO_BASIC]
(
	@si_id_pk int,
	@dateStart datetime,
	@dateEnd datetime
)
AS
BEGIN
	SELECT SUM(PRIMKE_STAVKE.ps_si_nabavljena_kolicina) AS PrimkeKolicina
	FROM PRIMKE_ZAGLAVLJE INNER JOIN
			PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk
	WHERE(PRIMKE_ZAGLAVLJE.pr_datum_knjizenja BETWEEN @dateStart AND @dateEnd) AND (PRIMKE_ZAGLAVLJE.pr_proknjizeno = 1) AND (PRIMKE_STAVKE.ps_si_id_fk = @si_id_pk)

	SELECT SUM(IZDATNICE_STAVKE.is_kolicina) AS IzdatniceKolicina
	FROM IZDATNICE_ZAGLAVLJE INNER JOIN
			IZDATNICE_STAVKE ON IZDATNICE_ZAGLAVLJE.iz_id_pk = IZDATNICE_STAVKE.is_iz_id_fk
	WHERE (IZDATNICE_ZAGLAVLJE.iz_datum BETWEEN @dateStart AND @dateEnd) AND (IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 1) AND (IZDATNICE_STAVKE.is_si_id_fk = @si_id_pk)

	SELECT SUM(OTPISI_STAVKE.os_si_kolicina) AS OtpisiKolicina
	FROM OTPISI_ZAGLAVLJE INNER JOIN
			OTPISI_STAVKE ON OTPISI_ZAGLAVLJE.ot_id_pk = OTPISI_STAVKE.os_ot_id_fk
	WHERE (OTPISI_ZAGLAVLJE.ot_datum BETWEEN @dateStart AND @dateEnd) AND (OTPISI_ZAGLAVLJE.ot_proknjizeno = 1) AND (OTPISI_STAVKE.os_si_id_fk = @si_id_pk)

	SELECT SUM(NORMATIVI.no_kolicina * RACUNI_STAVKE.rs_kolicina) AS UtrosakKolicina
	FROM RACUNI_ZAGLAVLJE INNER JOIN
		RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
		ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
		NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk
	WHERE (RACUNI_ZAGLAVLJE.rz_vrijeme BETWEEN @dateStart AND @dateEnd) AND (NORMATIVI.no_sirovina_id_fk = @si_id_pk)

	SELECT SUM(INVENTURA_STAVKE.ins_sir_stanje_razlika) AS InventuraKolicina
	FROM INVENTURA_ZAGLAVLJE INNER JOIN
			INVENTURA_STAVKE ON INVENTURA_ZAGLAVLJE.in_id_pk = INVENTURA_STAVKE.ins_in_id_fk
	WHERE (INVENTURA_ZAGLAVLJE.in_nadnevak BETWEEN @dateStart AND @dateEnd) AND (INVENTURA_ZAGLAVLJE.in_knjizenje = 1) AND (INVENTURA_ZAGLAVLJE.in_proknjizeno = 1) AND (INVENTURA_STAVKE.ins_sir_id_fk = @si_id_pk)
END
GO



--
-- Definition for stored procedure Skladiste_Get_SIROVINA_INFO_PRIMKE_STAVKE_ZADNJA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_SIROVINA_INFO_PRIMKE_STAVKE_ZADNJA]
(
 	@si_id_pk int
)
AS
SELECT TOP 1 
	PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_STAVKE.*, GRUPE_PDV.*
FROM PRIMKE_ZAGLAVLJE INNER JOIN
		PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT OUTER JOIN
		GRUPE_PDV ON PRIMKE_STAVKE.ps_pdv_id_fk = GRUPE_PDV.gpdv_id_pk
WHERE PRIMKE_STAVKE.ps_si_id_fk = @si_id_pk
ORDER BY PRIMKE_ZAGLAVLJE.pr_datum_knjizenja DESC
GO





--
-- Definition for stored procedure Osnovno_Delete_NACINI_PLACANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_NACINI_PLACANJA]
(
	@np_id_pk int
)
as
delete NACINI_PLACANJA where np_id_pk = @np_id_pk
GO

--
-- Definition for stored procedure Osnovno_Update_NACINI_PLACANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_NACINI_PLACANJA]
(
	@np_id_pk int,
	@np_name nvarchar(20),
	@np_category_fk int,
	@np_kar_provizija decimal(6, 2),
	@np_sort int,
	@np_index int,
	@np_active bit
)
as
update
	NACINI_PLACANJA
set
	np_name = @np_name,
	np_category_fk = @np_category_fk,
	np_kar_provizija = @np_kar_provizija,
	np_sort = @np_sort,
	np_index = @np_index,
	np_active = @np_active
where
	np_id_pk = @np_id_pk
GO



--
-- Definition for stored procedure Osnovno_Insert_NACINI_PLACANJA : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_NACINI_PLACANJA]
(
	@RetVal int output,
	@np_name nvarchar(20),
	@np_category_fk int,
	@np_kar_provizija decimal(6, 2),
	@np_sort int,
	@np_index int,
	@np_active bit
)
as
insert into NACINI_PLACANJA
	(np_name, np_category_fk, np_kar_provizija, np_sort, np_index, np_active)
values
	(@np_name, @np_category_fk, @np_kar_provizija, @np_sort, @np_index, @np_active)

set @RetVal = scope_identity()
GO



--
-- Definition for stored procedure Osnovno_Get_NACINI_PLACANJA : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_NACINI_PLACANJA]
(
	@np_active bit = NULL
)
AS
SELECT NACINI_PLACANJA.*, 
	   SYS_PLACANJA.sypl_name_long, SYS_PLACANJA.sypl_name_short
FROM   NACINI_PLACANJA LEFT JOIN
       SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
WHERE
 	   (@np_active is null or (NACINI_PLACANJA.np_active = @np_active))
ORDER BY np_sort
GO

--
-- Definition for stored procedure Osnovno_Update_KONOBARI : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_KONOBARI]
(
	@kn_id_pk int,
	@kn_name nvarchar(30),
	@kn_oib nvarchar(20),
	@kn_sifra nvarchar(10),
	@kn_barcode nvarchar(30),
	@kn_adresa nvarchar(30),
	@kn_mjesto nvarchar(30),
	@kn_tel nvarchar(15),
	@kn_mob nvarchar(15),
	@kn_work_start datetime,
	@kn_work_end datetime,
	@kn_active bit,
	@kn_note nvarchar(40),
	@kn_oznaka nvarchar(20),
	@kn_status nvarchar(1)
)
as
update
	KONOBARI
set
	kn_name = @kn_name,
	kn_oib = @kn_oib,
	kn_sifra = @kn_sifra,
	kn_barcode = @kn_barcode,
	kn_adresa = @kn_adresa,
	kn_mjesto = @kn_mjesto,
	kn_tel = @kn_tel,
	kn_mob = @kn_mob,
	kn_work_start = @kn_work_start,
	kn_work_end = @kn_work_end,
	kn_active = @kn_active,
	kn_note = @kn_note, 
	kn_oznaka = @kn_oznaka,
	kn_status = @kn_status
where
	kn_id_pk = @kn_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_KONOBARI : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_KONOBARI]
(
	@kn_name nvarchar(30),
	@kn_oib nvarchar(20),
	@kn_sifra nvarchar(10),
	@kn_barcode nvarchar(30),
	@kn_adresa nvarchar(30),
	@kn_mjesto nvarchar(30),
	@kn_tel nvarchar(15),
	@kn_mob nvarchar(15),
	@kn_work_start datetime,
	@kn_work_end datetime,
	@kn_active bit,
	@kn_note nvarchar(40),
	@kn_oznaka nvarchar(20),
	@kn_status nvarchar(1)
)
as
insert into KONOBARI
	(kn_name, kn_oib, kn_sifra, kn_barcode, kn_adresa, kn_mjesto, kn_tel, kn_mob, kn_work_start, kn_work_end, kn_active, kn_note, kn_oznaka, kn_status)
values
	(@kn_name, @kn_oib, @kn_sifra, @kn_barcode, @kn_adresa, @kn_mjesto, @kn_tel, @kn_mob, @kn_work_start, @kn_work_end, @kn_active, @kn_note ,@kn_oznaka, @kn_status)
select scope_identity()
GO


--
-- Definition for stored procedure Osnovno_Get_KONOBARI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_KONOBARI]
(
	@active_only bit = null
)
AS
Select * from KONOBARI 
WHERE (@active_only is null or (KONOBARI.kn_active = 1))
GO

--
-- Definition for stored procedure Osnovno_Delete_KONOBARI : 
--
GO
CREATE procedure [dbo].[Osnovno_Delete_KONOBARI]
(
	@kn_id_pk int
)
as
delete KONOBARI where kn_id_pk = @kn_id_pk
GO

--
-- Definition for stored procedure Management_Get_RESERVATION_ZAGLAVLJE : 
--
GO
CREATE PROCEDURE [dbo].[Management_Get_RESERVATION_ZAGLAVLJE]
(
	@rzz_id_pk int = null,
	@rzz_kn_id_fk int = null,
	@rzz_st_id_fk int = null,
	@rzz_date datetime = null,
	@rzz_date_start datetime = null,
	@rzz_date_end datetime = null
)
AS
BEGIN
	SELECT RESERVATION_ZAGLAVLJE.*, 
		KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, 
		STOLOVI.st_name, STOLOVI.st_description, STOLOVI.ts_id_fk,
	    CASE WHEN rzz_check_in =0 THEN 'NE' ELSE 'DA' END AS rzz_check_in_str
	FROM RESERVATION_ZAGLAVLJE LEFT OUTER JOIN
			STOLOVI ON RESERVATION_ZAGLAVLJE.rzz_st_id_fk = STOLOVI.st_id_pk LEFT OUTER JOIN
			KONOBARI ON RESERVATION_ZAGLAVLJE.rzz_kn_id_fk = KONOBARI.kn_id_pk
	WHERE 
		(@rzz_id_pk is null or (RESERVATION_ZAGLAVLJE.rzz_id_pk = @rzz_id_pk)) AND
		(@rzz_kn_id_fk is null or (RESERVATION_ZAGLAVLJE.rzz_kn_id_fk = @rzz_kn_id_fk)) AND
		(@rzz_st_id_fk is null or (RESERVATION_ZAGLAVLJE.rzz_st_id_fk = @rzz_st_id_fk)) AND
		(@rzz_date is null or (RESERVATION_ZAGLAVLJE.rzz_date = @rzz_date)) AND
		(@rzz_date_start is null or (RESERVATION_ZAGLAVLJE.rzz_date between @rzz_date_start and @rzz_date_end)) 
END
GO

--
-- Definition for stored procedure Management_Get_PONUDA_ZAGLAVLJE : 
--
GO
CREATE PROCEDURE [dbo].[Management_Get_PONUDA_ZAGLAVLJE]
(
	@day_start datetime,
	@day_end datetime,
	@pnz_id_pk int = null
)
AS
BEGIN
	SELECT PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_kn_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_napomena, 
			KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, KONOBARI.kn_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_oib, 
			sum(PONUDA_STAVKE.pns_pnp) as count_pnp, 
			sum(PONUDA_STAVKE.pns_pdv) as count_pdv, 
			sum(PONUDA_STAVKE.pns_iznos) as count_ukupno  
	FROM PONUDA_ZAGLAVLJE LEFT OUTER JOIN
			PONUDA_STAVKE ON PONUDA_ZAGLAVLJE.pnz_id_pk = PONUDA_STAVKE.pns_ponuda_id_fk LEFT OUTER JOIN
			TVRTKE ON PONUDA_ZAGLAVLJE.pnz_tv_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
			KONOBARI ON PONUDA_ZAGLAVLJE.pnz_kn_id_fk = KONOBARI.kn_id_pk
	WHERE  (PONUDA_ZAGLAVLJE.pnz_nadnevak BETWEEN @day_start AND @day_end) AND
			(@pnz_id_pk is null or (PONUDA_ZAGLAVLJE.pnz_id_pk = @pnz_id_pk))
	GROUP BY  PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_kn_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_napomena, 
			KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, KONOBARI.kn_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_oib
END
GO


--
-- Definition for stored procedure Management_Get_PONUDA_BROJ_NEXT : 
--
GO
CREATE procedure [dbo].[Management_Get_PONUDA_BROJ_NEXT]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(pnz_broj) from PONUDA_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1
END
GO


--
-- Definition for stored procedure Management_Get_OTVORENI_RACUNI_ZAGLAVLJE : 
--
GO
CREATE procedure [dbo].[Management_Get_OTVORENI_RACUNI_ZAGLAVLJE]
(
	@wks_id_pk int = NULL,
	@wks_konobar_id_fk int = NULL,
	@wks_stol_id_fk int = NULL
)
AS
SELECT OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk, OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk, OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk, 
			OTVORENI_RACUNI_ZAGLAVLJE.wks_vrijeme, OTVORENI_RACUNI_ZAGLAVLJE.wks_napomena, OTVORENI_RACUNI_ZAGLAVLJE.wks_is_used, 
			KONOBARI.kn_name, STOLOVI.ts_id_fk, STOLOVI.st_name, STOLOVI.st_description, 
			SUM(OTVORENI_RACUNI_STAVKE.wkss_iznos) AS suma
FROM OTVORENI_RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			KONOBARI ON OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
			STOLOVI ON OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk = STOLOVI.st_id_pk LEFT OUTER JOIN
			OTVORENI_RACUNI_STAVKE ON OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk = OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk
WHERE (@wks_id_pk is null or (OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk = @wks_id_pk)) AND
	  (@wks_konobar_id_fk is null or (OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk = @wks_konobar_id_fk)) AND
	  (@wks_stol_id_fk is null or (OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk = @wks_stol_id_fk))
GROUP BY OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk, OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk, OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk, 
			OTVORENI_RACUNI_ZAGLAVLJE.wks_vrijeme, OTVORENI_RACUNI_ZAGLAVLJE.wks_napomena, OTVORENI_RACUNI_ZAGLAVLJE.wks_is_used, 
			KONOBARI.kn_name, STOLOVI.ts_id_fk, STOLOVI.st_name, STOLOVI.st_description
GO





--
-- Definition for stored procedure Management_Get_OTVORENI_RACUNI_ZAGLAVLJE_STAVKE : 
--
GO
CREATE procedure [dbo].[Management_Get_OTVORENI_RACUNI_ZAGLAVLJE_STAVKE]
(
	@ar_mjesto_izdavanja_fk int = null
)
AS
SELECT	OTVORENI_RACUNI_STAVKE.wkss_id_pk, OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk, OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk, 
			OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk, OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk,
			OTVORENI_RACUNI_STAVKE.wkss_kolicina, OTVORENI_RACUNI_STAVKE.wkss_popust,
			OTVORENI_RACUNI_STAVKE.wkss_cijena_bez_popusta,	OTVORENI_RACUNI_STAVKE.wkss_cijena,
			OTVORENI_RACUNI_STAVKE.wkss_pdv, OTVORENI_RACUNI_STAVKE.wkss_pnp,
			OTVORENI_RACUNI_STAVKE.wkss_iznos_bez_popusta, OTVORENI_RACUNI_STAVKE.wkss_iznos, 
			OTVORENI_RACUNI_STAVKE.wkss_nar_ns_id_pk, OTVORENI_RACUNI_STAVKE.wkss_nar_naruceno, 
 			OTVORENI_RACUNI_STAVKE.wkss_nar_status, OTVORENI_RACUNI_STAVKE.wkss_nar_napomena, 
 			OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_izdavanja, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_prihvacanja, 
 			OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_spremnosti, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_dostave, 
			OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_priority, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_name, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_oznaka, 
			ARTIKLI.ar_sifra, ARTIKLI.ar_barcode, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, 
			ARTIKLI.ar_cijena, ARTIKLI.ar_cijena_popust, ARTIKLI.ar_cijena_popust_2, ARTIKLI.ar_cijena_popust_3, 
			ARTIKLI.ar_mjesto_izdavanja_fk,
			GRUPE_PDV.gpdv_postotak, GRUPE_PDV.gpdv_name, GRUPE_PNP.gpnp_postotak, GRUPE_PNP.gpnp_name, 
			MJESTA_IZDAVANJA.mi_oznaka,
			OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk, OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk, OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk, 
			OTVORENI_RACUNI_ZAGLAVLJE.wks_vrijeme, OTVORENI_RACUNI_ZAGLAVLJE.wks_napomena, OTVORENI_RACUNI_ZAGLAVLJE.wks_is_used, 
			KONOBARI.kn_name, STOLOVI.ts_id_fk, STOLOVI.st_name, STOLOVI.st_description,
			NARUDZBE_ZAGLAVLJE.nz_broj_dnevni, NARUDZBE_ZAGLAVLJE.nz_broj_full 
FROM	OTVORENI_RACUNI_STAVKE LEFT OUTER JOIN
			OTVORENI_RACUNI_ZAGLAVLJE ON OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk = OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk LEFT OUTER JOIN
			ARTIKLI ON OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			MJESTA_IZDAVANJA ON ARTIKLI.ar_mjesto_izdavanja_fk = MJESTA_IZDAVANJA.mi_id_pk LEFT OUTER JOIN
			GRUPE_PDV ON OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			GRUPE_PNP ON OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
			NARUDZBE_ZAGLAVLJE ON OTVORENI_RACUNI_STAVKE.wkss_nar_ns_id_pk = NARUDZBE_ZAGLAVLJE.nz_id_pk LEFT OUTER JOIN
			STOLOVI ON OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk = STOLOVI.st_id_pk LEFT OUTER JOIN
			KONOBARI ON OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk = KONOBARI.kn_id_pk
WHERE (OTVORENI_RACUNI_STAVKE.wkss_nar_ns_id_pk IS NOT NULL) AND
		(@ar_mjesto_izdavanja_fk is null or (ARTIKLI.ar_mjesto_izdavanja_fk = @ar_mjesto_izdavanja_fk))
ORDER BY NARUDZBE_ZAGLAVLJE.nz_broj_full
GO




--
-- Definition for stored procedure Management_Get_NABAVNI_NALOG_ZAGLAVLJE : 
--
GO
CREATE PROCEDURE [dbo].[Management_Get_NABAVNI_NALOG_ZAGLAVLJE]
(
	@day_start datetime,
	@day_end datetime,
	@nnz_id_pk int = null
)
AS
BEGIN
	SELECT NABAVNI_NALOG_ZAGLAVLJE.nnz_id_pk, NABAVNI_NALOG_ZAGLAVLJE.nnz_broj, NABAVNI_NALOG_ZAGLAVLJE.nnz_nadnevak, 
			NABAVNI_NALOG_ZAGLAVLJE.nnz_kn_id_fk, NABAVNI_NALOG_ZAGLAVLJE.nnz_do_id_fk, NABAVNI_NALOG_ZAGLAVLJE.nnz_napomena, 
			KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, KONOBARI.kn_oznaka, 
			DOBAVLJACI.do_name, DOBAVLJACI.do_adresa, DOBAVLJACI.do_mjesto,  DOBAVLJACI.do_oib
	FROM NABAVNI_NALOG_ZAGLAVLJE LEFT OUTER JOIN
			DOBAVLJACI ON NABAVNI_NALOG_ZAGLAVLJE.nnz_do_id_fk = DOBAVLJACI.do_id_pk LEFT OUTER JOIN
			KONOBARI ON NABAVNI_NALOG_ZAGLAVLJE.nnz_kn_id_fk = KONOBARI.kn_id_pk
	WHERE  (NABAVNI_NALOG_ZAGLAVLJE.nnz_nadnevak BETWEEN @day_start AND @day_end) AND
			(@nnz_id_pk is null or (NABAVNI_NALOG_ZAGLAVLJE.nnz_id_pk = @nnz_id_pk))
END
GO


--
-- Definition for stored procedure Servis_Update_KASA : 
--
GO
CREATE procedure [dbo].[Servis_Update_KASA]
(
	@ks_id_pk int,
	@ks_name nvarchar(20),
	@ks_description nvarchar(50)
)
as
update
	KASE
set
	ks_name = @ks_name,
	ks_description = @ks_description
where
	ks_id_pk = @ks_id_pk
GO

--
-- Definition for stored procedure Servis_Insert_KASA : 
--
GO
CREATE procedure [dbo].[Servis_Insert_KASA]
(
	@ks_name nvarchar(20),
	@ks_description nvarchar(50)
)
as
insert into KASE
	(ks_name, ks_description)
values
	(@ks_name, @ks_description)
select scope_identity()
GO

--
-- Definition for stored procedure Servis_Get_KASE : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_KASE]
AS
Select * from KASE
GO

--
-- Definition for stored procedure Servis_Delete_KASA : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_KASA]
(
	@ks_id_pk int
)
AS
delete KASE where ks_id_pk = @ks_id_pk
GO


--
-- Definition for stored procedure Pregledi_Get_RACUNI_ZAGLAVLJE_DISTINCT : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUNI_ZAGLAVLJE_DISTINCT]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@use_naknadno_potpisani bit = null,
	@use_nepotpisani bit = null,
	@use_paragon bit = null,
	@use_kartice bit = null,
	@use_storno bit = null,
	@use_sve_tvrtke bit = null,
	@pay_type_id int = null,
	@tvrtka_id int = null,
	@rz_id_pk int = null,
	@KonobarID int = null,
	@StolID int = null,
	@KasaID int = null,
	@NaruciteljID int = null,
	@ArtikalID int = null,
	@Popust_Included bit = null,
	@Popust_Excluded bit = null,
	@Napojnice_Exists bit = null,
	@Napojnice_Not_Exists bit = null,
	@Fisk_1 bit = null,
	@Fisk_2 bit = null,
	@Fisk_Excluded bit = null
)
AS
SELECT	DISTINCT	RACUNI_ZAGLAVLJE.*, TVRTKE.*, NARUCITELJI.*, KONOBARI.*, NACINI_PLACANJA.*, KASE.*, STOLOVI.*,  
						 
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
						RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full,  
						NP1.np_name AS NP_NAZIV_1,
						NP2.np_name AS NP_NAZIV_2,
						NP3.np_name AS NP_NAZIV_3,
						NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis2_id IS NULL THEN 'EKANJE' WHEN RACUNI_ZAGLAVLJE.rz_fis2_id = '-' THEN 'IZUZETO' ELSE 'POSLANO' END AS rz_fis2_status_bpos
FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
						NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						STOLOVI ON RACUNI_ZAGLAVLJE.rz_stol_id_fk = STOLOVI.st_id_pk  LEFT JOIN
						RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN 
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 						
where (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end) AND
		(@use_naknadno_potpisani is null or (not RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AND 
		(@use_nepotpisani is null or (RACUNI_ZAGLAVLJE.rz_fis_jir is null AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AND
		(@use_paragon is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end AND NOT RACUNI_ZAGLAVLJE.rz_fis_paragon_broj is null)) AND 
		(@use_kartice is null or (NACINI_PLACANJA.np_category_fk = 1)) AND 
		(@use_storno is null or (RACUNI_ZAGLAVLJE.rz_fis_storno_sign='S')) AND 
		(@use_sve_tvrtke is null or (NOT RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk IS NULL)) AND 
		(@pay_type_id is null or (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @pay_type_id)) AND 
		(@tvrtka_id is null or (RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = @tvrtka_id)) AND
		(@rz_id_pk is null or (RACUNI_ZAGLAVLJE.rz_id_pk = @rz_id_pk)) AND
		(@KonobarID is null or (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @KonobarID)) AND
		(@KasaID is null or (RACUNI_ZAGLAVLJE.rz_kasa_id_fk = @KasaID)) AND
		(@NaruciteljID is null or (RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = @NaruciteljID)) AND
		(@StolID is null or (RACUNI_ZAGLAVLJE.rz_stol_id_fk = @StolID)) AND
		(@ArtikalID is null or (RACUNI_STAVKE.rs_artikal_id_fk = @ArtikalID)) AND
		(@Popust_Included is null or not (RACUNI_ZAGLAVLJE.rz_popust = 0)) AND
		(@Popust_Excluded is null or (RACUNI_ZAGLAVLJE.rz_popust = 0)) AND
		(@Napojnice_Exists is null or not (RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0)) AND
		(@Napojnice_Not_Exists is null or (RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0)) AND
		(@Fisk_1 is null or (RACUNI_ZAGLAVLJE.rz_fis_type = 1)) AND
		(@Fisk_2 is null or (RACUNI_ZAGLAVLJE.rz_fis_type = 2)) AND
		(@Fisk_Excluded is null or (RACUNI_ZAGLAVLJE.rz_fis_type IS NULL)) 
GO



--
-- Definition for stored procedure Pregledi_Get_RACUNI_ZAGLAVLJE : 
--
CREATE procedure [dbo].[Pregledi_Get_RACUNI_ZAGLAVLJE]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@use_naknadno_potpisani bit = null,
	@use_nepotpisani bit = null,
	@use_paragon bit = null,
	@use_kartice bit = null,
	@use_virman bit = null,
	@use_storno bit = null,
	@use_sve_tvrtke bit = null,
	@use_popusti bit = null,
	@pay_type_id int = null,
	@pay_type_category_id int = null,
	@tvrtka_id int = null,
	@rz_id_pk int = null,
	@KonobarID int = null,
	@StolID int = null,
	@KasaID int = null,
	@NaruciteljID int = null,
	@use_nap_nepotpisani bit = null,
	@use_fisk2_cekanje bit = null,
	@use_fisk2_all bit = null
	 
)
AS
SELECT		RACUNI_ZAGLAVLJE.*, TVRTKE.*, NARUCITELJI.*, KONOBARI.*, NACINI_PLACANJA.*, KASE.*, STOLOVI.*,  
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
						RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full,  
						NP1.np_name AS NP_NAZIV_1,
						NP2.np_name AS NP_NAZIV_2,
						NP3.np_name AS NP_NAZIV_3,
						NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis2_id IS NULL THEN 'EKANJE' WHEN RACUNI_ZAGLAVLJE.rz_fis2_id = '-' THEN 'IZUZETO' ELSE 'POSLANO' END AS rz_fis2_status_bpos
FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
						NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						STOLOVI ON RACUNI_ZAGLAVLJE.rz_stol_id_fk = STOLOVI.st_id_pk  LEFT JOIN
						RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN 
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 		
where (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end) AND
		(@use_naknadno_potpisani is null or (not RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_uuid is null)) AND 
		(@use_paragon is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end AND NOT RACUNI_ZAGLAVLJE.rz_fis_paragon_broj is null)) AND 
		(@use_kartice is null or (NACINI_PLACANJA.np_category_fk = 1)) AND 
		(@use_virman is null or (NACINI_PLACANJA.np_category_fk = 3)) AND 
		(@use_storno is null or (RACUNI_ZAGLAVLJE.rz_fis_storno_sign='S')) AND 
		(@use_sve_tvrtke is null or (NOT RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk IS NULL)) AND 
		(@pay_type_id is null or (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @pay_type_id)) AND 
		(@pay_type_category_id is null or (NACINI_PLACANJA.np_category_fk = @pay_type_category_id)) AND 
		(@tvrtka_id is null or (RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = @tvrtka_id)) AND
		(@rz_id_pk is null or (RACUNI_ZAGLAVLJE.rz_id_pk = @rz_id_pk)) AND
		(@KonobarID is null or (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @KonobarID)) AND
		(@KasaID is null or (RACUNI_ZAGLAVLJE.rz_kasa_id_fk = @KasaID)) AND
		(@NaruciteljID is null or (RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = @NaruciteljID)) AND
		(@StolID is null or (RACUNI_ZAGLAVLJE.rz_stol_id_fk = @StolID)) AND
		(@use_popusti is null or not (RACUNI_ZAGLAVLJE.rz_iznos_bez_popusta = RACUNI_ZAGLAVLJE.rz_iznos)) AND
		(@use_nepotpisani is null or (RACUNI_ZAGLAVLJE.rz_fis_jir is null AND RACUNI_ZAGLAVLJE.rz_fis_type = 1)) AND
		(@use_nap_nepotpisani is null or (RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 AND NOT RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0)) AND
		(@use_fisk2_cekanje is null or (RACUNI_ZAGLAVLJE.rz_fis2_id is null AND RACUNI_ZAGLAVLJE.rz_fis_type = 2)) AND
		(@use_fisk2_all is null or (RACUNI_ZAGLAVLJE.rz_fis_type = 2))
GO



--
-- Definition for stored procedure Management_Get_NARUDZBE_ZAGLAVLJE : 
--
GO
CREATE procedure [dbo].[Management_Get_NARUDZBE_ZAGLAVLJE]
(
	@nz_id_pk int = null,
	@day_start datetime = null,
	@day_end datetime = null,
	@nz_kasa_id_fk int = null,
	@nz_konobar_id_fk int = null,
	@nz_stol_id_fk int = null,
	@nz_ar_id_fk int = null,
	@nz_action_type nvarchar(15) = null
)
AS
BEGIN
SELECT DISTINCT NARUDZBE_ZAGLAVLJE.nz_id_pk, NARUDZBE_ZAGLAVLJE.nz_action_type, NARUDZBE_ZAGLAVLJE.nz_broj_full, 
                      NARUDZBE_ZAGLAVLJE.nz_broj_dnevni, NARUDZBE_ZAGLAVLJE.nz_vrijeme, NARUDZBE_ZAGLAVLJE.nz_dan, 
                      NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk, NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk, NARUDZBE_ZAGLAVLJE.nz_stol_id_fk, 
					  NARUDZBE_ZAGLAVLJE.nz_popust, NARUDZBE_ZAGLAVLJE.nz_iznos_bez_popusta, NARUDZBE_ZAGLAVLJE.nz_iznos,
					  KONOBARI.kn_name, KONOBARI.kn_oznaka, KONOBARI.kn_oib, KONOBARI.kn_status, 
					  STOLOVI.st_name, STOLOVI.st_name, STOLOVI.st_description, KASE.ks_name
FROM         NARUDZBE_ZAGLAVLJE LEFT OUTER JOIN
					  NARUDZBE_STAVKE ON NARUDZBE_ZAGLAVLJE.nz_id_pk = NARUDZBE_STAVKE.ns_nz_id_fk LEFT OUTER JOIN
					  KONOBARI ON NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
					  KASE ON NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
					  STOLOVI ON NARUDZBE_ZAGLAVLJE.nz_stol_id_fk = STOLOVI.st_id_pk 
WHERE (@day_start is null or (NARUDZBE_ZAGLAVLJE.nz_dan between @day_start and @day_end)) AND 
		(@nz_kasa_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk = @nz_kasa_id_fk)) AND
		(@nz_konobar_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk = @nz_konobar_id_fk)) AND
		(@nz_stol_id_fk is null or (NARUDZBE_ZAGLAVLJE.nz_stol_id_fk = @nz_stol_id_fk)) AND
		(@nz_ar_id_fk is null or (NARUDZBE_STAVKE.ns_ar_id_fk = @nz_ar_id_fk)) AND
		(@nz_id_pk is null or (NARUDZBE_ZAGLAVLJE.nz_id_pk = @nz_id_pk)) AND
		(@nz_action_type is null or (NARUDZBE_ZAGLAVLJE.nz_action_type = @nz_action_type))
END
GO


--
-- Definition for stored procedure Management_Get_KONZUMACIJA_ZAGLAVLJE : 
--
GO
CREATE procedure [dbo].[Management_Get_KONZUMACIJA_ZAGLAVLJE]
(
	@kzz_id_pk int = null,
	@day_start datetime = null,
	@day_end datetime = null,
	@KonobarID int = null,
	@StolID int = null,
	@tvrtka_id int = null,
	@NaruciteljID int = null,
	@KasaID int = null,
	@filter_open bit = null, 
	@filter_closed bit = null
)
AS
SELECT KONZUMACIJA_ZAGLAVLJE.kzz_id_pk, 
		KONZUMACIJA_ZAGLAVLJE.kzz_racun_id_fk, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, 
		KONZUMACIJA_ZAGLAVLJE.kzz_konobar_id_fk, KONOBARI.kn_name, KONOBARI.kn_oznaka, KONOBARI.kn_oib, KONOBARI.kn_status,
		KONZUMACIJA_ZAGLAVLJE.kzz_stol_id_fk, STOLOVI.st_name, STOLOVI.st_description, 
		KONZUMACIJA_ZAGLAVLJE.kzz_tvrtka_id_fk, TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_state, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj,
		KONZUMACIJA_ZAGLAVLJE.kzz_narucitelj_id_fk, NARUCITELJI.na_ime, NARUCITELJI.na_kartica, 
		KONZUMACIJA_ZAGLAVLJE.kzz_kasa_id_fk, KASE.ks_name, 
		KONZUMACIJA_ZAGLAVLJE.kzz_vrijeme, KONZUMACIJA_ZAGLAVLJE.kzz_nadnevak, 
		KONZUMACIJA_ZAGLAVLJE.kzz_broj_dnevni, KONZUMACIJA_ZAGLAVLJE.kzz_broj_full, 
		KONZUMACIJA_ZAGLAVLJE.kzz_popust, KONZUMACIJA_ZAGLAVLJE.kzz_iznos_bez_popusta, KONZUMACIJA_ZAGLAVLJE.kzz_iznos, 
		KONZUMACIJA_ZAGLAVLJE.kzz_pdv, KONZUMACIJA_ZAGLAVLJE.kzz_pnp, KONZUMACIJA_ZAGLAVLJE.kzz_napomena  
FROM KONZUMACIJA_ZAGLAVLJE LEFT OUTER JOIN
						RACUNI_ZAGLAVLJE ON KONZUMACIJA_ZAGLAVLJE.kzz_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
						KASE ON KONZUMACIJA_ZAGLAVLJE.kzz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						KONOBARI ON KONZUMACIJA_ZAGLAVLJE.kzz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
						NARUCITELJI ON KONZUMACIJA_ZAGLAVLJE.kzz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						TVRTKE ON KONZUMACIJA_ZAGLAVLJE.kzz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						STOLOVI ON KONZUMACIJA_ZAGLAVLJE.kzz_stol_id_fk = STOLOVI.st_id_pk
where	(@day_start is null or (KONZUMACIJA_ZAGLAVLJE.kzz_nadnevak between @day_start and @day_end)) AND
		(@filter_open is null or (KONZUMACIJA_ZAGLAVLJE.kzz_racun_id_fk is null)) AND 
		(@filter_closed is null or (KONZUMACIJA_ZAGLAVLJE.kzz_racun_id_fk is not null)) AND 
		(@tvrtka_id is null or (KONZUMACIJA_ZAGLAVLJE.kzz_tvrtka_id_fk = @tvrtka_id)) AND
		(@KonobarID is null or (KONZUMACIJA_ZAGLAVLJE.kzz_konobar_id_fk = @KonobarID)) AND
		(@KasaID is null or (KONZUMACIJA_ZAGLAVLJE.kzz_kasa_id_fk = @KasaID)) AND
		(@NaruciteljID is null or (KONZUMACIJA_ZAGLAVLJE.kzz_narucitelj_id_fk = @NaruciteljID)) AND
		(@StolID is null or (KONZUMACIJA_ZAGLAVLJE.kzz_stol_id_fk = @StolID)) AND
		(@kzz_id_pk is null or (KONZUMACIJA_ZAGLAVLJE.kzz_id_pk = @kzz_id_pk))
GO

--
-- Definition for stored procedure Skladiste_Get_PRIMKA_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_PRIMKA_BY_ID]
(
	@pr_id_pk int
)
AS
BEGIN
		SELECT     PRIMKE_ZAGLAVLJE.pr_id_pk, PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk, DOBAVLJACI.do_name,
                      PRIMKE_ZAGLAVLJE.pr_datum, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_ZAGLAVLJE.pr_datum_dospijeca, PRIMKE_ZAGLAVLJE.pr_osnovica, 
                      PRIMKE_ZAGLAVLJE.pr_pdv, PRIMKE_ZAGLAVLJE.pr_ukupno, PRIMKE_ZAGLAVLJE.pr_povratna_naknada, PRIMKE_ZAGLAVLJE.pr_napomena, 
                      PRIMKE_ZAGLAVLJE.pr_proknjizeno, PRIMKE_ZAGLAVLJE.pr_time_created, PRIMKE_ZAGLAVLJE.pr_time_created, 
                      DOBAVLJACI.do_maticni_broj, DOBAVLJACI.do_oib, DOBAVLJACI.do_adresa, DOBAVLJACI.do_mjesto, DOBAVLJACI.do_tel, DOBAVLJACI.do_fax, 
                      DOBAVLJACI.do_ziro_racun, DOBAVLJACI.do_kontakt_osoba, DOBAVLJACI.do_kontakt_osoba_mob, DOBAVLJACI.do_biljeska,
					  DOBAVLJACI.do_biljeska, do_state, DOBAVLJACI.do_porezni_broj
		FROM         PRIMKE_ZAGLAVLJE LEFT OUTER JOIN
                      DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
		where pr_id_pk = @pr_id_pk  
END

BEGIN
	SELECT     PRIMKE_STAVKE.ps_id_pk, PRIMKE_STAVKE.ps_pr_id_fk, PRIMKE_STAVKE.ps_si_id_fk, 
					  SIROVINE.si_sifra, SIROVINE.si_ime,
                      SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, 
                      SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, SIROVINE.si_povratna_naknada, 
					  PRIMKE_STAVKE.ps_si_povratna_naknada,
					  PRIMKE_STAVKE.ps_pdv_id_fk,  GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, 
					  PRIMKE_STAVKE.ps_si_cijena_osnovna_netto, PRIMKE_STAVKE.ps_si_nabavljena_kolicina, PRIMKE_STAVKE.ps_rabat_postotak,
                      PRIMKE_STAVKE.ps_tot_osnovica, PRIMKE_STAVKE.ps_tot_pdv, PRIMKE_STAVKE.ps_tot_ukupno, PRIMKE_STAVKE.ps_tot_povratna_naknada
	FROM       PRIMKE_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON PRIMKE_STAVKE.ps_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      SIROVINE ON PRIMKE_STAVKE.ps_si_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
                      GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT OUTER JOIN
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	where	   ps_pr_id_fk = @pr_id_pk  
END
GO

--
-- Definition for stored procedure Skladiste_Get_OTPIS_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_OTPIS_BY_ID]
(
	@ot_id_pk int
)
AS
BEGIN
Select * from OTPISI_ZAGLAVLJE where ot_id_pk = @ot_id_pk 

SELECT     OTPISI_STAVKE.os_id_pk, OTPISI_STAVKE.os_ot_id_fk, OTPISI_STAVKE.os_si_id_fk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_povratna_naknada, 
                      SIROVINE.si_kategorija_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, OTPISI_STAVKE.os_pdv_id_fk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, 
                      OTPISI_STAVKE.os_si_cijena, OTPISI_STAVKE.os_si_kolicina, OTPISI_STAVKE.os_tot_osnovica, OTPISI_STAVKE.os_tot_pdv, 
                      OTPISI_STAVKE.os_tot_ukupno, OTPISI_STAVKE.os_tot_pov_nak
FROM         OTPISI_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON OTPISI_STAVKE.os_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      SIROVINE ON OTPISI_STAVKE.os_si_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
                      GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
WHERE os_ot_id_fk = @ot_id_pk
END
GO

--
-- Definition for stored procedure Skladiste_Set_OTPIS_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_OTPIS_WRITE_MODE]
(
	@RetVal int output,
	@ot_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT ot_id_pk, ot_proknjizeno FROM OTPISI_ZAGLAVLJE WHERE ot_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE OTPISI_ZAGLAVLJE SET ot_proknjizeno=0 WHERE ot_id_pk=@ot_id_pk
		EXECUTE dbo.Skladiste_Get_OTPIS_BY_ID @ot_id_pk
	END
END
GO

--
-- Definition for stored procedure Skladiste_Get_IZDATNICA_BY_ID : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_IZDATNICA_BY_ID]
(
	@iz_id_pk int
)
AS
BEGIN
	SELECT     IZDATNICE_ZAGLAVLJE.iz_id_pk, IZDATNICE_ZAGLAVLJE.iz_broj, IZDATNICE_ZAGLAVLJE.iz_mo_id_fk, IZDATNICE_ZAGLAVLJE.iz_datum, 
                      IZDATNICE_ZAGLAVLJE.iz_opis, IZDATNICE_ZAGLAVLJE.iz_napomena, IZDATNICE_ZAGLAVLJE.iz_proknjizeno, MJESTA_OTPREME.mo_oznaka, 
                      IZDATNICE_ZAGLAVLJE.iz_time_created
	FROM       IZDATNICE_ZAGLAVLJE LEFT OUTER JOIN
                      MJESTA_OTPREME ON IZDATNICE_ZAGLAVLJE.iz_mo_id_fk = MJESTA_OTPREME.mo_id_pk	WHERE iz_id_pk = @iz_id_pk
END

BEGIN
	SELECT     IZDATNICE_STAVKE.is_id_pk, IZDATNICE_STAVKE.is_iz_id_fk, IZDATNICE_STAVKE.is_si_id_fk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_povratna_naknada,
                      SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, 
                      IZDATNICE_STAVKE.is_pdv_id_fk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, IZDATNICE_STAVKE.is_cijena, IZDATNICE_STAVKE.is_kolicina, IZDATNICE_STAVKE.is_tot_osnovica, 
                      IZDATNICE_STAVKE.is_tot_pdv, IZDATNICE_STAVKE.is_tot_ukupno, IZDATNICE_STAVKE.is_tot_pov_nak
	FROM         IZDATNICE_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON IZDATNICE_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      SIROVINE ON IZDATNICE_STAVKE.is_si_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
                      GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT OUTER JOIN
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE is_iz_id_fk = @iz_id_pk
END
GO

--
-- Definition for stored procedure Skladiste_Set_IZDATNICA_WRITE_MODE : 
--
GO
CREATE procedure [dbo].[Skladiste_Set_IZDATNICA_WRITE_MODE]
(
	@RetVal int output,
	@iz_id_pk int
)
AS
BEGIN
IF EXISTS (SELECT iz_id_pk, iz_proknjizeno FROM IZDATNICE_ZAGLAVLJE WHERE iz_proknjizeno=0)
	BEGIN
		SET @RetVal=-1
	END
ELSE
	BEGIN
		SET @RetVal =1
		UPDATE IZDATNICE_ZAGLAVLJE SET iz_proknjizeno=0 WHERE iz_id_pk=@iz_id_pk
		EXECUTE dbo.Skladiste_Get_IZDATNICA_BY_ID @iz_id_pk
	END
END
GO

--
-- Definition for stored procedure Skladiste_Get_INIT_PRIMKA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_PRIMKA]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(pr_sys_broj) from PRIMKE_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1

	declare @ID AS INT

	SELECT @ID=pr_id_pk FROM PRIMKE_ZAGLAVLJE where pr_proknjizeno = 0 

SELECT     PRIMKE_ZAGLAVLJE.pr_id_pk, PRIMKE_ZAGLAVLJE.pr_sys_broj, PRIMKE_ZAGLAVLJE.pr_broj, PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk, DOBAVLJACI.do_name,
                      PRIMKE_ZAGLAVLJE.pr_datum, PRIMKE_ZAGLAVLJE.pr_datum_knjizenja, PRIMKE_ZAGLAVLJE.pr_datum_dospijeca, PRIMKE_ZAGLAVLJE.pr_osnovica, 
                      PRIMKE_ZAGLAVLJE.pr_pdv, PRIMKE_ZAGLAVLJE.pr_ukupno, PRIMKE_ZAGLAVLJE.pr_povratna_naknada, PRIMKE_ZAGLAVLJE.pr_napomena,  
                      PRIMKE_ZAGLAVLJE.pr_proknjizeno, PRIMKE_ZAGLAVLJE.pr_time_created, 
					  PRIMKE_ZAGLAVLJE.pr_time_created, 
                      DOBAVLJACI.do_maticni_broj, DOBAVLJACI.do_oib, DOBAVLJACI.do_adresa, DOBAVLJACI.do_mjesto, DOBAVLJACI.do_tel, DOBAVLJACI.do_fax, 
                      DOBAVLJACI.do_ziro_racun, DOBAVLJACI.do_kontakt_osoba, DOBAVLJACI.do_kontakt_osoba_mob,  
                      DOBAVLJACI.do_biljeska, do_state, DOBAVLJACI.do_porezni_broj
FROM         PRIMKE_ZAGLAVLJE LEFT OUTER JOIN
                      DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
	where pr_proknjizeno = 0  

	SELECT     PRIMKE_STAVKE.ps_id_pk, PRIMKE_STAVKE.ps_pr_id_fk, PRIMKE_STAVKE.ps_si_id_fk, SIROVINE.si_sifra, SIROVINE.si_ime,
                      SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, 
                      SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, SIROVINE.si_povratna_naknada,
					  PRIMKE_STAVKE.ps_pdv_id_fk,  GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, 
					  PRIMKE_STAVKE.ps_si_cijena_osnovna_netto, PRIMKE_STAVKE.ps_si_nabavljena_kolicina, PRIMKE_STAVKE.ps_rabat_postotak,
                      PRIMKE_STAVKE.ps_tot_osnovica, PRIMKE_STAVKE.ps_tot_pdv, PRIMKE_STAVKE.ps_tot_ukupno,
					  PRIMKE_STAVKE.ps_tot_povratna_naknada
	FROM       PRIMKE_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON PRIMKE_STAVKE.ps_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      SIROVINE ON PRIMKE_STAVKE.ps_si_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
                      GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT OUTER JOIN
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE	   ps_pr_id_fk=@ID
END
GO

--
-- Definition for stored procedure Skladiste_Get_INIT_OTPIS : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_OTPIS]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(ot_broj) from OTPISI_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1

	declare @ID AS INT
	SELECT @ID=ot_id_pk FROM  OTPISI_ZAGLAVLJE WHERE ot_proknjizeno=0

SELECT     ot_id_pk, ot_broj, ot_datum, ot_opis, ot_napomena, ot_proknjizeno, ot_time_created, ot_dopusteni
FROM         OTPISI_ZAGLAVLJE
	WHERE ot_proknjizeno=0

SELECT     OTPISI_STAVKE.os_id_pk, OTPISI_STAVKE.os_ot_id_fk, OTPISI_STAVKE.os_si_id_fk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_povratna_naknada, 
                      SIROVINE.si_kategorija_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, OTPISI_STAVKE.os_pdv_id_fk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, 
                      OTPISI_STAVKE.os_si_cijena, OTPISI_STAVKE.os_si_kolicina, OTPISI_STAVKE.os_tot_osnovica, OTPISI_STAVKE.os_tot_pdv, 
                      OTPISI_STAVKE.os_tot_ukupno, OTPISI_STAVKE.os_tot_pov_nak
FROM         OTPISI_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON OTPISI_STAVKE.os_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      SIROVINE ON OTPISI_STAVKE.os_si_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk LEFT OUTER JOIN
                      GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
	WHERE OTPISI_STAVKE.os_ot_id_fk=@ID
END
GO

--
-- Definition for stored procedure Skladiste_Get_INIT_IZDATNICA : 
--
GO
CREATE procedure [dbo].[Skladiste_Get_INIT_IZDATNICA]
(
	@RetVal int output
)
AS
BEGIN
	declare @maxid as int
	select @maxid=max(iz_broj) from IZDATNICE_ZAGLAVLJE
	if @maxid is null
		SET @RetVal=1
	ELSE
		SET @RetVal=@maxid+1

	declare @ID AS INT

	SELECT @ID=iz_id_pk FROM IZDATNICE_ZAGLAVLJE WHERE iz_proknjizeno=0

	SELECT IZDATNICE_ZAGLAVLJE.iz_id_pk, IZDATNICE_ZAGLAVLJE.iz_broj, IZDATNICE_ZAGLAVLJE.iz_mo_id_fk, IZDATNICE_ZAGLAVLJE.iz_datum, 
           IZDATNICE_ZAGLAVLJE.iz_opis, IZDATNICE_ZAGLAVLJE.iz_napomena, IZDATNICE_ZAGLAVLJE.iz_proknjizeno, MJESTA_OTPREME.mo_oznaka, 
           IZDATNICE_ZAGLAVLJE.iz_time_created
	FROM IZDATNICE_ZAGLAVLJE LEFT OUTER JOIN
          MJESTA_OTPREME ON IZDATNICE_ZAGLAVLJE.iz_mo_id_fk = MJESTA_OTPREME.mo_id_pk
	WHERE (IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 0)

SELECT     IZDATNICE_STAVKE.is_id_pk, IZDATNICE_STAVKE.is_iz_id_fk, IZDATNICE_STAVKE.is_si_id_fk, SIROVINE.si_sifra, SIROVINE.si_ime, SIROVINE.si_jmj, SIROVINE.si_povratna_naknada,
                      SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, SYS_SIROVINE_KATEGORIJE.sysk_name, GRUPE_SIROVINA.gs_name, 
                      IZDATNICE_STAVKE.is_pdv_id_fk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, IZDATNICE_STAVKE.is_cijena, IZDATNICE_STAVKE.is_kolicina, IZDATNICE_STAVKE.is_tot_osnovica, 
                      IZDATNICE_STAVKE.is_tot_pdv, IZDATNICE_STAVKE.is_tot_ukupno, IZDATNICE_STAVKE.is_tot_pov_nak
FROM         IZDATNICE_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON IZDATNICE_STAVKE.is_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      SIROVINE ON IZDATNICE_STAVKE.is_si_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
                      GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT OUTER JOIN
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE is_iz_id_fk=@ID
END
GO

--
-- Definition for stored procedure Pregledi_Get_RACUNI_ZAGLAVLJE_DETALJNO : 
--
GO
CREATE procedure [dbo].[Pregledi_Get_RACUNI_ZAGLAVLJE_DETALJNO]
(
	@day_start datetime = null,
	@day_end datetime = null,
	@vrijeme_start datetime = null,
	@vrijeme_end datetime = null,
	@broj_start int = null,
	@broj_end int = null
)
AS
BEGIN
SELECT	RACUNI_ZAGLAVLJE.*, TVRTKE.*, NARUCITELJI.*, KONOBARI.*, NACINI_PLACANJA.*, KASE.*, STOLOVI.*,  
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
						RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full,  
						NP1.np_name AS NP_NAZIV_1,
						NP2.np_name AS NP_NAZIV_2,
						NP3.np_name AS NP_NAZIV_3,
						NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis2_id IS NULL THEN 'EKANJE' WHEN RACUNI_ZAGLAVLJE.rz_fis2_id = '-' THEN 'IZUZETO' ELSE 'POSLANO' END AS rz_fis2_status_bpos
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
						NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						STOLOVI ON RACUNI_ZAGLAVLJE.rz_stol_id_fk = STOLOVI.st_id_pk  LEFT JOIN
						RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id=RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 
	WHERE	(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@vrijeme_start is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @vrijeme_start and @vrijeme_end)) AND 
			(@broj_start is null or (RACUNI_ZAGLAVLJE.rz_broj between @broj_start and @broj_end)) 

SELECT		RACUNI_ZAGLAVLJE.*, TVRTKE.*, NARUCITELJI.*, KONOBARI.*, NACINI_PLACANJA.*, KASE.*, STOLOVI.*,  
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
						RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full,  
						NP1.np_name AS NP_NAZIV_1,
						NP2.np_name AS NP_NAZIV_2,
						NP3.np_name AS NP_NAZIV_3,
						NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis2_id IS NULL THEN 'EKANJE' WHEN RACUNI_ZAGLAVLJE.rz_fis2_id = '-' THEN 'IZUZETO' ELSE 'POSLANO' END AS rz_fis2_status_bpos,
						ARTIKLI.ar_id_pk, ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_kpd_sifra, ARTIKLI.ar_index, 
						RACUNI_STAVKE.rs_id_pk, RACUNI_STAVKE.rs_racun_id_fk,
						RACUNI_STAVKE.rs_cijena_bez_popusta, RACUNI_STAVKE.rs_popust, RACUNI_STAVKE.rs_cijena, RACUNI_STAVKE.rs_kolicina, 
						RACUNI_STAVKE.rs_iznos_bez_popusta, RACUNI_STAVKE.rs_pdv, RACUNI_STAVKE.rs_pnp, RACUNI_STAVKE.rs_iznos, 
						RACUNI_STAVKE.rs_gpdv_id_fk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, RACUNI_STAVKE.rs_gpnp_id_fk, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak
	FROM         RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
						GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
						GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
						ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
						NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						STOLOVI ON RACUNI_ZAGLAVLJE.rz_stol_id_fk = STOLOVI.st_id_pk LEFT JOIN
						RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id = RACUNI_ZAGLAVLJE_2.rz_id_pk  LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk 
	WHERE	(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@vrijeme_start is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @vrijeme_start and @vrijeme_end)) AND 
			(@broj_start is null or (RACUNI_ZAGLAVLJE.rz_broj between @broj_start and @broj_end)) 

	-- rekapitulacija poreza
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
				CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
				CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
	FROM	RACUNI_ZAGLAVLJE inner JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@vrijeme_start is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @vrijeme_start and @vrijeme_end)) AND 
			(@broj_start is null or (RACUNI_ZAGLAVLJE.rz_broj between @broj_start and @broj_end)) 
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
END
GO


--
-- Definition for stored procedure Osnovno_Update_GRUPE_PDV : 
--
GO
CREATE procedure [dbo].[Osnovno_Update_GRUPE_PDV]
(
	@gpdv_id_pk int,
	@gpdv_name nvarchar(20),
	@gpdv_postotak decimal(6, 2)
)
as
update
	GRUPE_PDV
set
	gpdv_name = @gpdv_name,
	gpdv_postotak = @gpdv_postotak
where
	gpdv_id_pk = @gpdv_id_pk
GO

--
-- Definition for stored procedure Osnovno_Insert_GRUPE_PDV : 
--
GO
CREATE procedure [dbo].[Osnovno_Insert_GRUPE_PDV]
(
	@gpdv_name nvarchar(20),
	@gpdv_postotak decimal(6, 2)
)
as
insert into GRUPE_PDV
	( gpdv_name, gpdv_postotak)
values
	( @gpdv_name, @gpdv_postotak)
select scope_identity()
GO

--
-- Definition for stored procedure Osnovno_Get_GRUPE_PDV : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_GRUPE_PDV]
AS
Select * from GRUPE_PDV
GO




--
-- Definition for stored procedure Osnovno_Get_ARTIKLI : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Get_ARTIKLI]
(
    @ar_grupa_fk int = null,
	@Sifra_Pocetna int = null,
	@Sifra_Zavrsna int = null,
	@ar_id_pk int = null,
	@ar_sifra int = null,
	@ar_is_active_DA bit = null,
	@ar_is_active_NE bit = null
)
AS
BEGIN
SELECT ARTIKLI.*, SYS_ARTIKLI_KATEGORIJE.syak_name, GRUPE_ARTIKALA.ga_name, MJESTA_IZDAVANJA.mi_oznaka, 
                      SYS_PICE_KATEGORIJE.sypk_name, GRUPE_PNP.gpnp_name, GRUPE_PDV.gpdv_name,
                      GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_postotak
FROM     ARTIKLI LEFT OUTER JOIN
                      SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT OUTER JOIN
                      GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
                      GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      MJESTA_IZDAVANJA ON ARTIKLI.ar_mjesto_izdavanja_fk = MJESTA_IZDAVANJA.mi_id_pk LEFT OUTER JOIN
                      GRUPE_PNP ON ARTIKLI.ar_pnp_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
                      SYS_PICE_KATEGORIJE ON ARTIKLI.ar_grupa_pica_fk = SYS_PICE_KATEGORIJE.sypk_id_pk
WHERE	(@ar_sifra is null or (ARTIKLI.ar_sifra = @ar_sifra)) AND
		(@Sifra_Pocetna is null or (ARTIKLI.ar_sifra >= @Sifra_Pocetna)) AND
		(@Sifra_Zavrsna is null or (ARTIKLI.ar_sifra <= @Sifra_Zavrsna)) AND
		(@ar_id_pk is null or (ARTIKLI.ar_id_pk = @ar_id_pk)) AND
		(@ar_is_active_DA is null or (ARTIKLI.ar_is_active = 1)) AND
		(@ar_is_active_NE is null or (ARTIKLI.ar_is_active = 0)) AND
		(@ar_grupa_fk is null or (ARTIKLI.ar_grupa_fk = @ar_grupa_fk))

SELECT	 ARTIKLI.ar_id_pk, COUNT(NORMATIVI.no_article_id_fk) AS 'NormativItems'
FROM     ARTIKLI LEFT OUTER JOIN
		 NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk
WHERE	(@ar_sifra is null or (ARTIKLI.ar_sifra = @ar_sifra)) AND
		(@Sifra_Pocetna is null or (ARTIKLI.ar_sifra >= @Sifra_Pocetna)) AND
		(@Sifra_Zavrsna is null or (ARTIKLI.ar_sifra <= @Sifra_Zavrsna)) AND
		(@ar_id_pk is null or (ARTIKLI.ar_id_pk = @ar_id_pk)) AND
		(@ar_is_active_DA is null or (ARTIKLI.ar_is_active = 1)) AND
		(@ar_is_active_NE is null or (ARTIKLI.ar_is_active = 0)) AND
		(@ar_grupa_fk is null or (ARTIKLI.ar_grupa_fk = @ar_grupa_fk))
GROUP BY ARTIKLI.ar_id_pk

SELECT	 ARTIKLI.ar_id_pk, COUNT(GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk) AS 'TouchGroupNr'
FROM     ARTIKLI LEFT OUTER JOIN
		 GRUPE_TOUCH_SCREEN_ARTIKLI ON ARTIKLI.ar_id_pk = GRUPE_TOUCH_SCREEN_ARTIKLI.ar_id_fk
WHERE	(@ar_sifra is null or (ARTIKLI.ar_sifra = @ar_sifra)) AND
		(@Sifra_Pocetna is null or (ARTIKLI.ar_sifra >= @Sifra_Pocetna)) AND
		(@Sifra_Zavrsna is null or (ARTIKLI.ar_sifra <= @Sifra_Zavrsna)) AND
		(@ar_id_pk is null or (ARTIKLI.ar_id_pk = @ar_id_pk)) AND
		(@ar_is_active_DA is null or (ARTIKLI.ar_is_active = 1)) AND
		(@ar_is_active_NE is null or (ARTIKLI.ar_is_active = 0)) AND
		(@ar_grupa_fk is null or (ARTIKLI.ar_grupa_fk = @ar_grupa_fk))
GROUP BY ARTIKLI.ar_id_pk
END
GO

--
-- Definition for stored procedure Osnovno_Delete_GRUPE_PDV : 
--
GO
CREATE PROCEDURE [dbo].[Osnovno_Delete_GRUPE_PDV]
(
@gpdv_id_pk int
)
AS
delete GRUPE_PDV where gpdv_id_pk = @gpdv_id_pk
GO



--
-- Definition for stored procedure Konobar_Init_KONOBAR_STOL : 
--
GO
CREATE procedure [dbo].[Konobar_Init_KONOBAR_STOL]
(	
	@RetVal_ID_before int output,
	@RetVal_ID_after int output,
 	@RetVal_konobar_before int output,
 	@RetVal_konobar_after int output,
	@RetVal_napomena_before nvarchar(40) output,
	@RetVal_in_use_before bit output,
	@RetVal_in_use_after bit output,
	@wks_update_konobar bit,
    @wks_stol_id_fk int,
	@wks_konobar_id_fk int,
	@wks_vrijeme DateTime
)
AS

-- DOHVATI PODATKE DA LI POSTOJI OTVORENI RACUN ZA ODABRANI STOL
SELECT @RetVal_ID_before = wks_id_pk, @RetVal_konobar_before = wks_konobar_id_fk, @RetVal_napomena_before = wks_napomena, @RetVal_in_use_before = wks_is_used FROM OTVORENI_RACUNI_ZAGLAVLJE where wks_stol_id_fk = @wks_stol_id_fk

IF @RetVal_ID_before is null
	BEGIN  -- NE POSTOJI OTVORENI RACUN - KREIRAJ GA
		INSERT INTO OTVORENI_RACUNI_ZAGLAVLJE (wks_konobar_id_fk, wks_stol_id_fk, wks_vrijeme, wks_is_used) VALUES (@wks_konobar_id_fk, @wks_stol_id_fk, @wks_vrijeme, 1)
		SET @RetVal_ID_after = @@IDENTITY 
		SET @RetVal_konobar_after = @wks_konobar_id_fk
		SET @RetVal_in_use_after = 1
	END
ELSE 
	BEGIN  -- POSTOJI OTVORENI RACUN
		IF @RetVal_in_use_before = 1
			BEGIN  -- OTVORENI RACUN SE EDITIRA
				SET @RetVal_ID_after = @RetVal_ID_before 
				SET @RetVal_konobar_after = @RetVal_konobar_before
				SET @RetVal_in_use_after = 0 
			END
		ELSE
			-- OTVORENI RACUN SE NE EDITIRA - VIDI DA LI JE OD TOG KONOBARA
			IF @RetVal_konobar_before = @wks_konobar_id_fk
				BEGIN  -- STOL JE OTVOREN OD STRANE TOG KONOBARA
					UPDATE OTVORENI_RACUNI_ZAGLAVLJE SET wks_is_used = 1 WHERE wks_id_pk = @RetVal_ID_before
					SET @RetVal_ID_after = @RetVal_ID_before 
					SET @RetVal_konobar_after = @RetVal_konobar_before
					SET @RetVal_in_use_after = 1 
				END
			ELSE
				BEGIN  -- STOL JE OTVOREN OD STRANE DRUGOG KONOBARA
					IF @wks_update_konobar = 1
						BEGIN  -- DOZVOLJENO PREUZIMANJE RACUNA
							UPDATE OTVORENI_RACUNI_ZAGLAVLJE SET wks_konobar_id_fk = @wks_konobar_id_fk, wks_is_used = 1 WHERE wks_id_pk = @RetVal_ID_before
							SET @RetVal_ID_after = @RetVal_ID_before 
							SET @RetVal_konobar_after = @wks_konobar_id_fk
							SET @RetVal_in_use_after = 1 
						END
					ELSE
						BEGIN  -- NIJE DOZVOLJENO PREUZIMANJE RACUNA
							SET @RetVal_ID_after = @RetVal_ID_before
							SET @RetVal_konobar_after = @RetVal_konobar_before
							SET @RetVal_in_use_after = 0 
						END
				END
	END

DECLARE @ID int  -- ID OTVORENIH STAVKI
IF NOT @RetVal_ID_before IS NULL SET @ID = @RetVal_ID_before ELSE SET @ID = @RetVal_ID_after

-- STAVKE OTVORENOG RACUNA
SELECT	OTVORENI_RACUNI_STAVKE.wkss_id_pk, OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk, OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk, 
		OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk, OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk,
		OTVORENI_RACUNI_STAVKE.wkss_kolicina, OTVORENI_RACUNI_STAVKE.wkss_popust,
		OTVORENI_RACUNI_STAVKE.wkss_cijena_bez_popusta,	OTVORENI_RACUNI_STAVKE.wkss_cijena,
		OTVORENI_RACUNI_STAVKE.wkss_pdv, OTVORENI_RACUNI_STAVKE.wkss_pnp,
		OTVORENI_RACUNI_STAVKE.wkss_iznos_bez_popusta, OTVORENI_RACUNI_STAVKE.wkss_iznos, 
		OTVORENI_RACUNI_STAVKE.wkss_nar_ns_id_pk, OTVORENI_RACUNI_STAVKE.wkss_nar_naruceno, 
 		OTVORENI_RACUNI_STAVKE.wkss_nar_status, OTVORENI_RACUNI_STAVKE.wkss_nar_napomena, 
 		OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_izdavanja, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_prihvacanja, 
 		OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_spremnosti, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_dostave, 
		OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_priority, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_name, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_oznaka, 
		ARTIKLI.ar_sifra, ARTIKLI.ar_kpd_sifra, ARTIKLI.ar_barcode, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, 
		ARTIKLI.ar_cijena, ARTIKLI.ar_cijena_popust, ARTIKLI.ar_cijena_popust_2, ARTIKLI.ar_cijena_popust_3, 
		ARTIKLI.ar_mjesto_izdavanja_fk,
	    GRUPE_PDV.gpdv_postotak, GRUPE_PDV.gpdv_name, GRUPE_PNP.gpnp_postotak, GRUPE_PNP.gpnp_name, 
		MJESTA_IZDAVANJA.mi_oznaka
FROM	OTVORENI_RACUNI_STAVKE LEFT OUTER JOIN
			OTVORENI_RACUNI_ZAGLAVLJE ON OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk = OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk LEFT OUTER JOIN
			ARTIKLI ON OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			MJESTA_IZDAVANJA ON ARTIKLI.ar_mjesto_izdavanja_fk = MJESTA_IZDAVANJA.mi_id_pk LEFT OUTER JOIN
			GRUPE_PDV ON OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			GRUPE_PNP ON OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk = GRUPE_PNP.gpnp_id_pk
WHERE (OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk = @ID)
GO



--
-- Definition for stored procedure Konobar_Init_KONOBAR : 
--
GO
CREATE procedure [dbo].[Konobar_Init_KONOBAR]
(	
	@RetVal_ID_before int output,
	@RetVal_ID_after int output,
 	@RetVal_konobar_before int output,
 	@RetVal_konobar_after int output,
	@RetVal_in_use_before bit output,
	@RetVal_in_use_after bit output,
	@RetVal_napomena_before nvarchar(40) output,	
   	@wks_konobar_id_fk int,
	@wks_vrijeme DateTime
)
AS

-- DOHVATI PODATKE DA LI POSTOJI OTVORENI RACUN ZA ODABRANOG KONOBARA
SELECT @RetVal_ID_before = wks_id_pk, @RetVal_konobar_before = wks_konobar_id_fk, @RetVal_napomena_before = wks_napomena, @RetVal_in_use_before = wks_is_used FROM OTVORENI_RACUNI_ZAGLAVLJE where wks_konobar_id_fk = @wks_konobar_id_fk AND wks_stol_id_fk IS NULL

IF @RetVal_ID_before IS NULL
	BEGIN  -- NE POSTOJI OTVORENI RACUN ZA ODABRANOG KONOBARA - KREIRAJ OTVORENI RACUN
		INSERT INTO OTVORENI_RACUNI_ZAGLAVLJE (wks_konobar_id_fk, wks_vrijeme, wks_is_used) VALUES (@wks_konobar_id_fk, @wks_vrijeme, 1)
		SET @RetVal_ID_after = @@IDENTITY 
		SET @RetVal_konobar_after = @wks_konobar_id_fk
		SET @RetVal_in_use_after = 1
	END
ELSE 
	BEGIN  -- POSTOJI OTVORENI RACUN
		IF @RetVal_in_use_before = 1
			BEGIN  -- OTVORENI RACUN SE EDITIRA
				SET @RetVal_ID_after = @RetVal_ID_before 
				SET @RetVal_konobar_after = @RetVal_konobar_before
				SET @RetVal_in_use_after = 0 
			END
		ELSE
			BEGIN  -- OTVORENI RACUN SE NE EDITIRA
				IF @RetVal_konobar_before = @wks_konobar_id_fk
					BEGIN  -- STOL JE OTVOREN OD STRANE TOG KONOBARA
						UPDATE OTVORENI_RACUNI_ZAGLAVLJE SET wks_is_used = 1 WHERE wks_id_pk = @RetVal_ID_before
						SET @RetVal_ID_after = @RetVal_ID_before 
						SET @RetVal_konobar_after = @RetVal_konobar_before
						SET @RetVal_in_use_after = 1 
					END
				ELSE
					BEGIN  -- STOL JE OTVOREN OD STRANE DRUGOG KONOBARA
						SET @RetVal_ID_after = @RetVal_ID_before
						SET @RetVal_konobar_after = @RetVal_konobar_before
						SET @RetVal_in_use_after = 0 
					END
			END
	END

DECLARE @ID int  -- ID OTVORENIH STAVKI
IF NOT @RetVal_ID_before IS NULL SET @ID = @RetVal_ID_before ELSE SET @ID = @RetVal_ID_after

-- STAVKE OTVORENOG RACUNA
SELECT	OTVORENI_RACUNI_STAVKE.wkss_id_pk, OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk, OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk, 
		OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk, OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk,
		OTVORENI_RACUNI_STAVKE.wkss_kolicina, OTVORENI_RACUNI_STAVKE.wkss_popust,
		OTVORENI_RACUNI_STAVKE.wkss_cijena_bez_popusta,	OTVORENI_RACUNI_STAVKE.wkss_cijena,
		OTVORENI_RACUNI_STAVKE.wkss_pdv, OTVORENI_RACUNI_STAVKE.wkss_pnp,
		OTVORENI_RACUNI_STAVKE.wkss_iznos_bez_popusta, OTVORENI_RACUNI_STAVKE.wkss_iznos, 
		OTVORENI_RACUNI_STAVKE.wkss_nar_ns_id_pk, OTVORENI_RACUNI_STAVKE.wkss_nar_naruceno, 
 		OTVORENI_RACUNI_STAVKE.wkss_nar_status, OTVORENI_RACUNI_STAVKE.wkss_nar_napomena, 
 		OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_izdavanja, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_prihvacanja, 
 		OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_spremnosti, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_dostave, 
		OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_priority, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_name, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_oznaka, 
		ARTIKLI.ar_sifra,  ARTIKLI.ar_kpd_sifra, ARTIKLI.ar_barcode, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, 
		ARTIKLI.ar_cijena, ARTIKLI.ar_cijena_popust, ARTIKLI.ar_cijena_popust_2, ARTIKLI.ar_cijena_popust_3, 
		ARTIKLI.ar_mjesto_izdavanja_fk,
	    GRUPE_PDV.gpdv_postotak, GRUPE_PDV.gpdv_name, GRUPE_PNP.gpnp_postotak, GRUPE_PNP.gpnp_name, 
		MJESTA_IZDAVANJA.mi_oznaka
FROM	OTVORENI_RACUNI_STAVKE LEFT OUTER JOIN
			OTVORENI_RACUNI_ZAGLAVLJE ON OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk = OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk LEFT OUTER JOIN
			ARTIKLI ON OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			MJESTA_IZDAVANJA ON ARTIKLI.ar_mjesto_izdavanja_fk = MJESTA_IZDAVANJA.mi_id_pk LEFT OUTER JOIN
			GRUPE_PDV ON OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			GRUPE_PNP ON OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk = GRUPE_PNP.gpnp_id_pk
WHERE (OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk = @ID)
GO



--
-- Definition for stored procedure Izvjesca_Get_UDIO_SIROVINA_NORMATIVI : 
--
GO
CREATE PROCEDURE [dbo].[Izvjesca_Get_UDIO_SIROVINA_NORMATIVI]
(
	@si_id_pk int = null
)

AS
BEGIN
	SELECT SIROVINE.si_ime, SIROVINE.si_type, SIROVINE.si_jmj, SIROVINE.si_id_pk, SIROVINE.si_sifra, SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, GRUPE_SIROVINA.gs_name, 
                      SYS_SIROVINE_KATEGORIJE.sysk_name
	FROM SIROVINE left JOIN
                      SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk left JOIN
                      GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk
	WHERE SIROVINE.si_type=0 AND
	       (@si_id_pk is null or (SIROVINE.si_id_pk = @si_id_pk)) 

	SELECT NORMATIVI.no_id_pk, NORMATIVI.no_kolicina, NORMATIVI.no_sirovina_id_fk, NORMATIVI.no_article_id_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, GRUPE_PDV.gpdv_name, 
                      GRUPE_PNP.gpnp_name, SYS_ARTIKLI_KATEGORIJE.syak_name, SYS_PICE_KATEGORIJE.sypk_name, GRUPE_ARTIKALA.ga_name, 
                      MJESTA_IZDAVANJA.mi_oznaka, ARTIKLI.ar_cijena
	FROM NORMATIVI LEFT OUTER JOIN
                      SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
                      ARTIKLI ON NORMATIVI.no_article_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
                      GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      GRUPE_PNP ON ARTIKLI.ar_pnp_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
                      MJESTA_IZDAVANJA ON ARTIKLI.ar_mjesto_izdavanja_fk = MJESTA_IZDAVANJA.mi_id_pk LEFT OUTER JOIN
                      GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
                      SYS_PICE_KATEGORIJE ON ARTIKLI.ar_grupa_pica_fk = SYS_PICE_KATEGORIJE.sypk_id_pk LEFT OUTER JOIN
                      SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk
	WHERE SIROVINE.si_type=0 AND
		       (@si_id_pk is null or (SIROVINE.si_id_pk = @si_id_pk)) 
END
GO

--
-- Definition for stored procedure Izvjesca_Get_PROMET_PO_MESECIMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PROMET_PO_MESECIMA]
AS
SELECT	count(distinct rz_id_pk) as BR_RACUNA, T.GODINA as GODINA, T.MJESEC as MJESEC, SUM(PNP) AS PNP, SUM(PDV) AS PDV , SUM(TOTAL) AS TOTAL 
FROM (
		SELECT  RACUNI_ZAGLAVLJE.rz_id_pk ,RACUNI_ZAGLAVLJE.rz_dan,rz_broj,MONTH(RACUNI_ZAGLAVLJE.rz_dan) as MJESEC,year(RACUNI_ZAGLAVLJE.rz_dan) as GODINA,
				CAST(SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END / (100 + CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
				CAST(SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END / (100 + CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL
		FROM dbo.RACUNI_ZAGLAVLJE left join
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk --LEFT OUTER JOIN
				GROUP BY RACUNI_ZAGLAVLJE.rz_dan,gpdv_postotak,gpnp_postotak,rz_broj,RACUNI_ZAGLAVLJE.rz_id_pk) AS T 
		GROUP BY T.GODINA,t.MJESEC
		ORDER BY GODINA ,MJESEC
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODAJA_ARTIKLA_PO_DANIMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODAJA_ARTIKLA_PO_DANIMA]
(
	@ar_id_pk int,
	@day_start datetime,
	@day_end datetime
)
AS

BEGIN
select rz_dan, sum(KOLICINA) as KOLICINA, SUM(PDV) AS PDV, SUM(PNP) AS PNP, SUM(TOTAL) AS TOTAL 
		FROM (
SELECT     RACUNI_ZAGLAVLJE.rz_dan, 
	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
	CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
	CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
	SUM(RACUNI_STAVKE.rs_kolicina) AS KOLICINA
FROM       RACUNI_ZAGLAVLJE INNER JOIN
                      RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
					   ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
					   GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
					   GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
                      NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
WHERE      (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_STAVKE.rs_artikal_id_fk = @ar_id_pk)
GROUP BY   RACUNI_ZAGLAVLJE.rz_dan,rs_gpnp_id_fk,gpdv_postotak,gpnp_postotak
) AS t GROUP BY rz_dan

SELECT   SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
	CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
	CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
	SUM(RACUNI_STAVKE.rs_kolicina) AS KOLICINA
FROM       RACUNI_ZAGLAVLJE INNER JOIN
                      RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
					   ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
					   GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
					   GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
                      NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
WHERE      (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_STAVKE.rs_artikal_id_fk = @ar_id_pk)
GROUP BY   rs_gpnp_id_fk,gpdv_postotak,gpnp_postotak

END
GO

--
-- Definition for stored procedure Izvjesca_Get_PRODANI_ARTIKLI_PO_GRUPAMA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODANI_ARTIKLI_PO_GRUPAMA]
(
	@is_period_vrijeme bit = null,
	@is_period_nadnevak bit = null,
	@day_start datetime,
	@day_end datetime,
	@kn_id_pk int = null
)
AS
BEGIN
	Select * from GRUPE_ARTIKALA
END
-- lista prodanih artikala
BEGIN
	SELECT ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, 
			SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina, 
			SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
			ARTIKLI.ar_grupa_fk, GRUPE_ARTIKALA.ga_name, ARTIKLI.ar_kategorija_fk, RACUNI_STAVKE.rs_cijena as ar_cijena, SYS_ARTIKLI_KATEGORIJE.syak_name, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
            ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
            GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
            GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
            SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT OUTER JOIN
            GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
            NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
  		    (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@kn_id_pk is null or (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @kn_id_pk))
	GROUP BY ARTIKLI.ar_kategorija_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, RACUNI_STAVKE.rs_cijena, SYS_ARTIKLI_KATEGORIJE.syak_name, GRUPE_ARTIKALA.ga_name, gpnp_postotak, gpdv_postotak, ARTIKLI.ar_grupa_fk, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak
	ORDER BY ARTIKLI.ar_sifra
END
-- po svim porezima svake grupe artikala
BEGIN
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
			CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV, 
			CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
			RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
	FROM	RACUNI_STAVKE  LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk=ARTIKLI.ar_id_pk  LEFT JOIN
				GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk RIGHT OUTER JOIN
				RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
  		    (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@kn_id_pk is null or (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @kn_id_pk))
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
	order by TOTAL DESC
END
-- po svim porezima
BEGIN
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS  null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
	FROM  RACUNI_ZAGLAVLJE inner JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
			GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
			GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
  		    (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
		  (@kn_id_pk is null or (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @kn_id_pk))
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
		  RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
END
GO


--
-- Definition for stored procedure Izvjesca_Get_PRODANI_ARTIKLI : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_PRODANI_ARTIKLI]
(
	@is_period_vrijeme bit = null,
	@is_period_nadnevak bit = null,
	@day_start datetime,
	@day_end datetime,
	@pay_type_id int = null,
	@tvrtka_id int = null,
	@KonobarID int = null,
	@StolID int = null,
	@KasaID int = null,
	@NaruciteljID int = null,
	@Artikal_Kategorija_ID int = null,
	@Artikal_Grupa_ID int = null
)
AS
BEGIN
	SELECT ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, 
		    SUM(RACUNI_STAVKE.rs_iznos_bez_popusta) AS Total_Bez_Popusta, 
			SUM(RACUNI_STAVKE.rs_iznos) AS Total, SUM(RACUNI_STAVKE.rs_kolicina) AS Kolicina, 
			SUM(RACUNI_STAVKE.rs_pdv) AS PDV, SUM(RACUNI_STAVKE.rs_pnp) AS PNP, ARTIKLI.ar_kategorija_fk, RACUNI_STAVKE.rs_cijena as ar_cijena, 
			SYS_ARTIKLI_KATEGORIJE.syak_name,gpdv_name,gpdv_postotak, GRUPE_ARTIKALA.ga_name
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
			GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk  INNER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
			SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT OUTER JOIN
			GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
  		    (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@pay_type_id is null or (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @pay_type_id)) AND 
			(@tvrtka_id is null or (RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = @tvrtka_id)) AND
			(@KonobarID is null or (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @KonobarID)) AND
			(@KasaID is null or (RACUNI_ZAGLAVLJE.rz_kasa_id_fk = @KasaID)) AND
			(@NaruciteljID is null or (RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = @NaruciteljID)) AND
			(@StolID is null or (RACUNI_ZAGLAVLJE.rz_stol_id_fk = @StolID)) AND
			(@Artikal_Kategorija_ID is null or (ARTIKLI.ar_kategorija_fk = @Artikal_Kategorija_ID)) AND
			(@Artikal_Grupa_ID is null or (ARTIKLI.ar_grupa_fk = @Artikal_Grupa_ID))
	GROUP BY ARTIKLI.ar_id_pk, ARTIKLI.ar_kategorija_fk, ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, RACUNI_STAVKE.rs_cijena, SYS_ARTIKLI_KATEGORIJE.syak_name,gpdv_name,gpdv_postotak, GRUPE_ARTIKALA.ga_name

	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
			CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV, 
			CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP, 
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
			RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, SYS_ARTIKLI_KATEGORIJE.syak_id_pk, SYS_ARTIKLI_KATEGORIJE.syak_name
	FROM	RACUNI_ZAGLAVLJE INNER JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk=RACUNI_STAVKE.rs_racun_id_fk   LEFT OUTER JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk=ARTIKLI.ar_id_pk  LEFT JOIN
				SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT OUTER JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk RIGHT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
  				(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				(@pay_type_id is null or (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @pay_type_id)) AND 
				(@tvrtka_id is null or (RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = @tvrtka_id)) AND
				(@KonobarID is null or (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @KonobarID)) AND
				(@KasaID is null or (RACUNI_ZAGLAVLJE.rz_kasa_id_fk = @KasaID)) AND
				(@NaruciteljID is null or (RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = @NaruciteljID)) AND
				(@StolID is null or (RACUNI_ZAGLAVLJE.rz_stol_id_fk = @StolID))
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, SYS_ARTIKLI_KATEGORIJE.syak_id_pk, SYS_ARTIKLI_KATEGORIJE.syak_name
END
GO

--
-- Definition for stored procedure Izvjesca_Get_KNJIGA_NORMATIVA : 
--
GO
CREATE PROCEDURE [dbo].[Izvjesca_Get_KNJIGA_NORMATIVA]
(
	@use_aktivni_artikli bit = null,
	@use_neaktivni_artikli bit = null
)
AS
BEGIN
	SELECT     ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_type, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_cijena, ARTIKLI.ar_cijena_popust, ARTIKLI.ar_kategorija_fk, 
						  ARTIKLI.ar_grupa_fk, ARTIKLI.ar_pnp_fk, ARTIKLI.ar_mjesto_izdavanja_fk, ARTIKLI.ar_grupa_pica_fk, SYS_PICE_KATEGORIJE.sypk_id_pk, 
						  ARTIKLI.ar_pdv_fk, ARTIKLI.ar_is_active, SYS_ARTIKLI_KATEGORIJE.syak_name, GRUPE_ARTIKALA.ga_name, MJESTA_IZDAVANJA.mi_oznaka, 
						  SYS_PICE_KATEGORIJE.sypk_name, GRUPE_PNP.gpnp_name, GRUPE_PDV.gpdv_name, COUNT(NORMATIVI.no_article_id_fk) AS 'NormativItems', 
						  GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_postotak, ARTIKLI.ar_time_inserted
	FROM         ARTIKLI LEFT OUTER JOIN
						  NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk LEFT OUTER JOIN
						  SYS_ARTIKLI_KATEGORIJE ON ARTIKLI.ar_kategorija_fk = SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT OUTER JOIN
						  GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
						  GRUPE_PDV ON ARTIKLI.ar_pdv_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
						  MJESTA_IZDAVANJA ON ARTIKLI.ar_mjesto_izdavanja_fk = MJESTA_IZDAVANJA.mi_id_pk LEFT OUTER JOIN
						  GRUPE_PNP ON ARTIKLI.ar_pnp_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
						  SYS_PICE_KATEGORIJE ON ARTIKLI.ar_grupa_pica_fk = SYS_PICE_KATEGORIJE.sypk_id_pk
	WHERE (ARTIKLI.ar_type = 0) AND
		  (@use_aktivni_artikli IS NULL OR (NOT ARTIKLI.ar_is_active = 0)) AND 
		  (@use_neaktivni_artikli IS NULL OR (ARTIKLI.ar_is_active = 0))
	GROUP BY ARTIKLI.ar_id_pk, ARTIKLI.ar_sifra, ARTIKLI.ar_type, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, ARTIKLI.ar_cijena, ARTIKLI.ar_cijena_popust, ARTIKLI.ar_kategorija_fk, 
						  ARTIKLI.ar_grupa_fk, ARTIKLI.ar_pnp_fk, ARTIKLI.ar_mjesto_izdavanja_fk, ARTIKLI.ar_grupa_pica_fk, SYS_PICE_KATEGORIJE.sypk_id_pk, 
						  ARTIKLI.ar_pdv_fk, SYS_ARTIKLI_KATEGORIJE.syak_name, GRUPE_ARTIKALA.ga_name, MJESTA_IZDAVANJA.mi_oznaka, ARTIKLI.ar_is_active, 
						  SYS_PICE_KATEGORIJE.sypk_name, GRUPE_PNP.gpnp_name, GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_postotak, ARTIKLI.ar_time_inserted
	
	SELECT NORMATIVI.no_id_pk, NORMATIVI.no_article_id_fk, NORMATIVI.no_kolicina, NORMATIVI.no_sirovina_id_fk, SIROVINE.si_id_pk, SIROVINE.si_ime, 
           SIROVINE.si_jmj, SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, SIROVINE.si_min_kolicina, GRUPE_SIROVINA.gs_name, 
           SYS_SIROVINE_KATEGORIJE.sysk_name
	FROM NORMATIVI left JOIN
			SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk left JOIN
			ARTIKLI ON NORMATIVI.no_article_id_fk = ARTIKLI.ar_id_pk left JOIN
            GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk left JOIN
            SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE (ARTIKLI.ar_type = 0) AND
		  (@use_aktivni_artikli IS NULL OR (NOT ARTIKLI.ar_is_active = 0)) AND 
		  (@use_neaktivni_artikli IS NULL OR (ARTIKLI.ar_is_active = 0))
END
GO

--
-- Definition for stored procedure Izvjesca_Get_KNJIGA_DNEVNIH_PROMETA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_KNJIGA_DNEVNIH_PROMETA]
(
	@day_start datetime,
	@day_end datetime
)
AS
BEGIN
SELECT T2.rz_dan, PNP,PDV,TOTAL, count(distinct RACUNI_ZAGLAVLJE.rz_id_pk ) as BR_RACUNA, RZ1.rz_broj_full AS PocetniRacunFull, RZ2.rz_broj_full as ZavrsniRacunFull FROM (
	SELECT	t.rz_dan,SUM(PNP) AS PNP, SUM(PDV) AS PDV , SUM(TOTAL) AS TOTAL,min(rz_broj) as PocetniRacun, max(rz_broj) as ZavrsniRacunFull
			FROM (
		SELECT  RACUNI_ZAGLAVLJE.rz_dan,rz_broj,
				CAST(SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END / (100 + CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
				CAST(SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END / (100 + CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
				SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL
		FROM dbo.RACUNI_ZAGLAVLJE left join
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE	(RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
		GROUP BY RACUNI_ZAGLAVLJE.rz_dan,gpdv_postotak,gpnp_postotak,rz_broj) AS T 
		GROUP BY t.rz_dan) AS T2 LEFT JOIN 			
		RACUNI_ZAGLAVLJE on t2.rz_dan=RACUNI_ZAGLAVLJE.rz_dan LEFT JOIN 
RACUNI_ZAGLAVLJE RZ1 ON T2.PocetniRacun = RZ1.rz_broj LEFT JOIN
				RACUNI_ZAGLAVLJE AS RZ2 ON T2.ZavrsniRacunFull=RZ2.rz_broj
		GROUP BY T2.rz_dan, PNP, PDV, TOTAL,RZ1.rz_broj_full,RZ2.rz_broj_full
END
BEGIN
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END / (100 + CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END / (100 + CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
	FROM  RACUNI_ZAGLAVLJE inner JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
			GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
			GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (RACUNI_ZAGLAVLJE.rz_dan between  @day_start and @day_end)
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
		  RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
END
GO



--
-- Definition for stored procedure Izvjesca_Get_REKAPITULACIJA_POREZA : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_REKAPITULACIJA_POREZA]
(
	@day_start datetime,
	@day_end datetime,
	@nacin_placanja_include int = NULL,
	@nacin_placanja_exclude int = NULL,
	@sys_placanja_include int = NULL,
	@sys_placanja_exclude int = NULL
)
AS
BEGIN
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
	FROM  RACUNI_ZAGLAVLJE inner JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
			GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
			SYS_PLACANJA ON NACINI_PLACANJA.np_id_pk = SYS_PLACANJA.sypl_id_pk
	WHERE  
			(@day_start is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
			(@nacin_placanja_include is null or (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @nacin_placanja_include)) AND 
			(@nacin_placanja_exclude is null or not (RACUNI_ZAGLAVLJE.rz_placanje_id_fk = @nacin_placanja_exclude)) AND 
			(@sys_placanja_include is null or (SYS_PLACANJA.sypl_id_pk = @sys_placanja_include)) AND 
			(@sys_placanja_exclude is null or not (SYS_PLACANJA.sypl_id_pk = @sys_placanja_exclude)) 
GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
		  RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
END
GO



--
-- Definition for stored procedure Servis_Update_DNEVNI_POLOG : 
--
GO
CREATE procedure [dbo].[Servis_Update_DNEVNI_POLOG]
(
	@dp_vrijeme DateTime,
	@dp_iznos Decimal(12, 2)
)
as
BEGIN 
	DECLARE	@return_id int
	SELECT  TOP 1 @return_id = dp_id_pk FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @dp_vrijeme
	 IF @return_id IS NULL
		begin
			insert into DNEVNI_POLOG (dp_vrijeme, dp_iznos)	values	(@dp_vrijeme, @dp_iznos)
			select scope_identity()
		end
	else
	begin
		UPDATE DNEVNI_POLOG SET dp_iznos=@dp_iznos WHERE dp_id_pk= @return_id
		select @return_id
	end
END
GO

--
-- Definition for stored procedure Servis_Insert_DNEVNI_POLOG : 
--
GO
CREATE procedure [dbo].[Servis_Insert_DNEVNI_POLOG]
(
	@dp_vrijeme DateTime,
	@dp_iznos Decimal(12, 2)
)
as
BEGIN 
	DECLARE	@return_id int
	SELECT  TOP 1 @return_id = dp_id_pk FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @dp_vrijeme
	 IF @return_id IS NULL
		begin
			insert into DNEVNI_POLOG (dp_vrijeme, dp_iznos)	values	(@dp_vrijeme, @dp_iznos)
			select scope_identity()
		end
END
GO

--
-- Definition for stored procedure Servis_Get_DNEVNI_POLOG_BY_NADNEVAK : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_DNEVNI_POLOG_BY_NADNEVAK]
(
	@dp_vrijeme DateTime
)
AS
SELECT * FROM DNEVNI_POLOG WHERE dp_vrijeme = @dp_vrijeme
GO

--
-- Definition for stored procedure Servis_Get_DNEVNI_POLOG_LIST_ALL : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Get_DNEVNI_POLOG_LIST_ALL]
AS
Select * from DNEVNI_POLOG
GO

--
-- Definition for stored procedure Servis_Delete_DNEVNI_POLOG : 
--
GO
CREATE PROCEDURE [dbo].[Servis_Delete_DNEVNI_POLOG]
(
	@dp_id_pk int
)
AS
delete DNEVNI_POLOG where dp_id_pk = @dp_id_pk
GO

--
-- Definition for stored procedure Izvjesca_Get_FINANCIJSKO_BY_KONOBAR_ID : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_FINANCIJSKO_BY_KONOBAR_ID]
(
	@RET_DNEVNI_POLOG AS DECIMAL (12,2) OUTPUT,
	@day_start datetime,
	@day_end datetime,
	@rz_konobar_id_fk int,
	@is_dnevni_izvjestaj bit
)
AS
BEGIN
-- po nacinima placanja
SELECT	np_id_pk, np_name, np_category_fk, sypl_name_long, 
		SUM(TOTAL) AS TOTAL, SUM(PDV) AS PDV, SUM(PNP) AS PNP FROM (
			SELECT	NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, np_category_fk, sypl_name_long,
					SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, SUM(RACUNI_ZAGLAVLJE.rz_pdv) AS PDV, SUM(RACUNI_ZAGLAVLJE.rz_pnp) AS PNP
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT JOIN
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @rz_konobar_id_fk)
		GROUP BY NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_id_pk, np_category_fk, sypl_name_long
) AS T GROUP BY np_id_pk, np_name, np_category_fk, sypl_name_long ORDER BY TOTAL DESC
-- po detaljnim nacinima placanja
SELECT np_id_pk, np_name, np_category_fk, sypl_name_long, SUM(TOTAL) AS TOTAL FROM (
		SELECT NP1.np_id_pk, NP1.np_name, np_category_fk, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL
		FROM RACUNI_ZAGLAVLJE inner JOIN
				NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
				SYS_PLACANJA ON NP1.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @rz_konobar_id_fk)
		GROUP BY NP1.np_name, NP1.np_id_pk, np_category_fk, sypl_name_long
	union all
		SELECT NP2.np_id_pk, NP2.np_name, np_category_fk, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL
		FROM RACUNI_ZAGLAVLJE inner JOIN
				NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
				SYS_PLACANJA ON NP2.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @rz_konobar_id_fk)
		GROUP BY NP2.np_name, NP2.np_id_pk, np_category_fk, sypl_name_long
	union all
		SELECT NP3.np_id_pk, NP3.np_name, np_category_fk, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL
		FROM RACUNI_ZAGLAVLJE inner JOIN
				NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
				SYS_PLACANJA ON NP3.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan BETWEEN @day_start AND @day_end) AND (RACUNI_ZAGLAVLJE.rz_konobar_id_fk = @rz_konobar_id_fk)
		GROUP BY NP3.np_name, NP3.np_id_pk, np_category_fk, sypl_name_long
) AS T GROUP BY np_id_pk,np_name,np_category_fk,sypl_name_long ORDER BY TOTAL DESC
END

if @is_dnevni_izvjestaj = 1
BEGIN
	-- dnevni polog
	SELECT @RET_DNEVNI_POLOG = dp_iznos FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @day_start
END
GO



--
-- Definition for stored procedure Izvjesca_Get_FINANCIJSKO : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_FINANCIJSKO]
(
	@use_po_konobarima bit,
	@use_po_grupama_artikala bit,
	@use_po_kategorijama_artikala bit,
	@use_po_kategorijama_pica bit,
	@use_po_kasama bit,
	@use_po_vrstama_placanja bit,
	@is_period_dnevni bit = null,
	@is_period_vrijeme bit = null,
	@is_period_nadnevak bit = null,
	@RET_DNEVNI_POLOG AS DECIMAL (12,2) OUTPUT,
	@RET_GOTOVINA_BLAGAJNA AS DECIMAL (12,2) OUTPUT,
	@day_start datetime,
	@day_end datetime,
	@use_shift bit = null,
	@shift_min_start int = null,
	@shift_min_end int = null
)
AS
-------------------------------------------------------------------
---------------------------------- PO KONOBARIMA
-------------------------------------------------------------------
if @use_po_konobarima = 1
BEGIN
	-- po konobarima
	SELECT kn_id_pk, kn_name,SUM(TOTAL)AS TOTAL FROM (
			SELECT SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, KONOBARI.kn_id_pk, KONOBARI.kn_name
			FROM RACUNI_ZAGLAVLJE INNER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk INNER JOIN
				KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk
			WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
				  (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				  (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				  (@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
				  (@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
			GROUP BY KONOBARI.kn_name, KONOBARI.kn_id_pk
	) AS T GROUP BY kn_id_pk, kn_name ORDER BY TOTAL DESC
	-- po konobarima i nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, kn_name, SUM(TOTAL) AS TOTAL, SUM(PDV) AS PDV, SUM(PNP) AS PNP, np_sort FROM (
				SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, kn_name, 
						SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, 
						SUM(RACUNI_ZAGLAVLJE.rz_pdv) AS PDV, 
						SUM(RACUNI_ZAGLAVLJE.rz_pnp) AS PNP
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk left join
						KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk =KONOBARI.kn_id_pk left join
						SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
				WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
						(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, kn_name
	) AS T GROUP BY np_id_pk, np_name, sypl_name_long, kn_name, np_sort ORDER BY np_sort ASC
	-- po konobarima i detaljnim nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, kn_name, SUM(TOTAL) AS TOTAL, np_sort FROM (
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, kn_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL  
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NACINI_PLACANJA.np_id_pk left join
					KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
					  (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					  (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					  (@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					  (@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, kn_name
			union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, kn_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL   
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NACINI_PLACANJA.np_id_pk left join
					KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
					    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, kn_name
			union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, kn_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL     
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NACINI_PLACANJA.np_id_pk left join
					KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
				WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
						(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, kn_name
	) AS T WHERE np_id_pk is not null 
		GROUP BY np_id_pk, np_name, sypl_name_long, np_sort, kn_name ORDER BY np_sort ASC
END
-------------------------------------------------------------------
---------------------------------- PO GRUPAMA ARTIKALA
-------------------------------------------------------------------
if @use_po_grupama_artikala = 1
BEGIN
	---- po grupama artikala
	SELECT  GRUPA_ARTIKALA_ID, GRUPA_ARTIKALA, SUM (TOTAL) AS TOTAL FROM (
			SELECT	GRUPE_ARTIKALA.ga_id_pk as GRUPA_ARTIKALA_ID,
					GRUPE_ARTIKALA.ga_name as GRUPA_ARTIKALA, 
					SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL
			FROM	RACUNI_STAVKE  LEFT JOIN
					ARTIKLI ON  RACUNI_STAVKE.rs_artikal_id_fk =ARTIKLI.ar_id_pk LEFT JOIN
					GRUPE_ARTIKALA ON  ARTIKLI.ar_grupa_fk =GRUPE_ARTIKALA.ga_id_pk LEFT JOIN
					RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
			WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
				    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
			GROUP BY GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
			UNION 
			SELECT  GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name as GRUPA_ARTIKALA,0 AS TOTAL FROM GRUPE_ARTIKALA
	)AS T GROUP BY GRUPA_ARTIKALA_ID, GRUPA_ARTIKALA ORDER BY TOTAL DESC
	---- po svim porezima svake grupe artikala
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
			CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL 
				THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV, 
			CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL 
				THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP,
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
			RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
	FROM	RACUNI_STAVKE  LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk=ARTIKLI.ar_id_pk  LEFT JOIN
				GRUPE_ARTIKALA ON ARTIKLI.ar_grupa_fk = GRUPE_ARTIKALA.ga_id_pk LEFT OUTER JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk RIGHT OUTER JOIN
				RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
				(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND  
				(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
				(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
	GROUP BY	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, GRUPE_ARTIKALA.ga_id_pk, GRUPE_ARTIKALA.ga_name
	order by  GRUPE_ARTIKALA.ga_name
END
-------------------------------------------------------------------
---------------------------------- PO KATEGORIJAMA ARTIKALA
-------------------------------------------------------------------
if @use_po_kategorijama_artikala = 1
BEGIN
	--Po kategorijama
	SELECT KATEGORIJA_ARTIKALA,SUM(TOTAL) AS TOTAL FROM (
		SELECT	SYS_ARTIKLI_KATEGORIJE.syak_name as KATEGORIJA_ARTIKALA, SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL
		FROM	RACUNI_STAVKE  LEFT JOIN
					ARTIKLI ON  RACUNI_STAVKE.rs_artikal_id_fk =ARTIKLI.ar_id_pk LEFT JOIN
					SYS_ARTIKLI_KATEGORIJE ON  ARTIKLI.ar_kategorija_fk =SYS_ARTIKLI_KATEGORIJE.syak_id_pk LEFT JOIN
					RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
		WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
					(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
		GROUP BY	SYS_ARTIKLI_KATEGORIJE.syak_name
		UNION 
		SELECT SYS_ARTIKLI_KATEGORIJE.syak_name as KATEGORIJA_ARTIKALA, 0 AS TOTAL FROM SYS_ARTIKLI_KATEGORIJE 
	) AS T GROUP BY KATEGORIJA_ARTIKALA ORDER BY TOTAL DESC
	---- po svim porezima svake kategorije artikla
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL 
					THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL 
					THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, SYS_PICE_KATEGORIJE.sypk_id_pk, SYS_PICE_KATEGORIJE.sypk_name
	FROM		GRUPE_PDV RIGHT OUTER JOIN
					SYS_PICE_KATEGORIJE INNER JOIN
					ARTIKLI ON SYS_PICE_KATEGORIJE.sypk_id_pk = ARTIKLI.ar_grupa_pica_fk RIGHT OUTER JOIN
					RACUNI_STAVKE ON ARTIKLI.ar_id_pk = RACUNI_STAVKE.rs_artikal_id_fk LEFT OUTER JOIN
					GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk ON 
					GRUPE_PDV.gpdv_id_pk = RACUNI_STAVKE.rs_gpdv_id_fk RIGHT OUTER JOIN
					RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE		(@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
				    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
	GROUP BY	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
					RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, SYS_PICE_KATEGORIJE.sypk_id_pk, SYS_PICE_KATEGORIJE.sypk_name
END
-------------------------------------------------------------------
---------------------------------- PO KATEGORIJAMA PICA
-------------------------------------------------------------------
if @use_po_kategorijama_pica = 1
BEGIN
	---- Po kategorijama pica
	SELECT  sypk_id_pk, KATEGORIJA_PICE, SUM (TOTAL) AS TOTAL FROM (
		SELECT	SYS_PICE_KATEGORIJE_1.sypk_id_pk, SYS_PICE_KATEGORIJE_1.sypk_name AS KATEGORIJA_PICE, SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL
		FROM	GRUPE_ARTIKALA RIGHT OUTER JOIN
					SYS_PICE_KATEGORIJE INNER JOIN
					ARTIKLI ON SYS_PICE_KATEGORIJE.sypk_id_pk = ARTIKLI.ar_grupa_pica_fk RIGHT OUTER JOIN
					RACUNI_ZAGLAVLJE INNER JOIN
					SYS_PLACANJA INNER JOIN
					NACINI_PLACANJA ON SYS_PLACANJA.sypl_id_pk = NACINI_PLACANJA.np_category_fk ON 
					RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
					RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk ON ARTIKLI.ar_id_pk = RACUNI_STAVKE.rs_artikal_id_fk ON 
					GRUPE_ARTIKALA.ga_id_pk = ARTIKLI.ar_grupa_fk LEFT OUTER JOIN
					SYS_PICE_KATEGORIJE AS SYS_PICE_KATEGORIJE_1 ON ARTIKLI.ar_grupa_pica_fk = SYS_PICE_KATEGORIJE_1.sypk_id_pk
		WHERE	(@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
				    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND  
					NOT ARTIKLI.ar_grupa_pica_fk IS NULL and (NOT (ARTIKLI.ar_grupa_pica_fk IS NULL)) AND (NOT RACUNI_STAVKE.rs_gpnp_id_fk Is null) AND
					(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
		group by SYS_PICE_KATEGORIJE_1.sypk_id_pk, SYS_PICE_KATEGORIJE_1.sypk_name 
		UNION 
		SELECT  SYS_PICE_KATEGORIJE.sypk_id_pk, SYS_PICE_KATEGORIJE.sypk_name AS KATEGORIJA_PICE, 0 AS TOTAL FROM SYS_PICE_KATEGORIJE
	)AS T GROUP BY sypk_id_pk, KATEGORIJA_PICE order by sypk_id_pk
	---- po svim porezima svake kategorije
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + 
					CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + 
					CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, SYS_PICE_KATEGORIJE.sypk_name, SYS_PICE_KATEGORIJE.sypk_id_pk
	FROM	SYS_PICE_KATEGORIJE INNER JOIN
				ARTIKLI ON SYS_PICE_KATEGORIJE.sypk_id_pk = ARTIKLI.ar_grupa_pica_fk RIGHT OUTER JOIN
				RACUNI_ZAGLAVLJE INNER JOIN
				RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk ON 
				ARTIKLI.ar_id_pk = RACUNI_STAVKE.rs_artikal_id_fk LEFT OUTER JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
   			    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				NOT ARTIKLI.ar_grupa_pica_fk IS NULL AND (NOT RACUNI_STAVKE.rs_gpnp_id_fk Is null) AND 
				(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
				(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, 
				RACUNI_STAVKE.rs_gpnp_id_fk, SYS_PICE_KATEGORIJE.sypk_name, SYS_PICE_KATEGORIJE.sypk_id_pk
END
-------------------------------------------------------------------
---------------------------------- PO KASAMA
-------------------------------------------------------------------
if @use_po_kasama = 1
BEGIN
	-- po kasama
	select sum(TOTAL) AS TOTAL ,ks_name FROM(
		SELECT SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, KASE.ks_name
			FROM	RACUNI_ZAGLAVLJE INNER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk
			WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
   					    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
		GROUP BY KASE.ks_name 
	) AS T GROUP BY ks_name ORDER BY ks_name ASC
	-- po svim porezima svake kase posebno
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL 
					THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV,
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL 
					THEN 0 ELSE gpdv_postotak END + CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, KASE.ks_id_pk, KASE.ks_name, KASE.ks_description
	FROM	RACUNI_STAVKE  LEFT JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk=ARTIKLI.ar_id_pk  LEFT JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk RIGHT OUTER JOIN
				RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
				KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
				(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
				(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
				(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
	GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
				RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, KASE.ks_id_pk, KASE.ks_name, KASE.ks_description
	ORDER BY KASE.ks_name DESC
	-- po kasama i nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, ks_name, SUM(TOTAL) AS TOTAL, SUM(PDV) AS PDV, SUM(PNP) AS PNP, np_sort FROM (
				SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name, 
						SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, 
						SUM(RACUNI_ZAGLAVLJE.rz_pdv) AS PDV, 
						SUM(RACUNI_ZAGLAVLJE.rz_pnp) AS PNP
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk left join
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk =KASE.ks_id_pk left join
						SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
				WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
						(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
	) AS T GROUP BY np_id_pk, np_name, sypl_name_long, ks_name, np_sort ORDER BY np_sort ASC
	-- po kasama i detaljnim nacinima placanja
	SELECT np_id_pk, np_name, sypl_name_long, ks_name, SUM(TOTAL) AS TOTAL, np_sort FROM (
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL  
			FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NACINI_PLACANJA.np_id_pk left join
					KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
					  (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					  (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					  (@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					  (@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
			union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL   
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NACINI_PLACANJA.np_id_pk left join
					KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
			WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
					    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
			union all
			SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, ks_name, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL     
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
					NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NACINI_PLACANJA.np_id_pk left join
					KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk left join
					SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
				WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
						(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
				GROUP BY NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, ks_name
	) AS T WHERE np_id_pk is not null 
		GROUP BY np_id_pk, np_name, sypl_name_long, np_sort, ks_name ORDER BY np_sort ASC
END
-------------------------------------------------------------------
---------------------------------- PO VRSTAMA PLACANJA
-------------------------------------------------------------------
if @use_po_vrstama_placanja = 1
BEGIN
	-- po osnovnim nacinima placanja
	SELECT np_id_pk, np_name, np_category_fk, sypl_name_long, np_sort,
			SUM(TOTAL) AS TOTAL, SUM(PDV) AS PDV, SUM(PNP) AS PNP 
			FROM (SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_sort, np_category_fk, sypl_name_long,
				  SUM(RACUNI_ZAGLAVLJE.rz_iznos) AS TOTAL, SUM(RACUNI_ZAGLAVLJE.rz_pdv) AS PDV, SUM(RACUNI_ZAGLAVLJE.rz_pnp) AS PNP
						FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
							NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT JOIN
							SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk 
						WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
								(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
								(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
								(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
								(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
						GROUP BY NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, np_category_fk, sypl_name_long
	) AS T GROUP BY np_id_pk, np_name, np_category_fk, np_sort, sypl_name_long ORDER BY np_sort ASC
	-- po detaljnim nacinima placanja
	SELECT np_id_pk, np_name, np_category_fk, sypl_name_long,
			SUM(TOTAL) AS TOTAL
			FROM (SELECT NP1.np_id_pk, NP1.np_name, NP1.np_sort, np_category_fk, sypl_sort, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) AS TOTAL 
					FROM RACUNI_ZAGLAVLJE inner JOIN
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						SYS_PLACANJA ON NP1.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
					WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
							(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
							(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
							(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
							(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
					GROUP BY NP1.np_name, NP1.np_id_pk, NP1.np_sort, np_category_fk, sypl_sort, sypl_name_long
			union all
				  SELECT NP2.np_id_pk, NP2.np_name, NP2.np_sort, np_category_fk, sypl_sort, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) AS TOTAL
					FROM RACUNI_ZAGLAVLJE inner JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						SYS_PLACANJA ON NP2.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
					WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
							(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
							(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
							(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
							(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
					GROUP BY NP2.np_name, NP2.np_id_pk, NP2.np_sort, np_category_fk, sypl_sort, sypl_name_long
			union all
				  SELECT NP3.np_id_pk, NP3.np_name, NP3.np_sort, np_category_fk, sypl_sort, sypl_name_long, SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) AS TOTAL
					FROM RACUNI_ZAGLAVLJE inner JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
						SYS_PLACANJA ON NP3.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
					WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
							(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
							(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
							(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
							(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
					GROUP BY NP3.np_name, NP3.np_id_pk, NP3.np_sort, np_category_fk, sypl_sort, sypl_name_long
	) AS T GROUP BY np_id_pk,np_name, np_sort, np_category_fk, sypl_sort, sypl_name_long ORDER BY np_sort ASC
	-- po svim porezima svake vrste placanja
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + 
					CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + 
					CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, 
				RACUNI_STAVKE.rs_gpnp_id_fk, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_long
	FROM	RACUNI_ZAGLAVLJE LEFT OUTER JOIN
				RACUNI_STAVKE LEFT OUTER JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk ON 
				RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT OUTER JOIN
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
				SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
	WHERE		(@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
					(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
	GROUP BY	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
					RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_long
END
-------------------------------------------------------------------
---------------------------------- PO SVIM POREZIMA
-------------------------------------------------------------------
BEGIN
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL , 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
	FROM  RACUNI_ZAGLAVLJE inner JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk LEFT JOIN
			GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT JOIN
			GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
		  (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
		  (@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
		  (@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
		  (@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
		  RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
END
-------------------------------------------------------------------
---------------------------------- UKUPAN BROJ, PRVI I ZADNJI RACUN
-------------------------------------------------------------------
BEGIN
SELECT	T.BrojRacuna, RACUNI_ZAGLAVLJE.rz_broj AS PocetniRacun, RACUNI_ZAGLAVLJE.rz_broj_full AS PocetniRacunFull, RZ2.rz_broj AS ZavrsniRacun, RZ2.rz_broj_full AS ZavrsniRacunFull FROM (
			SELECT	min(rz_broj) as PocetniRacun, max(rz_broj) as ZavrsniRacun, count(distinct rz_id_pk) AS BrojRacuna FROM 
			RACUNI_ZAGLAVLJE 
			WHERE(
					(@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
  				    (@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
					(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
					(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
					))as T LEFT JOIN 
				RACUNI_ZAGLAVLJE ON T.PocetniRacun = RACUNI_ZAGLAVLJE.rz_broj LEFT JOIN
				RACUNI_ZAGLAVLJE AS RZ2 ON T.ZavrsniRacun=RZ2.rz_broj
END
-------------------------------------------------------------------
---------------------------------- DNEVNI POLOG - STANJE GOTOVINE
-------------------------------------------------------------------
if @is_period_dnevni is not null
BEGIN
	-- dnevni polog
	SELECT @RET_DNEVNI_POLOG = dp_iznos FROM dbo.DNEVNI_POLOG WHERE dp_vrijeme = @day_start
	-- ukupna vrijednost samo gotovinskog placanja i koliko treba biti u kasi
	DECLARE @KASA_NP1 DECIMAL(12,2)
	DECLARE @KASA_NP2 DECIMAL(12,2)
	DECLARE @KASA_NP3 DECIMAL(12,2)

	SELECT @KASA_NP1 = SUM(RACUNI_ZAGLAVLJE.rz_pl_1_iznos) 
		FROM RACUNI_ZAGLAVLJE left join
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day_start) and NACINI_PLACANJA.np_category_fk = 2 AND
				(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
				(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
	SELECT @KASA_NP2 = SUM(RACUNI_ZAGLAVLJE.rz_pl_2_iznos) 
			FROM RACUNI_ZAGLAVLJE left join
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day_start) and NACINI_PLACANJA.np_category_fk = 2 AND
				(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
				(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))
	SELECT @KASA_NP3 = SUM(RACUNI_ZAGLAVLJE.rz_pl_3_iznos) 
			FROM RACUNI_ZAGLAVLJE left join
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NACINI_PLACANJA.np_id_pk 
		WHERE (RACUNI_ZAGLAVLJE.rz_dan = @day_start) and NACINI_PLACANJA.np_category_fk = 2 AND
				(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
				(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))

	if @KASA_NP1 is null set @KASA_NP1 = 0
	if @KASA_NP2 is null set @KASA_NP2 = 0
	if @KASA_NP3 is null set @KASA_NP3 = 0
	if @RET_DNEVNI_POLOG is null set @RET_DNEVNI_POLOG = 0
	set @RET_GOTOVINA_BLAGAJNA = @KASA_NP1 + @KASA_NP2 + @KASA_NP3 + @RET_DNEVNI_POLOG
END
GO



--
-- Definition for stored procedure Izvjesca_Get_FINANCIJSKO_NAPOJNICE : 
--
GO
CREATE procedure [dbo].[Izvjesca_Get_FINANCIJSKO_NAPOJNICE]
(
	@is_period_dnevni bit = null,
	@is_period_vrijeme bit = null,
	@is_period_nadnevak bit = null,
	@day_start datetime,
	@day_end datetime,
	@use_shift bit = null,
	@shift_min_start int = null,
	@shift_min_end int = null
)
AS
	SELECT np_id_pk, np_name, np_sort, SUM(TOTAL) AS TOTAL,
	       sypl_id_pk, sypl_name_short, sypl_name_long, sypl_sort, rz_konobar_id_fk, kn_name FROM (
				SELECT NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_sort, 
				       SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_short, SYS_PLACANJA.sypl_name_long, SYS_PLACANJA.sypl_sort,  
				       RACUNI_ZAGLAVLJE.rz_konobar_id_fk, kn_name, 
						SUM(RACUNI_ZAGLAVLJE.rz_fis_nap_iznos) AS TOTAL
				FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NACINI_PLACANJA.np_id_pk left join
						KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk =KONOBARI.kn_id_pk left join
						SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk = SYS_PLACANJA.sypl_id_pk
				WHERE   (NOT RACUNI_ZAGLAVLJE.rz_fis_nap_iznos = 0) AND 
						(@is_period_vrijeme is null or (RACUNI_ZAGLAVLJE.rz_vrijeme between @day_start and @day_end)) AND 
						(@is_period_dnevni is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@is_period_nadnevak is null or (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)) AND 
						(@use_shift is null or ((@shift_min_end > @shift_min_start and datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+(60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_start and @shift_min_end) OR 
						(@shift_min_end < @shift_min_start and not datepart(mi,RACUNI_ZAGLAVLJE.rz_vrijeme)+ (60 * datepart(hh,RACUNI_ZAGLAVLJE.rz_vrijeme)) between @shift_min_end and @shift_min_start)))

				GROUP BY NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_sort, kn_name,
				RACUNI_ZAGLAVLJE.rz_konobar_id_fk, SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_short, SYS_PLACANJA.sypl_name_long, SYS_PLACANJA.sypl_sort
	) AS T GROUP BY np_id_pk, np_name, sypl_name_long, kn_name, np_sort, rz_konobar_id_fk, sypl_id_pk, sypl_name_short, sypl_sort ORDER BY np_sort ASC
GO




--
-- Definition for stored procedure Management_Get_KONZUMACIJA_BY_ID : 
--
GO
CREATE procedure [dbo].[Management_Get_KONZUMACIJA_BY_ID]
(
	@kzz_id_pk int
)
AS
BEGIN
SELECT KONZUMACIJA_ZAGLAVLJE.kzz_id_pk, 
		KONZUMACIJA_ZAGLAVLJE.kzz_racun_id_fk, RACUNI_ZAGLAVLJE.rz_broj_full, RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, 
		KONZUMACIJA_ZAGLAVLJE.kzz_konobar_id_fk, KONOBARI.kn_name, KONOBARI.kn_oznaka, KONOBARI.kn_oib, KONOBARI.kn_status,
		KONZUMACIJA_ZAGLAVLJE.kzz_stol_id_fk, STOLOVI.st_name, STOLOVI.st_description, 
		KONZUMACIJA_ZAGLAVLJE.kzz_tvrtka_id_fk, TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_state, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj,
		KONZUMACIJA_ZAGLAVLJE.kzz_narucitelj_id_fk, NARUCITELJI.na_ime, NARUCITELJI.na_kartica, 
		KONZUMACIJA_ZAGLAVLJE.kzz_kasa_id_fk, KASE.ks_name, 
		KONZUMACIJA_ZAGLAVLJE.kzz_vrijeme, KONZUMACIJA_ZAGLAVLJE.kzz_nadnevak, 
		KONZUMACIJA_ZAGLAVLJE.kzz_broj_dnevni, KONZUMACIJA_ZAGLAVLJE.kzz_broj_full, 
		KONZUMACIJA_ZAGLAVLJE.kzz_popust, KONZUMACIJA_ZAGLAVLJE.kzz_iznos_bez_popusta, KONZUMACIJA_ZAGLAVLJE.kzz_iznos, 
		KONZUMACIJA_ZAGLAVLJE.kzz_pdv, KONZUMACIJA_ZAGLAVLJE.kzz_pnp, KONZUMACIJA_ZAGLAVLJE.kzz_napomena  
FROM KONZUMACIJA_ZAGLAVLJE LEFT OUTER JOIN
						RACUNI_ZAGLAVLJE ON KONZUMACIJA_ZAGLAVLJE.kzz_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
						KASE ON KONZUMACIJA_ZAGLAVLJE.kzz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						KONOBARI ON KONZUMACIJA_ZAGLAVLJE.kzz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
						NARUCITELJI ON KONZUMACIJA_ZAGLAVLJE.kzz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						TVRTKE ON KONZUMACIJA_ZAGLAVLJE.kzz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						STOLOVI ON KONZUMACIJA_ZAGLAVLJE.kzz_stol_id_fk = STOLOVI.st_id_pk
where (@kzz_id_pk is null or (KONZUMACIJA_ZAGLAVLJE.kzz_id_pk = @kzz_id_pk))

SELECT	KONZUMACIJA_STAVKE.kzs_id_pk, KONZUMACIJA_STAVKE.kzs_kzz_id_fk, 
		KONZUMACIJA_STAVKE.kzs_artikal_id_fk, ARTIKLI.ar_naziv, ARTIKLI.ar_sifra, ARTIKLI.ar_barcode, ARTIKLI.ar_jmj, 
		KONZUMACIJA_STAVKE.kzs_kolicina, KONZUMACIJA_STAVKE.kzs_cijena_bez_popusta, KONZUMACIJA_STAVKE.kzs_cijena, 
		KONZUMACIJA_STAVKE.kzs_popust, KONZUMACIJA_STAVKE.kzs_iznos_bez_popusta, KONZUMACIJA_STAVKE.kzs_iznos, 
		KONZUMACIJA_STAVKE.kzs_pdv, KONZUMACIJA_STAVKE.kzs_pnp, 
		KONZUMACIJA_STAVKE.kzs_gpdv_id_fk, KONZUMACIJA_STAVKE.kzs_gpnp_id_fk, GRUPE_PDV.gpdv_name, GRUPE_PNP.gpnp_name,  GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_postotak, 
 		KONZUMACIJA_STAVKE.kzs_napomena                     
FROM         KONZUMACIJA_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON KONZUMACIJA_STAVKE.kzs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      GRUPE_PNP ON KONZUMACIJA_STAVKE.kzs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
                      ARTIKLI ON KONZUMACIJA_STAVKE.kzs_artikal_id_fk = ARTIKLI.ar_id_pk
	where
		kzs_kzz_id_fk = @kzz_id_pk
END
GO



--
-- Definition for stored procedure Management_Get_NABAVNI_NALOG_BY_ID : 
--
CREATE procedure [dbo].[Management_Get_NABAVNI_NALOG_BY_ID]
(
	@nnz_id_pk int
)
AS
BEGIN
	SELECT NABAVNI_NALOG_ZAGLAVLJE.nnz_id_pk, NABAVNI_NALOG_ZAGLAVLJE.nnz_broj, NABAVNI_NALOG_ZAGLAVLJE.nnz_nadnevak, 
			NABAVNI_NALOG_ZAGLAVLJE.nnz_kn_id_fk, NABAVNI_NALOG_ZAGLAVLJE.nnz_do_id_fk, NABAVNI_NALOG_ZAGLAVLJE.nnz_napomena, 
			KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, KONOBARI.kn_oznaka, 
			DOBAVLJACI.do_name, DOBAVLJACI.do_adresa, DOBAVLJACI.do_mjesto,  DOBAVLJACI.do_oib
	FROM NABAVNI_NALOG_ZAGLAVLJE LEFT OUTER JOIN
			DOBAVLJACI ON NABAVNI_NALOG_ZAGLAVLJE.nnz_do_id_fk = DOBAVLJACI.do_id_pk LEFT OUTER JOIN
			KONOBARI ON NABAVNI_NALOG_ZAGLAVLJE.nnz_kn_id_fk = KONOBARI.kn_id_pk
	WHERE (@nnz_id_pk is null or (NABAVNI_NALOG_ZAGLAVLJE.nnz_id_pk = @nnz_id_pk))


	SELECT NABAVNI_NALOG_STAVKE.*, 
		SIROVINE.si_ime, SIROVINE.si_jmj,  SIROVINE.si_sifra, SIROVINE.si_grupa_fk, SIROVINE.si_kategorija_fk, 
		GRUPE_SIROVINA.gs_name, SYS_SIROVINE_KATEGORIJE.sysk_name
	FROM NABAVNI_NALOG_STAVKE LEFT OUTER JOIN
			SIROVINE ON NABAVNI_NALOG_STAVKE.nns_sirovina_id_fk = SIROVINE.si_id_pk LEFT OUTER JOIN
			GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT OUTER JOIN			
			SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk			
	WHERE (NABAVNI_NALOG_STAVKE.nns_nabavni_nalog_id_fk = @nnz_id_pk)
END
GO



--
-- Definition for stored procedure Management_Get_NARUDZBA_BY_ID : 
--
CREATE procedure [dbo].[Management_Get_NARUDZBA_BY_ID]
(
	@nz_id_pk int
)
AS
BEGIN
	SELECT NARUDZBE_ZAGLAVLJE.nz_id_pk, NARUDZBE_ZAGLAVLJE.nz_action_type, NARUDZBE_ZAGLAVLJE.nz_broj_full, 
                      NARUDZBE_ZAGLAVLJE.nz_broj_dnevni, NARUDZBE_ZAGLAVLJE.nz_vrijeme, NARUDZBE_ZAGLAVLJE.nz_dan, 
                      NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk, NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk, NARUDZBE_ZAGLAVLJE.nz_stol_id_fk, 
					  NARUDZBE_ZAGLAVLJE.nz_popust, NARUDZBE_ZAGLAVLJE.nz_iznos_bez_popusta, NARUDZBE_ZAGLAVLJE.nz_iznos,
					  KONOBARI.kn_name, KONOBARI.kn_oznaka, KONOBARI.kn_oib, KONOBARI.kn_status, 
					  STOLOVI.st_name, STOLOVI.st_name, STOLOVI.st_description, KASE.ks_name
	FROM NARUDZBE_ZAGLAVLJE LEFT OUTER JOIN
					  NARUDZBE_STAVKE ON NARUDZBE_ZAGLAVLJE.nz_id_pk = NARUDZBE_STAVKE.ns_nz_id_fk LEFT OUTER JOIN
					  KONOBARI ON NARUDZBE_ZAGLAVLJE.nz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
					  KASE ON NARUDZBE_ZAGLAVLJE.nz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
					  STOLOVI ON NARUDZBE_ZAGLAVLJE.nz_stol_id_fk = STOLOVI.st_id_pk 
	WHERE (@nz_id_pk is null or (NARUDZBE_ZAGLAVLJE.nz_id_pk = @nz_id_pk))

	SELECT	NARUDZBE_STAVKE.ns_id_pk, NARUDZBE_STAVKE.ns_nz_id_fk, NARUDZBE_STAVKE.ns_ar_id_fk,
			NARUDZBE_STAVKE.ns_napomena, NARUDZBE_STAVKE.ns_ar_cijena, NARUDZBE_STAVKE.ns_kolicina,
			NARUDZBE_STAVKE.ns_iznos, NARUDZBE_STAVKE.ns_popust, NARUDZBE_STAVKE.ns_iznos_bez_popusta, NARUDZBE_STAVKE.ns_slijed,
			NARUDZBE_STAVKE.ns_mi_id_fk,
			NARUDZBE_STAVKE.ns_vrijeme_izdavanja, NARUDZBE_STAVKE.ns_vrijeme_prihvacanja, 
			NARUDZBE_STAVKE.ns_vrijeme_spremnosti, NARUDZBE_STAVKE.ns_vrijeme_dostave, 
			NARUDZBE_STAVKE.ns_status,
			ARTIKLI.ar_sifra, ARTIKLI.ar_naziv, 
			MJESTA_IZDAVANJA.mi_oznaka
	FROM    NARUDZBE_STAVKE LEFT OUTER JOIN
			ARTIKLI ON NARUDZBE_STAVKE.ns_ar_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			MJESTA_IZDAVANJA ON NARUDZBE_STAVKE.ns_mi_id_fk = MJESTA_IZDAVANJA.mi_id_pk
	WHERE
			ns_nz_id_fk = @nz_id_pk
END
GO



--
-- Definition for stored procedure Management_Get_OTVORENI_RACUN_BY_ID : 
--
CREATE procedure [dbo].[Management_Get_OTVORENI_RACUN_BY_ID]
(
	@wks_id_pk int
)
AS
BEGIN

	SELECT OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk, OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk, OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk, 
			OTVORENI_RACUNI_ZAGLAVLJE.wks_vrijeme, OTVORENI_RACUNI_ZAGLAVLJE.wks_napomena, OTVORENI_RACUNI_ZAGLAVLJE.wks_is_used, 
			KONOBARI.kn_name, KONOBARI.kn_oznaka, KONOBARI.kn_status, KONOBARI.kn_oib,  
			STOLOVI.ts_id_fk, STOLOVI.st_name, STOLOVI.st_description, 
			SUM(OTVORENI_RACUNI_STAVKE.wkss_iznos) AS suma
	FROM OTVORENI_RACUNI_ZAGLAVLJE LEFT OUTER JOIN
			KONOBARI ON OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
			STOLOVI ON OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk = STOLOVI.st_id_pk LEFT OUTER JOIN
			OTVORENI_RACUNI_STAVKE ON OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk = OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk
	WHERE wks_id_pk = @wks_id_pk
	GROUP BY OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk, OTVORENI_RACUNI_ZAGLAVLJE.wks_konobar_id_fk, OTVORENI_RACUNI_ZAGLAVLJE.wks_stol_id_fk, 
			OTVORENI_RACUNI_ZAGLAVLJE.wks_vrijeme, OTVORENI_RACUNI_ZAGLAVLJE.wks_napomena, OTVORENI_RACUNI_ZAGLAVLJE.wks_is_used, 
			KONOBARI.kn_name, KONOBARI.kn_oznaka, KONOBARI.kn_status, KONOBARI.kn_oib,
			STOLOVI.ts_id_fk, STOLOVI.st_name, STOLOVI.st_description

	SELECT	OTVORENI_RACUNI_STAVKE.wkss_id_pk, OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk, OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk, 
			OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk, OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk,
			OTVORENI_RACUNI_STAVKE.wkss_kolicina, OTVORENI_RACUNI_STAVKE.wkss_popust,
			OTVORENI_RACUNI_STAVKE.wkss_cijena_bez_popusta,	OTVORENI_RACUNI_STAVKE.wkss_cijena,
			OTVORENI_RACUNI_STAVKE.wkss_pdv, OTVORENI_RACUNI_STAVKE.wkss_pnp,
			OTVORENI_RACUNI_STAVKE.wkss_iznos_bez_popusta, OTVORENI_RACUNI_STAVKE.wkss_iznos, 
			OTVORENI_RACUNI_STAVKE.wkss_nar_ns_id_pk, OTVORENI_RACUNI_STAVKE.wkss_nar_naruceno, 
 			OTVORENI_RACUNI_STAVKE.wkss_nar_status, OTVORENI_RACUNI_STAVKE.wkss_nar_napomena, 
 			OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_izdavanja, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_prihvacanja, 
 			OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_spremnosti, OTVORENI_RACUNI_STAVKE.wkss_nar_vrijeme_dostave, 
			OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_priority, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_name, OTVORENI_RACUNI_STAVKE.wkss_nar_slijed_oznaka, 
			ARTIKLI.ar_sifra, ARTIKLI.ar_barcode, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj, 
			ARTIKLI.ar_cijena, ARTIKLI.ar_cijena_popust, ARTIKLI.ar_cijena_popust_2, ARTIKLI.ar_cijena_popust_3, 
			ARTIKLI.ar_mjesto_izdavanja_fk,
			GRUPE_PDV.gpdv_postotak, GRUPE_PDV.gpdv_name, GRUPE_PNP.gpnp_postotak, GRUPE_PNP.gpnp_name, 
			MJESTA_IZDAVANJA.mi_oznaka
	FROM	OTVORENI_RACUNI_STAVKE LEFT OUTER JOIN
				OTVORENI_RACUNI_ZAGLAVLJE ON OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk = OTVORENI_RACUNI_ZAGLAVLJE.wks_id_pk LEFT OUTER JOIN
				ARTIKLI ON OTVORENI_RACUNI_STAVKE.wkss_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
				MJESTA_IZDAVANJA ON ARTIKLI.ar_mjesto_izdavanja_fk = MJESTA_IZDAVANJA.mi_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON OTVORENI_RACUNI_STAVKE.wkss_pdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
				GRUPE_PNP ON OTVORENI_RACUNI_STAVKE.wkss_pnp_id_fk = GRUPE_PNP.gpnp_id_pk
	WHERE (OTVORENI_RACUNI_STAVKE.wkss_wks_id_fk = @wks_id_pk)
END
GO



--
-- Definition for stored procedure Management_Get_PONUDA_BY_ID : 
--
CREATE procedure [dbo].[Management_Get_PONUDA_BY_ID]
(
	@pnz_id_pk int
)
AS
BEGIN
	SELECT PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_kn_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_napomena, 
			KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, KONOBARI.kn_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_oib, 
			sum(PONUDA_STAVKE.pns_pnp) as count_pnp, 
			sum(PONUDA_STAVKE.pns_pdv) as count_pdv, 
			sum(PONUDA_STAVKE.pns_iznos) as count_ukupno  
	FROM PONUDA_ZAGLAVLJE LEFT OUTER JOIN
			PONUDA_STAVKE ON PONUDA_ZAGLAVLJE.pnz_id_pk = PONUDA_STAVKE.pns_ponuda_id_fk LEFT OUTER JOIN
			TVRTKE ON PONUDA_ZAGLAVLJE.pnz_tv_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
			KONOBARI ON PONUDA_ZAGLAVLJE.pnz_kn_id_fk = KONOBARI.kn_id_pk
	WHERE PONUDA_ZAGLAVLJE.pnz_id_pk = @pnz_id_pk
	GROUP BY PONUDA_ZAGLAVLJE.pnz_id_pk, PONUDA_ZAGLAVLJE.pnz_broj, PONUDA_ZAGLAVLJE.pnz_nadnevak, 
			PONUDA_ZAGLAVLJE.pnz_kn_id_fk, PONUDA_ZAGLAVLJE.pnz_tv_id_fk, PONUDA_ZAGLAVLJE.pnz_napomena, 
			KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, KONOBARI.kn_oznaka, 
			TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_oib

	SELECT PONUDA_STAVKE.*, 
		ARTIKLI.ar_sifra, ARTIKLI.ar_kpd_sifra, ARTIKLI.ar_naziv, ARTIKLI.ar_jmj,
		GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, 
		GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak
	FROM PONUDA_STAVKE LEFT OUTER JOIN
			ARTIKLI ON PONUDA_STAVKE.pns_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			GRUPE_PDV ON PONUDA_STAVKE.pns_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			GRUPE_PNP ON PONUDA_STAVKE.pns_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk
	WHERE PONUDA_STAVKE.pns_ponuda_id_fk = @pnz_id_pk
END
GO



--
-- Definition for stored procedure Management_Get_RESERVATION_BY_ID : 
--
CREATE procedure [dbo].[Management_Get_RESERVATION_BY_ID]
(
	@rzz_id_pk int
)
AS
BEGIN
	SELECT RESERVATION_ZAGLAVLJE.*, 
		KONOBARI.kn_name, KONOBARI.kn_oib, KONOBARI.kn_sifra, 
		STOLOVI.st_name, STOLOVI.st_description, STOLOVI.ts_id_fk,
	    CASE WHEN rzz_check_in =0 THEN 'NE' ELSE 'DA' END AS rzz_check_in_str
	FROM RESERVATION_ZAGLAVLJE LEFT OUTER JOIN
			STOLOVI ON RESERVATION_ZAGLAVLJE.rzz_st_id_fk = STOLOVI.st_id_pk LEFT OUTER JOIN
			KONOBARI ON RESERVATION_ZAGLAVLJE.rzz_kn_id_fk = KONOBARI.kn_id_pk
	WHERE RESERVATION_ZAGLAVLJE.rzz_id_pk = @rzz_id_pk 

	SELECT RESERVATION_STAVKE.*, 
		ARTIKLI.ar_sifra, ARTIKLI.ar_naziv
	FROM RESERVATION_STAVKE LEFT OUTER JOIN
			ARTIKLI ON RESERVATION_STAVKE.rzs_ar_id_fk = ARTIKLI.ar_id_pk
	WHERE RESERVATION_STAVKE.rzs_rzz_id_fk = @rzz_id_pk
END
GO



--
-- Definition for stored procedure Pregledi_Get_RACUN_BY_ID : 
--
CREATE procedure [dbo].[Pregledi_Get_RACUN_BY_ID]
(
	@rz_id_pk int
)
AS
BEGIN
SELECT		RACUNI_ZAGLAVLJE.*, 
						NACINI_PLACANJA.np_category_fk, NACINI_PLACANJA.np_name, KONOBARI.kn_name, KONOBARI.kn_oznaka, KONOBARI.kn_oib, KONOBARI.kn_status, 
						STOLOVI.st_name, STOLOVI.st_description, KASE.ks_name,
						TVRTKE.tv_ime, TVRTKE.tv_adresa, TVRTKE.tv_adresa_broj, TVRTKE.tv_mjesto, TVRTKE.tv_mjesto_postanski_broj, TVRTKE.tv_maticni_broj, TVRTKE.tv_oib, TVRTKE.tv_state, TVRTKE.tv_email, TVRTKE.tv_kontakt_osoba, TVRTKE.tv_porezni_broj, TVRTKE.tv_sifra,
						NARUCITELJI.na_ime, NARUCITELJI.na_oib, NARUCITELJI.na_kucna_adresa, NARUCITELJI.na_mjesto, NARUCITELJI.na_biljeska,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_naknadna_dostava_str, 
						RACUNI_ZAGLAVLJE_2.rz_broj_full AS rz_fis_racun_source_broj_full,  
						NP1.np_name AS NP_NAZIV_1,
						NP2.np_name AS NP_NAZIV_2,
						NP3.np_name AS NP_NAZIV_3,
						NP_NAPOJNICA.np_name AS NP_NAZIV_NAPOJNICA, NP_NAPOJNICA.np_category_fk AS NP_KATEGORIJA_NAPOJNICA,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_fiskalizirano = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_fiskalizirano_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis_nap_naknadna_dostava = 0 THEN 'NE' ELSE 'DA' END AS rz_fis_nap_naknadna_dostava_str,
						CASE WHEN RACUNI_ZAGLAVLJE.rz_fis2_id IS NULL THEN 'EKANJE' ELSE 'POSLANO' END AS rz_fis2_status_bpos
	FROM RACUNI_ZAGLAVLJE LEFT OUTER JOIN
						KASE ON RACUNI_ZAGLAVLJE.rz_kasa_id_fk = KASE.ks_id_pk LEFT OUTER JOIN
						KONOBARI ON RACUNI_ZAGLAVLJE.rz_konobar_id_fk = KONOBARI.kn_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
						NARUCITELJI ON RACUNI_ZAGLAVLJE.rz_narucitelj_id_fk = NARUCITELJI.na_id_pk LEFT OUTER JOIN
						TVRTKE ON RACUNI_ZAGLAVLJE.rz_tvrtka_id_fk = TVRTKE.tv_id_pk LEFT OUTER JOIN
						STOLOVI ON RACUNI_ZAGLAVLJE.rz_stol_id_fk = STOLOVI.st_id_pk  LEFT JOIN
						RACUNI_ZAGLAVLJE as RACUNI_ZAGLAVLJE_2 ON RACUNI_ZAGLAVLJE.rz_fis_racun_source_id = RACUNI_ZAGLAVLJE_2.rz_id_pk LEFT OUTER JOIN 
						NACINI_PLACANJA as NP1 ON RACUNI_ZAGLAVLJE.rz_pl_1_id_fk = NP1.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP2 ON RACUNI_ZAGLAVLJE.rz_pl_2_id_fk = NP2.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP3 ON RACUNI_ZAGLAVLJE.rz_pl_3_id_fk = NP3.np_id_pk LEFT OUTER JOIN
						NACINI_PLACANJA as NP_NAPOJNICA ON RACUNI_ZAGLAVLJE.rz_fis_nap_pl_id_fk = NP_NAPOJNICA.np_id_pk					
	WHERE (@rz_id_pk is null or (RACUNI_ZAGLAVLJE.rz_id_pk = @rz_id_pk))

	SELECT RACUNI_STAVKE.*, ARTIKLI.*, GRUPE_PNP.*,  GRUPE_PDV.*
	FROM RACUNI_STAVKE LEFT OUTER JOIN
                      GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
                      GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
                      ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk
	WHERE rs_racun_id_fk = @rz_id_pk
END
GO





--
-- Definition for stored procedure Konobar_Update_RACUN_FISKAL_2 : 
--
GO
CREATE procedure [dbo].[Konobar_Update_RACUN_FISKAL_2]
(
	@rz_id_pk int,
    @rz_fis2_id nvarchar(12),
    @rz_fis2_posrednik nvarchar(15)
)
as
update
	RACUNI_ZAGLAVLJE
set
	rz_fis2_id = @rz_fis2_id,
	rz_fis2_posrednik = @rz_fis2_posrednik
where
	rz_id_pk = @rz_id_pk
GO



--
-- Definition for stored procedure xxx_Custom_EVONA_Izvjesca_Get_FIN_PLACANJA_BEZ_CIGARETA : 
--
GO
CREATE procedure [dbo].[xxx_Custom_EVONA_Izvjesca_Get_FIN_PLACANJA_BEZ_CIGARETA]
(
	@day_start datetime,
	@day_end datetime,
	@CIGARETE_GRUPA_ID int
)
AS
-------------------------------------------------------------------
----------------- po svim porezima svake vrste placanja
-------------------------------------------------------------------
	SELECT		SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + 
					CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PDV, 
				CAST((SUM(RACUNI_STAVKE.rs_iznos) * CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) / (100 + CASE WHEN gpdv_postotak IS NULL THEN 0 ELSE gpdv_postotak END + 
					CASE WHEN gpnp_postotak IS NULL THEN 0 ELSE gpnp_postotak END) AS DECIMAL(12, 2)) AS PNP, 
				GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, 
				RACUNI_STAVKE.rs_gpnp_id_fk, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, NACINI_PLACANJA.np_sort, NACINI_PLACANJA.np_category_fk, SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_long
	FROM	RACUNI_STAVKE LEFT OUTER JOIN
				ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
				RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT JOIN
				GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
				GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN 
				NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk LEFT OUTER JOIN
				SYS_PLACANJA ON NACINI_PLACANJA.np_category_fk =dbo.SYS_PLACANJA.sypl_id_pk 
	WHERE	(ARTIKLI.ar_grupa_fk is NULL or not ARTIKLI.ar_grupa_fk = @CIGARETE_GRUPA_ID) AND
				 (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
	GROUP BY	GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
					RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk, NACINI_PLACANJA.np_id_pk, NACINI_PLACANJA.np_name, SYS_PLACANJA.sypl_id_pk, SYS_PLACANJA.sypl_name_long, NACINI_PLACANJA.np_sort, NACINI_PLACANJA.np_category_fk
-------------------------------------------------------------------
---------------------------------- PO SVIM POREZIMA
-------------------------------------------------------------------
	SELECT	SUM(RACUNI_STAVKE.rs_iznos) AS TOTAL, 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)* CASE WHEN gpdv_postotak IS null THEN 0 ELSE gpdv_postotak END /(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PDV, 
			CAST(SUM(RACUNI_STAVKE.rs_iznos)*CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END/(100+CASE WHEN gpdv_postotak IS  null THEN 0 ELSE gpdv_postotak END+CASE WHEN gpnp_postotak IS null THEN 0 ELSE gpnp_postotak END)AS DECIMAL(12,2)) AS PNP,
			GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
	FROM  RACUNI_STAVKE LEFT OUTER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk LEFT OUTER JOIN
			RACUNI_ZAGLAVLJE ON RACUNI_STAVKE.rs_racun_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk LEFT OUTER JOIN
			GRUPE_PDV ON RACUNI_STAVKE.rs_gpdv_id_fk = GRUPE_PDV.gpdv_id_pk LEFT OUTER JOIN
			GRUPE_PNP ON RACUNI_STAVKE.rs_gpnp_id_fk = GRUPE_PNP.gpnp_id_pk LEFT OUTER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE	(ARTIKLI.ar_grupa_fk is NULL or not ARTIKLI.ar_grupa_fk = @CIGARETE_GRUPA_ID) AND
		  (RACUNI_ZAGLAVLJE.rz_dan between @day_start and @day_end)
GROUP BY GRUPE_PDV.gpdv_name, GRUPE_PDV.gpdv_postotak, GRUPE_PNP.gpnp_name, GRUPE_PNP.gpnp_postotak, 
		  RACUNI_STAVKE.rs_gpdv_id_fk, RACUNI_STAVKE.rs_gpnp_id_fk
GO



--
-- Definition for stored procedure xxx_Custom_AGROLAGUNA_Skladiste_Get_SIROVINA_INFO : 
--
GO
CREATE procedure [dbo].[xxx_Custom_AGROLAGUNA_Skladiste_Get_SIROVINA_INFO]
(
 	@si_id_pk int,
	@dateEnd datetime,
	@dateEnd_Racuni_Vrijeme datetime,
	@dateEnd_Racuni_Nadnevak datetime
)
AS
BEGIN
	-- DETALJI SIROVINE
	SELECT SIROVINE.*, GRUPE_SIROVINA.gs_name, SYS_SIROVINE_KATEGORIJE.sysk_name
	FROM SIROVINE LEFT JOIN
           GRUPE_SIROVINA ON SIROVINE.si_grupa_fk = GRUPE_SIROVINA.gs_id_pk LEFT JOIN
           SYS_SIROVINE_KATEGORIJE ON SIROVINE.si_kategorija_fk = SYS_SIROVINE_KATEGORIJE.sysk_id_pk
	WHERE si_id_pk = @si_id_pk
	-- STAVKE PRIMKE PRIJE ZAVRSNOG DATUMA
	SELECT PRIMKE_ZAGLAVLJE.*, DOBAVLJACI.do_name, PRIMKE_STAVKE.*
	FROM PRIMKE_ZAGLAVLJE INNER JOIN
			PRIMKE_STAVKE ON PRIMKE_ZAGLAVLJE.pr_id_pk = PRIMKE_STAVKE.ps_pr_id_fk LEFT OUTER JOIN
			DOBAVLJACI ON PRIMKE_ZAGLAVLJE.pr_dobavljac_id_fk = DOBAVLJACI.do_id_pk
	WHERE (PRIMKE_ZAGLAVLJE.pr_datum_knjizenja <= @dateEnd) AND (PRIMKE_STAVKE.ps_si_id_fk = @si_id_pk) AND (PRIMKE_ZAGLAVLJE.pr_proknjizeno = 1)
	ORDER BY PRIMKE_ZAGLAVLJE.pr_datum_knjizenja 
 	-- STAVKE IZDATNICE PRIJE ZAVRSNOG DATUMA
	SELECT IZDATNICE_ZAGLAVLJE.*, IZDATNICE_STAVKE.*
	FROM IZDATNICE_ZAGLAVLJE INNER JOIN
			IZDATNICE_STAVKE ON IZDATNICE_ZAGLAVLJE.iz_id_pk = IZDATNICE_STAVKE.is_iz_id_fk
	WHERE (IZDATNICE_ZAGLAVLJE.iz_datum <= @dateEnd) AND (IZDATNICE_STAVKE.is_si_id_fk = @si_id_pk) AND (IZDATNICE_ZAGLAVLJE.iz_proknjizeno = 1)
	ORDER BY IZDATNICE_ZAGLAVLJE.iz_datum
	-- STAVKE OTPISI PRIJE ZAVRSNOG DATUMA
	SELECT OTPISI_ZAGLAVLJE.*, OTPISI_STAVKE.*
	FROM OTPISI_ZAGLAVLJE INNER JOIN
			OTPISI_STAVKE ON OTPISI_ZAGLAVLJE.ot_id_pk = OTPISI_STAVKE.os_ot_id_fk
	WHERE (OTPISI_ZAGLAVLJE.ot_datum <= @dateEnd) AND (OTPISI_STAVKE.os_si_id_fk = @si_id_pk) AND (OTPISI_ZAGLAVLJE.ot_proknjizeno = 1)
	ORDER BY OTPISI_ZAGLAVLJE.ot_datum
	-- STAVKE INVENTURE PRIJE ZAVRSNOG DATUMA
	SELECT INVENTURA_ZAGLAVLJE.*, INVENTURA_STAVKE.* 
	FROM INVENTURA_ZAGLAVLJE INNER JOIN
			INVENTURA_STAVKE ON INVENTURA_ZAGLAVLJE.in_id_pk = INVENTURA_STAVKE.ins_in_id_fk
	where (INVENTURA_ZAGLAVLJE.in_nadnevak <= @dateEnd) AND (INVENTURA_STAVKE.ins_sir_id_fk = @si_id_pk)  AND (INVENTURA_ZAGLAVLJE.in_knjizenje = 1)
	-- UTROSAK PO NORMATIVU PRIJE ZAVRSNOG DATUMA (ZA SVAKI RACUN)
	SELECT RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full,   
			RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, RACUNI_ZAGLAVLJE.rz_iznos,
			RACUNI_ZAGLAVLJE.rz_placanje_id_fk, 
 			SUM (NORMATIVI.no_kolicina * RACUNI_STAVKE.rs_kolicina) AS UTROSENA_KOLICINA
	FROM RACUNI_ZAGLAVLJE INNER JOIN
			RACUNI_STAVKE ON RACUNI_ZAGLAVLJE.rz_id_pk = RACUNI_STAVKE.rs_racun_id_fk INNER JOIN
			ARTIKLI ON RACUNI_STAVKE.rs_artikal_id_fk = ARTIKLI.ar_id_pk INNER JOIN
			NORMATIVI ON ARTIKLI.ar_id_pk = NORMATIVI.no_article_id_fk INNER JOIN
			SIROVINE ON NORMATIVI.no_sirovina_id_fk = SIROVINE.si_id_pk INNER JOIN
			NACINI_PLACANJA ON RACUNI_ZAGLAVLJE.rz_placanje_id_fk = NACINI_PLACANJA.np_id_pk
	WHERE (SIROVINE.si_id_pk = @si_id_pk) AND 
			(@dateEnd_Racuni_Vrijeme IS NULL OR (RACUNI_ZAGLAVLJE.rz_vrijeme <= @dateEnd_Racuni_Vrijeme)) AND 
			(@dateEnd_Racuni_Nadnevak IS NULL OR (RACUNI_ZAGLAVLJE.rz_dan <= @dateEnd_Racuni_Nadnevak))
	GROUP BY RACUNI_ZAGLAVLJE.rz_id_pk, RACUNI_ZAGLAVLJE.rz_broj, RACUNI_ZAGLAVLJE.rz_broj_full,   
			RACUNI_ZAGLAVLJE.rz_vrijeme, RACUNI_ZAGLAVLJE.rz_dan, RACUNI_ZAGLAVLJE.rz_iznos, RACUNI_ZAGLAVLJE.rz_placanje_id_fk
	ORDER BY RACUNI_ZAGLAVLJE.rz_vrijeme
END
GO




--
-- Definition for stored procedure xxx_Custom_M2PAY_Get_Transakcije : 
--
GO
CREATE procedure [dbo].[xxx_Custom_M2PAY_Get_Transakcije]
(
	@m2pay_id_pk int = null,
	@m2pay_rz_id_fk int = null,
	@m2pay_vrijeme_start datetime,
	@m2pay_vrijeme_end datetime,
	@m2pay_Var_PRINT_STATUS nvarchar(20) = null,
	@m2pay_Var_PRINT_Transaction_Type nvarchar(20) = null
)
AS
SELECT x_cust_KART_PLACANJE_M2PAY.*, RACUNI_ZAGLAVLJE.*
FROM x_cust_KART_PLACANJE_M2PAY LEFT OUTER JOIN
						RACUNI_ZAGLAVLJE ON x_cust_KART_PLACANJE_M2PAY.m2pay_rz_id_fk = RACUNI_ZAGLAVLJE.rz_id_pk 
where (x_cust_KART_PLACANJE_M2PAY.m2pay_vrijeme between @m2pay_vrijeme_start and @m2pay_vrijeme_end) AND
		(@m2pay_id_pk is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_id_pk = @m2pay_id_pk)) AND 
		(@m2pay_rz_id_fk is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_rz_id_fk = @m2pay_rz_id_fk)) AND
		(@m2pay_Var_PRINT_STATUS is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_Var_PRINT_STATUS = @m2pay_Var_PRINT_STATUS)) AND
		(@m2pay_Var_PRINT_Transaction_Type is null or (x_cust_KART_PLACANJE_M2PAY.m2pay_Var_PRINT_Transaction_Type = @m2pay_Var_PRINT_Transaction_Type))
GO




--
-- Definition for stored procedure xxx_Custom_KARTICE_M2PAY_Insert_Transakcija : 
--
GO
CREATE procedure [dbo].[xxx_Custom_KARTICE_M2PAY_Insert_Transakcija]
(
    @m2pay_rz_id_fk int,
    @m2pay_vrijeme datetime,
    @m2pay_Var_transactionResultId nvarchar(30),
    @m2pay_Var_RESULT_transactionID nvarchar(40),
    @m2pay_Var_RESULT_FinStatus nvarchar(20),
    @m2pay_Var_PRINT_merchantName nvarchar(50),
    @m2pay_Var_PRINT_merchantAddress nvarchar(50),
    @m2pay_Var_PRINT_Time datetime,
    @m2pay_Var_PRINT_STATUS nvarchar(20),
    @m2pay_Var_PRINT_Transaction_Type nvarchar(20),
    @m2pay_Var_PRINT_Iznos decimal(10, 2),
    @m2pay_Var_PRINT_Tip decimal(10, 2),
    @m2pay_Var_PRINT_Ukupno decimal(10, 2),
    @m2pay_Var_PRINT_ID_Terminala nvarchar(20),
    @m2pay_Var_PRINT_ID_Trgovca nvarchar(20),
    @m2pay_Var_PRINT_ID_KARTICA_Name nvarchar(20),
    @m2pay_Var_PRINT_ID_KARTICA_ID nvarchar(20),
    @m2pay_Var_PRINT_Nacin_Unosa nvarchar(20),
    @m2pay_Var_PRINT_Provjere nvarchar(20),
    @m2pay_Var_PRINT_Vrsta_Kartice nvarchar(20),
    @m2pay_Var_PRINT_Broj_Odobrenja nvarchar(20),
    @m2pay_Var_PRINT_GUID nvarchar(50),
    @m2pay_Var_PRINT_GUID_STORNO_PRODAJE nvarchar(50),
    @m2pay_Var_PRINT_RRN nvarchar(20),
    @m2pay_Var_PRINT_AID nvarchar(20),
    @m2pay_Var_PRINT_TVR nvarchar(20),
    @m2pay_Var_PRINT_IAD nvarchar(50),
    @m2pay_Var_PRINT_TSI nvarchar(20),
    @m2pay_Var_PRINT_ARC nvarchar(20)
)
as
insert into x_cust_KART_PLACANJE_M2PAY
	(m2pay_rz_id_fk, m2pay_vrijeme, m2pay_Var_transactionResultId,
	m2pay_Var_RESULT_transactionID, m2pay_Var_RESULT_FinStatus,  
	m2pay_Var_PRINT_merchantName, m2pay_Var_PRINT_merchantAddress, 
	m2pay_Var_PRINT_Time, m2pay_Var_PRINT_STATUS, m2pay_Var_PRINT_Transaction_Type, 
	m2pay_Var_PRINT_Iznos, m2pay_Var_PRINT_Tip, m2pay_Var_PRINT_Ukupno, 
	m2pay_Var_PRINT_ID_Terminala, m2pay_Var_PRINT_ID_Trgovca, 
	m2pay_Var_PRINT_ID_KARTICA_Name, m2pay_Var_PRINT_ID_KARTICA_ID, 
	m2pay_Var_PRINT_Nacin_Unosa, m2pay_Var_PRINT_Provjere,
	m2pay_Var_PRINT_Vrsta_Kartice, m2pay_Var_PRINT_Broj_Odobrenja,
	m2pay_Var_PRINT_GUID, m2pay_Var_PRINT_GUID_STORNO_PRODAJE,  
	m2pay_Var_PRINT_RRN, m2pay_Var_PRINT_AID, m2pay_Var_PRINT_TVR, 
	m2pay_Var_PRINT_IAD, m2pay_Var_PRINT_TSI, m2pay_Var_PRINT_ARC)
values
	(@m2pay_rz_id_fk, @m2pay_vrijeme, @m2pay_Var_transactionResultId,
	@m2pay_Var_RESULT_transactionID, @m2pay_Var_RESULT_FinStatus,  
	@m2pay_Var_PRINT_merchantName, @m2pay_Var_PRINT_merchantAddress, 
	@m2pay_Var_PRINT_Time, @m2pay_Var_PRINT_STATUS, @m2pay_Var_PRINT_Transaction_Type, 
	@m2pay_Var_PRINT_Iznos, @m2pay_Var_PRINT_Tip, @m2pay_Var_PRINT_Ukupno, 
	@m2pay_Var_PRINT_ID_Terminala, @m2pay_Var_PRINT_ID_Trgovca, 
	@m2pay_Var_PRINT_ID_KARTICA_Name, @m2pay_Var_PRINT_ID_KARTICA_ID, 
	@m2pay_Var_PRINT_Nacin_Unosa, @m2pay_Var_PRINT_Provjere,
	@m2pay_Var_PRINT_Vrsta_Kartice, @m2pay_Var_PRINT_Broj_Odobrenja,
	@m2pay_Var_PRINT_GUID, @m2pay_Var_PRINT_GUID_STORNO_PRODAJE,  
	@m2pay_Var_PRINT_RRN, @m2pay_Var_PRINT_AID, @m2pay_Var_PRINT_TVR, 
	@m2pay_Var_PRINT_IAD, @m2pay_Var_PRINT_TSI, @m2pay_Var_PRINT_ARC)
select scope_identity()
GO



--
-- Definition for stored procedure Konobar_Init_ALL_WORKING_TABLES : 
--
GO
CREATE PROCEDURE [dbo].[Konobar_Init_ALL_WORKING_TABLES]
	AS
	exec Osnovno_Get_KONOBARI @active_only = 1 
	exec Osnovno_Get_NACINI_PLACANJA  @np_active = 1
	exec Osnovno_Get_TERASE_STOLOVI
	exec Osnovno_Get_NARUDZBE_SLIJEDOVI
	exec Osnovno_Get_MJESTA_IZDAVANJA
	exec Osnovno_Get_GRUPE_PDV
	exec Servis_Get_ADMINISTRATORS
	exec Servis_Get_KASE
	exec System_Get_SYS_PLACANJA
GO